/*
 * *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.generator;

import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelOperation;

/**
 * Created: 14 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1716 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-16 21:31:10 +0100 (mer. 16 déc. 2009) $ par :
 *          $Author: tchemit $
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DAOImplTransformer"
 */
public class DAOImplTransformer extends ObjectModelTransformerToJava {

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY) || hasDAOOperations(clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        ObjectModelClass result = createClass(clazzName + "DAOImpl<E extends " + clazzName + ">", clazz.getPackageName());
        setDocumentation(result, "/**\n" +
                " Implantation du DAO pour l'entité " + clazzName + ".\n" +
                " * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n" +
                " * simplement dans ces sources. Cette classe générée sera alors simplement\n" +
                " * écrasée\n" +
                " */");
        setSuperClass(result, clazzFQN + "DAOAbstract<E>");
    }

    /**
     * Detect if the class has DAO operations identified with <<dao>> stereotype.
     *
     * @param clazz The ObjectModelClass with operations (Corresponding to the Entity)
     * @return true if the class has some dao operations, false if not
     */
    public static boolean hasDAOOperations(ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)) {
                return true;
            }
        }
        return false;
    }
}
