/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/*******************************************************************************
 * DAOHelperGenerator.java
 * 
 * Created: 12 déc. 2005
 * 
 * @author Arnaud Thimel <thimel@codelutin.com>
 * 
 * @version $Revision: 1668 $
 * 
 * Mise a jour: $Date: 2009-11-13 14:01:01 +0100 (Fri, 13 Nov 2009) $ par : $Author: fdesbois $
 */

package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Ce generateur permet d'avoir une classe permettant de recuperer les DAO
 * sans cast.
 *
 * La classe générée contient aussi une énumération nommée <code>EntityEnum</code> qui permet
 * d'avoir facilement les types d'entités gérées par ce dao.
 *  
 * @author poussin
 */
public class DAOHelperGenerator extends ObjectModelGenerator {

    private Log log = LogFactory.getLog(DAOHelperGenerator.class);

    @Override
    public String getFilenameForModel(ObjectModel model) {
        
        String modelName = GeneratorUtil.capitalize(model.getName());
        
        return (getProperty("defaultPackage") + ".").replace('.',
                File.separatorChar)
                + modelName + "DAOHelper.java";
    }

    @Override
    public void generateFromModel(Writer output, ObjectModel model)
            throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
        String packageName = getProperty("defaultPackage");
/*{package <%=packageName%>;

}*/
        String modelName = GeneratorUtil.capitalize(model.getName());
        String modelVersion = model.getVersion();
        String daoHelperClazzName = modelName+"DAOHelper";
        String entityEnumName = modelName+"EntityEnum";
        List<ObjectModelClass> classes = TopiaGeneratorUtil.getEntityClasses(model,true);
        boolean generateOperator = TopiaGeneratorUtil.shouldgenerateOperatorForDAOHelper(null, model);
        
        List<String> imports  = computeImports(generateOperator,packageName, classes);
        if (log.isDebugEnabled()) {
            log.debug("imports for class <" + daoHelperClazzName + ">");
        }
        for (String anImport : imports) {
            if (log.isDebugEnabled()) {
                log.debug("import " + anImport);
            }
/*{import <%=anImport%>;
}*/
        }
/*{
public class <%=daoHelperClazzName%> {

}*/
        
/*{    /**
     * no instance for this helper
     *)
    protected <%=daoHelperClazzName%>() {
    }

    /**
     * Model version.
     * 
     * @return model version
     *)
    public static String getModelVersion() {
        return "<%=modelVersion%>";
    }
}*/

        for (ObjectModelClass clazz : classes) {
        	String clazzName = clazz.getName();
                String daoClazzName = clazzName + "DAO";
/*{
    public static <%=daoClazzName%> get<%=daoClazzName%>(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=daoClazzName%> result = (<%=daoClazzName%>) ci.getDAO(<%=clazzName%>.class);
        return result;
    }
}*/
        }
/*{
    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getContractClasses() {
        <%=entityEnumName%>[] values = <%=entityEnumName%>.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        <%=entityEnumName%>[] values = <%=entityEnumName%>.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static <%=entityEnumName%>[] getContracts() {
        return <%=entityEnumName%>.values();
    }
}*/
    if (generateOperator) {
/*{
    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> EntityOperator<T> getOperator(Class<T> klass) {
        <%=entityEnumName%> constant = <%=entityEnumName%>.valueOf(klass);
        return (EntityOperator<T>) EntityOperatorStore.getOperator(constant);
    }
}*/
    }
/*{
    /*
     * Enumeration of all types of entities managed by this helper.
     *)
    public enum <%=entityEnumName%> implements org.nuiton.topia.persistence.TopiaEntityEnum {
}*/
        
        for (Iterator<ObjectModelClass> i=classes.iterator(); i.hasNext();) {
            ObjectModelClass clazz = i.next();
            String clazzName = clazz.getName();
/*{
        <%=clazzName%>(<%=clazzName%>.class)<%=(i.hasNext() ? "," : ";")%>}*/
        }
/*{

        /** the contract of the entity *)
        private Class<? extends TopiaEntity> contract;

        /** the fully qualified name of the implementation of the entity *)
        private String implementationFQN;

        /** the implementation class of the entity (will be lazy computed at runtime)*)
        private Class<? extends TopiaEntity> implementation;

        <%=entityEnumName%>(Class<? extends TopiaEntity > contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName()+"Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract() {
            return contract;
        }
       
        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return getContract();
        }
        
        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return getImplementation();
        }

        @Override
        public String getImplementationFQN() {
            return implementationFQN;
        }

        @Override
        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
}*/
        if (generateOperator) {
/*{            // on reinitialise le magasin d'operators
            EntityOperatorStore.clear();
}*/
        }
/*{        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass) {
            return <%=daoHelperClazzName%>.getContractClass(klass) == contract;
        }
 
        @Override
        @SuppressWarnings({"unchecked"})
        public Class<? extends TopiaEntity> getImplementation() {
            if (implementation == null) {
                try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
            }
            return implementation;
        }

        public static <%=entityEnumName%> valueOf(TopiaEntity entity) {
            return valueOf(entity.getClass());
        }

        public static <%=entityEnumName%> valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return <%=entityEnumName%>.valueOf(klass.getSimpleName());
            }
            for (<%=entityEnumName%> entityEnum : <%=entityEnumName%>.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(<%=entityEnumName%>.values()));
        }        
    }
}*/
        String entitiesList = "";
        if (classes.isEmpty()) {
/*{
    /**
      * @eprecated (prefer use {@link #getImplementationClassesAsString()}
      *) 
    public static final String entitiesList = "";
}*/
        } else {
/*{
    /**
     * use {@link #getImplementationClassesAsString()}
     *
     * @deprecated (will be removed soon).
     *)
    public static final String entitiesList = "" +
}*/

            for (Iterator<ObjectModelClass> i=classes.iterator(); i.hasNext();) {
                ObjectModelClass clazz = i.next();
                String doType = TopiaGeneratorUtil.getDOType(clazz, model);
                entitiesList += doType + (i.hasNext()?",":"");
/*{        "<%=doType%><%=(i.hasNext()?",\" +":"\";")%>
}*/
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Full entities list : " + entitiesList);
        }
/*{
} //<%=daoHelperClazzName%>
}*/
    }

    protected List<String> computeImports(boolean generateOperator,String packageName, List<ObjectModelClass> classes) {
        java.util.Set<String> imports = new java.util.HashSet<String>(java.util.Arrays.asList(
                java.lang.reflect.Array.class.getName(),
                java.util.Arrays.class.getName(),
                org.nuiton.topia.TopiaContext.class.getName(),
                org.nuiton.topia.TopiaException.class.getName(),
                org.nuiton.topia.framework.TopiaContextImplementor.class.getName(),
                org.nuiton.topia.persistence.TopiaDAO.class.getName(),                
                org.nuiton.topia.persistence.TopiaEntity.class.getName()));
                if (generateOperator) {
                    imports.add(org.nuiton.topia.persistence.util.EntityOperator.class.getName());
                    imports.add(org.nuiton.topia.persistence.util.EntityOperatorStore.class.getName());

                }
        for (ObjectModelClass clazz : classes) {
            String clazzFQN = clazz.getQualifiedName();
            imports.add(clazzFQN);
            imports.add(clazzFQN + "DAO");
        }
        List<String> cleanImports  = TopiaGeneratorUtil.cleanImports(packageName, imports);
        java.util.Collections.sort(cleanImports);
        return cleanImports;
    }
} //DAOHelperGenerator
