/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

class IconRowHeader
extends AbstractGutterComponent
implements MouseListener {
    private List trackingIcons;
    private int width = 16;
    private boolean bookmarkingEnabled;
    private Icon bookmarkIcon;
    private Rectangle visibleRect = new Rectangle();
    private Insets textAreaInsets;

    public IconRowHeader(RTextArea rTextArea) {
        super(rTextArea);
        this.addMouseListener(this);
    }

    public GutterIconInfo addOffsetTrackingIcon(int n, Icon icon) throws BadLocationException {
        int n2;
        Position position = this.textArea.getDocument().createPosition(n);
        GutterIconImpl gutterIconImpl = new GutterIconImpl(icon, position);
        if (this.trackingIcons == null) {
            this.trackingIcons = new ArrayList(1);
        }
        if ((n2 = Collections.binarySearch(this.trackingIcons, gutterIconImpl)) < 0) {
            n2 = -(n2 + 1);
        }
        this.trackingIcons.add(n2, gutterIconImpl);
        this.repaint();
        return gutterIconImpl;
    }

    public Icon getBookmarkIcon() {
        return this.bookmarkIcon;
    }

    public GutterIconInfo[] getBookmarks() {
        ArrayList<GutterIconImpl> arrayList = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                if (gutterIconImpl.getIcon() != this.bookmarkIcon) continue;
                arrayList.add(gutterIconImpl);
            }
        }
        GutterIconInfo[] gutterIconInfoArray = new GutterIconInfo[arrayList.size()];
        return arrayList.toArray(gutterIconInfoArray);
    }

    void handleDocumentEvent(DocumentEvent documentEvent) {
        int n = this.textArea.getLineCount();
        if (n != this.currentLineCount) {
            this.currentLineCount = n;
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        int n = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(this.width, n);
    }

    private GutterIconImpl getTrackingIcon(int n) {
        return (GutterIconImpl)this.trackingIcons.get(n);
    }

    public GutterIconImpl[] getTrackingIcons(int n) throws BadLocationException {
        ArrayList<GutterIconImpl> arrayList = new ArrayList<GutterIconImpl>(1);
        if (this.trackingIcons != null) {
            int n2 = this.textArea.getLineStartOffset(n);
            int n3 = this.textArea.getLineEndOffset(n);
            if (n == this.textArea.getLineCount() - 1) {
                ++n3;
            }
            for (int i = 0; i < this.trackingIcons.size(); ++i) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                int n4 = gutterIconImpl.getMarkedOffset();
                if (n4 >= n2 && n4 < n3) {
                    arrayList.add(gutterIconImpl);
                    continue;
                }
                if (n4 >= n3) break;
            }
        }
        GutterIconImpl[] gutterIconImplArray = new GutterIconImpl[arrayList.size()];
        return arrayList.toArray(gutterIconImplArray);
    }

    public boolean isBookmarkingEnabled() {
        return this.bookmarkingEnabled;
    }

    void lineHeightsChanged() {
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.bookmarkingEnabled && this.bookmarkIcon != null) {
            try {
                int n = this.textArea.viewToModel(mouseEvent.getPoint());
                if (n > -1) {
                    int n2 = this.textArea.getLineOfOffset(n);
                    this.toggleBookmark(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, this.visibleRect.y, this.width, this.visibleRect.height);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(graphics);
            return;
        }
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n = this.textArea.getLineHeight();
        int n2 = this.visibleRect.y / n;
        int n3 = Math.min(n2 + this.visibleRect.height / n, element.getElementCount());
        int n4 = n2 * n;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.textAreaInsets != null) {
            n4 += this.textAreaInsets.top;
        }
        if (this.trackingIcons != null) {
            int n5 = n3;
            for (int i = this.trackingIcons.size() - 1; i >= 0; --i) {
                GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                int n6 = gutterIconImpl.getMarkedOffset();
                if (n6 < 0 || n6 > document.getLength()) continue;
                int n7 = element.getElementIndex(n6);
                if (n7 <= n5 && n7 > n2 - 1) {
                    Icon icon = gutterIconImpl.getIcon();
                    if (icon == null) continue;
                    int n8 = n4 + (n7 - n2) * n;
                    gutterIconImpl.getIcon().paintIcon(this, graphics, 0, n8 += (n - icon.getIconHeight()) / 2);
                    n5 = n7 - 1;
                    continue;
                }
                if (n7 <= n2 - 1) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics graphics) {
        int n;
        GutterIconImpl gutterIconImpl;
        int n2;
        RTextAreaUI rTextAreaUI = (RTextAreaUI)this.textArea.getUI();
        View view = rTextAreaUI.getRootView(this.textArea).getView(0);
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n3 = element.getElementCount();
        int n4 = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int n5 = element.getElementIndex(n4);
        Rectangle rectangle = rTextAreaUI.getVisibleEditorRect();
        Rectangle rectangle2 = IconRowHeader.getChildViewBounds(view, n5, rectangle);
        int n6 = rectangle2.y;
        int n7 = this.visibleRect.y + this.visibleRect.height;
        int n8 = -1;
        if (this.trackingIcons != null) {
            for (n2 = 0; n2 < this.trackingIcons.size(); ++n2) {
                gutterIconImpl = this.getTrackingIcon(n2);
                int n9 = gutterIconImpl.getMarkedOffset();
                if (n9 < 0 || n9 > document.getLength() || (n = element.getElementIndex(n9)) < n5) continue;
                n8 = n2;
                break;
            }
        }
        graphics.setColor(this.getForeground());
        n2 = this.textArea.getLineHeight();
        while (n6 < n7) {
            rectangle2 = LineNumberList.getChildViewBounds(view, n5, rectangle);
            if (n8 > -1) {
                Icon icon;
                gutterIconImpl = null;
                while (n8 < this.trackingIcons.size()) {
                    GutterIconImpl gutterIconImpl2 = this.getTrackingIcon(n8);
                    n = gutterIconImpl2.getMarkedOffset();
                    if (n >= 0 && n <= document.getLength()) {
                        int n10 = element.getElementIndex(n);
                        if (n10 == n5) {
                            gutterIconImpl = gutterIconImpl2;
                        } else if (n10 > n5) break;
                    }
                    ++n8;
                }
                if (gutterIconImpl != null && (icon = gutterIconImpl.getIcon()) != null) {
                    n = n6 + (n2 - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, graphics, 0, n);
                }
            }
            n6 += rectangle2.height;
            if (++n5 < n3) continue;
            break;
        }
    }

    public void removeTrackingIcon(Object object) {
        if (this.trackingIcons != null && this.trackingIcons.remove(object)) {
            this.repaint();
        }
    }

    public void removeAllTrackingIcons() {
        if (this.trackingIcons != null && this.trackingIcons.size() > 0) {
            this.trackingIcons.clear();
            this.repaint();
        }
    }

    private void removeBookmarkTrackingIcons() {
        if (this.trackingIcons != null) {
            Iterator iterator = this.trackingIcons.iterator();
            while (iterator.hasNext()) {
                GutterIconImpl gutterIconImpl = (GutterIconImpl)iterator.next();
                if (gutterIconImpl.getIcon() != this.bookmarkIcon) continue;
                iterator.remove();
            }
        }
    }

    public void setBookmarkIcon(Icon icon) {
        this.removeBookmarkTrackingIcons();
        this.bookmarkIcon = icon;
        this.repaint();
    }

    public void setBookmarkingEnabled(boolean bl) {
        if (bl != this.bookmarkingEnabled) {
            this.bookmarkingEnabled = bl;
            if (!bl) {
                this.removeBookmarkTrackingIcons();
            }
            this.repaint();
        }
    }

    public void setTextArea(RTextArea rTextArea) {
        this.removeAllTrackingIcons();
        super.setTextArea(rTextArea);
    }

    public boolean toggleBookmark(int n) throws BadLocationException {
        int n2;
        if (!this.isBookmarkingEnabled() || this.getBookmarkIcon() == null) {
            return false;
        }
        GutterIconImpl[] gutterIconImplArray = this.getTrackingIcons(n);
        if (gutterIconImplArray.length == 0) {
            int n3 = this.textArea.getLineStartOffset(n);
            this.addOffsetTrackingIcon(n3, this.bookmarkIcon);
            return true;
        }
        boolean bl = false;
        for (n2 = 0; n2 < gutterIconImplArray.length; ++n2) {
            if (gutterIconImplArray[n2].getIcon() != this.bookmarkIcon) continue;
            this.removeTrackingIcon(gutterIconImplArray[n2]);
            bl = true;
        }
        if (!bl) {
            n2 = this.textArea.getLineStartOffset(n);
            this.addOffsetTrackingIcon(n2, this.bookmarkIcon);
        }
        return !bl;
    }

    private static class GutterIconImpl
    implements GutterIconInfo,
    Comparable {
        private Icon icon;
        private Position pos;

        public GutterIconImpl(Icon icon, Position position) {
            this.icon = icon;
            this.pos = position;
        }

        public int compareTo(Object object) {
            if (object instanceof GutterIconImpl) {
                return this.pos.getOffset() - ((GutterIconImpl)object).getMarkedOffset();
            }
            return -1;
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getMarkedOffset() {
            return this.pos.getOffset();
        }

        public int hashCode() {
            return this.icon.hashCode();
        }
    }
}

