/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed;

import java.io.InputStream;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.spgeed.Query;
import org.nuiton.spgeed.SqlSession;
import org.nuiton.spgeed.annotations.Script;
import org.nuiton.spgeed.annotations.Select;
import org.nuiton.spgeed.annotations.Update;

public class ClassCreator {
    private static Log log = LogFactory.getLog(ClassCreator.class);
    protected ProxyFactory proxyFactory = new ProxyFactory();

    public <E> E generate(Class<E> c, SqlSession session) throws Exception {
        if (c.isInterface()) {
            this.proxyFactory.setInterfaces(new Class[]{c});
        } else {
            this.proxyFactory.setSuperclass(c);
        }
        this.proxyFactory.setFilter(m -> {
            boolean result = m.isAnnotationPresent(Update.class) || m.isAnnotationPresent(Select.class) || m.isAnnotationPresent(Script.class) || m.getName().equals("getSession") && m.getParameterCount() == 0;
            return result;
        });
        Class resultClass = this.proxyFactory.createClass();
        MethodHandler mi = (self, method, proceed, args) -> {
            Query query;
            String[] roles;
            if (method.getName().equals("getSession")) {
                return session;
            }
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            Parameter[] parameters = method.getParameters();
            int index = 0;
            for (Parameter parameter : parameters) {
                String name = parameter.getName();
                parameterValues.put(name, args[index++]);
            }
            Class<?> returnType = method.getReturnType();
            if (method.isAnnotationPresent(Update.class)) {
                Update annotation = method.getDeclaredAnnotation(Update.class);
                String sql = annotation.sql();
                roles = annotation.roles();
                query = new Query(session, sql, roles, parameterValues, returnType);
                return query.executeUpdate();
            }
            if (method.isAnnotationPresent(Select.class)) {
                Select annotation = method.getDeclaredAnnotation(Select.class);
                String sql = annotation.sql();
                roles = annotation.roles();
                query = new Query(session, sql, roles, parameterValues, returnType);
                return query.executeQuery();
            }
            if (method.isAnnotationPresent(Script.class)) {
                Script annotation = method.getDeclaredAnnotation(Script.class);
                String file = annotation.file();
                ClassLoader classLoader = SqlSession.class.getClassLoader();
                InputStream resource = classLoader.getResourceAsStream(file);
                String content = IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
                Query query2 = new Query(session, content, parameterValues, Boolean.class);
                return query2.execute();
            }
            return null;
        };
        Object result = resultClass.newInstance();
        ((Proxy)result).setHandler(mi);
        return (E)result;
    }
}

