/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.processor.I18nExtractor;

public class I18nExtractorTask
extends MatchingTask {
    public static final int MSG_VERBOSE = 3;
    protected File srcDir;
    protected File destFile;
    protected String[] includes = new String[0];
    protected String[] excludes = new String[0];
    protected String[] srcFileNames;

    protected void doExecute() throws BuildException {
        this.destFile.getParentFile().mkdirs();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < this.srcFileNames.length; ++i) {
            fileList.add(new File(this.srcFileNames[i]));
        }
        try {
            new I18nExtractor().extract(fileList.toArray(new File[0]), this.destFile);
        }
        catch (IOException eee) {
            throw new BuildException((Throwable)eee);
        }
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir \"" + this.srcDir.getPath() + "\" does not exist!", this.getLocation());
        }
        if (this.destFile == null) {
            throw new BuildException("destFile attribute must be set!", this.getLocation());
        }
        this.buildFileList();
        this.doExecute();
    }

    protected void buildFileList() {
        String[] excludes;
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] includes = this.getIncludes();
        if (includes.length > 0) {
            ds.setIncludes(includes);
        }
        if ((excludes = this.getExcludes()).length > 0) {
            ds.setExcludes(excludes);
        }
        ds.scan();
        this.srcFileNames = ds.getIncludedFiles();
    }

    protected boolean isNewer(String filein, String fileout) {
        boolean result;
        boolean bl = result = new File(filein).lastModified() > new File(fileout).lastModified();
        if (result) {
            this.log(filein + " is newer than " + fileout, 3);
        }
        return result;
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes.split(",");
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes.split(",");
    }
}

