/*
 * *##% 
 * Nuiton processor ant task
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

package org.nuiton.processor.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.processor.I18nExtractor;

/**
 * I18nExtractorTask.
 *
 * Created: Aug 16, 2004
 *
 * @author Cédric Pineau <pineau@codelutin.com>
 * @version $Revision: 283 $
 *
 * Last update : $Date: 2009-10-10 16:04:48 +0200 (sam., 10 oct. 2009) $
 * by : $Author: tchemit $
 */
public class I18nExtractorTask extends MatchingTask {

    public static final int MSG_VERBOSE = Project.MSG_VERBOSE;

    protected File srcDir;

    protected File destFile;

    protected String[] includes = new String[] {};

    protected String[] excludes = new String[] {};

    protected String[] srcFileNames;

    public I18nExtractorTask() {

    }

    protected void doExecute() throws BuildException {
        // creation du repertoire pour le fichier destination
        destFile.getParentFile().mkdirs();
        List<File> fileList = new ArrayList<File>();
        for (int i = 0; i < srcFileNames.length; i++) {
            fileList.add(new File(srcFileNames[i]));
        }
        try {
            new I18nExtractor()
                    .extract(fileList.toArray(new File[0]), destFile);
        } catch (IOException eee) {
            throw new BuildException(eee);
        }
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    @Override
    public void execute() throws BuildException {
        // first of all, make sure that we've got a srcdir
        if (srcDir == null) {
            throw new BuildException("srcdir attribute must be set!",
                    getLocation());
        }
        if (!srcDir.exists()) {
            throw new BuildException("srcdir \"" + srcDir.getPath()
                    + "\" does not exist!", getLocation());
        }

        if (destFile == null) {
            throw new BuildException("destFile attribute must be set!",
                    getLocation());
        }

        // Build the list of files to compute
        buildFileList();

        // generate the source files
        doExecute();
    }

    protected void buildFileList() {

        // Obtain this list of files within the source directory
        DirectoryScanner ds = getDirectoryScanner(srcDir);

        String[] ins = getIncludes();
        if (ins.length > 0) {
            ds.setIncludes(ins);
        }
        String[] exs = getExcludes();
        if (exs.length > 0) {
            ds.setExcludes(exs);
        }

        ds.scan();

        // on met le resultat dans files
        srcFileNames = ds.getIncludedFiles();
    }

    protected boolean isNewer(String filein, String fileout) {
        boolean result = new File(filein).lastModified() > new File(fileout)
                .lastModified();
        if (result) {
            log(filein + " is newer than " + fileout, MSG_VERBOSE);
        }
        return result;
    }

    protected String[] getExcludes() {
        return excludes;
    }

    protected String[] getIncludes() {
        return includes;
    }

    @Override
    public void setIncludes(String includes) {
        this.includes = includes.split(",");
    }

    @Override
    public void setExcludes(String excludes) {
        this.excludes = excludes.split(",");
    }

}
