package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ArgumentMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableArgumentMeta.builder()}.
 */
@Generated(from = "ArgumentMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableArgumentMeta implements ArgumentMeta {
  private final String type;
  private final @Nullable String name;

  private ImmutableArgumentMeta(String type, @Nullable String name) {
    this.type = type;
    this.name = name;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ArgumentMeta#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableArgumentMeta withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableArgumentMeta(newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ArgumentMeta#getName() name} attribute.
   * @param value The value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableArgumentMeta withName(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "name");
    if (Objects.equals(this.name, newValue)) return this;
    return new ImmutableArgumentMeta(this.type, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ArgumentMeta#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final ImmutableArgumentMeta withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableArgumentMeta(this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableArgumentMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableArgumentMeta
        && equalTo((ImmutableArgumentMeta) another);
  }

  private boolean equalTo(ImmutableArgumentMeta another) {
    return type.equals(another.type)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code ArgumentMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ArgumentMeta")
        .omitNullValues()
        .add("type", type)
        .add("name", name)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ArgumentMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ArgumentMeta instance
   */
  public static ImmutableArgumentMeta copyOf(ArgumentMeta instance) {
    if (instance instanceof ImmutableArgumentMeta) {
      return (ImmutableArgumentMeta) instance;
    }
    return ImmutableArgumentMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableArgumentMeta ImmutableArgumentMeta}.
   * <pre>
   * ImmutableArgumentMeta.builder()
   *    .type(String) // required {@link ArgumentMeta#getType() type}
   *    .name(String) // optional {@link ArgumentMeta#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableArgumentMeta builder
   */
  public static ImmutableArgumentMeta.Builder builder() {
    return new ImmutableArgumentMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableArgumentMeta ImmutableArgumentMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ArgumentMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String type;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ArgumentMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ArgumentMeta instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        name(nameOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ArgumentMeta#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link ArgumentMeta#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      return this;
    }

    /**
     * Initializes the optional value {@link ArgumentMeta#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableArgumentMeta ImmutableArgumentMeta}.
     * @return An immutable instance of ArgumentMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableArgumentMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableArgumentMeta(type, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ArgumentMeta, some of required attributes are not set " + attributes;
    }
  }
}
