package org.nuiton.config.example;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Generated;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Mon Dec 19 11:57:01 CET 2016")
public abstract class GeneratedNuitonConfigExampleConfig implements Supplier<ApplicationConfig> {

    private ApplicationConfig applicationConfig;

    protected GeneratedNuitonConfigExampleConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedNuitonConfigExampleConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(NuitonConfigExampleConfigOption.values());
        this.applicationConfig.loadActions(NuitonConfigExampleConfigAction.class);
    }

    @Override
    public ApplicationConfig get() {
        return applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getFirstName() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey());
    }

    public void setFirstName(String firstName) {    setOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey(), firstName);
    }

    public String getLastName() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey());
    }

    public void setLastName(String lastName) {    setOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey(), lastName);
    }

    public String getEmail() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.EMAIL.getKey());
    }

    public void setEmail(String email) {    setOption(NuitonConfigExampleConfigOption.EMAIL.getKey(), email);
    }

    public String getTwitter() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.TWITTER.getKey());
    }

    public void setTwitter(String twitter) {    setOption(NuitonConfigExampleConfigOption.TWITTER.getKey(), twitter);
    }

    public int getAge() {
        return applicationConfig.getOptionAsInt(NuitonConfigExampleConfigOption.AGE.getKey());
    }

    public void setAge(int age) {    setOption(NuitonConfigExampleConfigOption.AGE.getKey(), age);
    }

    public String getConfigurationDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n=====================================================================================================================");
        builder.append("\n=== Configuration ===================================================================================================");
        builder.append("\n=====================================================================================================================");
        builder.append(String.format("\n=== %1$-40s = %2$s", "Filename", get().getConfigFileName()));
        for (NuitonConfigExampleConfigOption option : orderedByKey()) {
            builder.append(String.format("\n=== %1$-40s = %2$s", option.getKey(), get().getOption(option.getKey())));
        }
        builder.append("\n=====================================================================================================================");
        return builder.toString();
    }

    protected List<NuitonConfigExampleConfigOption> orderedByKey() {
        List<NuitonConfigExampleConfigOption> values = Arrays.asList(NuitonConfigExampleConfigOption.values());
        Collections.sort(values, new Comparator<NuitonConfigExampleConfigOption>() {
            @Override
            public int compare(NuitonConfigExampleConfigOption o1, NuitonConfigExampleConfigOption o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return Collections.unmodifiableList(values);
    }

} //GeneratedNuitonConfigExampleConfig
