/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.BasicMatrixIterator;
import org.nuiton.math.matrix.DimensionHelper;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorIterator;

public class BasicMatrix {
    protected MatrixFactory factory = null;
    protected int[] dimensions = null;
    protected Vector data = null;
    protected int[] linearFactor = null;

    public BasicMatrix(MatrixFactory factory, int[] dimensions) {
        this.factory = factory;
        this.checkDim(dimensions);
        this.dimensions = new int[dimensions.length];
        System.arraycopy(dimensions, 0, this.dimensions, 0, dimensions.length);
        this.linearFactor = MatrixHelper.getLinearFactor(dimensions);
        int dataSize = MatrixHelper.getVectorSize(dimensions, this.linearFactor);
        this.data = factory.createVector(dataSize);
    }

    public BasicMatrix(MatrixFactory factory, Vector data, int[] dimensions) {
        this.factory = factory;
        this.checkDim(dimensions);
        this.dimensions = new int[dimensions.length];
        System.arraycopy(dimensions, 0, this.dimensions, 0, dimensions.length);
        this.linearFactor = MatrixHelper.getLinearFactor(dimensions);
        this.data = data;
        int dataSize = MatrixHelper.getVectorSize(dimensions, this.linearFactor);
        if (dataSize != data.size()) {
            throw new IllegalArgumentException(String.format("Vector backend in argument don't have right size. Vector size %s but need %d", data.size(), dataSize));
        }
    }

    public Vector getInternalVector() {
        return this.data;
    }

    public int getNumberOfAssignedValue() {
        int result = 0;
        if (this.data != null) {
            this.data.getNumberOfAssignedValue();
        }
        return result;
    }

    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    public double getMaxOccurrence() {
        return this.data.getMaxOccurrence();
    }

    public int getNbDim() {
        return this.dimensions.length;
    }

    public int getDim(int dim) {
        this.checkDim(dim);
        return this.dimensions[dim];
    }

    public int[] getDim() {
        return this.dimensions;
    }

    public double getValue(int[] pos) {
        int indice = this.coordonatesToLinear(pos);
        return this.data.getValue(indice);
    }

    public void setValue(int[] pos, double value) {
        int indice = this.coordonatesToLinear(pos);
        this.data.setValue(indice, value);
    }

    public BasicMatrixIterator iterator() {
        return new BasicMatrixIteratorImpl(this);
    }

    public BasicMatrixIterator iteratorNotZero() {
        return new BasicMatrixIteratorImpl(this, 0.0);
    }

    public void map(MapFunction f) {
        if (this.data.isImplementedMap()) {
            this.data.map(f);
        } else {
            for (int i = 0; i < this.data.size(); ++i) {
                double result = f.apply(this.data.getValue(i));
                this.data.setValue(i, result);
            }
        }
    }

    protected int coordonatesToLinear(int[] coordonates) {
        if (this.dimensions.length != coordonates.length) {
            throw new NoSuchElementException(I18n.t((String)"nuitonmatrix.invalid.element", (Object[])new Object[]{Arrays.toString(coordonates), Arrays.toString(this.dimensions)}));
        }
        int result = 0;
        for (int i = 0; i < this.linearFactor.length; ++i) {
            int p = coordonates[i];
            if (0 <= p && p < this.dimensions[i]) {
                result += p * this.linearFactor[i];
                continue;
            }
            throw new NoSuchElementException(I18n.t((String)"nuitonmatrix.invalid.element", (Object[])new Object[]{Arrays.toString(coordonates), Arrays.toString(this.dimensions)}));
        }
        return result;
    }

    protected int[] linearToCoordinates(int pos) {
        int[] result = new int[this.linearFactor.length];
        return this.linearToCoordinates(result, pos);
    }

    protected int[] linearToCoordinates(int[] result, int pos) {
        for (int i = 0; i < result.length; ++i) {
            result[i] = pos / this.linearFactor[i];
            pos -= result[i] * this.linearFactor[i];
        }
        return result;
    }

    protected void checkDim(int[] dim) {
        for (int i = 0; i < dim.length; ++i) {
            if (dim[i] > 0) continue;
            throw new IllegalArgumentException(I18n.t((String)"nuitonmatrix.invalid.size", (Object[])new Object[]{i, dim[i]}));
        }
    }

    protected void checkDim(int dim) {
        if (dim < 0 || dim >= this.getNbDim()) {
            throw new IndexOutOfBoundsException(I18n.t((String)"nuitonmatrix.invalid.size", (Object[])new Object[]{dim, this.getNbDim()}));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.getNbDim() == 1) {
            result.append("matrix1D [");
            for (int i = 0; i < this.data.size(); ++i) {
                result.append(this.data.getValue(i) + ",");
            }
            result.append("]");
        } else if (this.getNbDim() == 2) {
            DimensionHelper dimHelper = new DimensionHelper();
            result.append("matrix2D [");
            for (int y = 0; y < this.getDim(1); ++y) {
                result.append("\n");
                for (int x = 0; x < this.getDim(0); ++x) {
                    result.append(this.getValue(dimHelper.get(x, y)) + ",");
                }
            }
            result.append("]");
        } else {
            int i;
            result.append("dimensions = [\n");
            for (i = 0; i < this.dimensions.length; ++i) {
                result.append(this.dimensions[i] + ",");
            }
            result.append("\n]\nmatrice = [\n");
            for (i = 0; i < this.data.size(); ++i) {
                result.append(this.data.getValue(i) + ",");
            }
            result.append("\n]\nlinearFactor = [\n");
            for (i = 0; i < this.linearFactor.length; ++i) {
                result.append(this.linearFactor[i] + ",");
            }
            result.append("\n]\n");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof BasicMatrix) {
            BasicMatrix other = (BasicMatrix)o;
            return this == o || Arrays.equals(this.dimensions, other.dimensions) && this.data.equals(other.data);
        }
        return false;
    }

    protected class BasicMatrixIteratorImpl
    implements BasicMatrixIterator {
        protected BasicMatrix matrix = null;
        protected VectorIterator iter;
        protected int[] pos;

        public BasicMatrixIteratorImpl(BasicMatrix matrix) {
            this.matrix = matrix;
            this.iter = matrix.data.iterator();
            this.pos = new int[matrix.getNbDim()];
        }

        public BasicMatrixIteratorImpl(BasicMatrix matrix, double exclude) {
            this(matrix);
            this.iter.setExclude(exclude);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean next() {
            boolean result = this.hasNext();
            if (result) {
                this.iter.next();
            }
            return result;
        }

        @Override
        public double getValue() {
            return this.iter.getValue();
        }

        @Override
        public void setValue(double value) {
            this.iter.setValue(value);
        }

        @Override
        public int[] getCoordinates() {
            return this.matrix.linearToCoordinates(this.pos, this.iter.getPosition());
        }
    }
}

