/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixDimensionIndex;
import org.nuiton.math.matrix.MatrixND;

public class MatrixHelper {
    public static MatrixND convertToId(MatrixND mat) {
        int size = mat.getDim(0);
        if (size > mat.getDim(1)) {
            size = mat.getDim(1);
        }
        MatrixHelper.fill(mat, 0.0);
        for (int i = 0; i < size; ++i) {
            mat.setValue(i, i, 1.0);
        }
        return mat;
    }

    public static List<?> convertStringToList(String s) {
        List result = null;
        Stack stack = new Stack();
        StringBuffer number = new StringBuffer(20);
        for (int i = 0; i < s.length(); ++i) {
            Double value;
            char c = s.charAt(i);
            if (c == ' ') {
                // empty if block
            }
            if (c == '[') {
                stack.push(new ArrayList());
                continue;
            }
            if (c == ',') {
                if (number.length() != 0) {
                    value = Double.valueOf(number.toString());
                    ((List)stack.peek()).add(value);
                }
                number.setLength(0);
                continue;
            }
            if (c == ']') {
                if (number.length() != 0) {
                    value = Double.valueOf(number.toString());
                    ((List)stack.peek()).add(value);
                    number.setLength(0);
                }
                List current = (List)stack.pop();
                if (stack.empty()) {
                    result = current;
                    continue;
                }
                ((List)stack.peek()).add(current);
                continue;
            }
            number.append(c);
        }
        return result;
    }

    public static String coordinatesToString(int[] coordinates) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coordinates.length; ++i) {
            sb.append(coordinates[i]);
            if (i + 1 >= coordinates.length) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static String coordinatesToString(Object[] coordinates) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coordinates.length; ++i) {
            sb.append(coordinates[i]);
            if (i + 1 >= coordinates.length) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static boolean sameDimension(int[] dim1, int[] dim2) {
        return Arrays.equals(dim1, dim2);
    }

    public static Object[] dimensionToSemantics(List<?>[] semantics, int[] coordinates) {
        Object[] result = new Object[coordinates.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = semantics[i].get(coordinates[i]);
            if (result[i] != null) continue;
            result[i] = MatrixDimensionIndex.valueOf(coordinates[i]);
        }
        return result;
    }

    public static int[] semanticsToDimension(List<?>[] semantics, Object[] coordinates) {
        int[] result = new int[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            result[i] = coordinates[i] == null ? -1 : MatrixHelper.indexOf(semantics, i, coordinates[i]);
        }
        return result;
    }

    public static int indexOf(List<?>[] semantics, int dim, Object o) throws NoSuchElementException {
        if (o instanceof MatrixDimensionIndex) {
            return ((MatrixDimensionIndex)o).intValue();
        }
        int result = -1;
        if (0 <= dim && dim < semantics.length) {
            result = semantics[dim].indexOf(o);
        }
        if (result == -1) {
            throw new NoSuchElementException("L'objet pass\u00e9 en argument n'a pas \u00e9t\u00e9 retrouv\u00e9 ou la dimension donn\u00e9e ne convient pas:" + o + " in " + semantics[dim]);
        }
        return result;
    }

    public static MatrixND fill(MatrixND mat, final double value) {
        mat.map(new MapFunction(){

            @Override
            public double apply(double v) {
                return value;
            }
        });
        return mat;
    }

    @Deprecated
    public static double maxOccurence(double[] tab) {
        return MatrixHelper.maxOccurrence(tab);
    }

    @Deprecated
    public static double maxOccurence(float[] tab) {
        return MatrixHelper.maxOccurrence(tab);
    }

    public static double maxOccurrence(double[] tab) {
        double[] tmp = new double[tab.length];
        System.arraycopy(tab, 0, tmp, 0, tab.length);
        return MatrixHelper.maxOccurrence1(tmp);
    }

    public static double maxOccurrence(float[] tab) {
        double[] tmp = new double[tab.length];
        for (int i = 0; i < tab.length; ++i) {
            tmp[i] = tab[i];
        }
        return MatrixHelper.maxOccurrence1(tmp);
    }

    protected static double maxOccurrence1(double[] tmp) {
        if (tmp.length == 0) {
            throw new IllegalArgumentException("Array must be not empty");
        }
        Arrays.sort(tmp);
        int max = 1;
        int count = 1;
        double result = tmp[0];
        double old = tmp[0];
        double current = tmp[0];
        for (int i = 1; max < tmp.length - i + count && i < tmp.length; ++i) {
            current = tmp[i];
            if (current == old) {
                ++count;
                continue;
            }
            if (count > max) {
                max = count;
                result = old;
            }
            count = 1;
            old = current;
        }
        if (count > max) {
            max = count;
            result = current;
        }
        return result;
    }
}

