package org.nuiton.jredmine.plugin.announcement;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.nuiton.jredmine.model.Attachment;

import java.io.File;
import java.util.Map;

/**
 * Created: 10 janv. 2010
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 77 $
 *          <p/>
 *          Mise a jour: $Date: 2010-01-10 20:29:08 +0100 (dim., 10 janv. 2010) $ par :
 *          $Author: tchemit $
 * @since 1.2.1
 */
public interface AnnouncementGeneratorConfiguration {

    /**
     * @return the redmine url
     */
    String getUrl();

    /**
     * @return the redmine attachment url template
     */
    String getAttachmentLinkTemplate();

    /**
     * @return logger
     */
    Log getLog();

    String getArtifactId();

    Map<File, String> getArtifactUrls();

    Map<Attachment, String> getAttachmentUrls();

    String getBasedir();

    String getDeploymentUrl();

    String getDevelopmentTeam();

    String getFinalName();

    String getGroupId();

    String getIntroduction();

    String getPackaging();

    String getProjectUrl();

    String getUrlDownload();

    Map<String, Object> getAnnounceParameters();

    String getVersionId();

    MavenProject getProject();
}
