/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: AttachmentXpp3Reader.java 393 2012-11-11 09:10:44Z tchemit $
 * $HeadURL: https://svn.nuiton.org/jredmine/tags/jredmine-1.8.1/jredmine-client/src/main/java/org/nuiton/jredmine/model/io/xpp3/AttachmentXpp3Reader.java $
 * %%
 * Copyright (C) 2009 - 2012 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.io.xpp3.api.AbstractXpp3Reader;

import java.beans.IntrospectionException;

/**
 * {@link Attachment} reader.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class AttachmentXpp3Reader extends AbstractXpp3Reader<Attachment> {

    public AttachmentXpp3Reader() {
        super(Attachment.class, "attachments", "attachment");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(RedmineDataConverter.Integer, true,
                                 "author-id",
                                 "container-id",
                                 "filesize",
                                 "downloads",
                                 "id");

        addTagTextContentMappers(RedmineDataConverter.Datetime, true,
                                 "created-on");

        addTagTextContentMappers(RedmineDataConverter.Text, true,
                                 "container-type",
                                 "content-type",
                                 "description",
                                 "digest",
                                 "disk-filename",
                                 "filename");
    }
}
