/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.nuiton.io.xpp3.Xpp3Helper;
import org.nuiton.jredmine.model.RedmineModelEnum;

import java.io.*;

/**
 * Pour construire le modèle à partir de fichiers xml contenant les données.
 *
 * @author chemit
 * @since 1.0.0
 */
public class RedmineXpp3Helper {

    public <O> O readObject(Class<O> klass, String txt) throws IOException, XmlPullParserException {
        O result = readObject(klass, new ByteArrayInputStream(txt.getBytes()));
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, String txt) throws IOException, XmlPullParserException {
        O[] results = readObjects(klass, new ByteArrayInputStream(txt.getBytes()));
        return results;
    }

    public <O> O readObject(Class<O> klass, File file) throws IOException, XmlPullParserException {
        O result = readObject(klass, new FileInputStream(file));
        return result;
    }

    public <O> O[] readObjects(Class<O> klass, File file) throws IOException, XmlPullParserException {
        O[] results = readObjects(klass, new FileInputStream(file));
        return results;
    }

    public <O> O readObject(Class<O> klass, InputStream stream) throws IOException, XmlPullParserException {

        RedmineModelEnum.safeValueOf(klass);

        O result = Xpp3Helper.readObject(klass, ReaderFactory.newXmlReader(stream));

        return result;
    }

    public <O> O[] readObjects(Class<O> klass, InputStream stream) throws IOException, XmlPullParserException {

        RedmineModelEnum.safeValueOf(klass);

        O[] results = Xpp3Helper.readObjects(klass, ReaderFactory.newXmlReader(stream));
        return results;
    }
}
