package jaxx.runtime.swing.editor.config;
/*
 * #%L
 * JAXX :: Widgets
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.config.model.CategoryModel;
import jaxx.runtime.swing.editor.config.model.ConfigTableModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ConfigCategoryUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uWlLoiap2iInheJIdJ0EEIigUsdNZFebuLKdtCSHMPZO7CnjnWV3NnZqFfEnAH8B3LkgceOEOHDmwAXxLyDEgSvizex612tvcSJy2Ng77/ve997M+8bf/oGSjo2Wn+FOR7NdU9AW0R7lnj4t1Z6RunhInLpNLcFt5P2NJVDiCKWM4L0j0J0jXcKzPjyb5y2Lm8TsQ2/qaMYRZ4w4TUKEQLejiLrjZCvB8mbHcu0eayAqjvXrv/5MfGF8/k0CoY4F6q5BKelRqLCScR0lqCHQHGQ6xVmGzQbIsKnZAL2z8l2eYcfZwy3yKfoMTepowsI2kAm0cv6SFYfCdyyBpl579BibhK0JtB5R6rQhr0YMClitzs0T2gD18l8eC9Lg9tl+0bIU0YRAk01sGozYAr13YZaCBw3Jki1uECbQ2yOpVKBPuF/cld9Cmtm6n2L3gnT9sJBuRuAaIz7XuxeSVg2QId0VhzA40ZSbPuWrcoM7PpdOHVGJBITIuV5dOq4RpnYPXvajvS2V4dPD3VCoQYB6KSNvBoBpVa9kEmgxElyp25ypxNEUSYUYpFbFy4jlILB36Nbl99tRkqu9WYbCeynuyMcbQUiqL0Sg69FspCNyNsEydHUo4UaQMGRL2sSRHjAf4dlyheCmDNGCyHEHnyo9G/57G92MnAPwDS30jXCwx44giwuvBVo6GraaMix5JrM0YDKSUK3+szD/6w+/f7/Tc5YU5L4eG9pnjDDxls0tmEoqU1/1bMUVlGV3sbV5hKa9M6hc81aMsIq/DOIg3ysSrkm4VsBOEyiSk7/9+NPCx79cQokdNMM4NnawjC/C4WlCW5ucGR3rwwdK0eX2lLREqQ2GqYbrnzRs7prgd7PdPGcwOU8Kxer2iw704VZMHwIxtemf/56vfPeg14sx0HbjpeFhP5KHaIKajJpE+axvobG+mrIc4ho8tMo480Sxo2j5g/q+et6PK/5anTO3ZRYINoh9QElboMOuSdppbwwzx5kV30T6DvrK6pvpijyb+3IDGkSA32ETN4idUyZRBEhmhZon3G7hHmB9bRX6KYVsqUbJTw/R8JCNEp0EOzjhddfxBjx5ghnMDBoXMG0CpbuhYpNrXNFq3tkixsrqC4U2xT2HPgdUYh0umynplgNsNm/DQRx7K05x/8yPUnsptsVLXZVPtk5ZkreWkeoWT+WM1DHznG0L2485o/UzgbLd0OzAyx2BTeFoB9vlajGf048r+XJJ17dy5eOc/iT3UQW4bjS5TZ9DtTFsa7FshVK5eFjaq0b49rYhSezehb48qg/jcMtgV/AykY2Xt4jcK8+Qtdx+tXRc3q4UD7dBvH6cL+n7u3uygnnYh+DuyTHG28QId2kaVguENpqw8YmNdyBcpsiD5QpSBiC3hfwZMC5sl8TJ9y6Jc0ifJKaMhNTLXdizyK2cWdWoA5/oCSWG2kL/KM77xxAr8Zpv7TM4GBGBLnsh9/y1lOCcValVVfjFGLwmqBVbiVq9UCW5UZWk795Nx4YcYEYjlc5FlcqraaDQlF+otxStc2EY/bIy1a13DlebYPiMw62JrnxgYIHTNWoaYFf3hzjH5HPmHIwDP5Fk3FfxbK+PZJOvv/wPhsz/ZsgCw78y6KJnvwwAAA==";
    private static final Log log = LogFactory.getLog(ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel categoryLabel;
    protected JPanel categoryLabelPanel;
    protected CategoryModel categoryModel;
    protected JTextArea description;
    protected JScrollPane descriptionPane;
    protected ConfigCategoryUIHandler handler;
    protected ConfigUIModel model;
    protected JButton reset;
    protected JButton save;
    protected ListSelectionModel selectionModel;
    protected JTable table;
    protected ConfigTableModel tableModel;
    protected JScrollPane tablePane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private JPanel $JPanel1;
    private JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
      getHandler().init();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ConfigCategoryUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.reset();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.saveModified();
    }

    public void doTableChanged__on__tableModel(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (!event.getValueIsAdjusting()) {handler.updateDescriptionText(); }
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public JTextArea getDescription() {
        return description;
    }

    public JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public ConfigCategoryUIHandler getHandler() {
        return handler;
    }

    public ConfigUIModel getModel() {
        return model;
    }

    public JButton getReset() {
        return reset;
    }

    public JButton getSave() {
        return save;
    }

    public ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public JTable getTable() {
        return table;
    }

    public ConfigTableModel getTableModel() {
        return tableModel;
    }

    public JScrollPane getTablePane() {
        return tablePane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(CategoryModel categoryModel) {
        CategoryModel oldValue = this.categoryModel;
        this.categoryModel = categoryModel;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, categoryModel);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, selectionModel);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new JLabel());
        
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new JPanel());
        
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new JTextArea());
        
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new JScrollPane());
        
        descriptionPane.setName("descriptionPane");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new ConfigCategoryUIHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        
        selectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JTable(tableModel));
        
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setRowHeight(25);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new ConfigTableModel(categoryModel));
        
        tableModel.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new JScrollPane());
        
        tablePane.setName("tablePane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(_("config.description"), SwingUtil.getUIManagerActionIcon("information"), 10));
        SwingUtil.setText(description, _("config.no.option.selected"));
        
        reset.setIcon(SwingUtil.createActionIcon("config-reset"));
        save.setIcon(SwingUtil.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}