/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: JAXXLog4jHandler.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.16/jaxx-widgets/src/main/java/jaxx/runtime/swing/log/JAXXLog4jHandler.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.log;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class JAXXLog4jHandler {

    private static final Log log = LogFactory.getLog(JAXXLog4jHandler.class);

    protected JAXXLog4jUI ui;

    protected static JAXXLog4jAppender appender;

    public JAXXLog4jHandler(JAXXLog4jUI ui) {
        this.ui = ui;
    }

    /**
     * Init {@link JAXXLog4jAppender} with level INFO and pattern : %5p [%t] (%F:%L) %M - %m%n
     */
    public static void init() {
        init("INFO", "%5p [%t] (%F:%L) %M - %m%n");
    }

    /**
     * Init {@link JAXXLog4jAppender} with specific {@link Level} and {@link PatternLayout}
     *
     * @param level specify log4j {@link Level}
     * @param patternLayout log4j {@link PatternLayout} to display
     */
    public static void init(String level, String patternLayout) {
        Logger logger = Logger.getRootLogger();

        if (appender == null) {
            appender = new JAXXLog4jAppender();
            logger.addAppender(appender);
        }
        appender.setLevel(Level.toLevel(level));
        appender.setLayout(new PatternLayout(patternLayout));
    }

    final protected Action closeAction = new AbstractAction("close") {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog container = ui.getParentContainer(JDialog.class);
            if (container != null) {
                container.dispose();
            } else {
                ui.setVisible(false);
            }
        }
    };

    public JAXXLog4jAppender getAppender() {
        return appender;
    }

    public void showInDialog(Frame ui, boolean undecorated) {
        JDialog f = new JDialog(ui, this.ui.getTitle(), false);
        f.add(this.ui);
        f.setResizable(true);
        f.setSize(550, 450);
        f.setUndecorated(undecorated);
        JRootPane rootPane = f.getRootPane();
        rootPane.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        rootPane.getActionMap().put("close", closeAction);
        f.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component) e.getSource();
                if (log.isInfoEnabled()) {
                    log.info("destroy ui " + ui);
                }
                JAXXUtil.destroy(ui);
                JAXXUtil.destroy(JAXXLog4jHandler.this.ui);
            }
        });
        SwingUtil.center(ui, f);
        f.setVisible(true);
    }
}
