/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import jaxx.runtime.swing.HidorButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HidorButtonHandler {
    private static final Log log = LogFactory.getLog(HidorButtonHandler.class);
    protected final HidorButton ui;

    public HidorButtonHandler(HidorButton ui) {
        this.ui = ui;
    }

    void $afterCompleteSetup() {
        this.ui.addPropertyChangeListener("targetVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">"));
                }
                boolean newValue = (Boolean)evt.getNewValue();
                if (HidorButtonHandler.this.ui.target != null) {
                    HidorButtonHandler.this.ui.target.setVisible(newValue);
                }
            }
        });
    }

    public void setTarget(JComponent target) {
        JComponent oldValue = this.ui.target;
        this.ui.target = target;
        this.ui.firePropertyChange("target", oldValue, target);
    }

    public void setExpandIcon(Icon icon) {
        this.ui.putClientProperty("expandIcon", icon);
    }

    public void setHideIcon(Icon icon) {
        this.ui.putClientProperty("hideIcon", icon);
    }

    protected String updateToolTipText(boolean c) {
        return c ? this.ui.hideTip : this.ui.showTip;
    }

    protected String updateText(boolean c) {
        return c ? this.ui.hideText : this.ui.showText;
    }

    protected Icon updateIcon(boolean c) {
        String key = c ? "hideIcon" : "showIcon";
        return (Icon)this.ui.getClientProperty(key);
    }
}

