/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Author: tchemit $
 * $Id: MainCallBackFinalizer.java 2012 2010-06-30 16:47:57Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.1.1/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/config/model/MainCallBackFinalizer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.config.model;

import java.util.ArrayList;
import java.util.List;

/**
 * A finalizer to mark a special category to eat every others categories
 * when finalizing.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0.2
 */
public class MainCallBackFinalizer implements CallBackFinalizer {

    /** name of call back which eats everybody */
    protected final String mainCallBack;

    public MainCallBackFinalizer(String mainCallBack) {
        this.mainCallBack = mainCallBack;
    }

    @Override
    public CallBackMap finalize(CallBackMap result) {
        CallBackEntry applicationEntry = result.getCallBack(mainCallBack);
        CallBackMap newResult;
        if (applicationEntry == null) {
            // rien n'a change
            newResult = result;
        } else {
            newResult = new CallBackMap();
            // on passe toutes les options sur ce callback
            List<OptionModel> options = new ArrayList<OptionModel>();

            for (List<OptionModel> optionModels : result.values()) {
                options.addAll(optionModels);
            }
            newResult.put(applicationEntry, options);
        }
        return newResult;
    }
}
