package jaxx.runtime.swing.editor.config;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.ColumnSelector;
import jaxx.runtime.swing.editor.config.*;
import jaxx.runtime.swing.editor.config.model.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class ConfigCategoryUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_TABLE_PANE_COLUMN_HEADER_VIEW = "tablePane.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uUlKrCYplMo1JUpEu04AqYcgWsckiqtNXNlO2iaHMPZOnCnjnWV2HDu1ivgDQOJPgDsXJG6cEAfOHLgg/gWEOHBFvJld73rjLU6ED+v1zHvf+96b977xt3+gpCvQ7ee40zFEy5a0SYxH+adPS7XnpC4/Im5dUEdygbzPSAIlDlHKCtZdid46NJV7znfPFXjT4Tax+7zXTTTlyjNG3BNCpERvRj3qrpurBNvrHacleqgBqTjUr//6M/GV9fk3CYQ6DrCbhVQyw7zCTEZNlKCWRHMQ6RTnGLYbQENQuwF8p9VagWHX3cVN8in6DI2baMzBAsAkyl48ZY2h/TuORBN3Hj3GNmGrEq1FmLptiGsQi4KvUef2MW0Ae/VVwJI0uDjbKzqOBhqTKNnkFmESvT8UQxv6SHvFHfUrhJmu+9g7l4TrdwvhpiSuMeJj3b8UtWrgGcLNuIRBE1Ju+5C31Jl0fCyTurISMQg953p5mbhGmC44LPZ7e6egzCcHq6G9zjvoRWW5GDhM6nwVkkQLEeNKXXCmA0dDJLXHeWidvLK4FRj2+mRN/X49CjLbGz9IvBciox53ApNUn4lE16PRSEfmBcHKdGkg4LtBwBAtKYirxjYdwdloScltZfJOYDnq4lPNJ+evC/RGpA9g1I1w1MNZHDmEKC1YlmjxcFAdyrDl6cLiOV1QgHr3n/n0rz/8/v1WTwxSEPt6rGmflsGQOoI7REiqQs96StCSlOV2sLN+iCa9HtRCdzOGWMXfBnIQ7zXlbih3Yxu7JwCRHP/tx5/mP/7lCkpsoSnGsbWFlX0RmucEynrCmdVxHjzUjK62J+B5TXGDYarh+icNwVs2SNR0t8AZTM6T7WJ182UH6nAzpg4Bmdrkz3+nK9897NViBLjdeKV5WI/kARqjNqM20dLoq16sFKYcl7QsHqpbnN6h2FF0/EG9r5/rcclfq3PWatrbBFtE7FPSluhZ1ybtjDeGy0fLWV9EvEZXfZ5duZupqNbcU/VvEAlyh23cICKvNaIIHstZah9z0cQ9h7XVFSin4vFA10m95dHgjA3jnAQ1OOb1luvNd/IYMxgZNCph2CTKdEPCNje4hjW81iJWduWl9rblPZe+AK/EGlwPE0osz6EJ3oY+HHkvjnH/yA9jeyW2wotdHU+VTiuSt7es2C2cqhGpY+YJ2wYWjzmj9TOJct1Q60DKXYlt6Rr7m+VqsZA3jyqFcsk0N/Llo7z5JP+sAlg3TrigLyDbGLTVWLTtUrl4UNqtRvB2NyFI7NmFsnyBOszgluRlogqvLhF1Vp4eG/m9aumovFkpHmwCefOoUDL3dnZVBmk4h+DqyTPG28QKTymtEAsgsJKUwY4LCbWDThAtEsfWuxKGMR2VaJzYyhIi3e7CEUXu4OUVg7rwRo8psfSJ+Z2X9rsOa66GL+RTOJgIia56Jvf8vZTknFWpU9X+CzH+hqRObCZ691KZ5IdlkllaysSa7GNGI5nORZmqi+hcoik/UW8rmuf8oPer0tR33AU0bIzhMw53JJr5wMISZ2rUtkCdPhzAHFHPqQsgnvtDpOy+jEfLDkVTy1/8B8Lb/xvhLiD8C+z5g41gDAAA";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.config.ConfigCategoryUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel categoryLabel;
    protected javax.swing.JPanel categoryLabelPanel;
    protected jaxx.runtime.swing.editor.config.model.CategoryModel categoryModel;
    protected javax.swing.JTextArea description;
    protected javax.swing.JScrollPane descriptionPane;
    protected jaxx.runtime.swing.editor.config.model.ConfigUIModel model;
    protected javax.swing.JButton reset;
    protected javax.swing.JButton save;
    protected javax.swing.ListSelectionModel selectionModel;
    protected javax.swing.JTable table;
    protected jaxx.runtime.swing.editor.config.model.ConfigTableModel tableModel;
    protected javax.swing.JScrollPane tablePane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ConfigCategoryUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    void $afterCompleteSetup() {
        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(table,
            n_("config.key"),
            n_("config.key.tip"),
            n_("config.value"),
            n_("config.value.tip"),
            n_("config.defaultValue"),
            n_("config.defaultValue.tip"));
    
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        //TODO to be continued...
        //columnSelector.setMyTable(table);
        //tablePane.setCorner(ScrollPaneConstants.UPPER_RIGHT_CORNER, columnSelector);
    }
    
    protected void updateDescriptionText() {
        OptionModel option;
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(JAXXContext parentContext) {
        Util.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        model.reset();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        model.saveModified();
    }

    public void doTableChanged__on__tableModel(javax.swing.event.TableModelEvent event) {
        updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(javax.swing.event.ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) { updateDescriptionText(); };
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public javax.swing.JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public jaxx.runtime.swing.editor.config.model.CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public javax.swing.JTextArea getDescription() {
        return description;
    }

    public javax.swing.JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigUIModel getModel() {
        return model;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigTableModel getTableModel() {
        return tableModel;
    }

    public javax.swing.JScrollPane getTablePane() {
        return tablePane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCategoryModel(jaxx.runtime.swing.editor.config.model.CategoryModel newValue) {
        jaxx.runtime.swing.editor.config.model.CategoryModel oldValue = this.categoryModel;
        this.categoryModel = newValue;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, newValue);
    }

    public void setSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new javax.swing.JLabel());
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new javax.swing.JPanel());
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new javax.swing.JTextArea());
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new javax.swing.JScrollPane());
        descriptionPane.setName("descriptionPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ConfigUIModel.class));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new javax.swing.JButton());
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        selectionModel.addListSelectionListener(Util.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new javax.swing.JTable(tableModel));
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new jaxx.runtime.swing.editor.config.model.ConfigTableModel(categoryModel));
        tableModel.addTableModelListener(Util.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new javax.swing.JScrollPane());
        tablePane.setName("tablePane");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        
        // apply 3 data bindings
        Util.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(_("config.descrition"), SwingUtil.getUIManagerActionIcon("information"), 10));
        jaxx.runtime.SwingUtil.setText(description, _("config.no.option.selected"));
        
        reset.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config-reset"));
        save.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 3 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createModel();
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_PANE_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (table != null) {
                    table.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (table != null) {
                    table.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("categoryModel", this);
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("modified", this);
                }
                if (getCategoryModel() != null) {
                    getCategoryModel().removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}