package jaxx.runtime.swing.editor.config;

import jaxx.runtime.swing.editor.config.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.Util;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.swing.editor.config.model.*;
import jaxx.runtime.swing.editor.ColumnSelector;
import static org.nuiton.i18n.I18n.n_;
import jaxx.runtime.DataBindingListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigCategoryUI extends javax.swing.JPanel implements jaxx.runtime.JAXXObject {
    public static final String PROPERTY_CATEGORY_MODEL = "categoryModel";
    public static final String PROPERTY_SELECTION_MODEL = "selectionModel";
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.config.ConfigCategoryUI.class);
    private static String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuHF+uUlLrPyo2kLiosqR2nUClUBKVeqYVHG1iSvbSUtyCGPvxJky3llmx7FTq4grnPgT4M4FiRsnxIEzBy6IfwFVHLgi3syud732FgeRg+PMvO9733sz75t8+wdKugKtPsedjiFatqRNYjzOP3tWqj0ndfkhceuCOpIL5P2MJVDiCKWsYN2V6NaRqeA5H54r8KbDbWL3oTdNNOPKc0bcU0KkRDejiLrr5irB9mbHaYkeayAqjvXrP18lvrI+/yaBUMcBdXNQysooVFjJuIkS1JJoHjKd4RzDdgNkCGo3QO+sWisw7Lp7uEk+RZ+hSRNNOFgAmUSZi5esOTS+40g09fbjJ9gmbF2ijYhStw15DWJRwBp1bp/QBqhXvwpYkgYX5/tFx9FEExLN1v3FXW4RJtG9kVxNFWgU+mEh3YzENUZ8rvcuyqX/qAbIkG7OJQxuD+W2T/mmambH5zKpKyuRgBA536vLxDXCdKdgsR/ttU+FTw93Q6MGAXpRRS4EgGldr2KSaCkSXKkLznTiaIqkRgxS6+JVxPUgsHfAG+rvpSjJld7cQOG9FDfVx2oQkuoLkWghmo10ZF4QrEJvDSV8J0gYsiUFcdW8pSM8Wy0pua1CskHkuIvPtJ47/rpA1yP3AGbUCGc0HKKxI8jSgmWJlo+Gx7oMW95ALw8MtCLUu38vpn/94ffvH/WmOAW5F2JD+0wIpssR3CFCUpX6ijfCLUlZbhc7m0do2ruD2qFuxAir+NsgDvK9oeCGghs72D0FiuTkbz/+tPjxL5dQ4hGaYRxbj7CKL8LlOYW2nnJmdZwPHmpFl9tT8HlVaYNhquH6Jw3BWzZ4y2y3wBlMztOdYnX7ZQf6cCOmD4GY2vTPf6Ur3z3s9WIMtF17bXjYj+QhmqA2ozbRnubbVayHpRyXtCwe2lKcUaHYUXT8Qb2nP9+PK/5qnbNW094h2CLigJK2RLhrk/aKN4bZ42zGNxHvoqt7nlm7E3XtfXUODSL3i7vYxg0i8torioDMZqh9wkUT94Ab62vQVqXnvu6X+vYADc/aKO1JcIUTXm+53pwnTzCD0UHjEoZOopVuKNzmBte0hnfFiJVZe6nRtrzr0heASmyAv08p0xxgE7wN93Hs3TjF/aM/Su2l2E4vd3U+1TrtTN5eVqlbOlOjUsfMM7gtLJ5wRuvnEuW6oeeBpbsS29I1DrbL1WIhbx5XCuWSaW7ly8d582n+owpwXTvlgr6AamPY1mPZdkrl4mFprxrh29uGJLFnF9rzBfowh1uSl4lqvHpM1Fl5vmzk96ul4/J2pXi4DeLN40LJ3N/dUxWk4RyCJyjPGG8TKzyltGIsgNFKUoY4LiT0Dm6CaJE4td7TMErpuESTxFaRkGm1C0cUeYuzawZ14Rs9ocTSJ+bfvLR/67DWaviGPoODiZDoshdy199LSc5ZlTpVjV+KwRuSOrGV6N3/VEl+VCUrt2+vxIYcYEYjlc5HlaoHaaDQlF+otxWtc3EY/boy9Vt3AS+bYPicw1uJ5u5bWOKVGrUteEAfDHGOqc+ZCzAO/GOk4r6MZ3trJJta/uJfGDL/m2ENGP4BW6Bf6iEMAAA=";
    private static final long serialVersionUID = 1L;
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected java.util.Map<?,?> $previousValues = new java.util.HashMap<Object,Object>();
    protected javax.swing.JLabel categoryLabel;
    protected javax.swing.JPanel categoryLabelPanel;
    protected jaxx.runtime.swing.editor.config.model.CategoryModel categoryModel;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();
    protected javax.swing.JTextArea description;
    protected javax.swing.JScrollPane descriptionPane;
    protected javax.swing.JButton reset;
    protected javax.swing.JButton save;
    protected javax.swing.ListSelectionModel selectionModel;
    protected javax.swing.JTable table;
    protected jaxx.runtime.swing.editor.config.model.ConfigTableModel tableModel;
    protected javax.swing.JScrollPane tablePane;
    private ConfigCategoryUI $JPanel0 = this;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JPanel $JPanel2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    private PropertyChangeListener $DataSource14 = new DataBindingListener(this, "reset.enabled");
    private PropertyChangeListener $DataSource16 = new DataBindingListener(this, "save.enabled");
    private PropertyChangeListener $DataSource8 = new DataBindingListener(this, "tablePane.columnHeaderView");

    /* begin raw body code */    
    
    void $afterCompleteSetup() {
        // prepare table
        SwingUtil.setI18nTableHeaderRenderer(table,
            n_("config.key"),
            n_("config.key.tip"),
            n_("config.value"),
            n_("config.value.tip"),
            n_("config.defaultValue"),
            n_("config.defaultValue.tip"));
    
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer(table, 0, renderer);
        SwingUtil.setTableColumnRenderer(table, 1, renderer);
        SwingUtil.setTableColumnRenderer(table, 2, renderer);
        Font f = table.getFont().deriveFont(Font.ITALIC | Font.BOLD);
        int width = SwingUtil.computeTableColumnWidth(table, f, 0, "___*");
        SwingUtil.fixTableColumnWidth(table, 0, width);
        SwingUtil.setTableColumnEditor(table, 1, new ConfigTableEditor((ConfigTableModel) table.getModel()));
        //TODO to be continued...
        //columnSelector.setMyTable(table);
        //tablePane.setCorner(ScrollPaneConstants.UPPER_RIGHT_CORNER, columnSelector);
    }
    
    protected void updateDescriptionText() {
        OptionModel option;
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel) table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug(row + " : " + option);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(_("config.no.option.selected"));
        } else {
            buffer.append(_("config.option.label", option.getKey(), _(option.getDescription()))).append('\n');
            if (option.isModified()) {
                buffer.append(_("config.option.modified", option.getOriginalValue(), option.getValue())).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(_("config.option.final")).append('\n');
            }
        }
        description.setText(buffer.toString());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ConfigCategoryUI() {
        $initialize();
    }

    public ConfigCategoryUI(jaxx.runtime.JAXXContext parentContext) {
        jaxx.runtime.Util.initContext(this, parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ("tablePane.columnHeaderView".equals($binding)) {    
            if (table != null) {
                table.addPropertyChangeListener("tableHeader", $DataSource8);
            }
        } else if ("reset.enabled".equals($binding)) {    
            addPropertyChangeListener("categoryModel", $DataSource14);
            if (getCategoryModel() != null) {
                getCategoryModel().addPropertyChangeListener("modified", $DataSource14);
            }
        } else if ("save.enabled".equals($binding)) {    
            addPropertyChangeListener("categoryModel", $DataSource16);
            if (getCategoryModel() != null) {
                getCategoryModel().addPropertyChangeListener("modified", $DataSource16);
            }
            if ( getCategoryModel() != null) {
                getCategoryModel().addPropertyChangeListener("valid", $DataSource16);
            }
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("tablePane.columnHeaderView".equals($dest)) {
                if (table != null) {
                    tablePane.setColumnHeaderView(table.getTableHeader());
                }
            } else if ("reset.enabled".equals($dest)) {
                if (getCategoryModel() != null) {
                    reset.setEnabled(getCategoryModel().isModified());
                }
            } else if ("save.enabled".equals($dest)) {
                if ( getCategoryModel() != null) {
                    save.setEnabled(getCategoryModel().isModified() && getCategoryModel().isValid());
                }
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ("tablePane.columnHeaderView".equals($binding)) {    
            if (table != null) {
                table.removePropertyChangeListener("tableHeader", $DataSource8);
            }
        } else if ("reset.enabled".equals($binding)) {    
            removePropertyChangeListener("categoryModel", $DataSource14);
            if (getCategoryModel() != null) {
                getCategoryModel().removePropertyChangeListener("modified", $DataSource14);
            }
        } else if ("save.enabled".equals($binding)) {    
            removePropertyChangeListener("categoryModel", $DataSource16);
            if (getCategoryModel() != null) {
                getCategoryModel().removePropertyChangeListener("modified", $DataSource16);
            }
            if ( getCategoryModel() != null) {
                getCategoryModel().removePropertyChangeListener("valid", $DataSource16);
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return Util.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return Util.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__reset(java.awt.event.ActionEvent event) {
        getContextValue(ConfigUIModel.class).reset();
    }

    public void doActionPerformed__on__save(java.awt.event.ActionEvent event) {
        getContextValue(ConfigUIModel.class).saveModified();
    }

    public void doTableChanged__on__tableModel(javax.swing.event.TableModelEvent event) {
        updateDescriptionText();
    }

    public void doValueChanged__on__selectionModel(javax.swing.event.ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) { updateDescriptionText(); };
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JLabel getCategoryLabel() {
        return categoryLabel;
    }

    public javax.swing.JPanel getCategoryLabelPanel() {
        return categoryLabelPanel;
    }

    public jaxx.runtime.swing.editor.config.model.CategoryModel getCategoryModel() {
        return categoryModel;
    }

    public javax.swing.JTextArea getDescription() {
        return description;
    }

    public javax.swing.JScrollPane getDescriptionPane() {
        return descriptionPane;
    }

    public javax.swing.JButton getReset() {
        return reset;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public javax.swing.ListSelectionModel getSelectionModel() {
        return selectionModel;
    }

    public javax.swing.JTable getTable() {
        return table;
    }

    public jaxx.runtime.swing.editor.config.model.ConfigTableModel getTableModel() {
        return tableModel;
    }

    public javax.swing.JScrollPane getTablePane() {
        return tablePane;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setCategoryModel(jaxx.runtime.swing.editor.config.model.CategoryModel newValue) {
        jaxx.runtime.swing.editor.config.model.CategoryModel oldValue = this.categoryModel;
        this.categoryModel = newValue;
        firePropertyChange(PROPERTY_CATEGORY_MODEL, oldValue, newValue);
    }

    public void setSelectionModel(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = newValue;
        firePropertyChange(PROPERTY_SELECTION_MODEL, oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JPanel get$JPanel2() {
        return $JPanel2;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add(categoryLabelPanel, BorderLayout.NORTH);
        add(tablePane, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
        addChildrenToCategoryLabelPanel();
        addChildrenToTablePane();
        // inline complete setup of $JPanel1
        $JPanel1.add(descriptionPane, BorderLayout.CENTER);
        $JPanel1.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToDescriptionPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(reset);
        $JPanel2.add(save);
        // init data bindings
        table.setSelectionModel(selectionModel);
        categoryLabelPanel.setBackground(Color.WHITE);
        applyDataBinding("tablePane.columnHeaderView");
        tablePane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        tablePane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
        descriptionPane.setColumnHeaderView(new JLabel(_("config.descrition"), jaxx.runtime.Util.getUIManagerActionIcon("information"), 10));
        jaxx.runtime.SwingUtil.setText(description, _("config.no.option.selected"));
        
        applyDataBinding("reset.enabled");
        reset.setIcon(jaxx.runtime.Util.createActionIcon("config-reset"));
        applyDataBinding("save.enabled");
        save.setIcon(jaxx.runtime.Util.createActionIcon("config-save"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createCategoryModel();
        createTableModel();
        createSelectionModel();
        createCategoryLabelPanel();
        createCategoryLabel();
        createTablePane();
        createTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createDescriptionPane();
        createDescription();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new javax.swing.JPanel());
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createReset();
        createSave();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

    protected void addChildrenToCategoryLabelPanel() {
        if (!allComponentsCreated) {
            return;
        }
        categoryLabelPanel.add(categoryLabel);
    }

    protected void addChildrenToDescriptionPane() {
        if (!allComponentsCreated) {
            return;
        }
        descriptionPane.getViewport().add(description);
    }

    protected void addChildrenToTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        tablePane.getViewport().add(table);
    }

    protected void createCategoryLabel() {
        $objectMap.put("categoryLabel", categoryLabel = new javax.swing.JLabel());
        categoryLabel.setName("categoryLabel");
    }

    protected void createCategoryLabelPanel() {
        $objectMap.put("categoryLabelPanel", categoryLabelPanel = new javax.swing.JPanel());
        categoryLabelPanel.setName("categoryLabelPanel");
    }

    protected void createCategoryModel() {
        $objectMap.put("categoryModel", categoryModel = getContextValue(CategoryModel.class));
    }

    protected void createDescription() {
        $objectMap.put("description", description = new javax.swing.JTextArea());
        description.setName("description");
        description.setColumns(15);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        description.setFocusable(false);
        if (description.getFont() != null) {
            description.setFont(description.getFont().deriveFont((float) 10));
        }
        description.setEditable(false);
        description.setRows(3);
    }

    protected void createDescriptionPane() {
        $objectMap.put("descriptionPane", descriptionPane = new javax.swing.JScrollPane());
        descriptionPane.setName("descriptionPane");
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new javax.swing.JButton());
        reset.setName("reset");
        reset.setText(_("config.action.reset"));
        reset.setToolTipText(_("config.action.reset.tip"));
        reset.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__reset"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new javax.swing.JButton());
        save.setName("save");
        save.setText(_("config.action.save"));
        save.setToolTipText(_("config.action.save.tip"));
        save.addActionListener(Util.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectionModel() {
        $objectMap.put("selectionModel", selectionModel = new DefaultListSelectionModel());
        selectionModel.addListSelectionListener(Util.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__selectionModel"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new javax.swing.JTable(tableModel));
        table.setName("table");
        table.setRowSelectionAllowed(false);
        table.setAutoCreateRowSorter(true);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new jaxx.runtime.swing.editor.config.model.ConfigTableModel(categoryModel));
        tableModel.addTableModelListener(Util.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__tableModel"));
    }

    protected void createTablePane() {
        $objectMap.put("tablePane", tablePane = new javax.swing.JScrollPane());
        tablePane.setName("tablePane");
    }

}