/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.absolute;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.swing.AbstractButton;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class CoordinatesEditorHandler
implements UIHandler<CoordinatesEditor> {
    private CoordinatesEditor ui;

    public void beforeInit(CoordinatesEditor ui) {
        this.ui = ui;
        CoordinatesEditorModel model = new CoordinatesEditorModel();
        model.setFormat(CoordinateFormat.dd);
        model.setQuadrant(0);
        ui.setContextValue(model);
    }

    public void afterInit(CoordinatesEditor ui) {
        ui.getLatitudeDd().init(false);
        ui.getLatitudeDms().init(false);
        ui.getLatitudeDmd().init(false);
        ui.getLongitudeDd().init(true);
        ui.getLongitudeDms().init(true);
        ui.getLongitudeDmd().init(true);
    }

    public void resetModel() {
        this.ui.getLongitudeDd().resetModel();
        this.ui.getLongitudeDms().resetModel();
        this.ui.getLongitudeDmd().resetModel();
        this.ui.getLatitudeDd().resetModel();
        this.ui.getLatitudeDms().resetModel();
        this.ui.getLatitudeDmd().resetModel();
    }

    public void resetQuadrant() {
        JAXXButtonGroup quadrantBG = this.ui.getQuadrantBG();
        quadrantBG.remove((AbstractButton)this.ui.getQuadrant1());
        quadrantBG.remove((AbstractButton)this.ui.getQuadrant2());
        quadrantBG.remove((AbstractButton)this.ui.getQuadrant3());
        quadrantBG.remove((AbstractButton)this.ui.getQuadrant4());
        this.ui.getQuadrant1().setSelected(false);
        this.ui.getQuadrant2().setSelected(false);
        this.ui.getQuadrant3().setSelected(false);
        this.ui.getQuadrant4().setSelected(false);
        quadrantBG.add((AbstractButton)this.ui.getQuadrant1());
        quadrantBG.add((AbstractButton)this.ui.getQuadrant2());
        quadrantBG.add((AbstractButton)this.ui.getQuadrant3());
        quadrantBG.add((AbstractButton)this.ui.getQuadrant4());
        this.ui.setQuadrant(null);
        this.ui.getQuadrantBG().setSelectedValue(null);
    }

    public void init(CoordinatesEditor ui) {
        CoordinatesEditorModel model = ui.getModel();
        Serializable bean = model.getBean();
        if (bean != null) {
            if (model.getPropertyLatitude() != null) {
                Method latitudeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyLatitude());
                Objects.requireNonNull(latitudeMutator, "could not find mutator for " + model.getPropertyLatitude());
                model.addPropertyChangeListener("latitude", new ModelPropertyChangeListener(model, latitudeMutator));
            }
            if (model.getPropertyLatitude() != null) {
                Method longitudeMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyLongitude());
                Objects.requireNonNull(longitudeMutator, "could not find mutator for " + model.getPropertyLongitude());
                model.addPropertyChangeListener("longitude", new ModelPropertyChangeListener(model, longitudeMutator));
            }
            if (model.getPropertyQuadrant() != null) {
                Method quadrantMutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyQuadrant());
                Objects.requireNonNull(quadrantMutator, "could not find mutator for " + model.getPropertyQuadrant());
                model.addPropertyChangeListener("quadrant", new ModelPropertyChangeListener(model, quadrantMutator));
            }
        }
    }

    public boolean isQuadrantSelected(Integer value, int requiredValue) {
        return value != null && value == requiredValue;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final CoordinatesEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(CoordinatesEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue = evt.getNewValue();
            try {
                this.mutator.invoke((Object)this.model.getBean(), newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

