/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorMessage;

public class SimpleBeanValidatorMessageTableModel
extends AbstractTableModel
implements SimpleBeanValidatorListener {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(SimpleBeanValidatorMessageTableModel.class);
    public static final String[] columnNames = new String[]{"validator.scope", "validator.field", "validator.message"};
    public static final Class<?>[] columnClasses = new Class[]{NuitonValidatorScope.class, String.class, String.class};
    protected transient List<SimpleBeanValidator<?>> validators = new ArrayList();
    protected List<SimpleBeanValidatorMessage> data = new ArrayList<SimpleBeanValidatorMessage>();

    public void registerValidator(SimpleBeanValidator<?> validator) {
        if (this.validators.contains(validator)) {
            throw new IllegalArgumentException("the validator " + validator + " is already registred in " + this);
        }
        this.validators.add(validator);
        validator.addSimpleBeanValidatorListener((SimpleBeanValidatorListener)this);
    }

    public void addMessages(SimpleBeanValidator<?> validator, String fieldName, NuitonValidatorScope scope, String ... messages) {
        this.addMessages(validator, fieldName, scope, true, messages);
    }

    public void removeMessages(SimpleBeanValidator<?> validator, String fieldName, NuitonValidatorScope scope, String ... messages) {
        this.removeMessages(validator, fieldName, scope, true, messages);
    }

    public void clear() {
        int i = this.data.size();
        if (i > 0) {
            this.data.clear();
            this.fireTableRowsDeleted(0, i - 1);
        }
    }

    public void clearValidators() {
        for (SimpleBeanValidator<?> v : this.validators) {
            v.removeSimpleBeanValidatorListener((SimpleBeanValidatorListener)this);
        }
        this.validators.clear();
    }

    public SimpleBeanValidatorMessage getRow(int rowIndex) {
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        return this.data.get(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        return columnClasses[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)column);
        return columnNames[column];
    }

    public void onFieldChanged(SimpleBeanValidatorEvent event) {
        boolean mustDel;
        String[] toDelete = event.getMessagesToDelete();
        String[] toAdd = event.getMessagesToAdd();
        String field = event.getField();
        NuitonValidatorScope scope = event.getScope();
        boolean mustAdd = toAdd != null && toAdd.length > 0;
        boolean bl = mustDel = toDelete != null && toDelete.length > 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)"----------------------------------------------------------");
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toAdd     " + mustAdd));
            log.trace((Object)(field + " - (" + this.getRowCount() + ") toDelete  " + mustDel));
        }
        SimpleBeanValidator validator = (SimpleBeanValidator)event.getSource();
        if (mustDel) {
            this.removeMessages(validator, field, scope, !mustAdd, toDelete);
        }
        if (mustAdd) {
            this.addMessages(validator, field, scope, true, toAdd);
        }
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SwingUtil.ensureColumnIndex((TableModel)this, (int)columnIndex);
        SwingUtil.ensureRowIndex((TableModel)this, (int)rowIndex);
        SimpleBeanValidatorMessage row = this.data.get(rowIndex);
        if (columnIndex == 0) {
            return row.getScope();
        }
        if (columnIndex == 1) {
            return row.getField();
        }
        if (columnIndex == 2) {
            return row.getMessage();
        }
        return null;
    }

    protected void addMessages(SimpleBeanValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean sort, String ... messages) {
        for (String error : messages) {
            SimpleBeanValidatorMessage row = new SimpleBeanValidatorMessage(validator, fieldName, error, scope);
            this.data.add(row);
            if (sort) continue;
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }
        if (sort) {
            Collections.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    protected void removeMessages(SimpleBeanValidator<?> validator, String fieldName, NuitonValidatorScope scope, boolean notify, String ... messages) {
        ArrayList<String> messagesToDel = new ArrayList<String>(Arrays.asList(messages));
        for (int i = this.getRowCount() - 1; i > -1; --i) {
            SimpleBeanValidatorMessage error = this.data.get(i);
            if (!validator.equals((Object)error.getValidator()) || error.getScope() != scope || !error.getField().equals(fieldName) || !messagesToDel.contains(error.getMessage())) continue;
            this.data.remove(i);
            if (!notify) continue;
            this.fireTableRowsDeleted(i, i);
        }
    }
}

