/*
 * *##%
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.context.JAXXContextEntryDef;
import org.jdesktop.swingx.treetable.TreeTableNode;

import java.util.Enumeration;

/**
 * Node of the {@link NavigationTreeTableModel}.
 *
 * @see NavigationTreeNode
 *
 * @author sletellier
 * @since 2.0.0
 */
public abstract class NavigationTreeTableNode extends NavigationTreeNode implements TreeTableNode{

    public NavigationTreeTableNode(String pathSeparator, String navigationPath, Object jaxxContextEntryDef) {
        super(pathSeparator, navigationPath, jaxxContextEntryDef);
    }

    public NavigationTreeTableNode(String pathSeparator, String navigationPath, JAXXContextEntryDef<?> jaxxContextEntryDef, String jaxxContextEntryPath) {
        super(pathSeparator, navigationPath, jaxxContextEntryDef, jaxxContextEntryPath);
    }

    @Override
    public NavigationTreeTableNode getChildAt(int index) {
        return (NavigationTreeTableNode) super.getChildAt(index);
    }

    @Override
    public NavigationTreeTableNode getParent() {
        return (NavigationTreeTableNode) super.getParent();
    }

    /**
     * @see NavigationTreeNode#getChild(String)
     */
    @Override
    public NavigationTreeTableNode getChild(String path) {
        Enumeration<?> childs = children();
        while (childs.hasMoreElements()) {
            NavigationTreeTableNode son = (NavigationTreeTableNode) childs.nextElement();
            if (path.equals(son.getNodePath())) {
                return son;
            }
        }
        return null;
    }

    public abstract Object getValueAt(int column);

    public abstract int getColumnCount();

    public abstract boolean isEditable(int column);

    public abstract void setValueAt(Object aValue, int column);
}
