package jaxx.runtime.swing.renderer;

import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import java.awt.*;

/**
 * A {@link TableCellRenderer} which use decorators from the {@link #provider} to obtain the text to display.
 * <p/>
 * The interest of this renderer is to define a unique renderer for your application (put it in JAXXContext)
 * and then use it simply :)
 * <p/>
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 03:00:53
 *
 * @see DecoratorProvider
 * @since 2.0.0
 */
public class DecoratorProviderTableCellRenderer implements TableCellRenderer {

    /**
     * Delegate cell renderer
     */
    protected TableCellRenderer delegate;

    /**
     * provider of decorators
     */
    protected DecoratorProvider provider;

    public DecoratorProviderTableCellRenderer(DecoratorProvider provider) {
        this(new DefaultTableCellRenderer(), provider);
    }

    public DecoratorProviderTableCellRenderer(TableCellRenderer delegate, DecoratorProvider provider) {
        this.delegate = delegate;
        this.provider = provider;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        if (value != null) {
            Decorator<?> decorator = provider.getDecorator(value);

            if (decorator != null) {
                value = decorator.toString(value);
            }
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
    }
}