/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXContextEntryDef;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeHandler
extends DefaultTreeSelectionModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NavigationTreeHandler.class);
    public static final String NAVIGATION_SELECTED_BEAN = "navigation-selected-bean";
    public static final JAXXContextEntryDef<String> NAVIGATION_SELECTED_PATH_ENTRY_DEF = JAXXContextEntryDef.newDef((String)"navigation-selected-path", String.class);
    public static final JAXXContextEntryDef<NavigationTreeModel.NavigationTreeNode> NAVIGATION_SELECTED_NODE_ENTRY_DEF = JAXXContextEntryDef.newDef((String)"navigation-selected-node", NavigationTreeModel.NavigationTreeNode.class);
    protected Class<? extends JAXXObject> defaultUIClass;
    protected Class<? extends JAXXAction> defaultUIHandlerClass;
    protected JAXXObject context;
    protected Strategy strategy;

    protected NavigationTreeHandler(Class<? extends JAXXObject> defaultUIClass, Class<? extends JAXXAction> defaultUIHandlerClass, JAXXObject context, Strategy strategy) {
        this.defaultUIClass = defaultUIClass;
        this.defaultUIHandlerClass = defaultUIHandlerClass;
        this.context = context;
        this.strategy = strategy;
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                if (event.getOldLeadSelectionPath() != null && event.getOldLeadSelectionPath().equals(event.getPath())) {
                    return;
                }
                NavigationTreeModel.NavigationTreeNode node = (NavigationTreeModel.NavigationTreeNode)event.getPath().getLastPathComponent();
                NavigationTreeHandler.this.selectNodeUI(node);
            }
        });
    }

    protected abstract NavigationTreeModel getNavigationTreeModel();

    protected abstract Component getCurrentUI();

    protected abstract Component getUI(NavigationTreeModel.NavigationTreeNode var1);

    protected abstract boolean closeUI(Component var1) throws Exception;

    protected abstract Component createUI(NavigationTreeModel.NavigationTreeNode var1) throws Exception;

    protected abstract JAXXContext createUIContext(NavigationTreeModel.NavigationTreeNode var1) throws Exception;

    protected abstract void openUI(Component var1, NavigationTreeModel.NavigationTreeNode var2) throws Exception;

    protected abstract void treateError(Exception var1);

    protected NavigationTreeModel.NavigationTreeNode prepareNode(NavigationTreeModel.NavigationTreeNode node) {
        if (node.getJaxxClass() == null) {
            node.setJaxxClass(this.defaultUIClass);
        }
        if (node.getJaxxActionClass() == null) {
            node.setJaxxActionClass(this.defaultUIHandlerClass);
        }
        return node;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (path.equals(this.getSelectionPath())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skip stay on path " + path));
            }
            return;
        }
        Component component = this.getCurrentUI();
        try {
            if (!this.closeUI(component)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"changing node canceled!");
                }
                return;
            }
        }
        catch (Exception ex) {
            this.treateError(ex);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will select path " + path));
        }
        super.setSelectionPath(path);
    }

    public void selectNodeUI(NavigationTreeModel.NavigationTreeNode node) {
        try {
            node = this.prepareNode(node);
            String path = node.getContextPath();
            if (log.isTraceEnabled()) {
                log.trace((Object)path);
            }
            Component newUI = this.getUI(node);
            node.cachedBean = null;
            if (node.renderer != null) {
                node.renderer.setRendererCachedValue(null);
            }
            Object data = this.getNavigationTreeModel().getJAXXContextValue((JAXXContext)this.context, path);
            this.addSelectedBeanInContext(node, data);
            if (newUI == null) {
                newUI = this.createUI(node);
            }
            NAVIGATION_SELECTED_PATH_ENTRY_DEF.setContextValue((JAXXContext)this.context, (Object)node.getContextPath());
            NAVIGATION_SELECTED_NODE_ENTRY_DEF.setContextValue((JAXXContext)this.context, (Object)node);
            this.openUI(newUI, node);
        }
        catch (Exception e) {
            this.treateError(e);
        }
    }

    protected void addSelectedBeanInContext(NavigationTreeModel.NavigationTreeNode node, Object data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("find data for contextPath <" + node.getContextPath() + "> : " + (data == null ? null : data.getClass())));
        }
        this.context.removeContextValue(Object.class, NAVIGATION_SELECTED_BEAN);
        if (data != null) {
            this.context.setContextValue(data, NAVIGATION_SELECTED_BEAN);
            this.context.setContextValue(data);
        }
    }

    protected String getNodeConstraints(NavigationTreeModel.NavigationTreeNode node) {
        String constraints;
        switch (this.strategy) {
            case PER_NODE: {
                constraints = node.getContextPath();
                break;
            }
            case PER_UI_TYPE: {
                constraints = node.getJaxxClass().getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("could not find constraint for node : " + node);
            }
        }
        return constraints;
    }

    protected JAXXAction getJAXXAction(Class<? extends JAXXAction> jaxxActionClass) throws Exception {
        JAXXAction action = jaxxActionClass.newInstance();
        return action;
    }

    public static enum Strategy {
        PER_NODE,
        PER_UI_TYPE;

    }
}

