/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class NavigationTreeCellRenderer
implements TreeCellRenderer {
    private static final Log log = LogFactory.getLog(NavigationTreeCellRenderer.class);
    protected JAXXContext context;
    protected DefaultTreeCellRenderer delegate;
    protected static long t = 0L;

    public NavigationTreeCellRenderer(JAXXContext context) {
        this.context = context;
        UIManager.put("Tree.rendererFillBackground", false);
        this.delegate = new DefaultTreeCellRenderer();
    }

    public NavigationTreeCellRenderer(JAXXContext context, DefaultTreeCellRenderer delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return this.delegate;
        }
        if (value != null) {
            long t0 = System.nanoTime();
            NavigationUtil.NodeRenderer renderer = this.getNodeRenderer(value);
            long t1 = System.nanoTime();
            if (renderer != null) {
                value = renderer.toString(this.context);
                long t2 = System.nanoTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use renderer [" + t++ + "]<" + row + ">" + renderer.decorator + " <" + StringUtil.convertTime((long)t0, (long)t1) + "/" + StringUtil.convertTime((long)t1, (long)t2) + ">"));
                }
            }
        }
        return this.delegate.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    protected NavigationUtil.NodeRenderer getNodeRenderer(Object value) {
        NavigationTreeModel.NavigationTreeNode node;
        NavigationUtil.NodeRenderer render = null;
        if (value != null && (node = this.getNode(value)) != null && node.getUserObject() instanceof NavigationUtil.NodeRenderer) {
            render = (NavigationUtil.NodeRenderer)node.getUserObject();
        }
        return render;
    }

    protected NavigationTreeModel.NavigationTreeNode getNode(Object value) {
        return value instanceof NavigationTreeModel.NavigationTreeNode ? (NavigationTreeModel.NavigationTreeNode)value : null;
    }
}

