package jaxx.runtime.swing;

import org.nuiton.util.EnumEditor;

import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import java.awt.Component;

/**
 * @author chemit
 * @since 1.5
 */
public class MyDefaultCellEditor extends DefaultCellEditor {

    private static final long serialVersionUID = 1L;

    public static TableCellEditor newTextEditor() {
        return new MyDefaultCellEditor(new JTextField());
    }

    public static TableCellEditor newBooleanEditor() {
        return new MyDefaultCellEditor(new JCheckBox());
    }

    public static TableCellEditor newListEditor() {
        return newListEditor(new JComboBox());
    }

    public static TableCellEditor newListEditor(JComboBox editor) {
        return new MyDefaultCellEditor(editor);
    }

    public static TableCellEditor newEnumEditor(EnumEditor editor) {
        return new MyDefaultCellEditor(editor) {

            private static final long serialVersionUID = 1L;

            @Override
            public Object getCellEditorValue() {
                Object value = super.getCellEditorValue();
                if (value != null) {
                    value = ((Enum) value).ordinal();
                } else {
                    value = -1;
                }
                return value;
            }
        };
    }

    public static TableCellEditor newBooleanEditor(Icon icon) {
        return new MyDefaultCellEditor(new JCheckBox(icon));
    }

    public static TableCellEditor newBooleanEditor(Icon icon, boolean requireSelect) {
        TableCellEditor cellEditor = newBooleanEditor(icon);
        ((MyDefaultCellEditor) cellEditor).setRequireSelect(requireSelect);
        return cellEditor;
    }

    public static TableCellEditor newBooleanEditor(boolean requireSelect) {
        TableCellEditor cellEditor = newBooleanEditor();
        ((MyDefaultCellEditor) cellEditor).setRequireSelect(requireSelect);
        return cellEditor;
    }
    protected boolean requireSelect = true;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!isSelected && requireSelect) {
            // force to have select the cell before editing, a way to not modify edition for nothing...
            return null;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public boolean isRequireSelect() {
        return requireSelect;
    }

    public void setRequireSelect(boolean requireSelect) {
        this.requireSelect = requireSelect;
    }

    protected MyDefaultCellEditor(JTextField textField) {
        super(textField);
        setClickCountToStart(1);
    }

    protected MyDefaultCellEditor(JCheckBox checkBox) {
        super(checkBox);
        setClickCountToStart(1);
    }

    protected MyDefaultCellEditor(JComboBox comboBox) {
        super(comboBox);
        setClickCountToStart(1);
    }
}
