package jaxx.runtime.swing;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import java.awt.Component;
import java.util.EnumSet;

/**
 * 
 * 
 * A {@link TableCellRenderer} which displays enum values from their ordinal value.
 *
 * @param <E>  le type de l'énumération.
 *
 * @author chemit
 * @since 1.5
 */
public class EnumTableCellRenderer<E extends Enum<E>> implements TableCellRenderer {

    private TableCellRenderer delegate;
    private EnumSet<E> enumValues;

    public EnumTableCellRenderer(TableCellRenderer delegate, Class<E> enumClass) {
        this.delegate = delegate;
        this.enumValues = EnumSet.allOf(enumClass);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        if (value != null) {
            //FIXME : should be also able to read it by name ?
            Integer ordinal = Integer.valueOf(value + "");
            if (ordinal == -1) {
                value = null;
            } else {
                for (E enumValue : enumValues) {
                    if (ordinal == enumValue.ordinal()) {
                        value = enumValue;
                        break;
                    }
                }
            }
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}
