package jaxx.runtime.swing;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import java.awt.GraphicsConfiguration;

public class Application extends JFrame {
    // Special: jaxxc will automatically add a main() method to any components which
    // extend <Application>


    public Application() {
    }


    public Application(GraphicsConfiguration gc) {
        super(gc);
    }


    public Application(String title) {
        super(title);
    }


    public Application(String title, GraphicsConfiguration gc) {
        super(title, gc);
    }


    public void setLookAndFeel(String lookAndFeel) {
        if (lookAndFeel.equals("system"))
            lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        else if (lookAndFeel.equals("cross_platform"))
            lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            if (isDisplayable())
                SwingUtilities.updateComponentTreeUI(this);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
    }
}