/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class JSliderHandler extends DefaultComponentHandler {
    public JSliderHandler(ClassDescriptor beanClass) {
        super(beanClass);
        if (!ClassDescriptorLoader.getClassDescriptor(JSlider.class).isAssignableFrom(beanClass))
            throw new IllegalArgumentException(getClass().getName() + " does not support the class " + beanClass.getName());
    }


    protected int getAttributeOrdering(Attr attr) {
        if (attr.getName().equals("value"))
            return 1;
        else
            return super.getAttributeOrdering(attr);
    }


    protected void setDefaults(CompiledObject object, Element tag, JAXXCompiler  compiler) throws CompilerException {
        super.setDefaults(object, tag, compiler);
        setAttribute(object, "value", "0", false, compiler);
    }


    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getValue", ChangeListener.class, "model");
    }
}