/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.writer.BaseModelFileWriter;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

public class ZargoModelFileWriter
extends BaseModelFileWriter {
    public static final String[] XMI_FILE_FILTER = new String[]{"*.xmi", "**/*.xmi"};

    public String getInputProtocol() {
        return "zargo";
    }

    public <M extends Model> String getOutputProtocol(Class<M> modelType) {
        return "xmi";
    }

    public <M extends Model> boolean acceptModel(Class<M> modelType) {
        return true;
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("zargo:") || include.endsWith(".zargo") || include.endsWith(".zuml");
    }

    public String getDefaultIncludes() {
        return "**/*.zargo";
    }

    public String getDefaultInputDirectory() {
        return "src/main/xmi";
    }

    public String getDefaultOutputDirectory() {
        return "xmi";
    }

    public void generate(File outputDir, File inputDirectory, String includePattern, boolean overwrite) throws IOException {
        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);
        this.getLog().info((CharSequence)("Expanding xmi from " + inputDirectory + " : " + includePattern));
        PluginHelper.expandFiles((PluginIOContext)ioContext, (String[])new String[]{includePattern}, null, (String[])XMI_FILE_FILTER, (boolean)overwrite);
        this.getLog().info((CharSequence)("Copying resources from " + inputDirectory + " : " + includePattern));
        PluginHelper.copyFiles((PluginIOContext)ioContext, null, (String[])new String[]{includePattern}, (boolean)overwrite);
    }
}

