<?xml version='1.0'?>
<!--
    Copyright 2009-2010 Sharengo, Jean Couteau
    License: GPL v3
    Author: Jean Couteau (couteau@codelutin.com)

    %%Ignore-License
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns="http://www.w3.org/TR/xhtml1/transitional"
    xmlns:fo="http://www.w3.org/1999/XSL/Format">

    <!--xsl:import href="../../fo/docbook.xsl"/-->
    <xsl:import href="urn:docbkx:stylesheet"/>

    <xsl:output method="xml" indent="yes" encoding="UTF-8" />


    <!--Numbering-->
    <xsl:param name="appendix.autolabel" select="'A'"/>
    <xsl:param name="chapter.autolabel" select="1"/>
    <xsl:param name="part.autolabel" select="'I'"/>
    <xsl:param name="reference.autolabel" select="'I'"/>
    <xsl:param name="section.autolabel" select="1"/>
    <xsl:param name="section.label.includes.component.label" select="1" />

    <!-- No intendation of Titles -->
    <xsl:param name="body.start.indent">0pt</xsl:param>

    <!--Text format-->
    <xsl:param name="alignment">justify</xsl:param>
    <xsl:param name="line-height" select="1.5"/>

    <!--Page format-->
    <xsl:param name="paper.type" select="'A4'"/>

    <!--Title colors-->
    <xsl:param name="title.color">#6161e1</xsl:param>
    <xsl:param name="chapter.title.color" select="$title.color" />
    <xsl:param name="section.title.color" select="$title.color" />
    <xsl:param name="titlepage.color" select="$title.color"/>

    <!--Title page properties-->
    <xsl:attribute-set name="book.titlepage.recto.style">
	<xsl:attribute name="color">
            <xsl:value-of select="$chapter.title.color"/>
        </xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="padding-left">1em</xsl:attribute>
	<xsl:attribute name="padding-right">1em</xsl:attribute>
    </xsl:attribute-set>

    <!--Keep verso title page blank-->
    <xsl:template name="book.titlepage.verso"></xsl:template>

    <!-- Prevent blank pages in output -->
    <xsl:template name="book.titlepage.before.verso"></xsl:template>
    <xsl:template name="book.titlepage.separator"></xsl:template>

    <!--Chapter title page properties-->
    <xsl:attribute-set name="chapter.titlepage.recto.style">
	<xsl:attribute name="color">
            <xsl:value-of select="$chapter.title.color"/>
        </xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="font-size">24pt</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="padding-left">1em</xsl:attribute>
	<xsl:attribute name="padding-right">1em</xsl:attribute>
    </xsl:attribute-set>

    <!--Section title page properties-->
    <xsl:attribute-set name="section.titlepage.recto.style">
	<xsl:attribute name="color">
            <xsl:value-of select="$section.title.color"/>
        </xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
    </xsl:attribute-set>

    <!--Appendix title page properties-->
    <xsl:attribute-set name="appendix.titlepage.recto.style">
	<xsl:attribute name="color">
            <xsl:value-of select="$chapter.title.color"/>
        </xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
    </xsl:attribute-set>

    <!--Formal titles (figure, table,...) properties-->
    <xsl:attribute-set name="formal.title.properties"
                    use-attribute-sets="normal.para.spacing">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="hyphenate">false</xsl:attribute>
        <xsl:attribute name="space-before.minimum">0pt</xsl:attribute>
        <xsl:attribute name="space-before.optimum">0pt</xsl:attribute>
        <xsl:attribute name="space-before.maximum">0pt</xsl:attribute>
        <xsl:attribute name="space-after.minimum">8.5pt</xsl:attribute>
        <xsl:attribute name="space-after.optimum">9pt</xsl:attribute>
        <xsl:attribute name="space-after.maximum">9.5pt</xsl:attribute>
    </xsl:attribute-set>

    <!--tips-warning-... properties-->
    <xsl:param name="admon.graphics" select="1"/>
    <xsl:param name="admon.graphics.path">
        <xsl:if test="$img.src.path != ''">
            <xsl:value-of select="$img.src.path"/>
        </xsl:if>
        <xsl:text>images/community/docbook/</xsl:text>
    </xsl:param>
    <xsl:param name="admon.graphics.extension" select="'.svg'"/>
    <xsl:attribute-set name="admonition.title.properties">
        <xsl:attribute name="font-size">13pt</xsl:attribute>
        <xsl:attribute name="color">#EE7D01</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="hyphenate">false</xsl:attribute>
        <xsl:attribute name="keep-with-next.within-column">always</xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="graphical.admonition.properties">
        <xsl:attribute name="color">white</xsl:attribute>
        <xsl:attribute name="background-color">#463F3D</xsl:attribute>
        <xsl:attribute name="space-before.optimum">1em</xsl:attribute>
        <xsl:attribute name="space-before.minimum">0.8em</xsl:attribute>
        <xsl:attribute name="space-before.maximum">1.2em</xsl:attribute>
        <xsl:attribute name="space-after.optimum">1em</xsl:attribute>
        <xsl:attribute name="space-after.minimum">0.8em</xsl:attribute>
        <xsl:attribute name="space-after.maximum">1em</xsl:attribute>
        <xsl:attribute name="padding-bottom">7pt</xsl:attribute>
        <xsl:attribute name="padding-top">7pt</xsl:attribute>
        <xsl:attribute name="padding-right">7pt</xsl:attribute>
        <xsl:attribute name="padding-left">7pt</xsl:attribute>
        <xsl:attribute name="margin-left">
            <xsl:value-of select="$title.margin.left"/>
        </xsl:attribute>
    </xsl:attribute-set>
    <xsl:attribute-set name="xref.properties">
        <xsl:attribute name="font-style">italic</xsl:attribute>
        <xsl:attribute name="color">#EE7D01</xsl:attribute>
    </xsl:attribute-set>

    <!-- Make the section depth in the TOC 2, same as html -->
    <xsl:param name="toc.section.depth">2</xsl:param>

    <!-- Now, set enable scalefit for large images -->
    <xsl:param name="graphicsize.extension" select="'1'" />
    <!--xsl:param name="default.image.width">15cm</xsl:param-->

    <xsl:param name="hyphenate.verbatim">1</xsl:param>


    <!-- Properties for monospace and verbatim texts, should impact
    programlistings-->
    <xsl:attribute-set name="monospace.properties">
	<xsl:attribute name="font-size">9pt</xsl:attribute>
	<xsl:attribute name="wrap-option">wrap</xsl:attribute>
        <xsl:attribute name="hyphenation-character">\</xsl:attribute>
	<xsl:attribute name="font-family">
            <xsl:value-of select="$monospace.font.family"/>
	</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="monospace.verbatim.properties"
    use-attribute-sets="verbatim.properties monospace.properties">
	<xsl:attribute name="text-align">start</xsl:attribute>
	<xsl:attribute name="wrap-option">wrap</xsl:attribute>
	<xsl:attribute name="hyphenation-character">\</xsl:attribute>
    </xsl:attribute-set>

    <xsl:param name="shade.verbatim" select="1"/>
    <xsl:attribute-set name="shade.verbatim.style">
        <xsl:attribute name="background-color">white</xsl:attribute>
        <xsl:attribute name="color">black</xsl:attribute>
	<xsl:attribute name="padding-left">12pt</xsl:attribute>
	<xsl:attribute name="padding-right">12pt</xsl:attribute>
	<xsl:attribute name="padding-top">0pt</xsl:attribute>
	<xsl:attribute name="padding-bottom">0pt</xsl:attribute>
	<xsl:attribute name="margin-left">
            <xsl:value-of select="$title.margin.left"/>
	</xsl:attribute>
    </xsl:attribute-set>

    <xsl:attribute-set name="verbatim.properties">
        <xsl:attribute name="space-before.minimum">0pt</xsl:attribute>
        <xsl:attribute name="space-before.optimum">0pt</xsl:attribute>
        <xsl:attribute name="space-before.maximum">0pt</xsl:attribute>
        <xsl:attribute name="space-after.minimum">8.5pt</xsl:attribute>
        <xsl:attribute name="space-after.optimum">9pt</xsl:attribute>
        <xsl:attribute name="space-after.maximum">9.5pt</xsl:attribute>
        <xsl:attribute name="hyphenate">false</xsl:attribute>
        <xsl:attribute name="wrap-option">wrap</xsl:attribute>
        <xsl:attribute name="white-space-collapse">false</xsl:attribute>
        <xsl:attribute name="white-space-treatment">preserve</xsl:attribute>
        <xsl:attribute name="linefeed-treatment">preserve</xsl:attribute>
        <xsl:attribute name="text-align">start</xsl:attribute>
    </xsl:attribute-set>

    <!--Template to find component's title, used for header-->
    <xsl:template name="component.title.nomarkup">
        <xsl:param name="node" select="."/>
        <xsl:variable name="id">
            <xsl:call-template name="object.id">
                <xsl:with-param name="object" select="$node"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="title">
            <xsl:apply-templates select="$node" mode="object.title.markup">
                <xsl:with-param name="allow-anchors" select="1"/>
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:copy-of select="$title"/>
    </xsl:template>

    <!--Header generation-->
    <xsl:template name="header.content">
        <xsl:param name="pageclass" select="''"/>
        <xsl:param name="sequence" select="''"/>
        <xsl:param name="position" select="''"/>
        <xsl:param name="gentext-key" select="''"/>
	<xsl:param name="title-limit" select="'22'"/>
        <xsl:choose>
            <!--Put the sharengo logo in header center-->
            <xsl:when test="$position = 'center'">
                <fo:external-graphic content-height="0.5cm">
                    <xsl:attribute name="src">
                        <xsl:call-template name="fo-external-image">
                            <xsl:with-param name="filename">
                                <xsl:if test="$img.src.path != ''">
                                    <xsl:value-of select="$img.src.path"/>
                                </xsl:if>
                                <xsl:text>images/logo.svg</xsl:text>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:attribute>
                </fo:external-graphic>
            </xsl:when>
            <xsl:when test="$sequence = 'blank'">
                <!-- If blank page, put no title -->
            </xsl:when>
            <!--On left put chapter or section title truncated with...-->
            <xsl:when test="$position='left'">
                <xsl:variable name="text">
                    <xsl:call-template name="component.title.nomarkup"/>
                </xsl:variable>
                <fo:inline keep-together.within-line="always" font-weight="bold">
                    <xsl:choose>
                        <xsl:when test="string-length($text) &gt; '25'">
                            <xsl:value-of select="concat(substring($text, 0, $title-limit), '...')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$text"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </fo:inline>
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
    </xsl:template> <!--End of header generation-->

    <!-- Margins (chaotic stuff, don't touch) -->
    <xsl:param name="page.margin.top">15mm</xsl:param>
    <xsl:param name="region.before.extent">10mm</xsl:param>
    <xsl:param name="body.margin.top">15mm</xsl:param>
    <xsl:param name="body.margin.bottom">15mm</xsl:param>
    <xsl:param name="region.after.extent">10mm</xsl:param>
    <xsl:param name="page.margin.bottom">15mm</xsl:param>
    <xsl:param name="page.margin.outer">30mm</xsl:param>
    <xsl:param name="page.margin.inner">30mm</xsl:param>

    <!--Allow programlistings, tables,... to be break on several columns/pages-->
    <xsl:attribute-set name="formal.object.properties">
        <xsl:attribute name="keep-together.within-column">auto</xsl:attribute>
    </xsl:attribute-set>

    <!-- Format Variable Lists as Blocks (prevents horizontal overflow). -->
    <xsl:param name="variablelist.as.blocks">1</xsl:param>

    <!-- Callouts -->
    <!-- Place callout bullets at this column in programlisting.-->
    <xsl:param name="callout.defaultcolumn">80</xsl:param>
    <xsl:param name="callout.icon.size">7pt</xsl:param>
    <!-- Do not use pictures -->
    <xsl:param name="callout.unicode">1</xsl:param>
    <xsl:param name="callout.graphics">0</xsl:param>

    <!-- For indexes -->
    <xsl:attribute-set name="xep.index.item.properties"
                       use-attribute-sets="index.page.number.properties">
        <xsl:attribute name="merge-subsequent-page-numbers">true</xsl:attribute>
        <xsl:attribute name="link-back">true</xsl:attribute>
    </xsl:attribute-set>

    <!-- Override indexterm template to avoid title not being with following
     paragraph when putting indexterm right after title-->

    <xsl:template name="indexterm">
        <xsl:variable name="id"><xsl:call-template name="object.id"/></xsl:variable>
        <fo:block keep-with-previous.within-column="always"
                   keep-with-next.within-column="always">
            <xsl:attribute name="id">
                <xsl:value-of select="$id"/>
            </xsl:attribute>
        </fo:block>
    </xsl:template>

</xsl:stylesheet>
