/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.UnchangedRequest;

public class UpdateCommand
extends BasicCommand
implements TemporaryFileCreator {
    private static final String RENAME_FORMAT = "{0}/.#{1}.{2}";
    private static final Object[] FORMAT_PARAMETER = new Object[3];
    private final Set emptyDirectories = new HashSet();
    private boolean buildDirectories;
    private boolean cleanCopy;
    private boolean pruneDirectories;
    private boolean pipeToOutput;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private String updateByDate;
    private String updateByRevision;
    private KeywordSubstitutionOptions keywordSubst;
    private String mergeRevision1;
    private String mergeRevision2;

    public UpdateCommand() {
        this.resetCVSCommand();
    }

    public Builder createBuilder(EventManager eventManager) {
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventManager, this, this);
        }
        return new UpdateBuilder(eventManager, this.getLocalDirectory());
    }

    protected void sendEntryAndModifiedRequests(Entry entry, File file) {
        if (this.isCleanCopy() && file != null && entry != null) {
            if (!this.isPipeToOutput()) {
                UpdateCommand.FORMAT_PARAMETER[0] = file.getParent();
                UpdateCommand.FORMAT_PARAMETER[1] = file.getName();
                UpdateCommand.FORMAT_PARAMETER[2] = entry.getRevision();
                String string = MessageFormat.format(RENAME_FORMAT, FORMAT_PARAMETER);
                try {
                    FileUtils.copyFile(file, new File(string));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            file = null;
        }
        super.sendEntryAndModifiedRequests(entry, file);
    }

    public void setBuildDirectories(boolean bl) {
        this.buildDirectories = bl;
    }

    public boolean isBuildDirectories() {
        return this.buildDirectories;
    }

    public void setCleanCopy(boolean bl) {
        this.cleanCopy = bl;
    }

    public boolean isCleanCopy() {
        return this.cleanCopy;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean isPruneDirectories() {
        return this.pruneDirectories;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        super.execute(clientServices, eventManager);
        this.emptyDirectories.clear();
        try {
            if (!this.isRecursive()) {
                this.requests.add(1, new ArgumentRequest("-l"));
            }
            if (this.isBuildDirectories()) {
                this.requests.add(1, new ArgumentRequest("-d"));
            }
            if (this.isCleanCopy() && !this.isPipeToOutput()) {
                this.requests.add(1, new ArgumentRequest("-C"));
            }
            if (this.isPipeToOutput()) {
                this.requests.add(1, new ArgumentRequest("-p"));
            }
            if (this.isResetStickyOnes()) {
                this.requests.add(1, new ArgumentRequest("-A"));
            }
            if (this.isUseHeadIfNotFound()) {
                this.requests.add(1, new ArgumentRequest("-f"));
            }
            if (this.getUpdateByDate() != null) {
                this.requests.add(1, new ArgumentRequest("-D"));
                this.requests.add(2, new ArgumentRequest(this.getUpdateByDate()));
            } else if (this.getUpdateByRevision() != null) {
                this.requests.add(1, new ArgumentRequest("-r"));
                this.requests.add(2, new ArgumentRequest(this.getUpdateByRevision()));
            }
            if (this.getMergeRevision1() != null) {
                this.requests.add(1, new ArgumentRequest("-j"));
                this.requests.add(2, new ArgumentRequest(this.getMergeRevision1()));
                if (this.getMergeRevision2() != null) {
                    this.requests.add(3, new ArgumentRequest("-j"));
                    this.requests.add(4, new ArgumentRequest(this.getMergeRevision2()));
                }
            }
            if (this.getKeywordSubst() != null) {
                this.requests.add(1, new ArgumentRequest("-k"));
                this.requests.add(2, new ArgumentRequest(this.getKeywordSubst().toString()));
            }
            this.requests.add(1, new ArgumentRequest("-u"));
            this.addRequestForWorkingDirectory(clientServices);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.UPDATE);
            if (this.isPipeToOutput() && (this.getUpdateByRevision() != null || this.getUpdateByDate() != null)) {
                ListIterator<Request> listIterator = this.requests.listIterator();
                while (listIterator.hasNext()) {
                    Object e = listIterator.next();
                    if (!(e instanceof EntryRequest)) continue;
                    EntryRequest entryRequest = (EntryRequest)e;
                    Entry entry = entryRequest.getEntry();
                    if (entry.getRevision().startsWith("-")) {
                        entry.setRevision(entry.getRevision().substring(1));
                    }
                    listIterator.set(new EntryRequest(entry));
                    listIterator.add(new UnchangedRequest(entry.getName()));
                }
            }
            clientServices.processRequests(this.requests);
            if (this.pruneDirectories && (this.getGlobalOptions() == null || !this.getGlobalOptions().isDoNoChanges())) {
                this.pruneEmptyDirectories(clientServices);
            }
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean bl) {
        this.pipeToOutput = bl;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean bl) {
        this.resetStickyOnes = bl;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public String getUpdateByDate() {
        return this.updateByDate;
    }

    public void setUpdateByDate(String string) {
        this.updateByDate = UpdateCommand.getTrimmedString(string);
    }

    public String getUpdateByRevision() {
        return this.updateByRevision;
    }

    public void setUpdateByRevision(String string) {
        this.updateByRevision = UpdateCommand.getTrimmedString(string);
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubst = keywordSubstitutionOptions;
    }

    public File createTempFile(String string) throws IOException {
        File file = File.createTempFile("cvs", ".dff", this.getGlobalOptions().getTempDir());
        return file;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("update ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i].getName());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isPipeToOutput()) {
            stringBuffer.append("-p ");
        }
        if (this.isCleanCopy()) {
            stringBuffer.append("-C ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isBuildDirectories()) {
            stringBuffer.append("-d ");
        }
        if (this.isPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.isResetStickyOnes()) {
            stringBuffer.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getKeywordSubst() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubst().toString());
            stringBuffer.append(' ');
        }
        if (this.getUpdateByRevision() != null) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getUpdateByRevision());
            stringBuffer.append(' ');
        }
        if (this.getUpdateByDate() != null) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getUpdateByDate());
            stringBuffer.append(' ');
        }
        if (this.getMergeRevision1() != null) {
            stringBuffer.append("-j ");
            stringBuffer.append(this.getMergeRevision1());
            stringBuffer.append(' ');
            if (this.getMergeRevision2() != null) {
                stringBuffer.append("-j ");
                stringBuffer.append(this.getMergeRevision2());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'C') {
            this.setCleanCopy(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'd') {
            this.setBuildDirectories(true);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'A') {
            this.setResetStickyOnes(true);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'D') {
            this.setUpdateByDate(string.trim());
        } else if (c == 'r') {
            this.setUpdateByRevision(string.trim());
        } else if (c == 'k') {
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string);
            this.setKeywordSubst(keywordSubstitutionOptions);
        } else if (c == 'p') {
            this.setPipeToOutput(true);
        } else if (c == 'j') {
            if (this.getMergeRevision1() == null) {
                this.setMergeRevision1(string);
            } else {
                this.setMergeRevision2(string);
            }
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCleanCopy(false);
        this.setBuildDirectories(false);
        this.setPruneDirectories(false);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setUpdateByDate(null);
        this.setUpdateByRevision(null);
        this.setKeywordSubst(null);
        this.setPipeToOutput(false);
        this.setMergeRevision1(null);
        this.setMergeRevision2(null);
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (!this.pruneDirectories) {
            return;
        }
        String string = CommandUtils.getExaminedDirectory(messageEvent.getMessage(), ": Updating");
        if (string == null) {
            return;
        }
        if (string.equals(".")) {
            return;
        }
        this.emptyDirectories.add(new File(this.getLocalDirectory(), string));
    }

    private boolean pruneEmptyDirectory(File file, ClientServices clientServices) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            if (fileArray[i].getName().equals("CVS") || this.pruneEmptyDirectory(fileArray[i], clientServices)) continue;
            return false;
        }
        if (new File(file, "CVS/Entries").isFile() && new File(file, "CVS/Repository").isFile()) {
            File file2 = new File(file, "CVS");
            Iterator iterator = this.clientServices.getEntries(file);
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.getName() == null || !entry.isUserFileToBeRemoved()) continue;
                return false;
            }
            this.deleteRecursively(file2);
            file.delete();
            if (!clientServices.exists(file)) {
                clientServices.removeEntry(file);
            }
            return true;
        }
        return false;
    }

    private void deleteRecursively(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.deleteRecursively(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    private void pruneEmptyDirectories(ClientServices clientServices) throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file, clientServices);
        }
        this.emptyDirectories.clear();
    }

    public String getOptString() {
        return "RCnldPAfD:r:pj:k:";
    }

    public String getMergeRevision1() {
        return this.mergeRevision1;
    }

    public void setMergeRevision1(String string) {
        this.mergeRevision1 = UpdateCommand.getTrimmedString(string);
    }

    public String getMergeRevision2() {
        return this.mergeRevision2;
    }

    public void setMergeRevision2(String string) {
        this.mergeRevision2 = UpdateCommand.getTrimmedString(string);
    }
}

