/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.StoppableRunnable;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.BoundedIterable;

public class RecordScanner<RECORD>
implements StoppableRunnable {
    private final ProgressListener progress;
    private final BoundedIterable<RECORD> store;
    private final RecordProcessor<RECORD> processor;
    private volatile boolean continueScanning = true;

    public RecordScanner(BoundedIterable<RECORD> store, String taskName, ProgressMonitorFactory.MultiPartBuilder builder, RecordProcessor<RECORD> processor) {
        this.store = store;
        this.processor = processor;
        this.progress = builder.progressForPart(taskName, store.maxCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int entryCount = 0;
            for (Object record : this.store) {
                if (!this.continueScanning) {
                    return;
                }
                this.processor.process(record);
                this.progress.set((long)entryCount++);
            }
        }
        finally {
            try {
                this.store.close();
            }
            catch (Exception e) {
                this.progress.failed((Throwable)e);
            }
            this.processor.close();
            this.progress.done();
        }
    }

    @Override
    public void stopScanning() {
        this.continueScanning = false;
    }
}

