/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.DynamicOwner;
import org.neo4j.consistency.checking.full.Owner;
import org.neo4j.consistency.checking.full.PropertyOwner;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;

class OwnerCheck
implements CheckDecorator {
    private final ConcurrentMap<Long, PropertyOwner> owners;
    private final Map<RecordType, ConcurrentMap<Long, DynamicOwner>> dynamics;
    private static final ComparativeRecordChecker<PropertyRecord, PrimitiveRecord, ConsistencyReport.PropertyConsistencyReport> ORPHAN_CHECKER = new ComparativeRecordChecker<PropertyRecord, PrimitiveRecord, ConsistencyReport.PropertyConsistencyReport>(){

        @Override
        public void checkReference(PropertyRecord record, PrimitiveRecord primitiveRecord, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
            engine.report().orphanPropertyChain();
        }
    };

    OwnerCheck(boolean active, DynamicStore ... stores) {
        this.owners = active ? new ConcurrentHashMap(16, 0.75f, 4) : null;
        this.dynamics = active ? OwnerCheck.initialize(stores) : null;
    }

    private static Map<RecordType, ConcurrentMap<Long, DynamicOwner>> initialize(DynamicStore[] stores) {
        EnumMap map = new EnumMap(RecordType.class);
        for (DynamicStore store : stores) {
            map.put(store.type, new ConcurrentHashMap(16, 0.75f, 4));
        }
        return Collections.unmodifiableMap(map);
    }

    void scanForOrphanChains(ProgressMonitorFactory progressFactory) {
        ArrayList<OrphanCheck> tasks = new ArrayList<OrphanCheck>();
        ProgressMonitorFactory.MultiPartBuilder progress = progressFactory.multipleParts("Checking for orphan chains");
        if (this.owners != null) {
            tasks.add(new OrphanCheck(RecordType.PROPERTY, this.owners, progress));
        }
        if (this.dynamics != null) {
            for (Map.Entry entry : this.dynamics.entrySet()) {
                tasks.add(new OrphanCheck((RecordType)((Object)entry.getKey()), (ConcurrentMap)entry.getValue(), progress));
            }
        }
        for (Runnable runnable : tasks) {
            runnable.run();
        }
    }

    @Override
    public OwningRecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> decorateNeoStoreChecker(OwningRecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> checker) {
        if (this.owners == null) {
            return checker;
        }
        return new PrimitiveCheckerDecorator<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport>(checker){

            @Override
            PropertyOwner owner(NeoStoreRecord record) {
                return PropertyOwner.OWNING_GRAPH;
            }
        };
    }

    @Override
    public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
        if (this.owners == null) {
            return checker;
        }
        return new PrimitiveCheckerDecorator<NodeRecord, ConsistencyReport.NodeConsistencyReport>(checker){

            @Override
            PropertyOwner owner(NodeRecord record) {
                return new PropertyOwner.OwningNode(record);
            }
        };
    }

    @Override
    public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
        if (this.owners == null) {
            return checker;
        }
        return new PrimitiveCheckerDecorator<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport>(checker){

            @Override
            PropertyOwner owner(RelationshipRecord record) {
                return new PropertyOwner.OwningRelationship(record);
            }
        };
    }

    @Override
    public RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> decoratePropertyChecker(final RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
        if (this.owners == null && this.dynamics == null) {
            return checker;
        }
        return new RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport>(){

            @Override
            public void check(PropertyRecord record, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
                if (record.inUse()) {
                    if (OwnerCheck.this.owners != null && Record.NO_PREVIOUS_PROPERTY.is(record.getPrevProp())) {
                        PropertyOwner.UnknownOwner owner = new PropertyOwner.UnknownOwner();
                        engine.comparativeCheck(owner, ORPHAN_CHECKER);
                        if (null == OwnerCheck.this.owners.putIfAbsent(record.getId(), owner)) {
                            owner.markInCustody();
                        }
                    }
                    if (OwnerCheck.this.dynamics != null) {
                        for (PropertyBlock block : record) {
                            ConcurrentMap dynamicOwners;
                            RecordType type = OwnerCheck.this.recordType(block.forceGetType());
                            if (type == null || (dynamicOwners = (ConcurrentMap)OwnerCheck.this.dynamics.get((Object)type)) == null) continue;
                            long id = block.getSingleValueLong();
                            DynamicOwner.Property owner = new DynamicOwner.Property(type, record);
                            DynamicOwner prev = dynamicOwners.put(id, owner);
                            if (prev == null) continue;
                            engine.comparativeCheck(prev.record(records), owner);
                        }
                    }
                }
                checker.check(record, engine, records);
            }

            @Override
            public void checkChange(PropertyRecord oldRecord, PropertyRecord newRecord, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, DiffRecordAccess records) {
                checker.checkChange(oldRecord, newRecord, engine, records);
            }
        };
    }

    private RecordType recordType(PropertyType type) {
        if (type != null) {
            switch (type) {
                case STRING: {
                    return RecordType.STRING_PROPERTY;
                }
                case ARRAY: {
                    return RecordType.ARRAY_PROPERTY;
                }
            }
        }
        return null;
    }

    @Override
    public RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> decoratePropertyKeyTokenChecker(RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
        ConcurrentMap<Long, DynamicOwner> dynamicOwners = this.dynamicOwners(RecordType.PROPERTY_KEY_NAME);
        if (dynamicOwners == null) {
            return checker;
        }
        return new NameCheckerDecorator<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport>(checker, dynamicOwners){

            @Override
            DynamicOwner.NameOwner owner(PropertyKeyTokenRecord record) {
                return new DynamicOwner.PropertyKey(record);
            }
        };
    }

    @Override
    public RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> decorateRelationshipTypeTokenChecker(RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
        ConcurrentMap<Long, DynamicOwner> dynamicOwners = this.dynamicOwners(RecordType.RELATIONSHIP_TYPE_NAME);
        if (dynamicOwners == null) {
            return checker;
        }
        return new NameCheckerDecorator<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport>(checker, dynamicOwners){

            @Override
            DynamicOwner.NameOwner owner(RelationshipTypeTokenRecord record) {
                return new DynamicOwner.RelationshipTypeToken(record);
            }
        };
    }

    @Override
    public RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> decorateLabelTokenChecker(RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
        ConcurrentMap<Long, DynamicOwner> dynamicOwners = this.dynamicOwners(RecordType.RELATIONSHIP_TYPE_NAME);
        if (dynamicOwners == null) {
            return checker;
        }
        return new NameCheckerDecorator<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport>(checker, dynamicOwners){

            @Override
            DynamicOwner.NameOwner owner(LabelTokenRecord record) {
                return new DynamicOwner.LabelToken(record);
            }
        };
    }

    @Override
    public RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> decorateLabelMatchChecker(RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> checker) {
        return checker;
    }

    RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> decorateDynamicChecker(final RecordType type, final RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> checker) {
        final ConcurrentMap<Long, DynamicOwner> dynamicOwners = this.dynamicOwners(type);
        if (dynamicOwners == null) {
            return checker;
        }
        return new RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport>(){

            @Override
            public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
                if (record.inUse()) {
                    DynamicOwner.Unknown owner = new DynamicOwner.Unknown();
                    engine.comparativeCheck(owner, DynamicOwner.ORPHAN_CHECK);
                    if (null == dynamicOwners.putIfAbsent(record.getId(), owner)) {
                        owner.markInCustody();
                    }
                    if (!Record.NO_NEXT_BLOCK.is(record.getNextBlock())) {
                        DynamicOwner.Dynamic nextOwner = new DynamicOwner.Dynamic(type, record);
                        DynamicOwner prevOwner = dynamicOwners.put(record.getNextBlock(), nextOwner);
                        if (prevOwner != null) {
                            engine.comparativeCheck(prevOwner.record(records), nextOwner);
                        }
                    }
                }
                checker.check(record, engine, records);
            }

            @Override
            public void checkChange(DynamicRecord oldRecord, DynamicRecord newRecord, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, DiffRecordAccess records) {
                checker.checkChange(oldRecord, newRecord, engine, records);
            }
        };
    }

    @Override
    public RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> decorateRelationshipGroupChecker(RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
        return checker;
    }

    private ConcurrentMap<Long, DynamicOwner> dynamicOwners(RecordType type) {
        return this.dynamics == null ? null : this.dynamics.get((Object)type);
    }

    private static abstract class NameCheckerDecorator<RECORD extends TokenRecord, REPORT extends ConsistencyReport.NameConsistencyReport>
    implements RecordCheck<RECORD, REPORT> {
        private final RecordCheck<RECORD, REPORT> checker;
        private final ConcurrentMap<Long, DynamicOwner> owners;

        public NameCheckerDecorator(RecordCheck<RECORD, REPORT> checker, ConcurrentMap<Long, DynamicOwner> owners) {
            this.checker = checker;
            this.owners = owners;
        }

        @Override
        public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            if (record.inUse()) {
                DynamicOwner.NameOwner owner = this.owner(record);
                DynamicOwner prev = this.owners.put(Long.valueOf(record.getNameId()), owner);
                if (prev != null) {
                    engine.comparativeCheck(prev.record(records), owner);
                }
            }
            this.checker.check(record, engine, records);
        }

        abstract DynamicOwner.NameOwner owner(RECORD var1);

        @Override
        public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
            this.checker.checkChange(oldRecord, newRecord, engine, records);
        }
    }

    private abstract class PrimitiveCheckerDecorator<RECORD extends PrimitiveRecord, REPORT extends ConsistencyReport.PrimitiveConsistencyReport>
    implements OwningRecordCheck<RECORD, REPORT> {
        private final OwningRecordCheck<RECORD, REPORT> checker;

        PrimitiveCheckerDecorator(OwningRecordCheck<RECORD, REPORT> checker) {
            this.checker = checker;
        }

        @Override
        public void check(RECORD record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            PropertyOwner previous;
            long prop;
            if (record.inUse() && !Record.NO_NEXT_PROPERTY.is(prop = record.getNextProp()) && (previous = OwnerCheck.this.owners.put(prop, this.owner(record))) != null) {
                engine.comparativeCheck(previous.record(records), this.checker.ownerCheck());
            }
            this.checker.check(record, engine, records);
        }

        @Override
        public void checkChange(RECORD oldRecord, RECORD newRecord, CheckerEngine<RECORD, REPORT> engine, DiffRecordAccess records) {
            this.checker.checkChange(oldRecord, newRecord, engine, records);
        }

        @Override
        public ComparativeRecordChecker<RECORD, PrimitiveRecord, REPORT> ownerCheck() {
            return this.checker.ownerCheck();
        }

        abstract PropertyOwner owner(RECORD var1);
    }

    private static class OrphanCheck
    implements Runnable {
        private final ConcurrentMap<Long, ? extends Owner> owners;
        private final ProgressListener progress;

        OrphanCheck(RecordType property, ConcurrentMap<Long, ? extends Owner> owners, ProgressMonitorFactory.MultiPartBuilder progress) {
            this.owners = owners;
            this.progress = progress.progressForPart("Checking for orphan " + property.name() + " chains", (long)owners.size());
        }

        @Override
        public void run() {
            for (Owner owner : this.owners.values()) {
                owner.checkOrphanage();
                this.progress.add(1L);
            }
            this.progress.done();
        }
    }
}

