/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.rng.deallocator;

import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import lombok.NonNull;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.rng.deallocator.GarbageStateReference;
import org.nd4j.rng.deallocator.NativePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeRandomDeallocator {
    private static final Logger log = LoggerFactory.getLogger(NativeRandomDeallocator.class);
    private static final NativeRandomDeallocator INSTANCE = new NativeRandomDeallocator();
    private final ReferenceQueue<NativePack> queue;
    private final Map<Long, GarbageStateReference> referenceMap;
    private List<DeallocatorThread> deallocatorThreads = new ArrayList<DeallocatorThread>();
    @Deprecated
    public static final String DeallocatorThreadNamePrefix = "NativeRandomDeallocator thread ";

    private NativeRandomDeallocator() {
        this.queue = new ReferenceQueue();
        this.referenceMap = new ConcurrentHashMap<Long, GarbageStateReference>();
        DeallocatorThread thread = new DeallocatorThread(0, this.queue, this.referenceMap);
        thread.start();
        this.deallocatorThreads.add(thread);
    }

    public static NativeRandomDeallocator getInstance() {
        return INSTANCE;
    }

    public void trackStatePointer(NativePack random) {
        if (random.getStatePointer() != null) {
            GarbageStateReference reference = new GarbageStateReference(random, this.queue);
            this.referenceMap.put(random.getStatePointer().address(), reference);
        }
    }

    protected class DeallocatorThread
    extends Thread
    implements Runnable {
        private final ReferenceQueue<NativePack> queue;
        private final Map<Long, GarbageStateReference> referenceMap;

        protected DeallocatorThread(@NonNull int threadId, ReferenceQueue<NativePack> queue, Map<Long, GarbageStateReference> referenceMap) {
            if (queue == null) {
                throw new NullPointerException("queue is marked non-null but is null");
            }
            this.queue = queue;
            this.referenceMap = referenceMap;
            this.setName(NativeRandomDeallocator.DeallocatorThreadNamePrefix + threadId);
            this.setDaemon(true);
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        GarbageStateReference reference;
                        if ((reference = (GarbageStateReference)this.queue.remove()) != null) {
                            if (reference.getStatePointer() == null) continue;
                            this.referenceMap.remove(reference.getStatePointer().address());
                            NativeOpsHolder.getInstance().getDeviceNativeOps().destroyRandom(reference.getStatePointer());
                            continue;
                        }
                        LockSupport.parkNanos(5000L);
                    }
                }
                catch (InterruptedException reference) {
                    continue;
                }
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

