/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.rng;

import java.util.List;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueRandomGenerator;
import org.nd4j.rng.NativeRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaNativeRandom
extends NativeRandom {
    private static final Logger log = LoggerFactory.getLogger(CudaNativeRandom.class);
    private NativeOps nativeOps;
    protected List<DataBuffer> stateBuffers;

    public CudaNativeRandom() {
        this(System.currentTimeMillis());
    }

    public CudaNativeRandom(long seed) {
        super(seed);
    }

    public CudaNativeRandom(long seed, long nodeSeed) {
        super(seed, nodeSeed);
    }

    public void init() {
        this.nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        this.statePointer = this.nativeOps.createRandomGenerator(this.seed, this.seed ^ 0xFFFFFFFFDEADBEEFL);
        if (this.nativeOps.lastErrorCode() != 0) {
            throw new RuntimeException(this.nativeOps.lastErrorMessage());
        }
        this.setSeed(this.seed);
    }

    public void close() {
        this.nativeOps.deleteRandomGenerator((OpaqueRandomGenerator)this.statePointer);
    }

    public PointerPointer getExtraPointers() {
        return null;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.currentPosition.set(0L);
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, seed, seed ^ 0xFFFFFFFFDEADBEEFL);
    }

    public long getSeed() {
        return this.seed;
    }

    public float nextFloat() {
        return this.nativeOps.getRandomGeneratorRelativeFloat((OpaqueRandomGenerator)this.statePointer, this.currentPosition.getAndIncrement());
    }

    public double nextDouble() {
        return this.nativeOps.getRandomGeneratorRelativeDouble((OpaqueRandomGenerator)this.statePointer, this.currentPosition.getAndIncrement());
    }

    public int nextInt() {
        return this.nativeOps.getRandomGeneratorRelativeInt((OpaqueRandomGenerator)this.statePointer, this.currentPosition.getAndIncrement());
    }

    public long nextLong() {
        return this.nativeOps.getRandomGeneratorRelativeLong((OpaqueRandomGenerator)this.statePointer, this.currentPosition.getAndIncrement());
    }

    public long rootState() {
        return this.nativeOps.getRandomGeneratorRootState((OpaqueRandomGenerator)this.statePointer);
    }

    public long nodeState() {
        return this.nativeOps.getRandomGeneratorNodeState((OpaqueRandomGenerator)this.statePointer);
    }

    public void setStates(long rootState, long nodeState) {
        this.nativeOps.setRandomGeneratorStates((OpaqueRandomGenerator)this.statePointer, rootState, nodeState);
    }
}

