/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.time.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nd4j.jita.allocator.time.RateTimer;

public class SimpleTimer
implements RateTimer {
    protected volatile long timeframe;
    protected final AtomicLong latestEvent = new AtomicLong(0L);
    protected volatile long[] buckets;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SimpleTimer(long timeframe, TimeUnit timeUnit) {
        this.timeframe = TimeUnit.MILLISECONDS.convert(timeframe, timeUnit);
        int bucketsize = (int)TimeUnit.SECONDS.convert(timeframe, timeUnit);
        this.buckets = new long[bucketsize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerEvent() {
        try {
            int currentBin;
            this.lock.writeLock().lock();
            long currentTime = System.currentTimeMillis();
            if (this.latestEvent.get() == 0L) {
                this.latestEvent.set(currentTime);
            }
            this.actualizeCounts(currentTime);
            int n = currentBin = (int)TimeUnit.SECONDS.convert(currentTime, TimeUnit.MILLISECONDS) % this.buckets.length;
            this.buckets[n] = this.buckets[n] + 1L;
            if (currentBin == this.buckets.length - 1) {
                this.buckets[0] = 0L;
            } else {
                this.buckets[currentBin + 1] = 0L;
            }
            this.latestEvent.set(currentTime);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void actualizeCounts(long currentTime) {
        block4: {
            int expiredBinsNum;
            block3: {
                int currentBin = (int)TimeUnit.SECONDS.convert(currentTime, TimeUnit.MILLISECONDS) % this.buckets.length;
                long lastTime = this.latestEvent.get();
                expiredBinsNum = (int)TimeUnit.SECONDS.convert(currentTime - lastTime, TimeUnit.MILLISECONDS);
                if (expiredBinsNum <= 0 || expiredBinsNum >= this.buckets.length) break block3;
                for (int x = 1; x <= expiredBinsNum; ++x) {
                    int position = currentBin + x;
                    if (position >= this.buckets.length) {
                        position -= this.buckets.length;
                    }
                    this.buckets[position] = 0L;
                }
                break block4;
            }
            if (expiredBinsNum < this.buckets.length) break block4;
            for (int x = 0; x < this.buckets.length; ++x) {
                this.buckets[x] = 0L;
            }
        }
    }

    @Override
    public double getFrequencyOfEvents() {
        return (double)this.getNumberOfEvents() / (double)TimeUnit.SECONDS.convert(this.timeframe, TimeUnit.MILLISECONDS);
    }

    protected long sumCounts() {
        long result = 0L;
        for (int x = 0; x < this.buckets.length; ++x) {
            result += this.buckets[x];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberOfEvents() {
        try {
            this.lock.readLock().lock();
            long currentTime = System.currentTimeMillis();
            this.actualizeCounts(currentTime);
            long l = this.sumCounts();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

