/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.concurrency;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.jita.allocator.enums.AccessState;

public class AtomicState {
    protected final AtomicInteger currentState;
    protected final AtomicLong tickRequests = new AtomicLong(0L);
    protected final AtomicLong tackRequests = new AtomicLong(0L);
    protected final AtomicLong toeRequests = new AtomicLong(0L);
    protected final AtomicLong waitingTicks = new AtomicLong(0L);
    protected final AtomicBoolean isToeWaiting = new AtomicBoolean(false);
    protected final AtomicBoolean isToeScheduled = new AtomicBoolean(false);
    protected final AtomicLong toeThread = new AtomicLong(0L);

    public AtomicState() {
        this(AccessState.TACK);
    }

    public AtomicState(AccessState initialStatus) {
        this.currentState = new AtomicInteger(initialStatus.ordinal());
    }

    public void requestTick() {
        this.requestTick(10L, TimeUnit.SECONDS);
    }

    public void requestTick(long time, TimeUnit timeUnit) {
        long timeframeMs = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        long currentTime = System.currentTimeMillis();
        boolean isWaiting = false;
        try {
            while (this.isToeScheduled.get() || this.isToeWaiting.get() || this.getCurrentState() == AccessState.TOE) {
                if (!isWaiting) {
                    isWaiting = true;
                    this.waitingTicks.incrementAndGet();
                }
                Thread.sleep(50L);
            }
            this.currentState.set(AccessState.TICK.ordinal());
            this.waitingTicks.decrementAndGet();
            this.tickRequests.incrementAndGet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void requestTack() {
        this.currentState.set(AccessState.TACK.ordinal());
        this.tackRequests.incrementAndGet();
    }

    public void requestToe() {
        this.isToeWaiting.set(true);
        try {
            while (this.getCurrentState() != AccessState.TACK && (this.getCurrentState() != AccessState.TOE || this.toeThread.get() != Thread.currentThread().getId())) {
                Thread.sleep(20L);
            }
            this.toeRequests.incrementAndGet();
            this.currentState.set(AccessState.TOE.ordinal());
            this.toeThread.set(Thread.currentThread().getId());
            this.isToeWaiting.set(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tryRequestToe() {
        this.scheduleToe();
        if (this.isToeWaiting.get() || this.getCurrentState() == AccessState.TOE) {
            this.discardScheduledToe();
            return false;
        }
        this.discardScheduledToe();
        this.requestToe();
        return true;
    }

    public void releaseToe() {
        if (this.getCurrentState() == AccessState.TOE) {
            if (this.toeRequests.decrementAndGet() == 0L) {
                this.tickRequests.set(0L);
                this.tackRequests.set(0L);
                this.currentState.set(AccessState.TACK.ordinal());
            }
        } else {
            throw new IllegalStateException("Object is NOT in Toe state!");
        }
    }

    public AccessState getCurrentState() {
        if (AccessState.values()[this.currentState.get()] == AccessState.TOE) {
            return AccessState.TOE;
        }
        if (this.tickRequests.get() <= this.tackRequests.get()) {
            this.tickRequests.set(0L);
            this.tackRequests.set(0L);
            return AccessState.TACK;
        }
        return AccessState.TICK;
    }

    public long getWaitingTickRequests() {
        return this.waitingTicks.get();
    }

    public long getTickRequests() {
        return this.tickRequests.get();
    }

    public long getTackRequests() {
        return this.tackRequests.get();
    }

    public boolean isToeAvailable() {
        return this.getCurrentState() == AccessState.TACK;
    }

    public void scheduleToe() {
        this.isToeScheduled.set(true);
    }

    public void discardScheduledToe() {
        if (this.isToeScheduled.get()) {
            this.isToeScheduled.set(false);
        }
    }
}

