// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.nd4j.nativeblas;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class Nd4jCuda extends org.nd4j.nativeblas.Nd4jCudaHelper {
    static { Loader.load(); }

@Name("std::vector<std::vector<int> >") public static class IntVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntVectorVector(Pointer p) { super(p); }
    public IntVectorVector(int[] ... array) { this(array.length); put(array); }
    public IntVectorVector()       { allocate();  }
    public IntVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef IntVectorVector put(@ByRef IntVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);
    public boolean empty(@Cast("size_t") long i) { return size(i) == 0; }
    public native @Index(function = "at") long size(@Cast("size_t") long i);
    public void clear(@Cast("size_t") long i) { resize(i, 0); }
    public native @Index(function = "at") void resize(@Cast("size_t") long i, @Cast("size_t") long n);

    @Index(function = "at") public native int get(@Cast("size_t") long i, @Cast("size_t") long j);
    public native IntVectorVector put(@Cast("size_t") long i, @Cast("size_t") long j, int value);

    public int[][] get() {
        int[][] array = new int[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE][];
        for (int i = 0; i < array.length; i++) {
            array[i] = new int[size(i) < Integer.MAX_VALUE ? (int)size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < array[i].length; j++) {
                array[i][j] = get(i, j);
            }
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.deepToString(get());
    }

    public IntVectorVector put(int[] ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            if (size(i) != array[i].length) { resize(i, array[i].length); }
            for (int j = 0; j < array[i].length; j++) {
                put(i, j, array[i][j]);
            }
        }
        return this;
    }
}

@Name("std::vector<std::vector<Nd4jLong> >") public static class LongVectorVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public LongVectorVector(Pointer p) { super(p); }
    public LongVectorVector(long[] ... array) { this(array.length); put(array); }
    public LongVectorVector()       { allocate();  }
    public LongVectorVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef LongVectorVector put(@ByRef LongVectorVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);
    public boolean empty(@Cast("size_t") long i) { return size(i) == 0; }
    public native @Index(function = "at") long size(@Cast("size_t") long i);
    public void clear(@Cast("size_t") long i) { resize(i, 0); }
    public native @Index(function = "at") void resize(@Cast("size_t") long i, @Cast("size_t") long n);

    @Index(function = "at") public native @Cast("Nd4jLong") long get(@Cast("size_t") long i, @Cast("size_t") long j);
    public native LongVectorVector put(@Cast("size_t") long i, @Cast("size_t") long j, long value);

    public long[][] get() {
        long[][] array = new long[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE][];
        for (int i = 0; i < array.length; i++) {
            array[i] = new long[size(i) < Integer.MAX_VALUE ? (int)size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < array[i].length; j++) {
                array[i][j] = get(i, j);
            }
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.deepToString(get());
    }

    public LongVectorVector put(long[] ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            if (size(i) != array[i].length) { resize(i, array[i].length); }
            for (int j = 0; j < array[i].length; j++) {
                put(i, j, array[i][j]);
            }
        }
        return this;
    }
}

@Name("std::vector<sd::NDArray*>") public static class NDArrayVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public NDArrayVector(Pointer p) { super(p); }
    public NDArrayVector(NDArray value) { this(1); put(0, value); }
    public NDArrayVector(NDArray ... array) { this(array.length); put(array); }
    public NDArrayVector()       { allocate();  }
    public NDArrayVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef NDArrayVector put(@ByRef NDArrayVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native NDArray get(@Cast("size_t") long i);
    public native NDArrayVector put(@Cast("size_t") long i, NDArray value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, NDArray value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @Const NDArray get();
    }

    public NDArray[] get() {
        NDArray[] array = new NDArray[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public NDArray pop_back() {
        long size = size();
        NDArray value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public NDArrayVector push_back(NDArray value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public NDArrayVector put(NDArray value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public NDArrayVector put(NDArray ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@Name("std::vector<const sd::NDArray*>") public static class ConstNDArrayVector extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ConstNDArrayVector(Pointer p) { super(p); }
    public ConstNDArrayVector(NDArray value) { this(1); put(0, value); }
    public ConstNDArrayVector(NDArray ... array) { this(array.length); put(array); }
    public ConstNDArrayVector()       { allocate();  }
    public ConstNDArrayVector(long n) { allocate(n); }
    private native void allocate();
    private native void allocate(@Cast("size_t") long n);
    public native @Name("operator =") @ByRef ConstNDArrayVector put(@ByRef ConstNDArrayVector x);

    public boolean empty() { return size() == 0; }
    public native long size();
    public void clear() { resize(0); }
    public native void resize(@Cast("size_t") long n);

    @Index(function = "at") public native @Const NDArray get(@Cast("size_t") long i);
    public native ConstNDArrayVector put(@Cast("size_t") long i, NDArray value);

    public native @ByVal Iterator insert(@ByVal Iterator pos, @Const NDArray value);
    public native @ByVal Iterator erase(@ByVal Iterator pos);
    public native @ByVal Iterator begin();
    public native @ByVal Iterator end();
    @NoOffset @Name("iterator") public static class Iterator extends Pointer {
        public Iterator(Pointer p) { super(p); }
        public Iterator() { }

        public native @Name("operator ++") @ByRef Iterator increment();
        public native @Name("operator ==") boolean equals(@ByRef Iterator it);
        public native @Name("operator *") @Const NDArray get();
    }

    public NDArray[] get() {
        NDArray[] array = new NDArray[size() < Integer.MAX_VALUE ? (int)size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; i++) {
            array[i] = get(i);
        }
        return array;
    }
    @Override public String toString() {
        return java.util.Arrays.toString(get());
    }

    public NDArray pop_back() {
        long size = size();
        NDArray value = get(size - 1);
        resize(size - 1);
        return value;
    }
    public ConstNDArrayVector push_back(NDArray value) {
        long size = size();
        resize(size + 1);
        return put(size, value);
    }
    public ConstNDArrayVector put(NDArray value) {
        if (size() != 1) { resize(1); }
        return put(0, value);
    }
    public ConstNDArrayVector put(NDArray ... array) {
        if (size() != array.length) { resize(array.length); }
        for (int i = 0; i < array.length; i++) {
            put(i, array[i]);
        }
        return this;
    }
}

@NoOffset @Name("std::pair<int,int>") public static class IntIntPair extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public IntIntPair(Pointer p) { super(p); }
    public IntIntPair(int firstValue, int secondValue) { this(); put(firstValue, secondValue); }
    public IntIntPair()       { allocate();  }
    private native void allocate();
    public native @Name("operator =") @ByRef IntIntPair put(@ByRef IntIntPair x);


    @MemberGetter public native int first(); public native IntIntPair first(int first);
    @MemberGetter public native int second();  public native IntIntPair second(int second);

    public IntIntPair put(int firstValue, int secondValue) {
        first(firstValue);
        second(secondValue);
        return this;
    }
}

// Parsed from array/DataType.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_DATATYPE_H
// #define ND4J_DATATYPE_H
    /** enum sd::DataType */
    public static final int
        INHERIT = 0,
        BOOL = 1,
        FLOAT8 = 2,
        HALF = 3,
        HALF2 = 4,
        FLOAT32 = 5,
        DOUBLE = 6,
        INT8 = 7,
        INT16 = 8,
        INT32 = 9,
        INT64 = 10,
        UINT8 = 11,
        UINT16 = 12,
        UINT32 = 13,
        UINT64 = 14,
        QINT8 = 15,
        QINT16 = 16,
        BFLOAT16 = 17,
        UTF8 = 50,
        UTF16 = 51,
        UTF32 = 52,
        ANY = 100,
        AUTO = 200;


// #endif

// Parsed from array/DataBuffer.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
// @author Yurii Shyrma (iuriish@yahoo.com)
//

// #ifndef DEV_TESTS_DATABUFFER_H
// #define DEV_TESTS_DATABUFFER_H

// #include <cstring>
// #include <system/op_boilerplate.h>
// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <array/DataType.h>
// #include <memory/Workspace.h>
// #include <execution/LaunchContext.h>

@Namespace("sd") @NoOffset public static class DataBuffer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DataBuffer(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DataBuffer(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DataBuffer position(long position) {
        return (DataBuffer)super.position(position);
    }
    @Override public DataBuffer getPointer(long i) {
        return new DataBuffer((Pointer)this).position(position + i);
    }


        public DataBuffer(Pointer primary, Pointer special,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType,
                                       @Cast("const bool") boolean isOwnerPrimary/*=false*/, @Cast("const bool") boolean isOwnerSpecial/*=false*/,
                                       Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(primary, special, lenInBytes, dataType, isOwnerPrimary, isOwnerSpecial, workspace); }
        private native void allocate(Pointer primary, Pointer special,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType,
                                       @Cast("const bool") boolean isOwnerPrimary/*=false*/, @Cast("const bool") boolean isOwnerSpecial/*=false*/,
                                       Workspace workspace/*=nullptr*/);
        public DataBuffer(Pointer primary, Pointer special,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType) { super((Pointer)null); allocate(primary, special, lenInBytes, dataType); }
        private native void allocate(Pointer primary, Pointer special,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType);

        public DataBuffer(Pointer primary,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType,
                                       @Cast("const bool") boolean isOwnerPrimary/*=false*/,
                                       Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(primary, lenInBytes, dataType, isOwnerPrimary, workspace); }
        private native void allocate(Pointer primary,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType,
                                       @Cast("const bool") boolean isOwnerPrimary/*=false*/,
                                       Workspace workspace/*=nullptr*/);
        public DataBuffer(Pointer primary,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType) { super((Pointer)null); allocate(primary, lenInBytes, dataType); }
        private native void allocate(Pointer primary,
                                       @Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType);

        public DataBuffer(@Const Pointer hostBuffer,
                                       @Cast("const sd::DataType") int dataType, @Cast("const size_t") long lenInBytes,
                                       Workspace workspace/*=nullptr*/) { super((Pointer)null); allocate(hostBuffer, dataType, lenInBytes, workspace); }
        private native void allocate(@Const Pointer hostBuffer,
                                       @Cast("const sd::DataType") int dataType, @Cast("const size_t") long lenInBytes,
                                       Workspace workspace/*=nullptr*/);
        public DataBuffer(@Const Pointer hostBuffer,
                                       @Cast("const sd::DataType") int dataType, @Cast("const size_t") long lenInBytes) { super((Pointer)null); allocate(hostBuffer, dataType, lenInBytes); }
        private native void allocate(@Const Pointer hostBuffer,
                                       @Cast("const sd::DataType") int dataType, @Cast("const size_t") long lenInBytes);

        public DataBuffer(@Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType, Workspace workspace/*=nullptr*/, @Cast("const bool") boolean allocBoth/*=false*/) { super((Pointer)null); allocate(lenInBytes, dataType, workspace, allocBoth); }
        private native void allocate(@Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType, Workspace workspace/*=nullptr*/, @Cast("const bool") boolean allocBoth/*=false*/);
        public DataBuffer(@Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType) { super((Pointer)null); allocate(lenInBytes, dataType); }
        private native void allocate(@Cast("const size_t") long lenInBytes, @Cast("const sd::DataType") int dataType);

        public DataBuffer(@Const @ByRef DataBuffer other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef DataBuffer other);
        public DataBuffer() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native @ByRef @Name("operator =") DataBuffer put(@Const @ByRef DataBuffer other);

        public native @Cast("sd::DataType") int getDataType();
        public native void setDataType(@Cast("sd::DataType") int dataType);
        public native @Cast("size_t") long getLenInBytes();

        public native Pointer primary();
        public native Pointer special();

        public native void allocatePrimary();
        public native void allocateSpecial();

        public native void writePrimary();
        public native void writeSpecial();
        public native void readPrimary();
        public native void readSpecial();
        public native @Cast("bool") boolean isPrimaryActual();
        public native @Cast("bool") boolean isSpecialActual();

        public native void expand(@Cast("const uint64_t") long size);

        public native int deviceId();
        public native void setDeviceId(int deviceId);
        public native void migrate();

        public native void syncToPrimary(@Const LaunchContext context, @Cast("const bool") boolean forceSync/*=false*/);
        public native void syncToPrimary(@Const LaunchContext context);
        public native void syncToSpecial(@Cast("const bool") boolean forceSync/*=false*/);
        public native void syncToSpecial();

        public native void setToZeroBuffers(@Cast("const bool") boolean both/*=false*/);
        public native void setToZeroBuffers();

        public native void copyBufferFrom(@Const @ByRef DataBuffer other, @Cast("size_t") long sizeToCopyinBytes/*=0*/, @Cast("const Nd4jLong") long offsetThis/*=0*/, @Cast("const Nd4jLong") long offsetOther/*=0*/);
        public native void copyBufferFrom(@Const @ByRef DataBuffer other);

        public static native void memcpy(@Const @ByRef DataBuffer dst, @Const @ByRef DataBuffer src);

        public native void setPrimaryBuffer(Pointer buffer, @Cast("size_t") long length);
        public native void setSpecialBuffer(Pointer buffer, @Cast("size_t") long length);

        /**
         * This method deletes buffers, if we're owners
         */
        public native @Name("close") void _close();
}
///// IMLEMENTATION OF INLINE METHODS /////

////////////////////////////////////////////////////////////////////////
    

////////////////////////////////////////////////////////////////////////
    




// #endif //DEV_TESTS_DATABUFFER_H


// Parsed from array/PointerDeallocator.h

/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  * See the NOTICE file distributed with this work for additional
 *  * information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

//
//  @author raver119@gmail.com
//

// #ifndef SD_POINTERDEALLOCATOR_H_
// #define SD_POINTERDEALLOCATOR_H_

// #include <system/dll.h>
// #include <system/pointercast.h>



// #endif //SD_POINTERDEALLOCATOR_H_


// Parsed from array/PointerWrapper.h

/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  * See the NOTICE file distributed with this work for additional
 *  * information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

//
//  @author raver119@gmail.com
//

// #ifndef SD_ARRAY_POINTER_H_
// #define SD_ARRAY_POINTER_H_

// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <array/PointerDeallocator.h>
// #include <memory>
 // namespace sd

// #endif //SD_ARRAY_POINTER_H_


// Parsed from array/ConstantDescriptor.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef DEV_TESTS_CONSTANTDESCRIPTOR_H
// #define DEV_TESTS_CONSTANTDESCRIPTOR_H

// #include <array/DataType.h>
// #include <unordered_map>
// #include <vector>
// #include <system/pointercast.h>
// #include <system/dll.h>
// #include <array/ConstantDataBuffer.h>
    @Namespace("sd") @NoOffset public static class ConstantDescriptor extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ConstantDescriptor(Pointer p) { super(p); }
    
        public ConstantDescriptor(DoublePointer values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(DoublePointer values, int length);
        public ConstantDescriptor(DoubleBuffer values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(DoubleBuffer values, int length);
        public ConstantDescriptor(double[] values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(double[] values, int length);
        public ConstantDescriptor(@Cast("const Nd4jLong*") LongPointer values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer values, int length);
        public ConstantDescriptor(@Cast("const Nd4jLong*") LongBuffer values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer values, int length);
        public ConstantDescriptor(@Cast("const Nd4jLong*") long[] values, int length) { super((Pointer)null); allocate(values, length); }
        private native void allocate(@Cast("const Nd4jLong*") long[] values, int length);

        public ConstantDescriptor(@Cast("Nd4jLong*") @StdVector LongPointer values) { super((Pointer)null); allocate(values); }
        private native void allocate(@Cast("Nd4jLong*") @StdVector LongPointer values);
        public ConstantDescriptor(@Cast("Nd4jLong*") @StdVector LongBuffer values) { super((Pointer)null); allocate(values); }
        private native void allocate(@Cast("Nd4jLong*") @StdVector LongBuffer values);
        public ConstantDescriptor(@Cast("Nd4jLong*") @StdVector long[] values) { super((Pointer)null); allocate(values); }
        private native void allocate(@Cast("Nd4jLong*") @StdVector long[] values);
        public ConstantDescriptor(@StdVector DoublePointer values) { super((Pointer)null); allocate(values); }
        private native void allocate(@StdVector DoublePointer values);
        public ConstantDescriptor(@StdVector DoubleBuffer values) { super((Pointer)null); allocate(values); }
        private native void allocate(@StdVector DoubleBuffer values);
        public ConstantDescriptor(@StdVector double[] values) { super((Pointer)null); allocate(values); }
        private native void allocate(@StdVector double[] values);

        // equal to operator
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef ConstantDescriptor other);

        // less than operator
        public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef ConstantDescriptor other);

        public native @Cast("bool") boolean isInteger();
        public native @Cast("bool") boolean isFloat();

        public native @Cast("Nd4jLong") long length();

        public native @Cast("Nd4jLong*") @StdVector LongPointer integerValues();
        public native @StdVector DoublePointer floatValues();
    }


// #ifndef __JAVACPP_HACK__

// #endif


// #endif //DEV_TESTS_CONSTANTDESCRIPTOR_H


// Parsed from array/ConstantDataBuffer.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com

// #ifndef LIBND4J_CONSTANTDATABUFFER_H
// #define LIBND4J_CONSTANTDATABUFFER_H

// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <memory>
// #include <array/PointerWrapper.h>
// #include <array/DataType.h>
    @Namespace("sd") @NoOffset public static class ConstantDataBuffer extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ConstantDataBuffer(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ConstantDataBuffer(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ConstantDataBuffer position(long position) {
            return (ConstantDataBuffer)super.position(position);
        }
        @Override public ConstantDataBuffer getPointer(long i) {
            return new ConstantDataBuffer((Pointer)this).position(position + i);
        }
    
        public ConstantDataBuffer(@Const @ByRef ConstantDataBuffer other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef ConstantDataBuffer other);
        public ConstantDataBuffer() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native @Cast("uint8_t") byte sizeOf();
        public native @Cast("uint64_t") long length();

        public native Pointer primary();
        public native Pointer special();

        public native @ByRef @Name("operator =") ConstantDataBuffer put(@Const @ByRef ConstantDataBuffer other);
    }


// #endif //DEV_TESTS_CONSTANTDATABUFFER_H


// Parsed from array/ConstantShapeBuffer.h

/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  * See the NOTICE file distributed with this work for additional
 *  * information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

//
// @author raver119@gmail.com
//

// #ifndef SD_ARRAY_CONSTANTSHAPEBUFFER_H_
// #define SD_ARRAY_CONSTANTSHAPEBUFFER_H_

// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <array/PointerWrapper.h>
// #include <memory>

@Namespace("sd") public static class ConstantShapeBuffer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ConstantShapeBuffer(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ConstantShapeBuffer(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ConstantShapeBuffer position(long position) {
        return (ConstantShapeBuffer)super.position(position);
    }
    @Override public ConstantShapeBuffer getPointer(long i) {
        return new ConstantShapeBuffer((Pointer)this).position(position + i);
    }

  public ConstantShapeBuffer() { super((Pointer)null); allocate(); }
  private native void allocate();

  public native @Cast("const Nd4jLong*") LongPointer primary();
  public native @Cast("const Nd4jLong*") LongPointer special();
  public native @Cast("const Nd4jLong*") LongPointer platform();
}

 // namespace sd

// #endif //SD_ARRAY_CONSTANTSHAPEBUFFER_H_


// Parsed from array/ConstantOffsetsBuffer.h

/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  * See the NOTICE file distributed with this work for additional
 *  * information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

//
// @author raver119@gmail.com
//

// #ifndef SD_ARRAY_CONSTANTOFFSETSBUFFER_H_
// #define SD_ARRAY_CONSTANTOFFSETSBUFFER_H_

// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <memory>
// #include <array/PointerWrapper.h>

@Namespace("sd") public static class ConstantOffsetsBuffer extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ConstantOffsetsBuffer(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ConstantOffsetsBuffer(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ConstantOffsetsBuffer position(long position) {
        return (ConstantOffsetsBuffer)super.position(position);
    }
    @Override public ConstantOffsetsBuffer getPointer(long i) {
        return new ConstantOffsetsBuffer((Pointer)this).position(position + i);
    }

  public ConstantOffsetsBuffer() { super((Pointer)null); allocate(); }
  private native void allocate();

  public native @Cast("const Nd4jLong*") LongPointer primary();
  public native @Cast("const Nd4jLong*") LongPointer special();
  public native @Cast("const Nd4jLong*") LongPointer platform();
}

 // namespace sd

// #endif //SD_ARRAY_CONSTANTOFFSETSBUFFER_H_


// Parsed from array/TadPack.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef DEV_TESTS_TADPACK_H
// #define DEV_TESTS_TADPACK_H

// #include <array/ConstantOffsetsBuffer.h>
// #include <array/ConstantShapeBuffer.h>
    @Namespace("sd") @NoOffset public static class TadPack extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public TadPack(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public TadPack(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public TadPack position(long position) {
            return (TadPack)super.position(position);
        }
        @Override public TadPack getPointer(long i) {
            return new TadPack((Pointer)this).position(position + i);
        }
    
        public TadPack(@Const @ByRef ConstantShapeBuffer shapes, @Const @ByRef ConstantOffsetsBuffer offets, @Cast("Nd4jLong") long numTads) { super((Pointer)null); allocate(shapes, offets, numTads); }
        private native void allocate(@Const @ByRef ConstantShapeBuffer shapes, @Const @ByRef ConstantOffsetsBuffer offets, @Cast("Nd4jLong") long numTads);
        public TadPack() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native @Cast("const Nd4jLong*") LongPointer primaryShapeInfo();
        public native @Cast("const Nd4jLong*") LongPointer primaryOffsets();

        public native @Cast("const Nd4jLong*") LongPointer specialShapeInfo();
        public native @Cast("const Nd4jLong*") LongPointer specialOffsets();

        public native @Cast("Nd4jLong") long numberOfTads();
        public native int shapeInfoLength();

        /**
         * These methods return either primary or special pointers depending on platform binaries were compiled for
         * @return
         */
        public native @Cast("const Nd4jLong*") LongPointer platformShapeInfo();
        public native @Cast("const Nd4jLong*") LongPointer platformOffsets();
    }



// #endif //DEV_TESTS_TADPACK_H


// Parsed from execution/ErrorReference.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef DEV_TESTS_ERRORREFERENCE_H
// #define DEV_TESTS_ERRORREFERENCE_H

// #include <string>
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class ErrorReference extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ErrorReference(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ErrorReference(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ErrorReference position(long position) {
            return (ErrorReference)super.position(position);
        }
        @Override public ErrorReference getPointer(long i) {
            return new ErrorReference((Pointer)this).position(position + i);
        }
    
        public ErrorReference() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int errorCode();
        public native @Cast("char*") String errorMessage();

        public native void setErrorCode(int errorCode);
        public native void setErrorMessage(@StdString BytePointer message);
        public native void setErrorMessage(@StdString String message);
    }



// #endif //DEV_TESTS_ERRORREFERENCE_H


// Parsed from execution/Engine.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef SD_ENGINE_H
// #define SD_ENGINE_H
    /** enum samediff::Engine */
    public static final int
        ENGINE_CPU = 0,
        ENGINE_CUDA = 1;


// #endif //SD_ENGINE_H


// Parsed from execution/ExecutionMode.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/


//
// @author raver119@gmail.com
//

// #ifndef SD_EXECUTIONMODE_H
// #define SD_EXECUTIONMODE_H
    /** enum samediff::ExecutionMode */
    public static final int
        MODE_UNDEFINED = 0,
        MODE_TRAINING = 1,
        MODE_INFERENCE = 2;


// #endif //SD_EXECUTIONMODE_H


// Parsed from memory/MemoryType.h

//
// Created by raver119 on 07.05.19.
//

// #ifndef DEV_TESTS_MEMORYTYPE_H
// #define DEV_TESTS_MEMORYTYPE_H
        /** enum sd::memory::MemoryType */
        public static final int
            HOST = 0,
            DEVICE = 10;
    


// #endif //DEV_TESTS_MEMORYTYPE_H


// Parsed from system/Environment.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 06.10.2017.
//

// #ifndef LIBND4J_ENVIRONMENT_H
// #define LIBND4J_ENVIRONMENT_H

// #include <atomic>
// #include <vector>
// #include <system/dll.h>
// #include <stdexcept>
// #include <array/DataType.h>
// #include <types/pair.h>
// #include <system/pointercast.h>
    @Namespace("sd") @NoOffset public static class Environment extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Environment(Pointer p) { super(p); }
    
        /**
         * These 3 fields are mostly for CUDA/cuBLAS version tracking
         */
        public native int _blasMajorVersion(); public native Environment _blasMajorVersion(int setter);
        public native int _blasMinorVersion(); public native Environment _blasMinorVersion(int setter);
        public native int _blasPatchVersion(); public native Environment _blasPatchVersion(int setter);

        public static native @ByRef Environment getInstance();

        public native @Cast("bool") boolean isVerbose();
        public native void setVerbose(@Cast("bool") boolean reallyVerbose);
        public native @Cast("bool") boolean isDebug();
        public native @Cast("bool") boolean isProfiling();
        public native @Cast("bool") boolean isDetectingLeaks();
        public native @Cast("bool") boolean isDebugAndVerbose();
        public native void setDebug(@Cast("bool") boolean reallyDebug);
        public native void setProfiling(@Cast("bool") boolean reallyProfile);
        public native void setLeaksDetector(@Cast("bool") boolean reallyDetect);
        public native @Cast("bool") boolean helpersAllowed();
        public native void allowHelpers(@Cast("bool") boolean reallyAllow);

        public native @Cast("bool") boolean blasFallback();
        
        public native int tadThreshold();
        public native void setTadThreshold(int threshold);

        public native int elementwiseThreshold();
        public native void setElementwiseThreshold(int threshold);

        public native int maxThreads();
        public native void setMaxThreads(int max);

        public native int maxMasterThreads();
        public native void setMaxMasterThreads(int max);

        /*
         * Legacy memory limits API, still used in new API as simplified version
         */
        public native void setMaxPrimaryMemory(@Cast("uint64_t") long maxBytes);
        public native void setMaxSpecialyMemory(@Cast("uint64_t") long maxBytes);
        public native void setMaxDeviceMemory(@Cast("uint64_t") long maxBytes);

        public native @Cast("uint64_t") long maxPrimaryMemory();
        public native @Cast("uint64_t") long maxSpecialMemory();
        ////////////////////////

        /*
         * Methods for memory limits/counters
         */
        public native void setGroupLimit(int group, @Cast("Nd4jLong") long numBytes);
        public native void setDeviceLimit(int deviceId, @Cast("Nd4jLong") long numBytes);

        public native @Cast("Nd4jLong") long getGroupLimit(int group);
        public native @Cast("Nd4jLong") long getDeviceLimit(int deviceId);

        public native @Cast("Nd4jLong") long getGroupCounter(int group);
        public native @Cast("Nd4jLong") long getDeviceCounter(int deviceId);
        ////////////////////////

        public native @Cast("bool") boolean isUseMKLDNN();
        public native void setUseMKLDNN(@Cast("bool") boolean useMKLDNN);

        public native @Cast("sd::DataType") int defaultFloatDataType();
        public native void setDefaultFloatDataType(@Cast("sd::DataType") int dtype);

        public native @Cast("bool") boolean precisionBoostAllowed();
        public native void allowPrecisionBoost(@Cast("bool") boolean reallyAllow);

        public native @Cast("bool") boolean isExperimentalBuild();

        public native @Cast("bool") boolean isCPU();

        public native int blasMajorVersion();
        public native int blasMinorVersion();
        public native int blasPatchVersion();

        public native @StdVector Pair capabilities();
    }



// #endif //LIBND4J_ENVIRONMENT_H


// Parsed from types/utf8string.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef DEV_TESTS_UTF8STRING_H
// #define DEV_TESTS_UTF8STRING_H

// #include <string>
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class utf8string extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public utf8string(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public utf8string(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public utf8string position(long position) {
            return (utf8string)super.position(position);
        }
        @Override public utf8string getPointer(long i) {
            return new utf8string((Pointer)this).position(position + i);
        }
    
        public native @Cast("char*") BytePointer _buffer(); public native utf8string _buffer(BytePointer setter);
        public native @Cast("unsigned int") int _length(); public native utf8string _length(int setter);

        public utf8string() { super((Pointer)null); allocate(); }
        private native void allocate();

        public utf8string(@Cast("char*") String string, int length) { super((Pointer)null); allocate(string, length); }
        private native void allocate(@Cast("char*") String string, int length);
        public utf8string(@Cast("char*") BytePointer string, int length) { super((Pointer)null); allocate(string, length); }
        private native void allocate(@Cast("char*") BytePointer string, int length);
        public utf8string(@StdString BytePointer string) { super((Pointer)null); allocate(string); }
        private native void allocate(@StdString BytePointer string);
        public utf8string(@StdString String string) { super((Pointer)null); allocate(string); }
        private native void allocate(@StdString String string);
        public utf8string(@Const @ByRef utf8string other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef utf8string other);
        public native @ByRef @Name("operator =") utf8string put(@Const @ByRef utf8string other);
    }



// #endif //DEV_TESTS_UTF8STRING_H


// Parsed from legacy/NativeOps.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by agibsonccc on 2/21/16.
//

// #ifndef NATIVEOPERATIONS_NATIVEOPS_H
// #define NATIVEOPERATIONS_NATIVEOPS_H

/*
#ifndef thread_local
# if __STDC_VERSION__ >= 201112 && !defined __STDC_NO_THREADS__
#  define thread_local _Thread_local
# elif defined _WIN32 && ( \
       defined _MSC_VER || \
       defined __ICL || \
       defined __DMC__ || \
       defined __BORLANDC__ )
#  define thread_local __declspec(thread)
// note that ICC (linux) and Clang are covered by __GNUC__ 
# elif defined __GNUC__ || \
       defined __SUNPRO_C || \
       defined __xlC__
#  define thread_local __thread
# else
#  error "Cannot define thread_local"
# endif
#endif
*/

// #include <system/pointercast.h>
// #include <types/float16.h>
// #include <cnpy/cnpy.h>

//DO NOT REMOVE: THIS IS AN EDITOR SEMANTICS THING FOR CLION
//IT DEFINES THE EXPORT MACRO FOR THE EDITOR AND THEN
//RE ADDS THE DEFINITION VIA dll.h
// #ifdef  _WIN32
// #define ND4J_EXPORT __declspec(dllexport)
// #else
// #define ND4J_EXPORT
// #endif
// #include <system/dll.h>

/*
int tad_threshold = 1;
int element_threshold = 32;

bool debug = false;
bool verbose = false;
*/

// #include <array/ShapeList.h>
// #include <array/ConstantDescriptor.h>
// #include <helpers/ConstantShapeHelper.h>
// #include <array/ConstantDataBuffer.h>
// #include <array/InteropDataBuffer.h>
// #include <helpers/ConstantHelper.h>
// #include <array/TadPack.h>
// #include <graph/VariablesSet.h>
// #include <graph/GraphState.h>
// #include <graph/execution/LogicExecutor.h>
// #include <graph/ResultWrapper.h>
// #include <helpers/DebugInfo.h>
// #include <memory/MemoryCounter.h>

/**
 * This function returns last error code stored,
 * @return non-zero if something bad happened
 */
public native int lastErrorCode();

/**
 * This function returns last error message, if last error code > 0
 * @return
 */
public native @Cast("char*") String lastErrorMessage();

/**
 *
 * @param p
 * @param len
 */
public native void tryPointer(@Cast("Nd4jPointer") Pointer extra, @Cast("Nd4jPointer") Pointer p, int len);

/**
 *
 * @param num
 */
public native void setElementThreshold(int num);

/**
 *
 * @param num
 */
public native void setTADThreshold(int num);

/**
   *
   * @param opNum
   * @param x
   * @param xShapeInfo
   * @param extraParams
   */
public native void execIndexReduceScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                       Pointer extraParams,
                                       OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execIndexReduceScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                       Pointer extraParams,
                                       OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execIndexReduceScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                       int opNum,
                                       OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                       Pointer extraParams,
                                       OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 * @param result
 * @param resultShapeInfoBuffer
 * @param dimension
 * @param dimensionLength
 */
public native void execIndexReduce(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execIndexReduce(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execIndexReduce(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param y
 * @param yShapeInfo
 * @param result
 * @param resultShapeInfo
 * @param dimension
 * @param dimensionLength
 */
public native void execBroadcast(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execBroadcast(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execBroadcast(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);


public native void execBroadcastBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
        Pointer extraParams,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execBroadcastBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
        Pointer extraParams,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execBroadcastBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
        Pointer extraParams,
        OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);

/**
 *
 * @param opNum
 * @param dx
 * @param xShapeInfo
 * @param y
 * @param yShapeInfo
 * @param result
 * @param resultShapeInfo
 * @param extraParams
 * @param n
 */
public native void execPairwiseTransform(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
        Pointer extraParams);
public native void execPairwiseTransform(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
        Pointer extraParams);
public native void execPairwiseTransform(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
        Pointer extraParams);

public native void execPairwiseTransformBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
        Pointer extraParams);
public native void execPairwiseTransformBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
        Pointer extraParams);
public native void execPairwiseTransformBool(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int opNum,
        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
        OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
        Pointer extraParams);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 * @param result
 * @param resultShapeInfo
 */
public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduceFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);

public native void execReduceSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduceSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduceSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);

public native void execReduceBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduceBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduceBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);


public native void execReduceLong(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduceLong(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduceLong(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                 int opNum,
                                 OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                 Pointer extraParams,
                                 OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 * @param result
 * @param resultShapeInfo
 */
public native void execReduceFloat2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                    Pointer extraParams,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                    OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execReduceFloat2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                    Pointer extraParams,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                    OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execReduceFloat2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                    Pointer extraParams,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                    OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);


public native void execReduceSame2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execReduceSame2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execReduceSame2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);


public native void execReduceBool2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execReduceBool2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execReduceBool2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);


public native void execReduceLong2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape);
public native void execReduceLong2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape);
public native void execReduceLong2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParamsVals
 * @param y
 * @param yShapeInfo
 * @param result
 * @param resultShapeInfo
 */
public native void execReduce3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                              Pointer extraParamsVals,
                              OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
                              OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduce3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                              Pointer extraParamsVals,
                              OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
                              OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduce3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              int opNum,
                              OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                              Pointer extraParamsVals,
                              OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
                              OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParamsVals
 * @param y
 * @param yShapeInfo
 */
public native void execReduce3Scalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   Pointer extraParamsVals,
                                   OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo);
public native void execReduce3Scalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   Pointer extraParamsVals,
                                   OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo);
public native void execReduce3Scalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   Pointer extraParamsVals,
                                   OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo);
/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParamsVals
 * @param y
 * @param yShapeInfo
 * @param result
 * @param resultShapeInfoBuffer
 * @param dimension
 * @param dimensionLength
 */
public native void execReduce3Tad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape,
                                @Cast("const Nd4jLong*") LongPointer tadOnlyShapeInfo, @Cast("const Nd4jLong*") LongPointer tadOffsets,
                                @Cast("const Nd4jLong*") LongPointer yTadOnlyShapeInfo, @Cast("const Nd4jLong*") LongPointer yTadOffsets);
public native void execReduce3Tad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape,
                                @Cast("const Nd4jLong*") LongBuffer tadOnlyShapeInfo, @Cast("const Nd4jLong*") LongBuffer tadOffsets,
                                @Cast("const Nd4jLong*") LongBuffer yTadOnlyShapeInfo, @Cast("const Nd4jLong*") LongBuffer yTadOffsets);
public native void execReduce3Tad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape,
                                @Cast("const Nd4jLong*") long[] tadOnlyShapeInfo, @Cast("const Nd4jLong*") long[] tadOffsets,
                                @Cast("const Nd4jLong*") long[] yTadOnlyShapeInfo, @Cast("const Nd4jLong*") long[] yTadOffsets);


public native void execReduce3All(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape,
                                @Cast("const Nd4jLong*") LongPointer xTadShapeInfo, @Cast("const Nd4jLong*") LongPointer xOffsets,
                                @Cast("const Nd4jLong*") LongPointer yTadShapeInfo, @Cast("const Nd4jLong*") LongPointer yOffsets);
public native void execReduce3All(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape,
                                @Cast("const Nd4jLong*") LongBuffer xTadShapeInfo, @Cast("const Nd4jLong*") LongBuffer xOffsets,
                                @Cast("const Nd4jLong*") LongBuffer yTadShapeInfo, @Cast("const Nd4jLong*") LongBuffer yOffsets);
public native void execReduce3All(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                Pointer extraParamsVals,
                                OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] dYShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape,
                                @Cast("const Nd4jLong*") long[] xTadShapeInfo, @Cast("const Nd4jLong*") long[] xOffsets,
                                @Cast("const Nd4jLong*") long[] yTadShapeInfo, @Cast("const Nd4jLong*") long[] yOffsets);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param result
 * @param resultShapeInfo
 * @param scalar
 * @param extraParams
 * @param n
 */
public native void execScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                            OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") LongPointer hSscalarShapeInfo, @Cast("const Nd4jLong*") LongPointer dSscalarShapeInfo,
                            Pointer extraParams);
public native void execScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                            OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") LongBuffer hSscalarShapeInfo, @Cast("const Nd4jLong*") LongBuffer dSscalarShapeInfo,
                            Pointer extraParams);
public native void execScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                            OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") long[] hSscalarShapeInfo, @Cast("const Nd4jLong*") long[] dSscalarShapeInfo,
                            Pointer extraParams);

public native void execScalarBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") LongPointer hSscalarShapeInfo, @Cast("const Nd4jLong*") LongPointer dSscalarShapeInfo,
                                Pointer extraParams);
public native void execScalarBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") LongBuffer hSscalarShapeInfo, @Cast("const Nd4jLong*") LongBuffer dSscalarShapeInfo,
                                Pointer extraParams);
public native void execScalarBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                int opNum,
                                OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                OpaqueDataBuffer dbScalar, @Cast("const Nd4jLong*") long[] hSscalarShapeInfo, @Cast("const Nd4jLong*") long[] dSscalarShapeInfo,
                                Pointer extraParams);

/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 */
public native void execSummaryStatsScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                        Pointer extraParams,
                                        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                        @Cast("bool") boolean biasCorrected);
public native void execSummaryStatsScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                        Pointer extraParams,
                                        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                        @Cast("bool") boolean biasCorrected);
public native void execSummaryStatsScalar(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                        int opNum,
                                        OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                        Pointer extraParams,
                                        OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                        @Cast("bool") boolean biasCorrected);
/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 * @param result
 * @param resultShapeInfo
 */
public native void execSummaryStats(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo,  @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                  @Cast("bool") boolean biasCorrected);
public native void execSummaryStats(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo,  @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                  @Cast("bool") boolean biasCorrected);
public native void execSummaryStats(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo,  @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                  Pointer extraParams,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                  @Cast("bool") boolean biasCorrected);
/**
 *
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param extraParams
 * @param result
 * @param resultShapeInfoBuffer
 * @param dimension
 * @param dimensionLength
 */
public native void execSummaryStatsTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                     Pointer extraParams,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                     OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape,
                                     @Cast("bool") boolean biasCorrected,
                                     @Cast("const Nd4jLong*") LongPointer tadShapeInfo, @Cast("const Nd4jLong*") LongPointer tadOffsets);
public native void execSummaryStatsTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                     Pointer extraParams,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                     OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape,
                                     @Cast("bool") boolean biasCorrected,
                                     @Cast("const Nd4jLong*") LongBuffer tadShapeInfo, @Cast("const Nd4jLong*") LongBuffer tadOffsets);
public native void execSummaryStatsTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                     Pointer extraParams,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                     OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape,
                                     @Cast("bool") boolean biasCorrected,
                                     @Cast("const Nd4jLong*") long[] tadShapeInfo, @Cast("const Nd4jLong*") long[] tadOffsets);

/**
 *
 * @param opNum
 * @param dx
 * @param xShapeInfo
 * @param result
 * @param resultShapeInfo
 * @param extraParams
 * @param n
 */
public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                    Pointer extraParams);
public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                    Pointer extraParams);
public native void execTransformFloat(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int opNum,
                                    OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                    OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                    Pointer extraParams);

public native void execTransformSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   Pointer extraParams);
public native void execTransformSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   Pointer extraParams);
public native void execTransformSame(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   Pointer extraParams);

public native void execTransformBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   Pointer extraParams);
public native void execTransformBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   Pointer extraParams);
public native void execTransformBool(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   Pointer extraParams);

public native void execTransformAny(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                  Pointer extraParams);
public native void execTransformAny(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                  Pointer extraParams);
public native void execTransformAny(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                  int opNum,
                                  OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                  OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                  Pointer extraParams);

public native void execTransformStrict(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                     Pointer extraParams);
public native void execTransformStrict(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                     Pointer extraParams);
public native void execTransformStrict(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                     int opNum,
                                     OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                     OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                     Pointer extraParams);

/**
 *
 * @param extraPointers
 * @param opNum
 * @param x
 * @param xShapeInfo
 * @param z
 * @param zShapeInfo
 * @param scalars
 * @param extraParams
 * @param dimension
 * @param dimensionLength
 */
public native void execScalarTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                               OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                               OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") LongPointer hScalarShapeInfo, @Cast("const Nd4jLong*") LongPointer dScalarShapeInfo,
                               Pointer extraParams,
                               OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape,
                               @Cast("const Nd4jLong*") LongPointer tadShapeInfo, @Cast("const Nd4jLong*") LongPointer tadOffsets,
                               @Cast("const Nd4jLong*") LongPointer tadShapeInfoZ, @Cast("const Nd4jLong*") LongPointer tadOffsetsZ);
public native void execScalarTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                               OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                               OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") LongBuffer hScalarShapeInfo, @Cast("const Nd4jLong*") LongBuffer dScalarShapeInfo,
                               Pointer extraParams,
                               OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape,
                               @Cast("const Nd4jLong*") LongBuffer tadShapeInfo, @Cast("const Nd4jLong*") LongBuffer tadOffsets,
                               @Cast("const Nd4jLong*") LongBuffer tadShapeInfoZ, @Cast("const Nd4jLong*") LongBuffer tadOffsetsZ);
public native void execScalarTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                               OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                               OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") long[] hScalarShapeInfo, @Cast("const Nd4jLong*") long[] dScalarShapeInfo,
                               Pointer extraParams,
                               OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape,
                               @Cast("const Nd4jLong*") long[] tadShapeInfo, @Cast("const Nd4jLong*") long[] tadOffsets,
                               @Cast("const Nd4jLong*") long[] tadShapeInfoZ, @Cast("const Nd4jLong*") long[] tadOffsetsZ);

public native void execScalarBoolTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeInfo, @Cast("const Nd4jLong*") LongPointer dZShapeInfo,
                                   OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") LongPointer hScalarShapeInfo, @Cast("const Nd4jLong*") LongPointer dScalarShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongPointer hDimensionShape, @Cast("const Nd4jLong*") LongPointer dDimensionShape,
                                   @Cast("const Nd4jLong*") LongPointer tadShapeInfo, @Cast("const Nd4jLong*") LongPointer tadOffsets,
                                   @Cast("const Nd4jLong*") LongPointer tadShapeInfoZ, @Cast("const Nd4jLong*") LongPointer tadOffsetsZ);
public native void execScalarBoolTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeInfo, @Cast("const Nd4jLong*") LongBuffer dZShapeInfo,
                                   OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") LongBuffer hScalarShapeInfo, @Cast("const Nd4jLong*") LongBuffer dScalarShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") LongBuffer hDimensionShape, @Cast("const Nd4jLong*") LongBuffer dDimensionShape,
                                   @Cast("const Nd4jLong*") LongBuffer tadShapeInfo, @Cast("const Nd4jLong*") LongBuffer tadOffsets,
                                   @Cast("const Nd4jLong*") LongBuffer tadShapeInfoZ, @Cast("const Nd4jLong*") LongBuffer tadOffsetsZ);
public native void execScalarBoolTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   int opNum,
                                   OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] dXShapeInfo,
                                   OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeInfo, @Cast("const Nd4jLong*") long[] dZShapeInfo,
                                   OpaqueDataBuffer dbScalars, @Cast("const Nd4jLong*") long[] hScalarShapeInfo, @Cast("const Nd4jLong*") long[] dScalarShapeInfo,
                                   Pointer extraParams,
                                   OpaqueDataBuffer dbDimension, @Cast("const Nd4jLong*") long[] hDimensionShape, @Cast("const Nd4jLong*") long[] dDimensionShape,
                                   @Cast("const Nd4jLong*") long[] tadShapeInfo, @Cast("const Nd4jLong*") long[] tadOffsets,
                                   @Cast("const Nd4jLong*") long[] tadShapeInfoZ, @Cast("const Nd4jLong*") long[] tadOffsetsZ);

public native void specialConcat(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int dimension,
        int numArrays,
        @Cast("Nd4jPointer*") PointerPointer data,
        @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
        Pointer result,
        @Cast("const Nd4jLong*") LongPointer resultShapeInfo,
        @Cast("Nd4jPointer*") PointerPointer tadPointers,
        @Cast("Nd4jPointer*") PointerPointer offsetPointers);
public native void specialConcat(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int dimension,
        int numArrays,
        @Cast("Nd4jPointer*") PointerPointer data,
        @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
        Pointer result,
        @Cast("const Nd4jLong*") LongBuffer resultShapeInfo,
        @Cast("Nd4jPointer*") PointerPointer tadPointers,
        @Cast("Nd4jPointer*") PointerPointer offsetPointers);
public native void specialConcat(
        @Cast("Nd4jPointer*") PointerPointer extraPointers,
        int dimension,
        int numArrays,
        @Cast("Nd4jPointer*") PointerPointer data,
        @Cast("Nd4jPointer*") PointerPointer inputShapeInfo,
        Pointer result,
        @Cast("const Nd4jLong*") long[] resultShapeInfo,
        @Cast("Nd4jPointer*") PointerPointer tadPointers,
        @Cast("Nd4jPointer*") PointerPointer offsetPointers);

/**
 * This method implementation exists only for cuda.
 * The other backends should have dummy method for JNI compatibility reasons.
 */
public native void initializeDevicesAndFunctions();

public native void initializeFunctions(@Cast("Nd4jPointer*") PointerPointer functions);

/**
 * This method acquires memory chunk of requested size on host side
 *
 * @param pointer pointer that'll be used for allocation
 * @param memorySize memory size, in bytes
 * @param flags optional parameter
 */
public native @Cast("Nd4jPointer") Pointer mallocHost(@Cast("Nd4jLong") long memorySize, int flags);

/**
 * This method acquires memory chunk of requested size on specified device
 *
 * @param pointer pointer that'll be used for allocation
 * @param memorySize memory size, in bytes
 * @param ptrToDeviceId pointer to deviceId. For cuda that's just and int, for OpenCL that's pointer to device_id, etc
 * @param flags optional parameter
 */
public native @Cast("Nd4jPointer") Pointer mallocDevice(@Cast("Nd4jLong") long memorySize, int deviceId, int flags);

/**
 * This method releases previously allocated host memory space
 *
 * @param pointer pointer that'll be freed
 */
public native int freeHost(@Cast("Nd4jPointer") Pointer pointer);

/**
 * This method releases previously allocated memory space on device
 *
 * @param pointer pointer that'll be freed
 * @param ptrToDeviceId pointer to deviceId.
 */
public native int freeDevice(@Cast("Nd4jPointer") Pointer pointer, int deviceId);

/**
 *
 * @return
 */
public native int ompGetMaxThreads();

/**
 *
 * @return
 */
public native int ompGetNumThreads();

/**
 *
 * @param threads
 */
public native void setOmpNumThreads(int threads);

/**
 *
 * @param threads
 */
public native void setOmpMinThreads(int threads);


public native @Cast("bool") boolean isBlasVersionMatches(int major, int minor, int build);

/**
 *
 * @return
 */
public native @Cast("Nd4jPointer") Pointer createContext();

/**
 *
 * @return
 */
public native @Cast("Nd4jPointer") Pointer createStream();

/**
 *
 * @return
 */
public native @Cast("Nd4jPointer") Pointer createEvent();

/**
 *
 * @param event
 * @param stream
 * @return
 */
public native int registerEvent(@Cast("Nd4jPointer") Pointer event, @Cast("Nd4jPointer") Pointer stream);

/**
 *
 * @param event
 * @return
 */
public native int destroyEvent(@Cast("Nd4jPointer") Pointer event);

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native int setDevice(int deviceId);

/**
 *
 * @return
 */
public native int getDevice();

/**
 *
 * @param stream
 * @return
 */
public native int streamSynchronize(@Cast("Nd4jPointer") Pointer stream);

/**
 *
 * @param event
 * @return
 */
public native int eventSynchronize(@Cast("Nd4jPointer") Pointer event);

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native @Cast("Nd4jLong") long getDeviceFreeMemory(int deviceId);

/**
 * Returns amount of free memory for current device
 * @return
 */
public native @Cast("Nd4jLong") long getDeviceFreeMemoryDefault();

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native @Cast("Nd4jLong") long getDeviceTotalMemory(int deviceId);

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native int getDeviceMajor(int deviceId);

/**
 * This method returns amount of cached memory
 * @param deviceId
 * @return
 */
public native @Cast("Nd4jLong") long getCachedMemory(int deviceId);

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native int getDeviceMinor(int deviceId);

/**
 *
 * @param ptrToDeviceId
 * @return
 */
public native @Cast("char*") String getDeviceName(int deviceId);

/**
 *
 * @param dst
 * @param src
 * @param size
 * @param flags
 * @param reserved
 * @return
 */
public native int memcpySync(@Cast("Nd4jPointer") Pointer dst,
                           @Cast("Nd4jPointer") Pointer src,
                           @Cast("Nd4jLong") long size,
                           int flags,
                           @Cast("Nd4jPointer") Pointer reserved);

/**
 *
 * @param dst
 * @param src
 * @param size
 * @param flags
 * @param reserved
 * @return
 */
public native int memcpyAsync(@Cast("Nd4jPointer") Pointer dst,
                            @Cast("Nd4jPointer") Pointer src,
                            @Cast("Nd4jLong") long size,
                            int flags,
                            @Cast("Nd4jPointer") Pointer reserved);

/**
 *
 * @param dst
 * @param value
 * @param size
 * @param flags
 * @param reserved
 * @return
 */
public native int memsetSync(@Cast("Nd4jPointer") Pointer dst,
                           int value,
                           @Cast("Nd4jLong") long size,
                           int flags,
                           @Cast("Nd4jPointer") Pointer reserved);

/**
 *
 * @param dst
 * @param value
 * @param size
 * @param flags
 * @param reserved
 * @return
 */
public native int memsetAsync(@Cast("Nd4jPointer") Pointer dst,
                            int value,
                            @Cast("Nd4jLong") long size,
                            int flags,
                            @Cast("Nd4jPointer") Pointer reserved);

/**
 *
 * @param dst
 * @param src
 * @param size
 * @param flags
 * @param reserved
 * @return
 */
public native int memcpyConstantAsync(@Cast("Nd4jLong") long dst,
                                    @Cast("Nd4jPointer") Pointer src,
                                    @Cast("Nd4jLong") long size,
                                    int flags,
                                    @Cast("Nd4jPointer") Pointer reserved);

/**
 *
 * @return
 */
public native @Cast("Nd4jPointer") Pointer getConstantSpace();

/**
 *
 * @return
 */
public native int getAvailableDevices();

/**
 *
 * @param reallyEnable
 */
public native void enableDebugMode(@Cast("bool") boolean reallyEnable);

/**
 *
 * @param reallyEnable
 */
public native void enableVerboseMode(@Cast("bool") boolean reallyEnable);

/**
 *
 * @param gridSize
 */
public native void setGridLimit(int gridSize);

/**
 *
 * @param xShapeInfo
 * @param dimension
 * @param dimensionLength
 * @param targetBuffer
 * @param offsetsBuffer
 */
public native OpaqueTadPack tadOnlyShapeInfo(@Cast("const Nd4jLong*") LongPointer xShapeInfo,
                                            IntPointer dimension,
                                            int dimensionLength);
public native OpaqueTadPack tadOnlyShapeInfo(@Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                                            IntBuffer dimension,
                                            int dimensionLength);
public native OpaqueTadPack tadOnlyShapeInfo(@Cast("const Nd4jLong*") long[] xShapeInfo,
                                            int[] dimension,
                                            int dimensionLength);

public native @Cast("const Nd4jLong*") LongPointer getPrimaryShapeInfo(OpaqueTadPack pack);
public native @Cast("const Nd4jLong*") LongPointer getPrimaryOffsets(OpaqueTadPack pack);
public native @Cast("const Nd4jLong*") LongPointer getSpecialShapeInfo(OpaqueTadPack pack);
public native @Cast("const Nd4jLong*") LongPointer getSpecialOffsets(OpaqueTadPack pack);
public native @Cast("Nd4jLong") long getNumberOfTads(OpaqueTadPack pack);
public native int getShapeInfoLength(OpaqueTadPack pack);

public native void deleteTadPack(OpaqueTadPack ptr);

/*
 * PullRow special op
 */

/**
 *
 * @param extraPointers
 * @param x
 * @param xShapeInfo
 * @param z
 * @param zShapeInfo
 * @param n
 * @param indexes
 * @param tadShapeInfo
 * @param tadOffsets
 * @param zTadShapeInfo
 * @param zTadOffsets
 */
public native void pullRows(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer xShapeInfo, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                          OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer zShapeInfo, @Cast("const Nd4jLong*") LongPointer dzShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") LongPointer indexes,
                          @Cast("const Nd4jLong*") LongPointer tadShapeInfo,
                          @Cast("const Nd4jLong*") LongPointer tadOffsets,
                          @Cast("const Nd4jLong*") LongPointer zTadShapeInfo,
                          @Cast("const Nd4jLong*") LongPointer zTadOffsets);
public native void pullRows(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer xShapeInfo, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                          OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer zShapeInfo, @Cast("const Nd4jLong*") LongBuffer dzShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") LongBuffer indexes,
                          @Cast("const Nd4jLong*") LongBuffer tadShapeInfo,
                          @Cast("const Nd4jLong*") LongBuffer tadOffsets,
                          @Cast("const Nd4jLong*") LongBuffer zTadShapeInfo,
                          @Cast("const Nd4jLong*") LongBuffer zTadOffsets);
public native void pullRows(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                          OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] xShapeInfo, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                          OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] zShapeInfo, @Cast("const Nd4jLong*") long[] dzShapeInfo,
                          @Cast("Nd4jLong") long n,
                          @Cast("Nd4jLong*") long[] indexes,
                          @Cast("const Nd4jLong*") long[] tadShapeInfo,
                          @Cast("const Nd4jLong*") long[] tadOffsets,
                          @Cast("const Nd4jLong*") long[] zTadShapeInfo,
                          @Cast("const Nd4jLong*") long[] zTadOffsets);

/**
 *
 * @param extras
 * @param dx
 * @param dz
 * @param n
 * @param length
 * @param propagate
 */
public native void average(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                         Pointer z, @Cast("const Nd4jLong*") LongPointer zShapeInfo,
                         Pointer dz, @Cast("const Nd4jLong*") LongPointer dzShapeInfo,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);
public native void average(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                         Pointer z, @Cast("const Nd4jLong*") LongBuffer zShapeInfo,
                         Pointer dz, @Cast("const Nd4jLong*") LongBuffer dzShapeInfo,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);
public native void average(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                         Pointer z, @Cast("const Nd4jLong*") long[] zShapeInfo,
                         Pointer dz, @Cast("const Nd4jLong*") long[] dzShapeInfo,
                         int n,
                         @Cast("Nd4jLong") long length,
                         @Cast("bool") boolean propagate);


public native void accumulate(@Cast("Nd4jPointer*") PointerPointer extras,
                            @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                            @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                            Pointer z, @Cast("const Nd4jLong*") LongPointer zShapeInfo,
                            Pointer dz, @Cast("const Nd4jLong*") LongPointer dzShapeInfo,
                            int n,
                            @Cast("Nd4jLong") long length);
public native void accumulate(@Cast("Nd4jPointer*") PointerPointer extras,
                            @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                            @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                            Pointer z, @Cast("const Nd4jLong*") LongBuffer zShapeInfo,
                            Pointer dz, @Cast("const Nd4jLong*") LongBuffer dzShapeInfo,
                            int n,
                            @Cast("Nd4jLong") long length);
public native void accumulate(@Cast("Nd4jPointer*") PointerPointer extras,
                            @Cast("Nd4jPointer*") PointerPointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                            @Cast("Nd4jPointer*") PointerPointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                            Pointer z, @Cast("const Nd4jLong*") long[] zShapeInfo,
                            Pointer dz, @Cast("const Nd4jLong*") long[] dzShapeInfo,
                            int n,
                            @Cast("Nd4jLong") long length);


/**
 * P2P enabler
 */
/**
 *
 * @param enable
 */
public native void enableP2P(@Cast("bool") boolean enable);

/**
 *
 */
public native void checkP2P();

/**
 *
 * @return
 */
public native @Cast("bool") boolean isP2PAvailable();

/**
 * Shuffle methods
 */

/**
 *
 * @param extras
 * @param dx
 * @param xShapeInfo
 * @param dz
 * @param zShapeInfo
 * @param N
 * @param shuffleMap
 * @param tadShapeInfo
 * @param tadOffsets
 */
public native void shuffle(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("Nd4jPointer*") PointerPointer dxShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer z, @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz, @Cast("Nd4jPointer*") PointerPointer dzShapeInfo,
                         int N,
                         IntPointer shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);
public native void shuffle(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("Nd4jPointer*") PointerPointer dxShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer z, @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz, @Cast("Nd4jPointer*") PointerPointer dzShapeInfo,
                         int N,
                         IntBuffer shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);
public native void shuffle(@Cast("Nd4jPointer*") PointerPointer extras,
                         @Cast("Nd4jPointer*") PointerPointer x, @Cast("Nd4jPointer*") PointerPointer xShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dx, @Cast("Nd4jPointer*") PointerPointer dxShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer z, @Cast("Nd4jPointer*") PointerPointer zShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer dz, @Cast("Nd4jPointer*") PointerPointer dzShapeInfo,
                         int N,
                         int[] shuffleMap,
                         @Cast("Nd4jPointer*") PointerPointer tadShapeInfo,
                         @Cast("Nd4jPointer*") PointerPointer tadOffsets);


/**
 * Type Conversions
 */

/**
 *
 * @param extras
 * @param srcType
 * @param x
 * @param N
 * @param dstType
 * @param z
 */
public native void convertTypes(@Cast("Nd4jPointer*") PointerPointer extras, int srcType, @Cast("Nd4jPointer") Pointer x, @Cast("Nd4jLong") long N, int dstType, @Cast("Nd4jPointer") Pointer z);


/**
 *
 * @return
 */
public native @Cast("bool") boolean isExperimentalEnabled();

/**
 * Aggregate
 */

/**
 *
 * @param extraPointers
 * @param opNum
 * @param arguments
 * @param numArguments
 * @param shapeArguments
 * @param numShapeArguments
 * @param indexArguments
 * @param numIndexArguments
 * @param intArrays
 * @param numIntArrays
 * @param realArguments
 * @param numRealArguments
 */
public native void execAggregate(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("void**") PointerPointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") PointerPointer shapeArguments,
                               int numShapeArguments,
                               IntPointer indexArguments,
                               int numIndexArguments,
                               @Cast("int**") PointerPointer intArrays,
                               int numIntArrays,
                               Pointer realArguments,
                               int numRealArguments,
                               @Cast("sd::DataType") int dtype);
public native void execAggregate(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("void**") @ByPtrPtr Pointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr LongPointer shapeArguments,
                               int numShapeArguments,
                               IntPointer indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr IntPointer intArrays,
                               int numIntArrays,
                               Pointer realArguments,
                               int numRealArguments,
                               @Cast("sd::DataType") int dtype);
public native void execAggregate(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("void**") @ByPtrPtr Pointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr LongBuffer shapeArguments,
                               int numShapeArguments,
                               IntBuffer indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr IntBuffer intArrays,
                               int numIntArrays,
                               Pointer realArguments,
                               int numRealArguments,
                               @Cast("sd::DataType") int dtype);
public native void execAggregate(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int opNum,
                               @Cast("void**") @ByPtrPtr Pointer arguments,
                               int numArguments,
                               @Cast("Nd4jLong**") @ByPtrPtr long[] shapeArguments,
                               int numShapeArguments,
                               int[] indexArguments,
                               int numIndexArguments,
                               @ByPtrPtr int[] intArrays,
                               int numIntArrays,
                               Pointer realArguments,
                               int numRealArguments,
                               @Cast("sd::DataType") int dtype);


public native void batchExecutor(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               int numAggregates,
                               int opNum,
                               int maxArgs,
                               int maxShapes,
                               int maxIntArrays,
                               int maxIntArraySize,
                               int maxIdx,
                               int maxReals,
                               Pointer ptrToArguments,
                               @Cast("sd::DataType") int dtype);

public native void execAggregateBatch(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                    int numAggregates,
                                    int opNum,
                                    int maxArgs,
                                    int maxShapes,
                                    int maxIntArrays,
                                    int maxIntArraySize,
                                    int maxIdx,
                                    int maxReals,
                                    Pointer ptrToArguments,
                                    @Cast("sd::DataType") int dtype);

/**
 * Random operations
 */

/**
 *
 * @param extraPointers
 * @param opNum
 * @param state
 * @param z
 * @param zShapeBuffer
 * @param extraArguments
 */
public native void execRandom(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeBuffer, @Cast("const Nd4jLong*") LongPointer dZShapeBuffer,
                            Pointer extraArguments);
public native void execRandom(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dZShapeBuffer,
                            Pointer extraArguments);
public native void execRandom(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                            int opNum,
                            @Cast("Nd4jPointer") Pointer state,
                            OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeBuffer, @Cast("const Nd4jLong*") long[] dZShapeBuffer,
                            Pointer extraArguments);

/**
 *
 * @param extraPointers
 * @param opNum
 * @param state
 * @param x
 * @param xShapeBuffer
 * @param y
 * @param yShapeBuffer
 * @param z
 * @param zShapeBuffer
 * @param extraArguments
 */
public native void execRandom3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeBuffer, @Cast("const Nd4jLong*") LongPointer dXShapeBuffer,
                             OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongPointer hYShapeBuffer, @Cast("const Nd4jLong*") LongPointer dYShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeBuffer, @Cast("const Nd4jLong*") LongPointer dZShapeBuffer,
                             Pointer extraArguments);
public native void execRandom3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dXShapeBuffer,
                             OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") LongBuffer hYShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dYShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dZShapeBuffer,
                             Pointer extraArguments);
public native void execRandom3(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeBuffer, @Cast("const Nd4jLong*") long[] dXShapeBuffer,
                             OpaqueDataBuffer dbY, @Cast("const Nd4jLong*") long[] hYShapeBuffer, @Cast("const Nd4jLong*") long[] dYShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeBuffer, @Cast("const Nd4jLong*") long[] dZShapeBuffer,
                             Pointer extraArguments);

/**
 *
 * @param extraPointers
 * @param opNum
 * @param state
 * @param x
 * @param xShapeBuffer
 * @param z
 * @param zShapeBuffer
 * @param extraArguments
 */
public native void execRandom2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer hXShapeBuffer, @Cast("const Nd4jLong*") LongPointer dXShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongPointer hZShapeBuffer, @Cast("const Nd4jLong*") LongPointer dZShapeBuffer,
                             Pointer extraArguments);
public native void execRandom2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer hXShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dXShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") LongBuffer hZShapeBuffer, @Cast("const Nd4jLong*") LongBuffer dZShapeBuffer,
                             Pointer extraArguments);
public native void execRandom2(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             int opNum,
                             @Cast("Nd4jPointer") Pointer state,
                             OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] hXShapeBuffer, @Cast("const Nd4jLong*") long[] dXShapeBuffer,
                             OpaqueDataBuffer dbZ, @Cast("const Nd4jLong*") long[] hZShapeBuffer, @Cast("const Nd4jLong*") long[] dZShapeBuffer,
                             Pointer extraArguments);


/**
 *
 * @param extraPointers
 * @param seed
 * @param bufferSize
 * @param ptrToBuffer
 * @return
 */
public native @Cast("Nd4jPointer") Pointer initRandom(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                   long seed,
                                   long bufferSize,
                                   @Cast("Nd4jPointer") Pointer ptrToBuffer);

/**
 *
 * @param extraPointers
 * @param seed
 * @param ptrRandom
 */
public native void refreshBuffer(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                               long seed,
                               @Cast("Nd4jPointer") Pointer ptrRandom);

/**
 *
 * @param extraPointers
 * @param seed
 * @param ptrRandom
 */
public native void reSeedBuffer(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              long seed,
                              @Cast("Nd4jPointer") Pointer ptrRandom);

/**
 *
 * @param ptrRandom
 */
public native void destroyRandom(@Cast("Nd4jPointer") Pointer ptrRandom);

/**
*
* @param data
* @param shapeBuffer
* @param wordSize
* @param headerSize
* @return
*/

public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") LongPointer headerSize);
public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") LongBuffer headerSize);
public native @Cast("Nd4jPointer") Pointer numpyHeaderForNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize,@Cast("Nd4jLong*") long[] headerSize);

/**
* Load numpy from a header
* based on the cnpy parse from header method.
* @param data the header data to parse
* @return a pointer to a numpy cnpy:NpyArray struct
*/
public native @Cast("Nd4jPointer") Pointer loadNpyFromHeader(@Cast("Nd4jPointer") Pointer data);

/**
* Create a numpy array from an nd4j
* array
* @param data a pointer to the data
* @param shapeBuffer  the shapebuffer for the nd4j array
* @param wordSize  the word size (4 for float, 8 for doubles)
* @return a pointer to a numpy array
*/

public native @Cast("Nd4jPointer") Pointer numpyFromNd4j(@Cast("Nd4jPointer") Pointer data,@Cast("Nd4jPointer") Pointer shapeBuffer,@Cast("Nd4jLong") long wordSize);


/**
*
* @param npyArray
* @return
*/
public native @Cast("Nd4jPointer") Pointer shapeBufferForNumpy(@Cast("Nd4jPointer") Pointer npyArray);


/**
* Get the shape buffer from a
* numpy array.
* **Warning** this allocates memory
* @param npyArray
* @return
*/
public native @Cast("Nd4jPointer") Pointer shapeBufferForNumpyHeader(@Cast("Nd4jPointer") Pointer npyArray);



/**
*
* @param npyArray
* @return
*/
public native @Cast("Nd4jPointer") Pointer dataPointForNumpyHeader(@Cast("Nd4jPointer") Pointer npyArray);

/**
*
* @param npyArray
* @return
*/
public native @Cast("Nd4jPointer") Pointer dataPointForNumpyStruct(@Cast("Nd4jPointer") Pointer npyArrayStruct);

/**
*
* @param npyArray
* @param fromFile
* @return
*/
public native @Cast("Nd4jPointer") Pointer dataPointForNumpy(@Cast("Nd4jPointer") Pointer npyArray);

/**
* Load a numpy array from a file
* and return it as an Nd4jPointer
* @param path
* @return
*/
public native @Cast("Nd4jPointer") Pointer numpyFromFile(@StdString BytePointer path);
public native @Cast("Nd4jPointer") Pointer numpyFromFile(@StdString String path);


////// NPZ //////

public native Pointer mapFromNpzFile(@StdString BytePointer path);
public native Pointer mapFromNpzFile(@StdString String path);


public native int getNumNpyArraysInMap(Pointer map);

public native @Cast("char*") String getNpyArrayNameFromMap(Pointer map, int index,@Cast("char*") BytePointer nameBuffer);
public native @Cast("char*") BytePointer getNpyArrayNameFromMap(Pointer map, int index,@Cast("char*") String nameBuffer);

public native Pointer getNpyArrayFromMap(Pointer map, int index);

public native int dataTypeFromNpyHeader(Pointer header);

public native Pointer getNpyArrayData(Pointer npArray);

public native int getNpyArrayRank(Pointer npArray);

public native @Cast("Nd4jLong*") LongPointer getNpyArrayShape(Pointer npArray);

public native char getNpyArrayOrder(Pointer npArray);

public native int getNpyArrayElemSize(Pointer npArray);

public native void deleteNPArrayStruct(Pointer npArray);

public native void deleteNPArrayMap(Pointer map);
//////

/**
* Get the element size for a numpy array
* @param npyArray  the numpy array's address
* to get the length for
* @return
*/
public native int elementSizeForNpyArray(@Cast("Nd4jPointer") Pointer npyArray);


/**
* Get the element size for a numpy array
* @param npyArray  the numpy array's address
* to get the length for
* @return
*/
public native int elementSizeForNpyArrayHeader(@Cast("Nd4jPointer") Pointer npyArray);


public native void releaseNumpy(@Cast("Nd4jPointer") Pointer npyArray);


/**
 * Return the length of a shape buffer
 * based on the pointer
 * @param buffer  the buffer pointer to check
 * @return
 */
public native int lengthForShapeBufferPointer(@Cast("Nd4jPointer") Pointer buffer);


/**
* The pointer to get the address for
*
* @param address the address to get the pointer
* @return the pointer for the given address
*/

public native @Cast("Nd4jPointer") Pointer pointerForAddress(@Cast("Nd4jLong") long _address);

/**
 * This method takes single N-dimensional tensor, and copies its TADs to target arrays
 *
 * @param x
 * @param xShapeInfo
 * @param targets
 * @param zShapeInfo
 * @return
 */
public native void tear(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongPointer xShapeInfo, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                      @Cast("Nd4jPointer*") PointerPointer targets, @Cast("const Nd4jLong*") LongPointer zShapeInfo,
                      @Cast("const Nd4jLong*") LongPointer tadShapeInfo,
                      @Cast("const Nd4jLong*") LongPointer tadOffsets);
public native void tear(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") LongBuffer xShapeInfo, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                      @Cast("Nd4jPointer*") PointerPointer targets, @Cast("const Nd4jLong*") LongBuffer zShapeInfo,
                      @Cast("const Nd4jLong*") LongBuffer tadShapeInfo,
                      @Cast("const Nd4jLong*") LongBuffer tadOffsets);
public native void tear(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      OpaqueDataBuffer dbX, @Cast("const Nd4jLong*") long[] xShapeInfo, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                      @Cast("Nd4jPointer*") PointerPointer targets, @Cast("const Nd4jLong*") long[] zShapeInfo,
                      @Cast("const Nd4jLong*") long[] tadShapeInfo,
                      @Cast("const Nd4jLong*") long[] tadOffsets);

public native void sort(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                      Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                      @Cast("bool") boolean descending);
public native void sort(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                      Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                      @Cast("bool") boolean descending);
public native void sort(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                      Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                      Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                      @Cast("bool") boolean descending);

public native void sortByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                           Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                           Pointer y, @Cast("const Nd4jLong*") LongPointer yShapeInfo,
                           Pointer dy, @Cast("const Nd4jLong*") LongPointer dyShapeInfo,
                           @Cast("bool") boolean descending);
public native void sortByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                           Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                           Pointer y, @Cast("const Nd4jLong*") LongBuffer yShapeInfo,
                           Pointer dy, @Cast("const Nd4jLong*") LongBuffer dyShapeInfo,
                           @Cast("bool") boolean descending);
public native void sortByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                           Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                           Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                           Pointer y, @Cast("const Nd4jLong*") long[] yShapeInfo,
                           Pointer dy, @Cast("const Nd4jLong*") long[] dyShapeInfo,
                           @Cast("bool") boolean descending);

public native void sortByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                             Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                             Pointer y, @Cast("const Nd4jLong*") LongPointer yShapeInfo,
                             Pointer dy, @Cast("const Nd4jLong*") LongPointer dyShapeInfo,
                             @Cast("bool") boolean descending);
public native void sortByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                             Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                             Pointer y, @Cast("const Nd4jLong*") LongBuffer yShapeInfo,
                             Pointer dy, @Cast("const Nd4jLong*") LongBuffer dyShapeInfo,
                             @Cast("bool") boolean descending);
public native void sortByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                             Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                             Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                             Pointer y, @Cast("const Nd4jLong*") long[] yShapeInfo,
                             Pointer dy, @Cast("const Nd4jLong*") long[] dyShapeInfo,
                             @Cast("bool") boolean descending);

public native void sortTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                         Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                         Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                         IntPointer dimension,
                         int dimensionLength,
                         @Cast("const Nd4jLong*") LongPointer tadShapeInfo,
                         @Cast("const Nd4jLong*") LongPointer tadOffsets,
                         @Cast("bool") boolean descending);
public native void sortTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                         Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                         Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                         IntBuffer dimension,
                         int dimensionLength,
                         @Cast("const Nd4jLong*") LongBuffer tadShapeInfo,
                         @Cast("const Nd4jLong*") LongBuffer tadOffsets,
                         @Cast("bool") boolean descending);
public native void sortTad(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                         Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                         Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                         int[] dimension,
                         int dimensionLength,
                         @Cast("const Nd4jLong*") long[] tadShapeInfo,
                         @Cast("const Nd4jLong*") long[] tadOffsets,
                         @Cast("bool") boolean descending);

public native void sortTadByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                              Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                              Pointer y, @Cast("const Nd4jLong*") LongPointer yShapeInfo,
                              Pointer dy, @Cast("const Nd4jLong*") LongPointer dyShapeInfo,
                              IntPointer dimension,
                              int dimensionLength,
                              @Cast("bool") boolean descending);
public native void sortTadByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                              Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                              Pointer y, @Cast("const Nd4jLong*") LongBuffer yShapeInfo,
                              Pointer dy, @Cast("const Nd4jLong*") LongBuffer dyShapeInfo,
                              IntBuffer dimension,
                              int dimensionLength,
                              @Cast("bool") boolean descending);
public native void sortTadByKey(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                              Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                              Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                              Pointer y, @Cast("const Nd4jLong*") long[] yShapeInfo,
                              Pointer dy, @Cast("const Nd4jLong*") long[] dyShapeInfo,
                              int[] dimension,
                              int dimensionLength,
                              @Cast("bool") boolean descending);

public native void sortTadByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo,
                                Pointer dx, @Cast("const Nd4jLong*") LongPointer dxShapeInfo,
                                Pointer y, @Cast("const Nd4jLong*") LongPointer yShapeInfo,
                                Pointer dy, @Cast("const Nd4jLong*") LongPointer dyShapeInfo,
                                IntPointer dimension,
                                int dimensionLength,
                                @Cast("bool") boolean descending);
public native void sortTadByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo,
                                Pointer dx, @Cast("const Nd4jLong*") LongBuffer dxShapeInfo,
                                Pointer y, @Cast("const Nd4jLong*") LongBuffer yShapeInfo,
                                Pointer dy, @Cast("const Nd4jLong*") LongBuffer dyShapeInfo,
                                IntBuffer dimension,
                                int dimensionLength,
                                @Cast("bool") boolean descending);
public native void sortTadByValue(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo,
                                Pointer dx, @Cast("const Nd4jLong*") long[] dxShapeInfo,
                                Pointer y, @Cast("const Nd4jLong*") long[] yShapeInfo,
                                Pointer dy, @Cast("const Nd4jLong*") long[] dyShapeInfo,
                                int[] dimension,
                                int dimensionLength,
                                @Cast("bool") boolean descending);


// special sort impl for sorting out COO indices and values
public native void sortCooIndices(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                @Cast("Nd4jLong*") LongPointer indices,
                                Pointer x,
                                @Cast("Nd4jLong") long length,
                                @Cast("const Nd4jLong*") LongPointer xShapeInfo);
public native void sortCooIndices(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                @Cast("Nd4jLong*") LongBuffer indices,
                                Pointer x,
                                @Cast("Nd4jLong") long length,
                                @Cast("const Nd4jLong*") LongBuffer xShapeInfo);
public native void sortCooIndices(@Cast("Nd4jPointer*") PointerPointer extraPointers,
                                @Cast("Nd4jLong*") long[] indices,
                                Pointer x,
                                @Cast("Nd4jLong") long length,
                                @Cast("const Nd4jLong*") long[] xShapeInfo);

/**
 *
 * @param extraPointers     not used
 * @param indices           DataBuffer containing COO indices for a sparse matrix that is to be raveled/flattened
 * @param flatIndices       DataBuffer where the raveled/flattened indices are to be written to
 * @param length            number of non-zero entries (length of flatIndices)
 * @param fullShapeBuffer   DataBuffer with ShapeInfo for the full matrix to be flattened
 * @param mode              clipMode determines the strategy to use if some of the the passed COO indices does
 *                          not fit into the shape determined by fullShapeBuffer
 *                              0   throw an exception (default)
 *                              1   wrap around shape
 *                              2   clip to shape
 */
public native void ravelMultiIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer indices, @Cast("Nd4jLong*") LongPointer flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") LongPointer shapeInfo, int mode);
public native void ravelMultiIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer indices, @Cast("Nd4jLong*") LongBuffer flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") LongBuffer shapeInfo, int mode);
public native void ravelMultiIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] indices, @Cast("Nd4jLong*") long[] flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") long[] shapeInfo, int mode);

/**
 *
 * @param extraPointers     not used
 * @param indices           DataBuffer where the unraveled COO indices are to be written
 * @param flatIndices       DataBuffer containing the raveled/flattened indices to be unravel
 * @param length            number of non-zero entries (length of flatIndices)
 * @param fullShapeBuffer   DataBuffer with ShapeInfo for the full matrix to be unraveled
 */
public native void unravelIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer indices, @Cast("Nd4jLong*") LongPointer flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") LongPointer shapeInfo);
public native void unravelIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer indices, @Cast("Nd4jLong*") LongBuffer flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") LongBuffer shapeInfo);
public native void unravelIndex(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] indices, @Cast("Nd4jLong*") long[] flatIndices, @Cast("Nd4jLong") long length,  @Cast("Nd4jLong*") long[] shapeInfo);

public native @Cast("Nd4jLong*") LongPointer mmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") String fileName, @Cast("Nd4jLong") long length);
public native @Cast("Nd4jLong*") LongBuffer mmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") BytePointer fileName, @Cast("Nd4jLong") long length);

public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongPointer ptrMap, @Cast("Nd4jLong") long length);
public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") LongBuffer ptrMap, @Cast("Nd4jLong") long length);
public native void munmapFile(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong*") long[] ptrMap, @Cast("Nd4jLong") long length);

// flatbuffers execution
public native OpaqueResultWrapper executeFlatGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer flatBufferPointer);

public native @Cast("Nd4jLong") long getResultWrapperSize(OpaqueResultWrapper ptr);
public native @Cast("Nd4jPointer") Pointer getResultWrapperPointer(OpaqueResultWrapper ptr);

public native @Cast("char*") String getAllCustomOps();

public native @Cast("char*") String getAllOperations();

// customOp executioner
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, @Cast("bool") boolean isInplace);
public native int execCustomOp2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer") Pointer opContext);

public native OpaqueShapeList calculateOutputShapes(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs);
public native OpaqueShapeList calculateOutputShapes(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs);
public native OpaqueShapeList calculateOutputShapes(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, IntPointer dArgs, int numDArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, IntBuffer dArgs, int numDArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, int[] dArgs, int numDArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoublePointer tArgs, int numTArgs, @Cast("Nd4jLong*") LongPointer iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, IntPointer dArgs, int numDArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, DoubleBuffer tArgs, int numTArgs, @Cast("Nd4jLong*") LongBuffer iArgs, int numIArgs, @Cast("bool*") BooleanPointer bArgs, int numBArgs, IntBuffer dArgs, int numDArgs);
public native OpaqueShapeList calculateOutputShapes2(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long hash, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputShapes, double[] tArgs, int numTArgs, @Cast("Nd4jLong*") long[] iArgs, int numIArgs, @Cast("bool*") boolean[] bArgs, int numBArgs, int[] dArgs, int numDArgs);

public native @Cast("Nd4jLong") long getShapeListSize(OpaqueShapeList list);
public native @Cast("const Nd4jLong*") LongPointer getShape(OpaqueShapeList list, @Cast("Nd4jLong") long i);

public native void deleteShapeList(@Cast("Nd4jPointer") Pointer shapeList);

public native int registerGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer") Pointer flatBufferPointer);

public native OpaqueVariablesSet executeStoredGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntPointer inputIndices, int numInputs);
public native OpaqueVariablesSet executeStoredGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, IntBuffer inputIndices, int numInputs);
public native OpaqueVariablesSet executeStoredGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int[] inputIndices, int numInputs);

public native @Cast("Nd4jLong") long getVariablesSetSize(OpaqueVariablesSet set);
public native @Cast("Nd4jStatus") int getVariablesSetStatus(OpaqueVariablesSet set);
public native OpaqueVariable getVariable(OpaqueVariablesSet set, @Cast("Nd4jLong") long i);
public native int getVariableId(OpaqueVariable variable);
public native int getVariableIndex(OpaqueVariable variable);
public native @Cast("char*") String getVariableName(OpaqueVariable variable);
public native @Cast("const Nd4jLong*") LongPointer getVariableShape(OpaqueVariable variable);
public native Pointer getVariableBuffer(OpaqueVariable variable);

public native int unregisterGraph(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jLong") long graphId);

public native void deleteCharArray(@Cast("Nd4jPointer") Pointer pointer);
public native void deleteIntArray(@Cast("Nd4jPointer") Pointer pointer);
public native void deleteLongArray(@Cast("Nd4jPointer") Pointer pointer);
public native void deletePointerArray(@Cast("Nd4jPointer") Pointer pointer);

public native void deleteVariablesSet(OpaqueVariablesSet pointer);

// GraphState creation
public native @Cast("Nd4jPointer") Pointer getGraphState(@Cast("Nd4jLong") long id);

public native void deleteGraphState(@Cast("Nd4jPointer") Pointer state);

public native void deleteResultWrapper(@Cast("Nd4jPointer") Pointer ptr);

public native int estimateThreshold(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, @Cast("const Nd4jLong*") LongPointer xShapeInfo, int N, float threshold);
public native int estimateThreshold(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, @Cast("const Nd4jLong*") LongBuffer xShapeInfo, int N, float threshold);
public native int estimateThreshold(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer x, @Cast("const Nd4jLong*") long[] xShapeInfo, int N, float threshold);

// this method executes op that requires scope to be present: if/while/cond/whatever
public native @Cast("Nd4jStatus") int execCustomOpWithScope(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongPointer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
public native @Cast("Nd4jStatus") int execCustomOpWithScope(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") LongBuffer scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);
public native @Cast("Nd4jStatus") int execCustomOpWithScope(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer state, @Cast("Nd4jLong") long opHash, @Cast("Nd4jLong*") long[] scopes, int numScopes, @Cast("Nd4jPointer*") PointerPointer inputBuffers, @Cast("Nd4jPointer*") PointerPointer inputShapes, int numInputs, @Cast("Nd4jPointer*") PointerPointer outputBuffers, @Cast("Nd4jPointer*") PointerPointer outputShapes, int numOutputs);

//void fillUtf8String(Nd4jPointer *extraPointers, const char **string, int numStrings, Nd4jPointer buffer);
public native @Cast("Nd4jPointer") Pointer createUtf8String(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") String string, int length);
public native @Cast("Nd4jPointer") Pointer createUtf8String(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("char*") BytePointer string, int length);
public native @Cast("Nd4jLong") long getUtf8StringLength(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer ptr);
public native @Cast("char*") BytePointer getUtf8StringBuffer(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer ptr);
public native void deleteUtf8String(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer ptr);

public native void scatterUpdate(@Cast("Nd4jPointer*") PointerPointer extraPointers, int opCode, int numOfSubArrs,
                               Pointer hX, @Cast("const Nd4jLong*") LongPointer hXShapeInfo, @Cast("const Nd4jLong*") LongPointer hXOffsets,
                               Pointer dX, @Cast("const Nd4jLong*") LongPointer dXShapeInfo, @Cast("const Nd4jLong*") LongPointer dXOffsets,
                               Pointer hY, @Cast("const Nd4jLong*") LongPointer hYShapeInfo, @Cast("const Nd4jLong*") LongPointer hYOffsets,
                               Pointer dY, @Cast("const Nd4jLong*") LongPointer dYShapeInfo, @Cast("const Nd4jLong*") LongPointer dYOffsets,
                               Pointer hIindexes, @Cast("const Nd4jLong*") LongPointer hIndicesShapeInfo, Pointer dIindexes, @Cast("const Nd4jLong*") LongPointer dIndicesShapeInfo);
public native void scatterUpdate(@Cast("Nd4jPointer*") PointerPointer extraPointers, int opCode, int numOfSubArrs,
                               Pointer hX, @Cast("const Nd4jLong*") LongBuffer hXShapeInfo, @Cast("const Nd4jLong*") LongBuffer hXOffsets,
                               Pointer dX, @Cast("const Nd4jLong*") LongBuffer dXShapeInfo, @Cast("const Nd4jLong*") LongBuffer dXOffsets,
                               Pointer hY, @Cast("const Nd4jLong*") LongBuffer hYShapeInfo, @Cast("const Nd4jLong*") LongBuffer hYOffsets,
                               Pointer dY, @Cast("const Nd4jLong*") LongBuffer dYShapeInfo, @Cast("const Nd4jLong*") LongBuffer dYOffsets,
                               Pointer hIindexes, @Cast("const Nd4jLong*") LongBuffer hIndicesShapeInfo, Pointer dIindexes, @Cast("const Nd4jLong*") LongBuffer dIndicesShapeInfo);
public native void scatterUpdate(@Cast("Nd4jPointer*") PointerPointer extraPointers, int opCode, int numOfSubArrs,
                               Pointer hX, @Cast("const Nd4jLong*") long[] hXShapeInfo, @Cast("const Nd4jLong*") long[] hXOffsets,
                               Pointer dX, @Cast("const Nd4jLong*") long[] dXShapeInfo, @Cast("const Nd4jLong*") long[] dXOffsets,
                               Pointer hY, @Cast("const Nd4jLong*") long[] hYShapeInfo, @Cast("const Nd4jLong*") long[] hYOffsets,
                               Pointer dY, @Cast("const Nd4jLong*") long[] dYShapeInfo, @Cast("const Nd4jLong*") long[] dYOffsets,
                               Pointer hIindexes, @Cast("const Nd4jLong*") long[] hIndicesShapeInfo, Pointer dIindexes, @Cast("const Nd4jLong*") long[] dIndicesShapeInfo);

public native void inspectArray(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jPointer") Pointer specialBuffer, @Cast("Nd4jLong*") LongPointer specialShapeInfo, @Cast("Nd4jPointer") Pointer debugInfo);
public native void inspectArray(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jPointer") Pointer specialBuffer, @Cast("Nd4jLong*") LongBuffer specialShapeInfo, @Cast("Nd4jPointer") Pointer debugInfo);
public native void inspectArray(@Cast("Nd4jPointer*") PointerPointer extraPointers, @Cast("Nd4jPointer") Pointer buffer, @Cast("Nd4jLong*") long[] shapeInfo, @Cast("Nd4jPointer") Pointer specialBuffer, @Cast("Nd4jLong*") long[] specialShapeInfo, @Cast("Nd4jPointer") Pointer debugInfo);

public native OpaqueConstantShapeBuffer shapeBuffer(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("bool") boolean empty);
public native OpaqueConstantShapeBuffer shapeBuffer(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("bool") boolean empty);
public native OpaqueConstantShapeBuffer shapeBuffer(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("bool") boolean empty);
public native OpaqueConstantShapeBuffer shapeBufferEx(int rank, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);
public native OpaqueConstantShapeBuffer shapeBufferEx(int rank, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);
public native OpaqueConstantShapeBuffer shapeBufferEx(int rank, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] strides, @Cast("sd::DataType") int dtype, char order, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);

public native OpaqueConstantDataBuffer constantBufferLong(@Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongPointer data, int length);
public native OpaqueConstantDataBuffer constantBufferLong(@Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongBuffer data, int length);
public native OpaqueConstantDataBuffer constantBufferLong(@Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") long[] data, int length);
public native OpaqueConstantDataBuffer constantBufferDouble(@Cast("sd::DataType") int dtype, DoublePointer data, int length);
public native OpaqueConstantDataBuffer constantBufferDouble(@Cast("sd::DataType") int dtype, DoubleBuffer data, int length);
public native OpaqueConstantDataBuffer constantBufferDouble(@Cast("sd::DataType") int dtype, double[] data, int length);
public native OpaqueConstantDataBuffer constantBuffer(@Cast("sd::DataType") int dtype, ConstantDescriptor descriptor);

public native @Cast("Nd4jPointer") Pointer getConstantDataBufferPrimary(OpaqueConstantDataBuffer dbf);
public native @Cast("Nd4jPointer") Pointer getConstantDataBufferSpecial(OpaqueConstantDataBuffer dbf);
public native @Cast("Nd4jLong") long getConstantDataBufferLength(OpaqueConstantDataBuffer dbf);

public native @Cast("Nd4jPointer") Pointer getConstantShapeBufferPrimary(OpaqueConstantShapeBuffer dbf);
public native @Cast("Nd4jPointer") Pointer getConstantShapeBufferSpecial(OpaqueConstantShapeBuffer dbf);

public native void deleteConstantShapeBuffer(OpaqueConstantShapeBuffer ptr);
public native void deleteConstantDataBuffer(OpaqueConstantDataBuffer ptr);

public native OpaqueContext createGraphContext(int nodeId);
public native OpaqueRandomGenerator getGraphContextRandomGenerator(OpaqueContext ptr);
public native void ctxAllowHelpers(OpaqueContext ptr, @Cast("bool") boolean reallyAllow);
public native void ctxShapeFunctionOverride(OpaqueContext ptr, @Cast("bool") boolean reallyOverride);
public native void ctxSetExecutionMode(OpaqueContext ptr, int execMode);
public native void ctxPurge(OpaqueContext ptr);
public native void markGraphContextInplace(OpaqueContext ptr, @Cast("bool") boolean reallyInplace);
public native void setGraphContextCudaContext(OpaqueContext ptr, Pointer stream, Pointer reductionPointer, Pointer allocationPointer);
public native void setGraphContextInputArray(OpaqueContext ptr, int index, Pointer buffer, Pointer shapeInfo, Pointer specialBuffer, Pointer specialShapeInfo);
public native void setGraphContextOutputArray(OpaqueContext ptr, int index, Pointer buffer, Pointer shapeInfo, Pointer specialBuffer, Pointer specialShapeInfo);
public native void setGraphContextInputBuffer(OpaqueContext ptr, int index, OpaqueDataBuffer buffer, Pointer shapeInfo, Pointer specialShapeInfo);
public native void setGraphContextOutputBuffer(OpaqueContext ptr, int index, OpaqueDataBuffer buffer, Pointer shapeInfo, Pointer specialShapeInfo);
public native void setGraphContextDArguments(OpaqueContext ptr, IntPointer arguments, int numberOfArguments);
public native void setGraphContextDArguments(OpaqueContext ptr, IntBuffer arguments, int numberOfArguments);
public native void setGraphContextDArguments(OpaqueContext ptr, int[] arguments, int numberOfArguments);
public native void setGraphContextTArguments(OpaqueContext ptr, DoublePointer arguments, int numberOfArguments);
public native void setGraphContextTArguments(OpaqueContext ptr, DoubleBuffer arguments, int numberOfArguments);
public native void setGraphContextTArguments(OpaqueContext ptr, double[] arguments, int numberOfArguments);
public native void setGraphContextIArguments(OpaqueContext ptr, @Cast("Nd4jLong*") LongPointer arguments, int numberOfArguments);
public native void setGraphContextIArguments(OpaqueContext ptr, @Cast("Nd4jLong*") LongBuffer arguments, int numberOfArguments);
public native void setGraphContextIArguments(OpaqueContext ptr, @Cast("Nd4jLong*") long[] arguments, int numberOfArguments);
public native void setGraphContextBArguments(OpaqueContext ptr, @Cast("bool*") BooleanPointer arguments, int numberOfArguments);
public native void setGraphContextBArguments(OpaqueContext ptr, @Cast("bool*") boolean[] arguments, int numberOfArguments);
public native void deleteGraphContext(OpaqueContext ptr);

public native OpaqueRandomGenerator createRandomGenerator(@Cast("Nd4jLong") long rootSeed/*=0*/, @Cast("Nd4jLong") long nodeSeed/*=0*/);
public native OpaqueRandomGenerator createRandomGenerator();
public native @Cast("Nd4jLong") long getRandomGeneratorRootState(OpaqueRandomGenerator ptr);
public native @Cast("Nd4jLong") long getRandomGeneratorNodeState(OpaqueRandomGenerator ptr);
public native void setRandomGeneratorStates(OpaqueRandomGenerator ptr, @Cast("Nd4jLong") long rootSeed/*=0*/, @Cast("Nd4jLong") long nodeSeed/*=0*/);
public native void setRandomGeneratorStates(OpaqueRandomGenerator ptr);
public native float getRandomGeneratorRelativeFloat(OpaqueRandomGenerator ptr, @Cast("Nd4jLong") long index);
public native double getRandomGeneratorRelativeDouble(OpaqueRandomGenerator ptr, @Cast("Nd4jLong") long index);
public native int getRandomGeneratorRelativeInt(OpaqueRandomGenerator ptr, @Cast("Nd4jLong") long index);
public native @Cast("Nd4jLong") long getRandomGeneratorRelativeLong(OpaqueRandomGenerator ptr, @Cast("Nd4jLong") long index);
public native void deleteRandomGenerator(OpaqueRandomGenerator ptr);

public native OpaqueLaunchContext defaultLaunchContext();
public native @Cast("Nd4jPointer") Pointer lcScalarPointer(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcReductionPointer(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcAllocationPointer(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcExecutionStream(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcCopyStream(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcBlasHandle(OpaqueLaunchContext lc);
public native @Cast("Nd4jPointer") Pointer lcSolverHandle(OpaqueLaunchContext lc);

public native OpaqueDataBuffer allocateDataBuffer(@Cast("Nd4jLong") long elements, int dataType, @Cast("bool") boolean allocateBoth);
public native OpaqueDataBuffer dbAllocateDataBuffer(@Cast("Nd4jLong") long elements, int dataType, @Cast("bool") boolean allocateBoth);
public native OpaqueDataBuffer dbCreateExternalDataBuffer(@Cast("Nd4jLong") long elements, int dataType, @Cast("Nd4jPointer") Pointer primary, @Cast("Nd4jPointer") Pointer special);
public native OpaqueDataBuffer dbCreateView(OpaqueDataBuffer dataBuffer, @Cast("Nd4jLong") long length, @Cast("Nd4jLong") long offset);
public native @Cast("Nd4jPointer") Pointer dbPrimaryBuffer(OpaqueDataBuffer dataBuffer);
public native @Cast("Nd4jPointer") Pointer dbSpecialBuffer(OpaqueDataBuffer dataBuffer);
public native void dbExpandBuffer(OpaqueDataBuffer dataBuffer, @Cast("Nd4jLong") long elements);
public native void dbAllocatePrimaryBuffer(OpaqueDataBuffer dataBuffer);
public native void dbAllocateSpecialBuffer(OpaqueDataBuffer dataBuffer);
public native void dbSetPrimaryBuffer(OpaqueDataBuffer dataBuffer, @Cast("Nd4jPointer") Pointer primaryBuffer, @Cast("Nd4jLong") long numBytes);
public native void dbSetSpecialBuffer(OpaqueDataBuffer dataBuffer, @Cast("Nd4jPointer") Pointer specialBuffer, @Cast("Nd4jLong") long numBytes);
public native void dbSyncToSpecial(OpaqueDataBuffer dataBuffer);
public native void dbSyncToPrimary(OpaqueDataBuffer dataBuffer);
public native int dbLocality(OpaqueDataBuffer dataBuffer);
public native int dbDeviceId(OpaqueDataBuffer dataBuffer);
public native void dbSetDeviceId(OpaqueDataBuffer dataBuffer, int deviceId);
public native void dbTickHostRead(OpaqueDataBuffer dataBuffer);
public native void dbTickHostWrite(OpaqueDataBuffer dataBuffer);
public native void dbTickDeviceRead(OpaqueDataBuffer dataBuffer);
public native void dbTickDeviceWrite(OpaqueDataBuffer dataBuffer);
public native void dbClose(OpaqueDataBuffer dataBuffer);
public native void deleteDataBuffer(OpaqueDataBuffer dataBuffer);
public native void dbExpand(OpaqueDataBuffer dataBuffer, @Cast("Nd4jLong") long elements);


public native int binaryLevel();
public native int optimalLevel();

public native @Cast("bool") boolean isMinimalRequirementsMet();
public native @Cast("bool") boolean isOptimalRequirementsMet();

// #endif //NATIVEOPERATIONS_NATIVEOPS_H


// Parsed from memory/ExternalWorkspace.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef LIBND4J_EXTERNALWORKSPACE_H
// #define LIBND4J_EXTERNALWORKSPACE_H

// #include <system/pointercast.h>
// #include <system/dll.h>
        @Namespace("sd::memory") @NoOffset public static class ExternalWorkspace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public ExternalWorkspace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public ExternalWorkspace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public ExternalWorkspace position(long position) {
                return (ExternalWorkspace)super.position(position);
            }
            @Override public ExternalWorkspace getPointer(long i) {
                return new ExternalWorkspace((Pointer)this).position(position + i);
            }
        
            public ExternalWorkspace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public ExternalWorkspace(@Cast("Nd4jPointer") Pointer ptrH, @Cast("Nd4jLong") long sizeH, @Cast("Nd4jPointer") Pointer ptrD, @Cast("Nd4jLong") long sizeD) { super((Pointer)null); allocate(ptrH, sizeH, ptrD, sizeD); }
            private native void allocate(@Cast("Nd4jPointer") Pointer ptrH, @Cast("Nd4jLong") long sizeH, @Cast("Nd4jPointer") Pointer ptrD, @Cast("Nd4jLong") long sizeD);
            
            public native Pointer pointerHost();
            public native Pointer pointerDevice();

            public native @Cast("Nd4jLong") long sizeHost();
            public native @Cast("Nd4jLong") long sizeDevice();
        }
    


// #endif

// Parsed from memory/Workspace.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class implements Workspace functionality in c++
//
//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_WORKSPACE_H
// #define LIBND4J_WORKSPACE_H

// #include <atomic>
// #include <vector>
// #include <mutex>
// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <types/float16.h>
// #include <memory/ExternalWorkspace.h>
// #include <memory/MemoryType.h>

        @Namespace("sd::memory") @NoOffset public static class Workspace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Workspace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public Workspace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public Workspace position(long position) {
                return (Workspace)super.position(position);
            }
            @Override public Workspace getPointer(long i) {
                return new Workspace((Pointer)this).position(position + i);
            }
        
            public Workspace(ExternalWorkspace external) { super((Pointer)null); allocate(external); }
            private native void allocate(ExternalWorkspace external);
            public Workspace(@Cast("Nd4jLong") long initialSize/*=0L*/, @Cast("Nd4jLong") long secondaryBytes/*=0L*/) { super((Pointer)null); allocate(initialSize, secondaryBytes); }
            private native void allocate(@Cast("Nd4jLong") long initialSize/*=0L*/, @Cast("Nd4jLong") long secondaryBytes/*=0L*/);
            public Workspace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jLong") long getAllocatedSize();
            public native @Cast("Nd4jLong") long getCurrentSize();
            public native @Cast("Nd4jLong") long getCurrentOffset();
            public native @Cast("Nd4jLong") long getSpilledSize();
            public native @Cast("Nd4jLong") long getUsedSize();

            public native @Cast("Nd4jLong") long getAllocatedSecondarySize();
            public native @Cast("Nd4jLong") long getCurrentSecondarySize();
            public native @Cast("Nd4jLong") long getCurrentSecondaryOffset();
            public native @Cast("Nd4jLong") long getSpilledSecondarySize();
            public native @Cast("Nd4jLong") long getUsedSecondarySize();

            public native void expandBy(@Cast("Nd4jLong") long primaryBytes, @Cast("Nd4jLong") long secondaryBytes/*=0L*/);
            public native void expandBy(@Cast("Nd4jLong") long primaryBytes);
            public native void expandTo(@Cast("Nd4jLong") long primaryBytes, @Cast("Nd4jLong") long secondaryBytes/*=0L*/);
            public native void expandTo(@Cast("Nd4jLong") long primaryBytes);

//            bool resizeSupported();

            public native Pointer allocateBytes(@Cast("Nd4jLong") long numBytes);
            public native Pointer allocateBytes(@Cast("sd::memory::MemoryType") int type, @Cast("Nd4jLong") long numBytes);

            public native void scopeIn();
            public native void scopeOut();

            /*
             * This method creates NEW workspace of the same memory size and returns pointer to it
             */
            public native Workspace clone();
        }
    


// #endif //LIBND4J_WORKSPACE_H


// Parsed from indexing/NDIndex.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_NDINDEX_H
// #define LIBND4J_NDINDEX_H

// #include <system/pointercast.h>
// #include <vector>
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class NDIndex extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndex(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public NDIndex(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public NDIndex position(long position) {
            return (NDIndex)super.position(position);
        }
        @Override public NDIndex getPointer(long i) {
            return new NDIndex((Pointer)this).position(position + i);
        }
    
        public NDIndex() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native @Cast("bool") boolean isAll();
        public native @Cast("bool") boolean isPoint();
        public native @Cast("bool") boolean isInterval();

        public native @Cast("Nd4jLong*") @StdVector LongPointer getIndices();
        public native @Cast("Nd4jLong") long stride();

        public native NDIndex all();
        public native NDIndex point(@Cast("Nd4jLong") long pt);
        public native NDIndex interval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/);
        public native NDIndex interval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end);
    }

    @Namespace("sd") public static class NDIndexAll extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexAll(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public NDIndexAll(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public NDIndexAll position(long position) {
            return (NDIndexAll)super.position(position);
        }
        @Override public NDIndexAll getPointer(long i) {
            return new NDIndexAll((Pointer)this).position(position + i);
        }
    
        public NDIndexAll() { super((Pointer)null); allocate(); }
        private native void allocate();
        public native @Cast("bool") boolean isInterval();
    }


    @Namespace("sd") public static class NDIndexPoint extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexPoint(Pointer p) { super(p); }
    
        public NDIndexPoint(@Cast("Nd4jLong") long point) { super((Pointer)null); allocate(point); }
        private native void allocate(@Cast("Nd4jLong") long point);
        public native @Cast("bool") boolean isInterval();
    }

    @Namespace("sd") public static class NDIndexInterval extends NDIndex {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDIndexInterval(Pointer p) { super(p); }
    
        public NDIndexInterval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/) { super((Pointer)null); allocate(start, end, stride); }
        private native void allocate(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end, @Cast("Nd4jLong") long stride/*=1*/);
        public NDIndexInterval(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end) { super((Pointer)null); allocate(start, end); }
        private native void allocate(@Cast("Nd4jLong") long start, @Cast("Nd4jLong") long end);
        public native @Cast("bool") boolean isInterval();
    }




// #endif //LIBND4J_NDINDEX_H


// Parsed from indexing/IndicesList.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_INDICESLIST_H
// #define LIBND4J_INDICESLIST_H

// #include <initializer_list>
// #include "NDIndex.h"
    @Namespace("sd") @NoOffset public static class IndicesList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public IndicesList(Pointer p) { super(p); }
    

        public native int size();
        public native NDIndex at(int idx);
        public native void push_back(NDIndex idx);
        public native @Cast("bool") boolean isScalar();
    }

// #endif //LIBND4J_INDICESLIST_H


// Parsed from graph/VariableType.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_VARIABLE_TYPE_H
// #define ND4J_VARIABLE_TYPE_H
        /** enum sd::graph::VariableType */
        public static final int
            NDARRAY = 0,
            ARRAY_LIST = 1,
            FLOW = 2,
            CONSTANT = 3,
            PLACEHOLDER = 4;
    


// #endif

// Parsed from graph/ArgumentsList.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 24.01.18.
//

// #ifndef LIBND4J_INPUTLIST_H
// #define LIBND4J_INPUTLIST_H

// #include <system/op_boilerplate.h>
// #include <system/pointercast.h>
// #include <system/dll.h>
// #include <vector>
// #include <types/pair.h>
    @Namespace("sd::graph") @NoOffset public static class ArgumentsList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ArgumentsList(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ArgumentsList(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ArgumentsList position(long position) {
            return (ArgumentsList)super.position(position);
        }
        @Override public ArgumentsList getPointer(long i) {
            return new ArgumentsList((Pointer)this).position(position + i);
        }
    
        public ArgumentsList() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
         * This method returns number of argument pairs available
         *
         * @return
         */
        public native int size();

        /**
         * This method returns Pair at specified index
         *
         * @param index
         * @return
         */
        public native @ByRef Pair at(int index);
    }



// #endif //LIBND4J_INPUTLIST_H


// Parsed from types/pair.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 24.01.18.
//

// #ifndef LIBND4J_PAIR_H
// #define LIBND4J_PAIR_H

// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class Pair extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Pair(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Pair(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Pair position(long position) {
            return (Pair)super.position(position);
        }
        @Override public Pair getPointer(long i) {
            return new Pair((Pointer)this).position(position + i);
        }
    
        public Pair(int first/*=0*/, int second/*=0*/) { super((Pointer)null); allocate(first, second); }
        private native void allocate(int first/*=0*/, int second/*=0*/);
        public Pair() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int first();
        public native int second();
    }



// #endif //LIBND4J_PAIR_H


// Parsed from array/NDArray.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

// #ifndef NDARRAY_H
// #define NDARRAY_H

// #include <system/dll.h>
// #include <initializer_list>
// #include <functional>
// #include <helpers/shape.h>
// #include "legacy/NativeOpExecutioner.h"
// #include <indexing/NDIndex.h>
// #include <indexing/IndicesList.h>
// #include <graph/Intervals.h>
// #include <array/DataType.h>
// #include <array/DataTypeUtils.h>
// #include <stdint.h>
// #include <array/ArrayOptions.h>
// #include <array/ArrayType.h>
// #include <array/ResultSet.h>
// #include <helpers/ShapeBuilders.h>
// #include <system/op_enums.h>
// #include <ops/BroadcastOpsTuple.h>
// #include <ops/BroadcastBoolOpsTuple.h>
// #include <ops/BroadcastIntOpsTuple.h>
// #include <array/ExtraArguments.h>
// #include <graph/Status.h>
// #include <array/ShapeDescriptor.h>
// #include <helpers/ConstantShapeHelper.h>
// #include <array/DataBuffer.h>
// #include <execution/AffinityManager.h>
// #include <memory>
// #include <array/InteropDataBuffer.h>
// #include <memory/MemoryCounter.h>
// #include <array/ConstantShapeBuffer.h>




    @Namespace("sd") public native @ByVal NDArray mmul(@Const @ByRef NDArray arg0, @Const @ByRef NDArray arg1);

    @Namespace("sd") @NoOffset public static class NDArray extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDArray(Pointer p) { super(p); }
    
        public NDArray() { super((Pointer)null); allocate(); }
        private native void allocate();

        /**
        *  do not allocate memory, memory for array is passed from outside
        */
// #ifndef __JAVACPP_HACK__

// #endif

        /**
        *  do not allocate memory, memory for array is passed from outside
        */
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, shapeInfo, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(buffer, shapeInfo); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") LongPointer shapeInfo);
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, shapeInfo, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(buffer, shapeInfo); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") LongBuffer shapeInfo);
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") long[] shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, shapeInfo, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") long[] shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, @Cast("Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(buffer, shapeInfo); }
        private native void allocate(Pointer buffer, @Cast("Nd4jLong*") long[] shapeInfo);

        /**
        *  do not allocate memory, memory for array is passed from outside
        *  we suppose the content of both (device and host) buffers is identical
        */
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongPointer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo, context, isBuffAlloc, isBuffDAlloc); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongPointer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/);
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongPointer shapeInfo);
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongBuffer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo, context, isBuffAlloc, isBuffDAlloc); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongBuffer shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/);
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") LongBuffer shapeInfo);
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") long[] shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo, context, isBuffAlloc, isBuffDAlloc); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") long[] shapeInfo, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isBuffAlloc/*=false*/, @Cast("bool") boolean isBuffDAlloc/*=false*/);
        public NDArray(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(buffer, bufferD, shapeInfo); }
        private native void allocate(Pointer buffer, Pointer bufferD, @Cast("const Nd4jLong*") long[] shapeInfo);

        /**
        *  copy constructor
        */
        public NDArray(@Const @ByRef NDArray other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef NDArray other);

        /**
        *  move constructor
        */

        /**
        *  constructor, create array stored at given workspace
        */
        public NDArray(LaunchContext context) { super((Pointer)null); allocate(context); }
        private native void allocate(LaunchContext context);


        /**
		*  constructor creates new NDArray using shape information from "shapeInfo", set all elements in new array to zeros, if copyStrides is true then use stride values from "shapeInfo", else calculate strides independently
        */
		public NDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, context, nullify); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
		public NDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo);
		public NDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, context, nullify); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
		public NDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
		public NDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, copyStrides, context, nullify); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
		public NDArray(@Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
		private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo);

        /**
        *  constructor creates new NDArray using shape information from "shapeInfo", set all elements in new array to be zeros, if copyStrides is true then use stride values from "shapeInfo", else calculate strides independently
        *  set dtype as array type
        */
        public NDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, dtype, copyStrides, context, nullify); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
        public NDArray(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(shapeInfo, dtype); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("sd::DataType") int dtype);
        public NDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, dtype, copyStrides, context, nullify); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
        public NDArray(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(shapeInfo, dtype); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("sd::DataType") int dtype);
        public NDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/) { super((Pointer)null); allocate(shapeInfo, dtype, copyStrides, context, nullify); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("sd::DataType") int dtype, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean nullify/*=true*/);
        public NDArray(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(shapeInfo, dtype); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("sd::DataType") int dtype);

        /**
        *  this constructor creates new array using shape information contained in vector argument
        */
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(order, shape); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        * This constructor creates new array with elements copied from data and using shape information stored in shape, elements from data will be casted to dtype
        */
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, data, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @StdVector DoublePointer data);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, data, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @StdVector DoubleBuffer data);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(order, shape, data, dtype, context); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data, @Cast("sd::DataType") int dtype/*=sd::DOUBLE*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);
        public NDArray(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data) { super((Pointer)null); allocate(order, shape, data); }
        private native void allocate(char order, @Cast("Nd4jLong*") @StdVector long[] shape, @StdVector double[] data);

        /**
        *  this constructor creates new array using given buffer (without memory allocation) and shape information stored in shape
        */
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, order, shape, dtype, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape,  @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(buffer, order, shape, dtype); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongPointer shape,  @Cast("sd::DataType") int dtype);
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, order, shape, dtype, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape,  @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(buffer, order, shape, dtype); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector LongBuffer shape,  @Cast("sd::DataType") int dtype);
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/) { super((Pointer)null); allocate(buffer, order, shape, dtype, context, isBuffAlloc); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape,  @Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("const bool") boolean isBuffAlloc/*=false*/);
        public NDArray(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape,  @Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(buffer, order, shape, dtype); }
        private native void allocate(Pointer buffer, char order, @Cast("Nd4jLong*") @StdVector long[] shape,  @Cast("sd::DataType") int dtype);

        /**
        * This method returns new array with the same shape & data type
        * @return
        */
        public native @ByVal NDArray like();

        /**
         * This method returns new uninitialized array with the same shape & data type
         * @return
         */
        public native @ByVal NDArray ulike();


        /**
        *  this constructor creates new NDArray with shape matching "other" array,
        *  doesn't copy "other" elements into new array !!!
        */
        public NDArray(@Const NDArray other, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/) { super((Pointer)null); allocate(other, copyStrides, context); }
        private native void allocate(@Const NDArray other, @Cast("bool") boolean copyStrides/*=false*/, LaunchContext context/*=sd::LaunchContext::defaultContext()*/);

        /**
        *  this constructor creates scalar(and set its value = 0) or empty array depending on bool argument isScalar
        */
        public NDArray(@Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isScalar/*=true*/) { super((Pointer)null); allocate(dtype, context, isScalar); }
        private native void allocate(@Cast("sd::DataType") int dtype, LaunchContext context/*=sd::LaunchContext::defaultContext()*/, @Cast("bool") boolean isScalar/*=true*/);
        public NDArray(@Cast("sd::DataType") int dtype) { super((Pointer)null); allocate(dtype); }
        private native void allocate(@Cast("sd::DataType") int dtype);

        /**
         * This method blocks until asynchronous operation finishes
         */
        public native void synchronize(@Cast("char*") String msg);
        public native void synchronize(@Cast("char*") BytePointer msg);

        /**
         * This method allows to set _isAttached flag
         * @param reallyAttached
         */
        public native void setAttached(@Cast("bool") boolean reallyAttached);

        public native void tickWriteHost();
        public native void tickWriteDevice();
        public native void tickReadHost();
        public native void tickReadDevice();
        public native void tickBothActual();
        public native @Cast("bool") boolean isActualOnHostSide();
        public native @Cast("bool") boolean isActualOnDeviceSide();
        public native void makeBothBuffersActual();

        public native void syncToHost();
        public native void syncToDevice();
        public native void syncShape();

        /**
         * This method can be used on architectures that use special buffers
         * @param writeList
         * @param readList
         */
        public native void registerSpecialUse(@Const @ByRef ConstNDArrayVector writeList, @Const @ByRef(nullValue = "std::vector<const sd::NDArray*>({})") ConstNDArrayVector readList);
        public native void registerSpecialUse(@Const @ByRef ConstNDArrayVector writeList);
        public native void prepareSpecialUse(@Const @ByRef ConstNDArrayVector writeList, @Const @ByRef(nullValue = "std::vector<const sd::NDArray*>({})") ConstNDArrayVector readList, @Cast("bool") boolean synchronizeWritables/*=false*/);
        public native void prepareSpecialUse(@Const @ByRef ConstNDArrayVector writeList);

        public native void registerPrimaryUse(@Const @ByRef ConstNDArrayVector writeList, @Const @ByRef(nullValue = "std::vector<const sd::NDArray*>({})") ConstNDArrayVector readList);
        public native void registerPrimaryUse(@Const @ByRef ConstNDArrayVector writeList);
        public native void preparePrimaryUse(@Const @ByRef ConstNDArrayVector writeList, @Const @ByRef(nullValue = "std::vector<const sd::NDArray*>({})") ConstNDArrayVector readList, @Cast("bool") boolean synchronizeWritables/*=false*/);
        public native void preparePrimaryUse(@Const @ByRef ConstNDArrayVector writeList);

        /**
         * This method returns buffer pointer offset by given number of elements, wrt own data type
         * @param offset
         * @return
         */
        public native Pointer bufferWithOffset(@Cast("Nd4jLong") long offset);
        public native Pointer specialBufferWithOffset(@Cast("Nd4jLong") long offset);
        /**
        *  copy assignment operator
        *  in particular, when _dataType != other._dataType and both shapes are the same, there will be allocation of new _buffer and _dataType acquires other._dataType
        */
        public native @ByRef @Name("operator =") NDArray put(@Const @ByRef NDArray other);

        /**
        *  move assignment operator
        */

        /**
        *  assignment operator, assigns the same scalar to all array elements
        */


        /**
        *   operators for memory allocation and deletion
        */
        public native @Name("operator new") Pointer _new(@Cast("size_t") long i);
        public native @Name("operator delete") void _delete(Pointer p);


        public native void setContext(LaunchContext context);

        /**
        *  create a new array by replicating current array by repeats times along given dimension
        *  axis - axis along which to repeat elements
        *  repeats - number of repetitions
        */
        public native @ByVal NDArray repeat(int axis, @StdVector IntPointer repeats);
        public native @ByVal NDArray repeat(int axis, @StdVector IntBuffer repeats);
        public native @ByVal NDArray repeat(int axis, @StdVector int[] repeats);

        /**
         * This method fills this array with zeros
         */
        public native void nullify();

        /**
         * This method returns quantized copy of given array
         *
         * @param array
         * @return
         */
        public native @ByVal NDArray quantize(@Const @ByRef NDArray array);

        /**
        *  fill target array by repeating current array
        *  axis - axis along which to repeat elements
        *  repeats - vector containing numbers of repetition for elements at given axis
        */
        public native void repeat(int axis, @StdVector IntPointer repeats, @ByRef NDArray target);
        public native void repeat(int axis, @StdVector IntBuffer repeats, @ByRef NDArray target);
        public native void repeat(int axis, @StdVector int[] repeats, @ByRef NDArray target);

        /**
        *  creates array which points on certain sub-range of this array, sub-range is defined by given indices
        */
        
        
        

        /**
        *  cast array elements to given dtype
        */
        public native @ByVal NDArray cast(@Cast("sd::DataType") int dtype);

        public native void cast(@ByRef NDArray target, @Cast("sd::DataType") int dtype);

        /**
        *   returns _context
        */
        public native LaunchContext getContext();

// #ifndef __JAVACPP_HACK__
// #endif

        /**
        *   returns host buffer
        */
        public native Pointer buffer();


        /**
        *   returns buffer offset (offset is the same for host and device buffers)
        */
        public native @Cast("Nd4jLong") long bufferOffset();

        /**
         *  checks if array has padded buffer
         */
        public native @Cast("bool") boolean hasPaddedBuffer();

        /**
        *  if _bufferD==nullptr return _buffer, else return _bufferD
        */
        public native Pointer specialBuffer();

        /**
        *   returns device buffer if compilation is for cuda case, otherwise returns host buffer
        */
        public native Pointer platformBuffer();

        /**
        *   returns _shapeInfo
        */
        public native @Cast("const Nd4jLong*") LongPointer shapeInfo();


        /**
         * Returns True if it's legally empty NDArray, or false otherwise
         * @return
         */
        public native @Cast("bool") boolean isEmpty();

        /**
        *  if _shapeInfoD==nullptr return _shapeInfo, else return _shapeInfoD
        */
        public native @Cast("const Nd4jLong*") LongPointer specialShapeInfo();

        public native @Cast("const Nd4jLong*") LongPointer platformShapeInfo();

        /**
        *  permutes (in-place) the dimensions in array according to "dimensions" array
        */
        public native @Cast("bool") boolean permutei(@StdVector IntPointer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector IntBuffer dimensions);
        public native @Cast("bool") boolean permutei(@StdVector int[] dimensions);
        public native @Cast("bool") boolean permutei(@Const IntPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const IntBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Const int[] dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native @Cast("bool") boolean permutei(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native @Cast("bool") boolean permutei(@Cast("const Nd4jLong*") long[] dimensions, int rank);

        public native @Cast("bool") boolean isFinite();
        public native @Cast("bool") boolean hasNaNs();
        public native @Cast("bool") boolean hasInfs();

        public native void copyBuffersContinuouslyFrom(@Const @ByRef NDArray other, @Cast("size_t") long sizeToCopyInBytes/*=0*/, @Cast("Nd4jLong") long offsetThis/*=0*/, @Cast("Nd4jLong") long offsetOther/*=0*/);
        public native void copyBuffersContinuouslyFrom(@Const @ByRef NDArray other);

        /**
        *  permutes the dimensions in array according to "dimensions" array, new array points on _buffer of this array
        */
        public native @ByVal NDArray permute(@StdVector IntPointer dimensions);
        public native @ByVal NDArray permute(@StdVector IntBuffer dimensions);
        public native @ByVal NDArray permute(@StdVector int[] dimensions);
        public native @ByVal NDArray permute(@Const IntPointer dimensions, int rank);
        public native @ByVal NDArray permute(@Const IntBuffer dimensions, int rank);
        public native @ByVal NDArray permute(@Const int[] dimensions, int rank);
        
        
        

        public native void permute(@Const IntPointer dimensions, int rank, @ByRef NDArray target);
        public native void permute(@Const IntBuffer dimensions, int rank, @ByRef NDArray target);
        public native void permute(@Const int[] dimensions, int rank, @ByRef NDArray target);
        public native void permute(@StdVector IntPointer dimensions, @ByRef NDArray target);
        public native void permute(@StdVector IntBuffer dimensions, @ByRef NDArray target);
        public native void permute(@StdVector int[] dimensions, @ByRef NDArray target);
        public native @ByVal NDArray permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions);
        public native @ByVal NDArray permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions);
        public native @ByVal NDArray permute(@Cast("Nd4jLong*") @StdVector long[] dimensions);
        public native @ByVal NDArray permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank);
        public native @ByVal NDArray permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank);
        public native @ByVal NDArray permute(@Cast("const Nd4jLong*") long[] dimensions, int rank);
        
        
        

        public native void permute(@Cast("const Nd4jLong*") LongPointer dimensions, int rank, @ByRef NDArray target);
        public native void permute(@Cast("const Nd4jLong*") LongBuffer dimensions, int rank, @ByRef NDArray target);
        public native void permute(@Cast("const Nd4jLong*") long[] dimensions, int rank, @ByRef NDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongPointer dimensions, @ByRef NDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector LongBuffer dimensions, @ByRef NDArray target);
        public native void permute(@Cast("Nd4jLong*") @StdVector long[] dimensions, @ByRef NDArray target);

        /**
         * This method streamlines given view or permuted array, and reallocates buffer
         */
        public native void streamline(char order/*='a'*/);
        public native void streamline();

        /**
        *  prints information about array shape
        *  msg - message to print out
        */
        public native void printShapeInfo(@Cast("char*") String msg/*=nullptr*/);
        public native void printShapeInfo();
        public native void printShapeInfo(@Cast("char*") BytePointer msg/*=nullptr*/);

        /**
        *  prints buffer elements
        *  msg - message to print out
        *  limit - number of array elements to print out
        *  sync - if true check whether host buffer is actual, if it is not then make it so
        */
        public native void printBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long _limit/*=-1*/, @Cast("const bool") boolean sync/*=true*/);
        public native void printBuffer();
        public native void printBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long _limit/*=-1*/, @Cast("const bool") boolean sync/*=true*/);

        /**
        * print element by element consequently in a way they (elements) are stored in physical memory
        */
        public native void printLinearBuffer();

        /**
        *  prints _buffer (if host = true) or _bufferD (if host = false) as it is, that is in current state without checking buffer status
        */

        /**
        *  prints buffer elements, takes into account offset between elements (element-wise-stride)
        *  msg - message to print out
        *  limit - number of array elements to print out
        */
        public native void printIndexedBuffer(@Cast("char*") String msg/*=nullptr*/, @Cast("Nd4jLong") long _limit/*=-1*/);
        public native void printIndexedBuffer();
        public native void printIndexedBuffer(@Cast("char*") BytePointer msg/*=nullptr*/, @Cast("Nd4jLong") long _limit/*=-1*/);

        public native @StdString BytePointer asIndexedString(@Cast("Nd4jLong") long _limit/*=-1*/);
        public native @StdString BytePointer asIndexedString();
        public native @StdString BytePointer asString(@Cast("Nd4jLong") long _limit/*=-1*/);
        public native @StdString BytePointer asString();

        /**
        *  this method assigns values of given array to this one
        */
        public native void assign(@Const NDArray other, @Cast("bool") boolean allowParallelism/*=true*/);
        public native void assign(@Const NDArray other);

        /**
        *  this method assigns values of given array to this one
        */

        /**
        *  this method assigns given value to all elements in array
        */

        /**
        *  returns new copy of this array, optionally in different order
        */
        public native @ByVal NDArray dup(byte newOrder/*='a'*/);
        public native @ByVal NDArray dup();

        /**
        *  returns sum of all elements of array
        */
        public native @ByVal NDArray sumNumber();

        /**
        *  returns mean number of array
        */
        public native @ByVal NDArray meanNumber();

// #ifndef __JAVACPP_HACK__

// #endif

        /**
        *   apply transpose operation to the copy of this array, that is this array remains unaffected
        */
        public native @ByVal NDArray transpose();
        

        /**
        *  perform transpose operation and store result in target, this array remains unaffected
        *  target - where to store result
        */
        public native void transpose(@ByRef NDArray target);

        /**
        *  apply in-place transpose operation to this array, so this array becomes transposed
        */
        public native void transposei();

        /**
        *  returns the number of arrays pointing on specified dimension(s)
        *  dimensions - array of dimensions to point on
        */
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntPointer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native @Cast("Nd4jLong") long tensorsAlongDimension(@StdVector int[] dimensions);

        /**
        *  returns true if elements of two arrays are equal to within given epsilon value
        *  other - input array to compare
        *  eps - epsilon, this value defines the precision of elements comparison
        */
        public native @Cast("bool") boolean equalsTo(@Const NDArray other, double eps/*=1e-5*/);
        public native @Cast("bool") boolean equalsTo(@Const NDArray other);

        /**
        *  add given row vector to all rows of this array
        *  row - row vector to add
        */
        public native void addiRowVector(@Const @ByRef NDArray row);

        /**
        *  add given row vector to all rows of this array, store result in target
        *  row - row vector to add
        *  target - where to store result
        */
        public native void addRowVector(@Const @ByRef NDArray row, @ByRef NDArray target);

        /**
        *  subtract given row vector from all rows of this array, store result in target
        *  row - row vector to subtract
        *  target - where to store result
        */
        public native void subRowVector(@Const @ByRef NDArray row, @ByRef NDArray target);

        /**
        *  multiply all rows of this array on given row vector, store result in target
        *  row - row vector to multiply on
        *  target - where to store result
        */
        public native void mulRowVector(@Const @ByRef NDArray row, @ByRef NDArray target);

        /**
        *  divide all rows of this array on given row vector, store result in target
        *  row - row vector to divide on
        *  target - where to store result
        */
        public native void divRowVector(@Const @ByRef NDArray row, @ByRef NDArray target);

        /**
        *  add given column vector to all columns of this array, store result in target
        *  column - column vector to add
        *  target - where to store result
        */
        public native void addColumnVector(@Const @ByRef NDArray column, @ByRef NDArray target);

        /**
        *  add given column vector to all columns of this array, this array becomes affected (in-place operation)
        *  column - column vector to add
        */
		public native void addiColumnVector(@Const @ByRef NDArray column);

        /**
        *  multiply all columns of this array on given column vector, this array becomes affected (in-place operation)
        *  column - column vector to multiply on
        */
		public native void muliColumnVector(@Const @ByRef NDArray column);

        /**
        *  returns number of bytes used by _buffer & _shapeInfo
        */
        public native @Cast("Nd4jLong") long memoryFootprint();

        /**
        *  these methods suited for FlatBuffers use
        */
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeAsVector();
        public native @StdVector IntPointer getShapeAsVectorInt();
        public native @Cast("Nd4jLong*") @StdVector LongPointer getShapeInfoAsVector();
        public native @Cast("int64_t*") @StdVector LongPointer getShapeInfoAsFlatVector();
        public native @Cast("int64_t*") @StdVector LongPointer getShapeAsFlatVector();

        /**
        *  set new order and shape in case of suitable array length (in-place operation)
        *  order - order to set
        *  shape - shape to set
        *  copyToNewBuff - if true then old buffer will be copied to new buffer if last one will be allocated after reshaping
        *  if there was permute applied before or there are weird strides, then new buffer is allocated for array
        */
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(byte order, @Cast("Nd4jLong*") @StdVector long[] shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector long[] shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @Cast("bool") boolean reshapei(@Cast("Nd4jLong*") @StdVector long[] shape);

        /**
        *  creates new array with corresponding order and shape, new array will point on _buffer of this array
        *  order - order to set
        *  shape - shape to set
        *
        * if permute have been applied before or there are weird strides, then new buffer is allocated for new array
        */
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("const bool") boolean copyToNewBuff/*=true*/);
		public native @ByVal NDArray reshape(byte order, @Cast("Nd4jLong*") @StdVector long[] shape);
        

        /**
        *  calculate strides and set given order
        *  order - order to set
        */
		public native void updateStrides(byte order);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        */
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native void tilei(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  returns new array which is created by repeating of this array the number of times given by reps
        *  repeats - contains numbers of repetitions
        */
		public native @ByVal NDArray tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats);
		public native @ByVal NDArray tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats);
		public native @ByVal NDArray tile(@Cast("Nd4jLong*") @StdVector long[] repeats);

        /**
        *  change an array by repeating it the number of times given by reps (in-place operation)
        *  repeats - contains numbers of repetitions
        *  target - where to store result
        */
        public native void tile(@Cast("Nd4jLong*") @StdVector LongPointer repeats, @ByRef NDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector LongBuffer repeats, @ByRef NDArray target);
        public native void tile(@Cast("Nd4jLong*") @StdVector long[] repeats, @ByRef NDArray target);

        /**
        *  change an array by repeating it the number of times to acquire the new shape which is the same as target shape
        *  target - where to store result
        */
        public native void tile(@ByRef NDArray target);

        /**
        *  check whether array is identity matrix
        */
		public native @Cast("bool") boolean isIdentityMatrix();

        /**
        *  check whether array is unitary matrix
        */
		public native @Cast("bool") boolean isUnitary();

        /**
        *  operator returns subarray with buffer pointing at this->_buffer with offset defined by given intervals
        *  idx - intervals of indexes which define the subarrays to point on, idx has form {dim0Start,dim0End,  dim1Start,dim1End, ....} and length (2 * this->rankOf())
        *        when (dimStart == dimEnd) then whole range will be used for current dimension
        *  keepUnitiesInShape - if false then eliminate unities from resulting array shape, for example {1,a,1,b} -> {a,b}
        *  isStrided - if true then idx has length (3 * this->rankOf()) and contains additional stride numbers which correspond to stride between dimStart and dimEnd,
        *              so structure of idx is like {dim0Start,dim0End,dim0Stride,    dim1Start,dim1End,dim1Stride, ....}
        */
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector LongPointer idx, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector LongPointer idx);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector LongBuffer idx, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector LongBuffer idx);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector long[] idx, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("Nd4jLong*") @StdVector long[] idx);

        /**
        *  evaluates subarray with buffer pointing at this->_buffer and offset defined by given sequential index subArrIdx and dimensions in dimsToExclude
        *  subArrIdx - index of current sub-array
        *  dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5], and subArrIdx must be in range [0,7]
        *                  if dimsToExclude is empty then idxRanges containing all zeros (means whole array) will be returned.
        *  keepUnitiesInShape - if false then eliminate unities from resulting array shape, for example {1,a,1,b} -> {a,b}
        */
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntPointer dimsToExclude);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector IntBuffer dimsToExclude);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native @ByVal @Name("operator ()") NDArray apply(@Cast("const Nd4jLong") long subArrIdx, @StdVector int[] dimsToExclude);

        /**
        * processes whole set of sub-arrays
        * evaluates shapeInfo of sub-arrays (all sub-arrays have the same shapeInfo) and their buffer offsets (each sub-array has its own unique offset from original this-buffer)
        * dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5]
        *                 if dimsToExclude.size() = array rank it means sub-array is whole array and copy of original_shapeInfo will be returned and one zero offset
        * subArrShapeInfo    - output argument, contains shapeInfo common for all sub-arrays
        * subArrOffsets      - output argument, contains successive sub-arrays offsets from original this-buffer
        * keepUnitiesInShape - if false then eliminate unities from sub-array shapeInfo, for example {1,a,1,b} -> {a,b}
        */
        public native void getSubArrShapeAndOffsets(@StdVector IntPointer dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef LongPointer subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongPointer subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native void getSubArrShapeAndOffsets(@StdVector IntPointer dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef LongPointer subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongPointer subArrOffsets);
        public native void getSubArrShapeAndOffsets(@StdVector IntBuffer dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native void getSubArrShapeAndOffsets(@StdVector IntBuffer dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer subArrOffsets);
        public native void getSubArrShapeAndOffsets(@StdVector int[] dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef long[] subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef long[] subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
        public native void getSubArrShapeAndOffsets(@StdVector int[] dimsToExclude, @Cast("Nd4jLong*&") @ByPtrRef long[] subArrShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef long[] subArrOffsets);

        /**
        *  addition unary operator array += other
        *  other - input array to add
        */
        public native @Name("operator +=") void addPut(@Const @ByRef NDArray other);

        /**
        *  subtraction unary operator array -= other
        *  other - input array to add
        */
        public native @Name("operator -=") void subtractPut(@Const @ByRef NDArray other);

        /**
        *  negative operator, it changes sign of all array elements on opposite
        */
        public native @ByVal @Name("operator -") NDArray subtract();
        

        /**
        *  pairwise multiplication unary operator array *= other
        *  other - input array to multiply on
        */
        public native @Name("operator *=") void multiplyPut(@Const @ByRef NDArray other);

        /**
        *  multiplication unary operator array *= scalar
        *  scalar - input scalar to multiply on
        */

        /**
        *  pairwise division unary operator: array /= other
        *  other - input array to divide on
        */
        public native @Name("operator /=") void dividePut(@Const @ByRef NDArray other);

        /**
        *  division unary operator: array /= scalar
        *  scalar - input scalar to divide on
        */

        /**
        *  friend function which implements mathematical multiplication of two arrays
        *  left - input array
        *  right - input array
        */
        

        /**
        *  return vector containing _buffer as flat binary array
        */
        public native @StdVector BytePointer asByteVector();

        /**
        *  makes array to be identity matrix (not necessarily square), that is set all diagonal elements = 1, rest = 0
        */
        public native void setIdentity();

        /**
        *  swaps the contents of tow arrays,
        *  PLEASE NOTE: method doesn't take into account the shapes of arrays, shapes may be different except one condition: arrays lengths must be the same
        */
        public native void swapUnsafe(@ByRef NDArray other);

        /**
        *  return vector with buffer which points on corresponding diagonal elements of array
        *  type - means of vector to be returned: column ('c') or row ('r')
        */
        public native @ByVal NDArray diagonal(byte type );

        /**
        * fill target matrix with given value in one or two directions from main diagonal:
        *   - down from main diagonal starting at subdiagonal number "lower" if direction = 'l' (down) or 'b' (both)
        *   - up from main diagonal starting at superdiagonal number "upper"if direction = 'u' (up) or 'b' (both)
        * direction - in what direction to fill matrix. There are 3 possible directions:
        *   'u' - fill up, mathematically this corresponds to lower triangular matrix, subdiagonal "lower" unaffected
        *   'l' - fill down, mathematically this corresponds to upper triangular matrix, superdiagonal "upper" remains unaffected
        *   'b' - fill in both directions, both "lower" and "upper" are taken into account
        * rest of target elements are equal to this array elements
        * target and this array should have same shapes, except when this_rank = 1 (in that case should be target_rank = 2)
        */

		/**
        *  change an array by repeating it the number of times in order to acquire new shape equal to the input shape
        *
        *  shape  - contains new shape to broadcast array to
        *  target - optional argument, if target != nullptr the resulting array will be placed in target, in opposite case tile operation is done in place
        */
        public native @ByVal NDArray tileToShape(@Cast("const Nd4jLong*") LongPointer shapeInfo);
        public native @ByVal NDArray tileToShape(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
        public native @ByVal NDArray tileToShape(@Cast("const Nd4jLong*") long[] shapeInfo);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongPointer shape, @ByRef NDArray target);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape, @ByRef NDArray target);
        public native void tileToShape(@Cast("Nd4jLong*") @StdVector long[] shape, @ByRef NDArray target);
// #ifndef __JAVACPP_HACK__
// #endif

        public native @ByVal NDArray asT(@Cast("sd::DataType") int dtype);


        public native void linspace(double start);

        public native void linspace(double start, double step);

        /**
        *  calculates the trace of an array, that is sum of elements on main diagonal = sum array[i, i, i, ...]
        */
        public native double getTrace();

        public native @ByVal ResultSet multipleTensorsAlongDimension(@StdVector IntPointer indices, @StdVector IntPointer dimensions);
        public native @ByVal ResultSet multipleTensorsAlongDimension(@StdVector IntBuffer indices, @StdVector IntBuffer dimensions);
        public native @ByVal ResultSet multipleTensorsAlongDimension(@StdVector int[] indices, @StdVector int[] dimensions);

        public native @ByVal ResultSet allTensorsAlongDimension(@StdVector IntPointer dimensions);
        public native @ByVal ResultSet allTensorsAlongDimension(@StdVector IntBuffer dimensions);
        public native @ByVal ResultSet allTensorsAlongDimension(@StdVector int[] dimensions);

        public native @ByVal ResultSet allExamples();

        /**
        *  set _shapeInfo
        */
        public native void setShapeInfo(@Cast("const Nd4jLong*") LongPointer shapeInfo);
        public native void setShapeInfo(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
        public native void setShapeInfo(@Cast("const Nd4jLong*") long[] shapeInfo);
        public native void setShapeInfo(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const sd::DataType") int dtype);
        public native void setShapeInfo(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const sd::DataType") int dtype);
        public native void setShapeInfo(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const sd::DataType") int dtype);
        public native void setShapeInfo(@Const @ByRef ShapeDescriptor descriptor);
        public native void setShapeInfo(@Const @ByRef ConstantShapeBuffer shapeBuffer);

        /**
        *  returns absolute offset which corresponds to given sequential index
        */
        public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong") long i);

        /**
        *  returns reference on array element with given index
        */


        /**
        *  returns array element with given index
        *  i - element index in array
        */


        /**
        *  default destructor
        */

        /**
        *  set _shapeInfo
        */

        /**
        *  returns the value of "dim" dimension
        */
        public native @Cast("Nd4jLong") long sizeAt(int dim);

        /**
        *  returns stride of "dim" dimension
        */
        public native @Cast("Nd4jLong") long strideAt(int dim);

        /**
        *  returns order of array
        */
        public native char ordering();

        /**
        *  return _isView
        */
        public native @Cast("bool") boolean isView();

        /**
        *  returns shape portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer shapeOf();

        /**
        *  returns strides portion of shapeInfo
        */
        public native @Cast("Nd4jLong*") LongPointer stridesOf();

        /**
        *  returns rank of array
        */
        public native int rankOf();

        /**
        *  returns length of array
        */
        public native @Cast("Nd4jLong") long lengthOf();

        /**
        *  returns number of rows in array
        */
        public native @Cast("Nd4jLong") long rows();

        /**
        *  returns number of columns in array
        */
        public native @Cast("Nd4jLong") long columns();

        /**
        *  returns size of array elements type
        */
        public native @Cast("size_t") long sizeOfT();

        /**
        *  returns element-wise-stride
        */
        public native @Cast("Nd4jLong") long ews();

        // returns true if arrays have same shape
        public native @Cast("bool") boolean isSameShape(@Const NDArray other);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongPointer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public native @Cast("bool") boolean isSameShape(@Cast("Nd4jLong*") @StdVector long[] shape);
        public native @Cast("bool") boolean areSameShapeAndType(@Const @ByRef NDArray other);

        /**
        *  returns true if these two NDArrays have same rank, dimensions, strides, ews and order
        */
        public native @Cast("bool") boolean isSameShapeStrict(@Const @ByRef NDArray other);

        /**
        *  returns true if buffer && shapeInfo were defined (non nullptr)
        */
        public native @Cast("bool") boolean nonNull();

        /**
        *  returns array element with given index from linear buffer
        *  i - element index in array
        */

        /**
        *  returns element with given indexes from 2D array
        *  i - number of row
        *  j - number of column
        */

        /**
        *  returns element with given indexes from 3D array
        *  i - height
        *  j - width
        *  k - depth
        */

        /**
        *  returns element with given indexes from DD array
        */

        /**
        *  returns array-scalar containing element of this array with given index
        *  i - element index in array
        */
        public native @ByVal NDArray e(@Cast("const Nd4jLong") long i);

        /**
        *  assigns given scalar to array element by given index, regards array buffer as linear
        *  i - element index in array
        *  value - scalar value to assign
        */

        public native void p(@Cast("const Nd4jLong") long i, @Const @ByRef NDArray value);

        /**
        *  assigns given scalar to 2D array element by given indexes
        *  i - number of row
        *  j - number of row
        *  value - scalar value to assign
        */

        /**
        *  assigns given scalar to 3D array element by given indexes
        *  i - height
        *  j - width
        *  k - depth
        *  value - scalar value to assign
        */
        public native void p(@Cast("const Nd4jLong") long i, @Cast("const Nd4jLong") long j, @Cast("const Nd4jLong") long k, @Cast("const Nd4jLong") long l, @Const @ByRef NDArray value);

        /**
        *  returns true if array is 2D
        */
        public native @Cast("bool") boolean isMatrix();

        /**
        *  returns true if array is vector
        */
        public native @Cast("bool") boolean isVector();

        /**
        *  returns true if array is column vector
        */
        public native @Cast("bool") boolean isColumnVector();

        /**
        *  returns true if array is row vector
        */
        public native @Cast("bool") boolean isRowVector();

        /**
        *  returns true if all dimensions of array except one are unities, for example: [1,1,n,1], [n,1,1], [n], ...
        *  posOfNonUnityDim - one dimension with value > 1
        */
        public native @Cast("bool") boolean isCommonVector(@ByRef IntPointer posOfNonUnityDim);
        public native @Cast("bool") boolean isCommonVector(@ByRef IntBuffer posOfNonUnityDim);
        public native @Cast("bool") boolean isCommonVector(@ByRef int[] posOfNonUnityDim);


        /**
        *  returns true if array is scalar
        */
        public native @Cast("bool") boolean isScalar();

        /**
        * Returns data type of this array
        * @return
        */
        public native @Cast("sd::DataType") int dataType();

        /**
         * This method returns true if value is from Integer space
         * @return
         */
        public native @Cast("bool") boolean isZ();

        /**
         * This method returns true if array is from Real space
         * @return
         */
        public native @Cast("bool") boolean isR();

        /**
         * This method returns true if array is from Boolean space
         * @return
         */
        public native @Cast("bool") boolean isB();

        /**
         * This method returns true if array contains Complex numbers
         * @return
         */
        public native @Cast("bool") boolean isC();

        /**
         * This method returns true if array contains String
         * @return
         */
        public native @Cast("bool") boolean isS();

        public native @Cast("bool") boolean isAttached();

        public native NDArray detach();

        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef NDArray other);

        public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef NDArray other);
    }




//////////////////////////////////////////////////////////////////////////
///// IMLEMENTATION OF INLINE METHODS /////
//////////////////////////////////////////////////////////////////////////




//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// still the definition of inline function must be in header file


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
// returns true if these two NDArrays have same _shapeInfo
// still the definition of inline function must be in header file



//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////






////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


// #ifndef __JAVACPP_HACK__
// #endif

////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////



// #if defined(__CUDACC__) //&& defined(BUILD_TESTS)
// for CUDA we need stil stuff inline
// #include <array/NDArrayLambda.hXX>
// #endif



// #endif


// Parsed from array/NDArrayList.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class describes collection of NDArrays
//
// @author raver119!gmail.com
//

// #ifndef NDARRAY_LIST_H
// #define NDARRAY_LIST_H

// #include <string>
// #include <atomic>
// #include <unordered_map>
// #include <array/NDArray.h>
// #include <memory/Workspace.h>
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class NDArrayList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public NDArrayList(Pointer p) { super(p); }
    
        public NDArrayList(int height, @Cast("bool") boolean expandable/*=false*/) { super((Pointer)null); allocate(height, expandable); }
        private native void allocate(int height, @Cast("bool") boolean expandable/*=false*/);
        public NDArrayList(int height) { super((Pointer)null); allocate(height); }
        private native void allocate(int height);

        public native @Cast("sd::DataType") int dataType();

        public native NDArray read(int idx);
        public native NDArray readRaw(int idx);
        public native @Cast("Nd4jStatus") int write(int idx, NDArray array);
        public native NDArray pick(@StdVector IntPointer indices);
        public native NDArray pick(@StdVector IntBuffer indices);
        public native NDArray pick(@StdVector int[] indices);
        public native @Cast("bool") boolean isWritten(int index);

        public native @Cast("Nd4jLong*") @StdVector LongPointer shape();

        public native NDArray stack();
        public native void unstack(NDArray array, int axis);

        public native @ByRef IntIntPair id();
        public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();
        //sd::memory::Workspace* workspace();
        public native LaunchContext context();
        public native NDArrayList clone();

        public native @Cast("bool") boolean equals(@ByRef NDArrayList other);

        public native int elements();
        public native int height();

        public native int counter();
    }


// #endif

// Parsed from array/ResultSet.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// This class is suited for execution results representation.
//
// PLESE NOTE: It will delete all stored NDArrays upon destructor call
//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_RESULTSET_H
// #define LIBND4J_RESULTSET_H

// #include <vector>
// #include <graph/generated/result_generated.h>
// #include <system/pointercast.h>
// #include <system/dll.h> // forward declaration of template class NDArray

    @Namespace("sd") @NoOffset public static class ResultSet extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ResultSet(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ResultSet(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ResultSet position(long position) {
            return (ResultSet)super.position(position);
        }
        @Override public ResultSet getPointer(long i) {
            return new ResultSet((Pointer)this).position(position + i);
        }
    
        public ResultSet() { super((Pointer)null); allocate(); }
        private native void allocate();

// #ifndef __JAVACPP_HACK__
// #endif

        public ResultSet(@Const @ByRef ResultSet other) { super((Pointer)null); allocate(other); }
        @NoException private native void allocate(@Const @ByRef ResultSet other);

        public native @ByRef @Name("operator =") @NoException ResultSet put(@Const @ByRef ResultSet other);

        // move constructor

        // move assignment operator

        public native int size();
        public native NDArray at(@Cast("const unsigned long") long idx);
        public native @Name("operator []") NDArray get(@Cast("const unsigned long") long idx);
        public native void push_back(NDArray array);

        public native @Cast("Nd4jStatus") int status();
        public native void setStatus(@Cast("Nd4jStatus") int status);
        public native void purge();
        public native void setNonRemovable();
    }


// #endif //LIBND4J_RESULTSET_H


// Parsed from graph/RandomGenerator.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@protonmail.com
//

// #ifndef LIBND4J_GRAPH_RNG_H
// #define LIBND4J_GRAPH_RNG_H

// #include <types/u64.h>
// #include <types/u32.h>
// #include <system/pointercast.h>
// #include <system/op_boilerplate.h>
// #include <system/dll.h>
// #include <chrono>
// #include <array/DataTypeUtils.h>
// #include <helpers/logger.h>
// #include <stdexcept>
// #include <math/templatemath.h>

// #ifdef __CUDACC__
// #endif
// #ifdef __CUDACC__
// #else
        @Namespace("sd::graph") @NoOffset public static class RandomGenerator extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public RandomGenerator(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public RandomGenerator(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public RandomGenerator position(long position) {
                return (RandomGenerator)super.position(position);
            }
            @Override public RandomGenerator getPointer(long i) {
                return new RandomGenerator((Pointer)this).position(position + i);
            }
        
            public native @Cast("uint32_t") int xoroshiro32(@Cast("uint64_t") long index);
            public native @Cast("uint64_t") long xoroshiro64(@Cast("uint64_t") long index);
            public RandomGenerator(@Cast("Nd4jLong") long rootSeed/*=0*/, @Cast("Nd4jLong") long nodeSeed/*=0*/) { super((Pointer)null); allocate(rootSeed, nodeSeed); }
            private native void allocate(@Cast("Nd4jLong") long rootSeed/*=0*/, @Cast("Nd4jLong") long nodeSeed/*=0*/);
            public RandomGenerator() { super((Pointer)null); allocate(); }
            private native void allocate();

            /**
             * This method allows to change graph-level state in runtime.
             * PLEASE NOTE: this method will change state of node as well.
             */
            public native void setStates(@Cast("Nd4jLong") long rootSeed, @Cast("Nd4jLong") long nodeState/*=0*/);
            public native void setStates(@Cast("Nd4jLong") long rootSeed);

            

            /**
             * This method returns T value between from and to
             */

            /**
             * This method returns T value between 0 and MAX_T
             */

            /**
             * These two methods are made for JVM
             * @param index
             * @return
             */
            public native int relativeInt(@Cast("Nd4jLong") long index);
            public native @Cast("Nd4jLong") long relativeLong(@Cast("Nd4jLong") long index);

            public native void rewindH(@Cast("uint64_t") long steps);

            /**
             * These methods set up only node states, with non-changed root ones
             */
            public native void setSeed(int seed);

            public native void setSeed(@Cast("uint64_t") long seed);

            public native @Cast("Nd4jLong") long rootState();

            public native @Cast("Nd4jLong") long nodeState();
        }


        

        

        

        

        

        

        

        

        

        

        

        

        


        

        

        //////
        @Namespace("sd::graph") public native @Cast("uint32_t") int rotl(@Cast("const uint32_t") int x, int k);

        @Namespace("sd::graph") public native @Cast("uint64_t") long rotl(@Cast("const uint64_t") long x, int k);

        @Namespace("sd::graph") public native @Cast("uint32_t") int next(@Cast("uint32_t") int s0, @Cast("uint32_t") int s1, @Cast("uint32_t") int s2, @Cast("uint32_t") int s3);

        

        

        
    


// #endif


// Parsed from graph/Variable.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_VARIABLE_H
// #define LIBND4J_VARIABLE_H

// #include <string>
// #include <array/NDArray.h>
// #include <array/NDArrayList.h>
// #include <graph/VariableType.h>
// #include <graph/generated/array_generated.h>
// #include <graph/generated/node_generated.h>
// #include <graph/generated/graph_generated.h>

// #ifndef __JAVACPP_HACK__

// #endif
        @Namespace("sd::graph") @NoOffset public static class Variable extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Variable(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public Variable(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public Variable position(long position) {
                return (Variable)super.position(position);
            }
            @Override public Variable getPointer(long i) {
                return new Variable((Pointer)this).position(position + i);
            }
        
            public Variable(@Cast("bool") boolean placeHolder) { super((Pointer)null); allocate(placeHolder); }
            private native void allocate(@Cast("bool") boolean placeHolder);
            public Variable(NDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(NDArray arrayw, @Cast("char*") String name, int id, int idx/*=0*/);
            public Variable(NDArray arrayw, @Cast("char*") String name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(NDArray arrayw, @Cast("char*") String name, int id);
            public Variable(NDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/) { super((Pointer)null); allocate(arrayw, name, id, idx); }
            private native void allocate(NDArray arrayw, @Cast("char*") BytePointer name, int id, int idx/*=0*/);
            public Variable(NDArray arrayw, @Cast("char*") BytePointer name, int id) { super((Pointer)null); allocate(arrayw, name, id); }
            private native void allocate(NDArray arrayw, @Cast("char*") BytePointer name, int id);
            public Variable(NDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(NDArray array/*=nullptr*/, @Cast("char*") String name/*=nullptr*/);
            public Variable() { super((Pointer)null); allocate(); }
            private native void allocate();
            public Variable(NDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(array, name); }
            private native void allocate(NDArray array/*=nullptr*/, @Cast("char*") BytePointer name/*=nullptr*/);

// #ifndef __JAVACPP_HACK__
// #endif

            public native Variable clone();

            public native @Cast("bool") boolean hasNDArray();
            public native NDArray getNDArray();
            public native void setNDArray(NDArray array);

            public native @Cast("bool") boolean hasNDArrayList();
            public native NDArrayList getNDArrayList();
            public native void setNDArrayList(NDArrayList list);

            public native @Cast("bool") boolean isExternal();
            public native @Cast("bool") boolean isReadOnly();
            public native @Cast("bool") boolean isEmpty();
            public native @Cast("bool") boolean isRemovable();

            public native @Cast("bool") boolean isPlaceholder();

            public native @Cast("sd::graph::VariableType") int variableType();
            public native void setVariableType(@Cast("sd::graph::VariableType") int variableType);

            /**
             * This method returns InputType of this variable  
             */
            //InputType variableType() {
            //    return _variableType;
            //}

            public native void markExternal(@Cast("bool") boolean reallyExternal);
            public native void markReadOnly(@Cast("bool") boolean reallyReadOnly);
            public native void markRemovable(@Cast("bool") boolean reallyRemovable);

            public native int id();
            public native int index();
            public native void setIndex(int index);
            public native void setId(int id);
            public native void setId(int id, int idx);

            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getName();
            public native void setName(@StdString @Cast({"char*", "std::string*"}) BytePointer name);

            public native @Cast("Nd4jLong*") @StdVector LongPointer shape();

// #ifndef __JAVACPP_HACK__
// #endif
        }
    



// #endif //LIBND4J_VARIABLE_H


// Parsed from graph/VariablesSet.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 15/11/17.
//

// #ifndef LIBND4J_VARIABLESSET_H
// #define LIBND4J_VARIABLESSET_H

// #include <iterator>
// #include <vector>
// #include <system/pointercast.h>
// #include <system/dll.h>
// #include <graph/Variable.h>
        @Namespace("sd::graph") @NoOffset public static class VariablesSet extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public VariablesSet(Pointer p) { super(p); }
        
            public VariablesSet(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/) { super((Pointer)null); allocate(status); }
            private native void allocate(@Cast("Nd4jStatus") int status/*=ND4J_STATUS_OK*/);
            public VariablesSet() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @Cast("Nd4jStatus") int status();

            public native int size();

            public native void push_back(Variable variable);

            public native Variable at(int index);

        }
    




// #endif //LIBND4J_VARIABLESSET_H


// Parsed from graph/FlowPath.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 16/11/17.
//

// #ifndef LIBND4J_FLOWPATH_H
// #define LIBND4J_FLOWPATH_H

// #include <system/op_boilerplate.h>
// #include <unordered_map>
// #include <map>
// #include <system/pointercast.h>
// #include <graph/NodeState.h>
// #include <graph/FrameState.h>
// #include <graph/profiling/GraphProfile.h>
// #include <system/dll.h>
        @Namespace("sd::graph") @NoOffset public static class FlowPath extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public FlowPath(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public FlowPath(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public FlowPath position(long position) {
                return (FlowPath)super.position(position);
            }
            @Override public FlowPath getPointer(long i) {
                return new FlowPath((Pointer)this).position(position + i);
            }
        
            public FlowPath() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native void setInnerTime(int nodeId, @Cast("Nd4jLong") long time);
            public native void setOuterTime(int nodeId, @Cast("Nd4jLong") long time);

            public native @Cast("Nd4jLong") long innerTime(int nodeId);
            public native @Cast("Nd4jLong") long outerTime(int nodeId);

            public native @Cast("bool") boolean isNodeActive(int nodeId);
            public native void markNodeActive(int nodeId, @Cast("bool") boolean isActive);

            public native @Cast("bool") boolean wasExecuted(int nodeId);
            public native void markExecuted(int nodeId, @Cast("bool") boolean wasExecuted);

            public native int branch(int nodeId);
            public native void markBranch(int nodeId, int index);

            // Frame-related methods

            public native void registerFrame(@Cast("Nd4jLong") long frameId);
            public native void forgetFrame(@Cast("Nd4jLong") long frameId);

            public native @Cast("bool") boolean isFrameActive(@Cast("Nd4jLong") long frameId);
            public native void markFrameActive(@Cast("Nd4jLong") long frameId, @Cast("bool") boolean isActive);

            public native @Cast("bool") boolean isRewindPlanned(@Cast("Nd4jLong") long frameId);
            public native void planRewind(@Cast("Nd4jLong") long frameId, @Cast("bool") boolean reallyRewind);

            public native int getRewindPosition(@Cast("Nd4jLong") long frameId);
            public native void setRewindPosition(@Cast("Nd4jLong") long frameId, int _position);
            public native void setRewindPositionOnce(@Cast("Nd4jLong") long frameId, int _position);

            public native void incrementNumberOfCycles(@Cast("Nd4jLong") long frameId);
            public native @Cast("Nd4jLong") long getNumberOfCycles(@Cast("Nd4jLong") long frameId);

            public native GraphProfile profile();
        }
    



// #endif //LIBND4J_FLOWPATH_H


// Parsed from graph/Intervals.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by yurii@skymind.io on 24.10.2017.
//

// #ifndef LIBND4J_INTERVALS_H
// #define LIBND4J_INTERVALS_H

// #include <system/pointercast.h>
// #include <vector>
// #include <initializer_list>
// #include <system/dll.h>

    @Namespace("sd") @NoOffset public static class Intervals extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Intervals(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public Intervals(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public Intervals position(long position) {
            return (Intervals)super.position(position);
        }
        @Override public Intervals getPointer(long i) {
            return new Intervals((Pointer)this).position(position + i);
        }
    

        // default constructor
        public Intervals() { super((Pointer)null); allocate(); }
        private native void allocate();
        
        // constructor
        public Intervals(@Const @ByRef LongVectorVector content ) { super((Pointer)null); allocate(content); }
        private native void allocate(@Const @ByRef LongVectorVector content );
        
        // accessing operator
        public native @Cast("Nd4jLong*") @StdVector @Name("operator []") LongPointer get(@Cast("const Nd4jLong") long i);

        // returns size of _content
        public native int size();

    }




// #endif //LIBND4J_INTERVALS_H


// Parsed from graph/Stash.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_STASH_H
// #define LIBND4J_STASH_H

//#include <graph/Block.h>
// #include <array/NDArray.h>
// #include <map>
// #include <vector>
// #include <string>
// #include <atomic>
// #include <functional>
// #include <system/pointercast.h>
        @Namespace("sd::graph") @NoOffset public static class KeyPair extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public KeyPair(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public KeyPair(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public KeyPair position(long position) {
                return (KeyPair)super.position(position);
            }
            @Override public KeyPair getPointer(long i) {
                return new KeyPair((Pointer)this).position(position + i);
            }
        
            public KeyPair(int node/*=0*/, @Cast("char*") String name/*=nullptr*/) { super((Pointer)null); allocate(node, name); }
            private native void allocate(int node/*=0*/, @Cast("char*") String name/*=nullptr*/);
            public KeyPair() { super((Pointer)null); allocate(); }
            private native void allocate();
            public KeyPair(int node/*=0*/, @Cast("char*") BytePointer name/*=nullptr*/) { super((Pointer)null); allocate(node, name); }
            private native void allocate(int node/*=0*/, @Cast("char*") BytePointer name/*=nullptr*/);

            public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef KeyPair other);

            public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef KeyPair other);

            public native int key();
            public native @StdString BytePointer name();
        }
    


// #ifndef __JAVACPP_HACK__

// #endif
        @Namespace("sd::graph") @NoOffset public static class Stash extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Stash(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public Stash(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public Stash position(long position) {
                return (Stash)super.position(position);
            }
            @Override public Stash getPointer(long i) {
                return new Stash((Pointer)this).position(position + i);
            }
        
            public Stash() { super((Pointer)null); allocate(); }
            private native void allocate();

            //void storeArray(sd::graph::Block<T>& block, const char *name, sd::NDArray<T> *array);
            public native void storeArray(int nodeId, @Cast("char*") String name, NDArray array);
            public native void storeArray(int nodeId, @Cast("char*") BytePointer name, NDArray array);

            //bool checkStash(sd::graph::Block<T>& block, const char *name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") String name);
            public native @Cast("bool") boolean checkStash(int nodeId, @Cast("char*") BytePointer name);

            //sd::NDArray<T>* extractArray(sd::graph::Block<T>& block, const char *name);
            public native NDArray extractArray(int nodeId, @Cast("char*") String name);
            public native NDArray extractArray(int nodeId, @Cast("char*") BytePointer name);

            public native void clear();
        }
    






// #endif //LIBND4J_STASH_H


// Parsed from graph/GraphState.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 23.01.18.
//

// #ifndef LIBND4J_GRAPHSTATE_H
// #define LIBND4J_GRAPHSTATE_H

// #include <system/pointercast.h>
// #include <system/op_boilerplate.h>
// #include <system/dll.h>
// #include <vector>
// #include <unordered_map>
// #include <map>
// #include <graph/Scope.h>
// #include <graph/Status.h>
// #include <graph/VariableSpace.h>
// #include <ops/declarable/DeclarableOp.h>
// #include <types/pair.h>
// #include <graph/ArgumentsList.h>
// #include <graph/Graph.h>

    @Namespace("sd::graph") @NoOffset public static class GraphState extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public GraphState(Pointer p) { super(p); }
    
        public GraphState(@Cast("Nd4jLong") long id) { super((Pointer)null); allocate(id); }
        private native void allocate(@Cast("Nd4jLong") long id);

        /**
         *
         * @return
         */
        public native @Cast("Nd4jLong") long id();

        /**
         * This method adds scope to this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int registerScope(int scopeId);

        /**
         * This method cheks if scope with given ID exists
         * 
         * @param scopeId - ID of the scope
         * @return - TRUE if scope exists, FALSE otherwise
         */
        public native @Cast("bool") boolean hasScope(int scopeId);

        /**
         * This method removes specified scope from this state tracker
         *
         * @param scopeId
         * @return
         */
        public native @Cast("Nd4jStatus") int forgetScope(int scopeId);

// #ifndef __JAVACPP_HACK__
// #endif
        /**
         * This method adds given op to the end of specified scope
         *
         * @param scopeId
         * @param opNum
         * @param type
         * @return
         */
        public native @Cast("Nd4jStatus") int attachOpToScope(int scopeId, @Cast("Nd4jLong") long opNum, int type, @ByVal ArgumentsList inputs);

        /**
         * This method adds return statement to specified scope
         *
         * PLEASE NOTE: should be used only in body scopes
         *
         * @param scopeId
         * @param nodeId
         * @param args
         * @return
         */
        public native @Cast("Nd4jStatus") int defineReturn(int scopeId, int nodeId, @ByVal ArgumentsList args);

        /**
         * This method returns current variable space of this state holder
         *
         * @return
         */
        public native VariableSpace variableSpace();
    }





// #endif //LIBND4J_GRAPHSTATE_H


// Parsed from graph/VariableSpace.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_VARIABLESPACE_H
// #define LIBND4J_VARIABLESPACE_H

// #include <helpers/logger.h>
// #include <helpers/helper_random.h>
// #include <string>
// #include <vector>
// #include <list>
// #include <unordered_map>
// #include <mutex>
// #include <array/NDArray.h>
// #include <array/NDArrayList.h>
// #include <graph/Variable.h>
// #include <memory/Workspace.h>
// #include <graph/Stash.h>
// #include <graph/FlowPath.h>
        @Namespace("sd::graph") @NoOffset public static class VariableSpace extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public VariableSpace(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public VariableSpace(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public VariableSpace position(long position) {
                return (VariableSpace)super.position(position);
            }
            @Override public VariableSpace getPointer(long i) {
                return new VariableSpace((Pointer)this).position(position + i);
            }
        
            public VariableSpace() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native @ByRef @Name("operator =") VariableSpace put(@Const @ByRef VariableSpace other);

            public native int numberOfPlaceholders();
            public native @Cast("sd::graph::Variable**") @StdVector PointerPointer getPlaceholders();
            public native void setWorkspace(Workspace workspace);

            public native LaunchContext launchContext();

            public native @Cast("bool") boolean hasExternalVariable(int it);
            public native @Cast("bool") boolean hasExternalVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasExternalVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("bool") boolean hasVariable(int id);
            public native @Cast("bool") boolean hasVariable(int id, int idx);
            public native @Cast("bool") boolean hasVariable(@ByRef IntIntPair pair);
            public native @Cast("bool") boolean hasVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native Variable getVariable(int id);
            public native Variable getVariable(int id, int idx);
            public native Variable getVariable(@ByRef IntIntPair pair);
            public native Variable getVariable(@StdString @Cast({"char*", "std::string*"}) BytePointer symbol);

            public native @Cast("sd::graph::Variable**") @StdVector PointerPointer getVariables();

            public native Variable putVariable(@ByRef IntIntPair pair, NDArray array);
            public native void putVariable(@ByRef IntIntPair pair, Variable variable);
            public native void putVariable(int id, Variable variable);
            public native void putVariable(int id, NDArray array);
            public native Variable putVariable(int id, int idx, NDArray array);
            public native void putVariable(int id, int idx, Variable array);

            public native void dropVariable(@ByRef IntIntPair pair);
            public native void dropVariable(int id, int idx);

            public native void trackList(NDArrayList list);

            public native void putOutputVariable(Variable variable);

            public native void replaceVariable(Variable variable);

            // memory-related statistics
            public native @Cast("Nd4jLong") long externalMemory();
            public native @Cast("Nd4jLong") long internalMemory();
            public native @Cast("Nd4jLong") long totalMemory();

            public native int externalEntries();
            public native int internalEntries();
            public native int totalEntries();

            public native VariableSpace clone();

            public native @Cast("sd::graph::Variable**") @StdVector PointerPointer handles();


            public native VariableSpace asT();
            public native void injectVariable(@ByRef IntIntPair pair, Variable variable);

            public native Stash getStash();

            public native @Cast("sd::graph::Variable**") @StdVector PointerPointer getExternalVariables();

            public native void setFlowPath(FlowPath timers);
            public native FlowPath flowPath();
        }
    



// #endif //LIBND4J_VARIABLESPACE_H


// Parsed from helpers/helper_generator.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_HELPER_GENERATOR_H
// #define LIBND4J_HELPER_GENERATOR_H

// #include <system/op_boilerplate.h>
// #include <system/pointercast.h>
// #include <array/DataTypeUtils.h>
// #include <system/dll.h>

// #ifdef _MSC_VER
// include for uint64_t on MSVC
// #include <stdint.h>
// #elif ANDROID
// #include <stdint.h>

// #ifndef UINT64_C
// #if defined(__LP64__)
// #define UINT64_C(c)     c ## UL
// #else
// #define UINT64_C(c)     c ## ULL
// #endif //LP64
// #endif // UINT64

// #endif // MSVC/ANDROID


// #ifdef __GNUC__
// #include <inttypes.h>
// #endif

// #ifdef __CUDACC__
// #else
        @Namespace("sd::random") @NoOffset public static class RandomBuffer extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public RandomBuffer(Pointer p) { super(p); }
        
            /**
             * This method allocates buffer of size * sizeof(Nd4jLong)
             *
             * @param size
             * @return
             */
// #ifdef __CUDACC__
// #endif
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongPointer buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongPointer buffer);
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongBuffer buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") LongBuffer buffer);
            public RandomBuffer(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") long[] buffer) { super((Pointer)null); allocate(seed, size, buffer); }
            private native void allocate(@Cast("Nd4jLong") long seed, @Cast("Nd4jLong") long size, @Cast("uint64_t*") long[] buffer);

            public native @Cast("uint64_t*") LongPointer getBuffer();

            public native @Cast("uint64_t*") LongPointer getDeviceBuffer();

// #ifdef __CUDACC__
// #endif

            public native @Cast("Nd4jLong") long getSize();

            public native @Cast("Nd4jLong") long getSeed();

            public native void setSeed(@Cast("Nd4jLong") long seed);

            public native @Cast("Nd4jLong") long getAllocatedSize();

            public native @Cast("Nd4jLong") long getOffset();

            public native void setOffset(@Cast("Nd4jLong") long offset);

            public native void reSeed(@Cast("Nd4jLong") long amplifier);

            public native @Cast("uint64_t") long getElement(@Cast("Nd4jLong") long _position);

            public native @Cast("uint64_t") long next64(@Cast("uint64_t") long shiftedSeed);

            public native @Cast("uint64_t") long rotl(@Cast("const uint64_t") long x, @Cast("uint64_t") long k);

            public native @Cast("uint64_t") long safeShift(@Cast("uint64_t") long x, @Cast("uint64_t") long y);

            public native @Cast("uint64_t") long seedConv(@Cast("Nd4jLong") long seed);

            public native void incrementGeneration();

            public native @Cast("Nd4jLong") long getNextIndex();

            public native @Cast("uint64_t") long getNextElement();


            /**
             * This method skips X elements from buffer
             *
             * @param numberOfElements number of elements to skip
             */
// #ifdef __CUDACC__
// #endif
            public native void rewindH(@Cast("Nd4jLong") long numberOfElements);

            /**
            * This method returns random int in range [0..MAX_INT]
            * @return
            */
            public native int nextInt();

            public native @Cast("uint64_t") long nextUInt64();

            /**
             * This method returns random int in range [0..to]
             * @param to
             * @return
             */
            public native int nextInt(int to);

            /**
             * This method returns random int in range [from..to]
             * @param from
             * @param to
             * @return
             */
            public native int nextInt(int from, int to);


            /**
             * This method returns random T in range of [0..1]
             * @return
             */

            /**
             * This method returns random T in range of [0..to]
             * @param to
             * @return
             */

            /**
             * This method returns random T in range [from..to]
             * @param from
             * @param to
             * @return
             */

            public native @Cast("uint64_t") long relativeUInt64(@Cast("Nd4jLong") long index);

            /**
             *  relative methods are made as workaround for lock-free concurrent execution
             */
            public native int relativeInt(@Cast("Nd4jLong") long index);

            /**
             * This method returns random int within [0..to]
             *
             * @param index
             * @param to
             * @return
             */
            public native int relativeInt(@Cast("Nd4jLong") long index, int to);

            /**
             * This method returns random int within [from..to]
             *
             * @param index
             * @param to
             * @param from
             * @return
             */
            public native int relativeInt(@Cast("Nd4jLong") long index, int from, int to);

            /**
             * This method returns random T within [0..1]
             *
             * @param index
             * @return
             */

/**
 * This method returns random T within [0..to]
 *
 * @param index
 * @param to
 * @return
 */

/**
 * This method returns random T within [from..to]
 *
 * @param index
 * @param from
 * @param to
 * @return
 */

        }

        @Namespace("sd::random") @NoOffset public static class IGenerator extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public IGenerator(Pointer p) { super(p); }
        


            public native RandomBuffer getBuffer();

            public native void setOffset(@Cast("Nd4jLong") long offset);

            public native @Cast("Nd4jLong") long getElementAbsolute(@Cast("Nd4jLong") long _position);

            public native @Cast("Nd4jLong") long getElementRelative(@Cast("Nd4jLong") long _position);

            public native void refreshBuffer();
        }



        @Namespace("sd::random") @NoOffset public static class Xoroshiro128 extends IGenerator {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Xoroshiro128(Pointer p) { super(p); }
        
            public Xoroshiro128(RandomBuffer buffer) { super((Pointer)null); allocate(buffer); }
            private native void allocate(RandomBuffer buffer);

            public native void refreshBuffer();
        }
    

// #endif //LIBND4J_HELPER_GENERATOR_H


// Parsed from graph/profiling/GraphProfile.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef ND4J_GRAPH_PROFILE_H
// #define ND4J_GRAPH_PROFILE_H

// #include "NodeProfile.h"
// #include <system/pointercast.h>
// #include <system/dll.h>
// #include <vector>
// #include <string>
// #include <map>
// #include <chrono>
        @Namespace("sd::graph") @NoOffset public static class GraphProfile extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public GraphProfile(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public GraphProfile(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public GraphProfile position(long position) {
                return (GraphProfile)super.position(position);
            }
            @Override public GraphProfile getPointer(long i) {
                return new GraphProfile((Pointer)this).position(position + i);
            }
        
            public GraphProfile() { super((Pointer)null); allocate(); }
            private native void allocate();

            /**
             * These methods just adding amount of bytes to various counters
             */
            public native void addToTotal(@Cast("Nd4jLong") long bytes);
            public native void addToActivations(@Cast("Nd4jLong") long bytes);
            public native void addToTemporary(@Cast("Nd4jLong") long bytes);
            public native void addToObjects(@Cast("Nd4jLong") long bytes);

            /**
             * This method allows to set graph construction (i.e. deserialization) time in nanoseconds
             */
            public native void setBuildTime(@Cast("Nd4jLong") long nanos);

            /**
             * This method sets graph execution time in nanoseconds.
             */
            public native void setExecutionTime(@Cast("Nd4jLong") long nanos);

            public native void startEvent(@Cast("char*") String name);
            public native void startEvent(@Cast("char*") BytePointer name);
            public native void recordEvent(@Cast("char*") String name);
            public native void recordEvent(@Cast("char*") BytePointer name);
            public native void deleteEvent(@Cast("char*") String name);
            public native void deleteEvent(@Cast("char*") BytePointer name);

            /**
             * This method saves time as delta from last saved time
             */
            public native void spotEvent(@Cast("char*") String name);
            public native void spotEvent(@Cast("char*") BytePointer name);

            /**
             * This method returns pointer to NodeProfile by ID
             * PLEASE NOTE: this method will create new NodeProfile if there's none
             */
            public native NodeProfile nodeById(int id, @Cast("char*") String name/*=nullptr*/);
            public native NodeProfile nodeById(int id);
            public native NodeProfile nodeById(int id, @Cast("char*") BytePointer name/*=nullptr*/);
            public native @Cast("bool") boolean nodeExists(int id);

            /**
             * This method merges values from other profile report
             * @param other
             */
            public native void merge(GraphProfile other);
            public native void assign(GraphProfile other);

            /**
             * These methods are just utility methods for time
             */
            public native @Cast("Nd4jLong") long currentTime();
            public native @Cast("Nd4jLong") long relativeTime(@Cast("Nd4jLong") long time);

            public native void printOut();
        }
    


// #endif

// Parsed from graph/profiling/NodeProfile.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_NODE_PROFILE_H
// #define LIBND4J_NODE_PROFILE_H

// #include <system/pointercast.h>
// #include <system/dll.h>
// #include <string>
// #include <vector>
        @Namespace("sd::graph") @NoOffset public static class NodeProfile extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public NodeProfile(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public NodeProfile(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public NodeProfile position(long position) {
                return (NodeProfile)super.position(position);
            }
            @Override public NodeProfile getPointer(long i) {
                return new NodeProfile((Pointer)this).position(position + i);
            }
        
            public NodeProfile() { super((Pointer)null); allocate(); }
            private native void allocate();

            public NodeProfile(int id, @Cast("char*") String name) { super((Pointer)null); allocate(id, name); }
            private native void allocate(int id, @Cast("char*") String name);
            public NodeProfile(int id, @Cast("char*") BytePointer name) { super((Pointer)null); allocate(id, name); }
            private native void allocate(int id, @Cast("char*") BytePointer name);

            public native void setBuildTime(@Cast("Nd4jLong") long time);
            public native void setPreparationTime(@Cast("Nd4jLong") long time);
            public native void setExecutionTime(@Cast("Nd4jLong") long time);
            public native void setTotalTime(@Cast("Nd4jLong") long time);
            public native void setShapeFunctionTime(@Cast("Nd4jLong") long time);
            public native void setArrayTime(@Cast("Nd4jLong") long time);
            public native void setInputTime(@Cast("Nd4jLong") long time);

            public native void setActivationsSize(@Cast("Nd4jLong") long bytes);
            public native void setTemporarySize(@Cast("Nd4jLong") long bytes);
            public native void setObjectsSize(@Cast("Nd4jLong") long bytes);
            public native void setTotalSize(@Cast("Nd4jLong") long bytes);

            public native void addInputShape(@Cast("const Nd4jLong*") LongPointer shapeInfo);
            public native void addInputShape(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
            public native void addInputShape(@Cast("const Nd4jLong*") long[] shapeInfo);
            public native void addOutputShape(@Cast("const Nd4jLong*") LongPointer shapeInfo);
            public native void addOutputShape(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
            public native void addOutputShape(@Cast("const Nd4jLong*") long[] shapeInfo);

            public native @Cast("Nd4jLong") long getActivationsSize();
            public native @Cast("Nd4jLong") long getTemporarySize();
            public native @Cast("Nd4jLong") long getObjectsSize();
            public native @Cast("Nd4jLong") long getTotalSize();

            public native @Cast("Nd4jLong") long getExecutionTime();

            public native @StdString @ByRef @Cast({"char*", "std::string*"}) BytePointer name();

            public native void merge(NodeProfile other);
            public native void assign(NodeProfile other);

            public native void printOut();
        }
    


// #endif

// Parsed from graph/Context.h

/*
 *  ******************************************************************************
 *  *
 *  *
 *  * This program and the accompanying materials are made available under the
 *  * terms of the Apache License, Version 2.0 which is available at
 *  * https://www.apache.org/licenses/LICENSE-2.0.
 *  *
 *  *  See the NOTICE file distributed with this work for additional
 *  *  information regarding copyright ownership.
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  * License for the specific language governing permissions and limitations
 *  * under the License.
 *  *
 *  * SPDX-License-Identifier: Apache-2.0
 *  *****************************************************************************
 */

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_CONTEXT_H
// #define LIBND4J_CONTEXT_H

// #include <vector>
// #include <array/NDArray.h>
// #include <graph/Variable.h>
// #include <graph/VariableSpace.h>
// #include <graph/ContextPrototype.h>
// #include <memory/Workspace.h>
// #include <execution/Engine.h>

// CUDA-specific includes
// #ifdef __CUDACC__
// #endif
        /**
         * This class defines input desired for any given node/operation within graph
         */
        @Namespace("sd::graph") @NoOffset public static class Context extends ContextPrototype {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public Context(Pointer p) { super(p); }
        
            public Context(ContextPrototype prototype, VariableSpace variableSpace) { super((Pointer)null); allocate(prototype, variableSpace); }
            private native void allocate(ContextPrototype prototype, VariableSpace variableSpace);

            public Context(int nodeId, VariableSpace variableSpace/*=nullptr*/) { super((Pointer)null); allocate(nodeId, variableSpace); }
            private native void allocate(int nodeId, VariableSpace variableSpace/*=nullptr*/);
            public Context(int nodeId) { super((Pointer)null); allocate(nodeId); }
            private native void allocate(int nodeId);
            public Context(int nodeId, VariableSpace variableSpace, @Cast("bool") boolean isInplace) { super((Pointer)null); allocate(nodeId, variableSpace, isInplace); }
            private native void allocate(int nodeId, VariableSpace variableSpace, @Cast("bool") boolean isInplace);

            // default destructor

            // these methods are for execution timing
            public native void setOuterTime(@Cast("Nd4jLong") long time);
            public native void setInnerTime(@Cast("Nd4jLong") long time);
            public native @Cast("Nd4jLong") long getOuterTime();
            public native @Cast("Nd4jLong") long getInnerTime();

            public native @Cast("sd::DataType") int dataType();

            public native @Cast("sd::DataType") int dataType(int index);
            public native void setDataType(int index, @Cast("sd::DataType") int type);
            // these methods are related to Workspace abstraction
            public native @Cast("bool") boolean hasWorkspaceProvided();
            public native void attachWorkspace(Workspace workspace);
            public native void forgetWorkspace();

            // these methods return full-time workspace
            public native Workspace getWorkspace();
            public native Workspace workspace();
            public native Workspace fWorkspace();

            // this method returns workspace for temporary allocations
            public native Workspace tWorkspace();

            // this method returns workspace for object allocations
            public native Workspace oWorkspace();

            public native void setVariableSpace(VariableSpace variableSpace);

            public native RandomBuffer getRNG();
            public native void setRNG(RandomBuffer rng);

            public native void setTargetEngine(@Cast("samediff::Engine") int engine);

            public native VariableSpace getVariableSpace();

            public native LaunchContext launchContext();

            // these fields define, if we can execute specific node in-place, without generating new array


            // these variables are only for Divergent Nodes
            public native int getBranch();
            public native void setBranch(int branch);

            /**
             *
             * @return
             */
            public native Stash getStash();

            /**
             *
             */
            public native void trackList(NDArrayList list);


            /**
             * This method returns variable for a given input index for this block
             * @param idx
             * @return
             */
            public native Variable getVariable(int idx);
            public native Variable variable(int idx);

            /**
             * This method is shortcut to getVariable(int idx);
             *
             * + it check fastpath for array availability (preferred)
             * @return
             */
            public native NDArray getNDArray(int idx);
            public native NDArray array(int idx);


            /**
             * This method fetches variable from VariableSpace DIRECTLY
             * @param p
             * @return
             */
            public native Variable variable(int node, int index);
            public native Variable variable(@ByRef IntIntPair p);


            public native void pushNDArrayToVariableSpace(int nodeId, int index, NDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(int nodeId, int index, NDArray array);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, NDArray array, @Cast("bool") boolean removable/*=true*/);
            public native void pushNDArrayToVariableSpace(@ByRef IntIntPair pair, NDArray array);

            public native void pushNDArrayListToVariableSpace(int nodeId, int index, NDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(int nodeId, int index, NDArrayList list);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, NDArrayList list, @Cast("bool") boolean track/*=true*/);
            public native void pushNDArrayListToVariableSpace(@ByRef IntIntPair pair, NDArrayList list);

            public native @Cast("bool") boolean isValueAvailable(int idx/*=0*/);
            public native @Cast("bool") boolean isValueAvailable();

            public native Variable ensureVariable(int idx/*=0*/);
            public native Variable ensureVariable();

            public native @Cast("unsigned long") long width();

            // methods used in java interop
            /**
             * This method checks if Context uses fastpath variable access
             * @return
             */
            public native @Cast("bool") boolean isFastPath();

            /**
             * Method allows to forbid FastPath execution
             * @param reallyForbid
             */
            public native void forbidFastPath(@Cast("bool") boolean reallyForbid);

// #ifndef __JAVACPP_HACK__
// #endif

            public native void setInputArray(int index, NDArray array, @Cast("bool") boolean removable/*=false*/);
            public native void setInputArray(int index, NDArray array);
            public native void setInputArray(int index, Pointer buffer, @Const Pointer shapeInfo, Pointer specialBuffer, @Const Pointer specialShapeInfo);
            public native void setInputArray(int index, Pointer databuffer, @Const Pointer shapeInfo, @Const Pointer specialShapeInfo);

            public native void setOutputArray(int index, NDArray array, @Cast("bool") boolean removable/*=false*/);
            public native void setOutputArray(int index, NDArray array);
            public native void setOutputArray(int index, Pointer buffer, @Const Pointer shapeInfo, Pointer specialBuffer, @Const Pointer specialShapeInfo);
            public native void setOutputArray(int index, Pointer databuffer, @Const Pointer shapeInfo, @Const Pointer specialShapeInfo);

            public native void setTArguments(DoublePointer arguments, int numberOfArguments);
            public native void setTArguments(DoubleBuffer arguments, int numberOfArguments);
            public native void setTArguments(double[] arguments, int numberOfArguments);
            public native void setIArguments(@Cast("Nd4jLong*") LongPointer arguments, int numberOfArguments);
            public native void setIArguments(@Cast("Nd4jLong*") LongBuffer arguments, int numberOfArguments);
            public native void setIArguments(@Cast("Nd4jLong*") long[] arguments, int numberOfArguments);
            public native void setBArguments(@Cast("bool*") BooleanPointer arguments, int numberOfArguments);
            public native void setBArguments(@Cast("bool*") boolean[] arguments, int numberOfArguments);
            public native void setDArguments(@Cast("sd::DataType*") IntPointer arguments, int numberOfArguments);
            public native void setDArguments(@Cast("sd::DataType*") IntBuffer arguments, int numberOfArguments);
            public native void setDArguments(@Cast("sd::DataType*") int[] arguments, int numberOfArguments);

            public native void setTArguments(@StdVector DoublePointer tArgs);
            public native void setTArguments(@StdVector DoubleBuffer tArgs);
            public native void setTArguments(@StdVector double[] tArgs);
            public native void setIArguments(@Cast("Nd4jLong*") @StdVector LongPointer tArgs);
            public native void setIArguments(@Cast("Nd4jLong*") @StdVector LongBuffer tArgs);
            public native void setIArguments(@Cast("Nd4jLong*") @StdVector long[] tArgs);
            public native void setBArguments(@Cast("bool*") @StdVector BooleanPointer tArgs);
            public native void setBArguments(@Cast("bool*") @StdVector boolean[] tArgs);
            public native void setDArguments(@Cast("sd::DataType*") @StdVector IntPointer dArgs);
            public native void setDArguments(@Cast("sd::DataType*") @StdVector IntBuffer dArgs);
            public native void setDArguments(@Cast("sd::DataType*") @StdVector int[] dArgs);

            /**
             * This method purges fastpath in/out contents and releases all the handles.
             *
             * PLEASE NOTE: I/T/B/D args will stay intact
             */
            public native void clearFastPath();

            public native void setCudaContext(@Cast("Nd4jPointer") Pointer cudaStream, @Cast("Nd4jPointer") Pointer reductionPointer, @Cast("Nd4jPointer") Pointer allocationPointer);

            public native void allowHelpers(@Cast("bool") boolean reallyAllow);
            public native @Cast("bool") boolean helpersAllowed();

            public native void setShapeFunctionOverride(@Cast("bool") boolean reallyOverride);
            public native @Cast("bool") boolean shapeFunctionOverride();

            public native @Cast("samediff::ExecutionMode") int executionMode();
            public native void setExecutionMode(@Cast("samediff::ExecutionMode") int executionMode);

            public native @Cast("bool") boolean isTraining();
            public native @Cast("bool") boolean isInference();
        }
    



// #endif //LIBND4J_BLOCK_H


// Parsed from graph/ContextPrototype.h

/*******************************************************************************
 * Copyright (c) 2015-2018 Skymind, Inc.
 * Copyright (c) 2019-2020 Konduit K.K.
 *
/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef ND4J_CONTEXT_PROTOTYPE_H
// #define ND4J_CONTEXT_PROTOTYPE_H

// #include <vector>
// #include <system/Environment.h>
// #include <array/DataType.h>
// #include <system/dll.h>
// #include <graph/RandomGenerator.h>
// #include <ops/declarable/OpDescriptor.h>
// #include <execution/Engine.h>
// #include <execution/ExecutionMode.h>

// #ifndef __STANDALONE_BUILD__
// #include <config.h>
// #endif

        @Namespace("sd::graph") @NoOffset public static class ContextPrototype extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public ContextPrototype(Pointer p) { super(p); }
            /** Native array allocator. Access with {@link Pointer#position(long)}. */
            public ContextPrototype(long size) { super((Pointer)null); allocateArray(size); }
            private native void allocateArray(long size);
            @Override public ContextPrototype position(long position) {
                return (ContextPrototype)super.position(position);
            }
            @Override public ContextPrototype getPointer(long i) {
                return new ContextPrototype((Pointer)this).position(position + i);
            }
        
            public ContextPrototype(OpDescriptor opDescriptor/*=nullptr*/, int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/) { super((Pointer)null); allocate(opDescriptor, nodeId, inPlace); }
            private native void allocate(OpDescriptor opDescriptor/*=nullptr*/, int nodeId/*=1*/, @Cast("bool") boolean inPlace/*=false*/);
            public ContextPrototype() { super((Pointer)null); allocate(); }
            private native void allocate();

            public native int getNodeId();
            public native int nodeId();

            // this method returns true, if inputs are defined
            public native @Cast("bool") boolean hasVariablesFilled();

            public native void setOpDescriptor(OpDescriptor opDescriptor);

            public native @Cast("sd::DataType") int dataType();
            public native @Cast("sd::DataType") int dataType(int index);
            public native void setDataType(int index, @Cast("sd::DataType") int type);

            public native @Cast("bool") boolean isInplace();
            public native void markInplace(@Cast("bool") boolean reallyInplace);

            public native void pickInput(int input);
            public native void pickInput(int input, int index);
            public native void pickInput(@ByRef IntIntPair p);
            public native void fillInputs(@StdVector IntPointer inputs);
            public native void fillInputs(@StdVector IntBuffer inputs);
            public native void fillInputs(@StdVector int[] inputs);
            public native @StdVector IntIntPair inputs();

            public native @StdVector DoublePointer getTArguments();
            public native @StdVector IntPointer getIArguments();
            public native @Cast("bool*") @StdVector BooleanPointer getBArguments();
            public native @Cast("sd::DataType*") @StdVector IntPointer getDArguments();
            public native @StdVector IntPointer getAxis();

            public native @Cast("samediff::Engine") int engine();

            public native @Cast("size_t") long numT();
            public native @Cast("size_t") long numI();
            public native @Cast("size_t") long numB();
            public native @Cast("size_t") long numD();

            public native IntIntPair input(int idx);

            public native int opNum();
            public native void setOpNum(int opNum);

            public native @Cast("bool") boolean isUseMKLDNN();
            public native void setUseMKLDNN(@Cast("bool") boolean useMKLDNN);

            /**
             * This method returns number of inputs available in this block
             * @return
             */
            public native @Cast("unsigned long") long width();

            // just a clone
            public native ContextPrototype clone();

            public native @ByRef RandomGenerator randomGenerator();
            public native @Const @ByRef RandomGenerator getRng();
            public native void setRng(@Const @ByRef RandomGenerator anotherRng);
            public native void setRandomGenerator(@Const @ByRef RandomGenerator anotherRng);
            public native @Cast("uint64_t") long randomSeed();
            public native void setRandomSeed(@Cast("uint64_t") long seed);
        }
    


// #endif //ND4J_CONTEXT_PROTOTYPE_H


// Parsed from graph/ResultWrapper.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 11/06/18.
//

// #ifndef LIBND4J_RESULTWRAPPER_H
// #define LIBND4J_RESULTWRAPPER_H

// #include <system/op_boilerplate.h>
// #include <system/pointercast.h>
// #include <system/dll.h>
        @Namespace("sd::graph") @NoOffset public static class ResultWrapper extends org.nd4j.nativeblas.ResultWrapperAbstraction {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public ResultWrapper(Pointer p) { super(p); }
        
            public ResultWrapper(@Cast("Nd4jLong") long size, @Cast("Nd4jPointer") Pointer ptr) { super((Pointer)null); allocate(size, ptr); }
            private native void allocate(@Cast("Nd4jLong") long size, @Cast("Nd4jPointer") Pointer ptr);

            public native @Cast("Nd4jLong") long size();

            public native @Cast("Nd4jPointer") Pointer pointer();
        }
    



// #endif //LIBND4J_RESULTWRAPPER_H


// Parsed from helpers/shape.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

/*
 * shape.h
 *
 *  Created on: Dec 28, 2015
 *      Author: agibsonccc
 */

// #ifndef SHAPE_H_
// #define SHAPE_H_

// #include <cstring>
// #include <cstdio>
// #include "system/dll.h"
// #include "system/nd4jmalloc.h"
// #include "math/templatemath.h"
// #include "../helpers/logger.h"
// #include "system/pointercast.h"
// #include "../cnpy/cnpy.h"
// #include <system/op_boilerplate.h>

public static final int MAX_DIMENSION = 0x7fffffff;
public static final int MAX_NUM_THREADS =  1024;
public static final int MAX_RANK = 32;
public static final int MAX_SHAPEINFOLENGTH = 2*MAX_RANK+4;
public static final int MAX_COORD = 3;
public static final int PREALLOC_SIZE = 33554432;
// #ifdef __CUDACC__
// #endif


// #ifdef __CUDACC__
// #else
// #define INLINEDEF inline
// #endif

// #include "system/pairwise_util.h"
// #include <stdint.h>
// #include <array/ArrayOptions.h>

/**
 * Shape information approximating
 * the information on an ndarray
 */
    @Namespace("shape") @NoOffset public static class ShapeInformation extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ShapeInformation(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ShapeInformation(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ShapeInformation position(long position) {
            return (ShapeInformation)super.position(position);
        }
        @Override public ShapeInformation getPointer(long i) {
            return new ShapeInformation((Pointer)this).position(position + i);
        }
    
        public ShapeInformation(@Cast("Nd4jLong*") LongPointer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongPointer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") LongPointer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongPointer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);
        public ShapeInformation() { super((Pointer)null); allocate(); }
        private native void allocate();
        public ShapeInformation(@Cast("Nd4jLong*") LongBuffer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") LongBuffer shape_/*=nullptr*/, @Cast("Nd4jLong*") LongBuffer stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);
        public ShapeInformation(@Cast("Nd4jLong*") long[] shape_/*=nullptr*/, @Cast("Nd4jLong*") long[] stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/) { super((Pointer)null); allocate(shape_, stride_, order_, rank_, offset_, elementWiseStride_); }
        private native void allocate(@Cast("Nd4jLong*") long[] shape_/*=nullptr*/, @Cast("Nd4jLong*") long[] stride_/*=nullptr*/, char order_/*=0*/, int rank_/*=0*/, int offset_/*=0*/, int elementWiseStride_/*=0*/);

        public native @Cast("Nd4jLong*") LongPointer shape(); public native ShapeInformation shape(LongPointer setter);
        public native @Cast("Nd4jLong*") LongPointer stride(); public native ShapeInformation stride(LongPointer setter);
        public native char order(); public native ShapeInformation order(char setter);
        public native int rank(); public native ShapeInformation rank(int setter);
        public native int offset(); public native ShapeInformation offset(int setter);
        public native int elementWiseStride(); public native ShapeInformation elementWiseStride(int setter);
    }

/**
 * Indexing information
 * for bounds checking
 */
    @Namespace("shape") public static class CurrentIndexing extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public CurrentIndexing() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public CurrentIndexing(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public CurrentIndexing(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public CurrentIndexing position(long position) {
            return (CurrentIndexing)super.position(position);
        }
        @Override public CurrentIndexing getPointer(long i) {
            return new CurrentIndexing((Pointer)this).position(position + i);
        }
    
        public native int numElementsPerThread(); public native CurrentIndexing numElementsPerThread(int setter);
        public native int blockStartingIndex(); public native CurrentIndexing blockStartingIndex(int setter);
        public native int startingThreadIndex(); public native CurrentIndexing startingThreadIndex(int setter);
        public native int endingThreadIndex(); public native CurrentIndexing endingThreadIndex(int setter);

    }



    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(int shape1Rank, @Cast("const Nd4jLong*") LongPointer shape1, int shape2Rank, @Cast("const Nd4jLong*") LongPointer shape2);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(int shape1Rank, @Cast("const Nd4jLong*") LongBuffer shape1, int shape2Rank, @Cast("const Nd4jLong*") LongBuffer shape2);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(int shape1Rank, @Cast("const Nd4jLong*") long[] shape1, int shape2Rank, @Cast("const Nd4jLong*") long[] shape2);

    @Namespace("shape") public native @Cast("const Nd4jLong*") LongPointer detachShape(@Cast("const Nd4jLong*") LongPointer originalShape);
    @Namespace("shape") public native @Cast("const Nd4jLong*") LongBuffer detachShape(@Cast("const Nd4jLong*") LongBuffer originalShape);
    @Namespace("shape") public native @Cast("const Nd4jLong*") long[] detachShape(@Cast("const Nd4jLong*") long[] originalShape);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer copyShape(@Cast("const Nd4jLong*") LongPointer originalShape);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer copyShape(@Cast("const Nd4jLong*") LongBuffer originalShape);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] copyShape(@Cast("const Nd4jLong*") long[] originalShape);

    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2);

    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2, @Cast("const Nd4jLong*") LongPointer shapeInfo3);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2, @Cast("const Nd4jLong*") LongBuffer shapeInfo3);
    @Namespace("shape") public native @Cast("bool") boolean shapeEquals(@Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2, @Cast("const Nd4jLong*") long[] shapeInfo3);

    @Namespace("shape") public native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("const Nd4jLong*") LongPointer shape1,int shape2Rank, @Cast("const Nd4jLong*") LongPointer shape2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("const Nd4jLong*") LongBuffer shape1,int shape2Rank, @Cast("const Nd4jLong*") LongBuffer shape2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(int shape1Rank,@Cast("const Nd4jLong*") long[] shape1,int shape2Rank, @Cast("const Nd4jLong*") long[] shape2);

    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2);

    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") LongPointer stride1,int rank1, @Cast("const Nd4jLong*") LongPointer stride2, int rank2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") LongBuffer stride1,int rank1, @Cast("const Nd4jLong*") LongBuffer stride2, int rank2);
    @Namespace("shape") public native @Cast("bool") boolean strideEquals(@Cast("const Nd4jLong*") long[] stride1,int rank1, @Cast("const Nd4jLong*") long[] stride2, int rank2);

    @Namespace("shape") public native @Cast("bool") boolean equalsSoft(@Cast("const Nd4jLong*") LongPointer shapeA, @Cast("const Nd4jLong*") LongPointer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsSoft(@Cast("const Nd4jLong*") LongBuffer shapeA, @Cast("const Nd4jLong*") LongBuffer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsSoft(@Cast("const Nd4jLong*") long[] shapeA, @Cast("const Nd4jLong*") long[] shapeB);

    @Namespace("shape") public native @Cast("bool") boolean equalsTypesAndShapesSoft(@Cast("const Nd4jLong*") LongPointer shapeA, @Cast("const Nd4jLong*") LongPointer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsTypesAndShapesSoft(@Cast("const Nd4jLong*") LongBuffer shapeA, @Cast("const Nd4jLong*") LongBuffer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsTypesAndShapesSoft(@Cast("const Nd4jLong*") long[] shapeA, @Cast("const Nd4jLong*") long[] shapeB);

    @Namespace("shape") public native @Cast("bool") boolean equalsStrict(@Cast("const Nd4jLong*") LongPointer shapeA, @Cast("const Nd4jLong*") LongPointer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsStrict(@Cast("const Nd4jLong*") LongBuffer shapeA, @Cast("const Nd4jLong*") LongBuffer shapeB);
    @Namespace("shape") public native @Cast("bool") boolean equalsStrict(@Cast("const Nd4jLong*") long[] shapeA, @Cast("const Nd4jLong*") long[] shapeB);

    // returns true if ranks, shapes and strides are the same
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2);
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2, @Cast("const Nd4jLong*") LongPointer shapeInfo3);
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2, @Cast("const Nd4jLong*") LongBuffer shapeInfo3);
    @Namespace("shape") public native @Cast("bool") boolean haveSameShapeAndStrides(@Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2, @Cast("const Nd4jLong*") long[] shapeInfo3);

    @Namespace("shape") public native int sizeAt(@Cast("const Nd4jLong*") LongPointer shapeInfo, int dim);
    @Namespace("shape") public native int sizeAt(@Cast("const Nd4jLong*") LongBuffer shapeInfo, int dim);
    @Namespace("shape") public native int sizeAt(@Cast("const Nd4jLong*") long[] shapeInfo, int dim);
    @Namespace("shape") public native @Cast("Nd4jLong") long strideAt(@Cast("const Nd4jLong*") LongPointer shapeInfo, int dim);
    @Namespace("shape") public native @Cast("Nd4jLong") long strideAt(@Cast("const Nd4jLong*") LongBuffer shapeInfo, int dim);
    @Namespace("shape") public native @Cast("Nd4jLong") long strideAt(@Cast("const Nd4jLong*") long[] shapeInfo, int dim);

    @Namespace("shape") public native void traceNew(int id);


    @Namespace("shape") public native int tadIndexForLinear(int linearIndex, int tadLength);

    @Namespace("shape") public native @Cast("Nd4jLong") long tadLength(@Cast("const Nd4jLong*") LongPointer shapeInfo, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tadLength(@Cast("const Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tadLength(@Cast("const Nd4jLong*") long[] shapeInfo, int[] dimension, int dimensionLength);

    @Namespace("shape") public native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") LongPointer oldShape, int newRank, @Cast("Nd4jLong*") LongPointer newShape, @Cast("bool") boolean isFOrder);
    @Namespace("shape") public native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") LongBuffer oldShape, int newRank, @Cast("Nd4jLong*") LongBuffer newShape, @Cast("bool") boolean isFOrder);
    @Namespace("shape") public native @Cast("bool") boolean canReshape(int oldRank, @Cast("Nd4jLong*") long[] oldShape, int newRank, @Cast("Nd4jLong*") long[] newShape, @Cast("bool") boolean isFOrder);

    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") LongPointer oldShapeInfo, byte newOrder, int newRank, @Cast("const Nd4jLong*") LongPointer newShape, @Cast("Nd4jLong*") LongPointer newShapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") LongBuffer oldShapeInfo, byte newOrder, int newRank, @Cast("const Nd4jLong*") LongBuffer newShape, @Cast("Nd4jLong*") LongBuffer newShapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") long[] oldShapeInfo, byte newOrder, int newRank, @Cast("const Nd4jLong*") long[] newShape, @Cast("Nd4jLong*") long[] newShapeInfo);
    /**
    * newShapeInfo contains rank, shape and order only, no strides/ews/type
    */
    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") LongPointer oldShapeInfo, @Cast("Nd4jLong*") LongPointer newShapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") LongBuffer oldShapeInfo, @Cast("Nd4jLong*") LongBuffer newShapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean reshapeC(@Cast("const Nd4jLong*") long[] oldShapeInfo, @Cast("Nd4jLong*") long[] newShapeInfo);

    /**
    * Get the shape info buffer
    * for the given rank and shape.
    */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongPointer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") long[] shape);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeBuffer(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] buffer);

    /**
    * Get the shape info buffer
    * for the given rank and shape.
     */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongPointer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") long[] shape);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer output);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer output);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeBufferFortran(int rank, @Cast("sd::DataType") int dtype, @Cast("const Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] output);

// #ifdef __CUDACC__
// #endif



/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("const Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("const Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("const Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("const Nd4jLong*") LongPointer shape, int rank, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("const Nd4jLong*") LongBuffer shape, int rank, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("const Nd4jLong*") long[] shape, int rank, @Cast("Nd4jLong*") long[] ret);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("const Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("const Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStrides(@Cast("const Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("const Nd4jLong*") LongPointer shape, int rank, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("const Nd4jLong*") LongBuffer shape, int rank, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStrides(@Cast("const Nd4jLong*") long[] shape, int rank, @Cast("Nd4jLong*") long[] ret);

    @Namespace("shape") public native void updateStrides(@Cast("Nd4jLong*") LongPointer shape, byte order);
    @Namespace("shape") public native void updateStrides(@Cast("Nd4jLong*") LongBuffer shape, byte order);
    @Namespace("shape") public native void updateStrides(@Cast("Nd4jLong*") long[] shape, byte order);
    @Namespace("shape") public native void updateStrides(int rank, @Cast("const Nd4jLong*") LongPointer shapeOnly, @Cast("Nd4jLong*") LongPointer stridesOnly, byte order);
    @Namespace("shape") public native void updateStrides(int rank, @Cast("const Nd4jLong*") LongBuffer shapeOnly, @Cast("Nd4jLong*") LongBuffer stridesOnly, byte order);
    @Namespace("shape") public native void updateStrides(int rank, @Cast("const Nd4jLong*") long[] shapeOnly, @Cast("Nd4jLong*") long[] stridesOnly, byte order);


// check whether input dimensions are permuted, not permuted dimensions order have to be 0,....,rank-1

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("const Nd4jLong*") LongPointer shape, int rank, int startNum);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("const Nd4jLong*") LongBuffer shape, int rank, int startNum);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("const Nd4jLong*") long[] shape, int rank, int startNum);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStridesFortran(@Cast("const Nd4jLong*") LongPointer shape, int rank, int startNum, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStridesFortran(@Cast("const Nd4jLong*") LongBuffer shape, int rank, int startNum, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStridesFortran(@Cast("const Nd4jLong*") long[] shape, int rank, int startNum, @Cast("Nd4jLong*") long[] ret);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("const Nd4jLong*") LongPointer shape, int rank, int startNum);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("const Nd4jLong*") LongBuffer shape, int rank, int startNum);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStrides(@Cast("const Nd4jLong*") long[] shape, int rank, int startNum);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer calcStrides(@Cast("const Nd4jLong*") LongPointer shape, int rank, int startNum, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer calcStrides(@Cast("const Nd4jLong*") LongBuffer shape, int rank, int startNum, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] calcStrides(@Cast("const Nd4jLong*") long[] shape, int rank, int startNum, @Cast("Nd4jLong*") long[] ret);

/**
 * @param toCopy the shape to copy
 * @return a copy of the original struct
 */
    @Namespace("shape") public native ShapeInformation shapeCopy( ShapeInformation toCopy);


    @Namespace("shape") public native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public native @Cast("bool") boolean strideDescendingCAscendingF(@Cast("const Nd4jLong*") long[] shapeBuffer);

    @Namespace("shape") public native @Cast("bool") boolean isContiguous(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isContiguous(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isContiguous(@Cast("const Nd4jLong*") long[] shapeInfo);


/**
 * copy-past from java hasDefaultStridesForShape function
 * check whether array is not permuted and has contiguous elements in memory
 */
    @Namespace("shape") public native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean areStridesDefault(@Cast("const Nd4jLong*") long[] shapeInfo);


/**
 * Compute the element wise stride
 * for a given shape/stride configuration
 * @param rank the rank of the shape/stride
 * @param shape the shape
 * @param stride the stride
 * @param isFOrder 0 or 1 for whether the array is f
 * ordered or not
 * @return 0 if there is no element wise stride the
 * element wise stride of reshape(1,length) otherwise
 */
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer stride, int isFOrder);
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer stride, int isFOrder);
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] stride, int isFOrder);

/**
 * Compute the element wise stride
 * for a given shape/stride configuration
 * @param rank the rank of the shape/stride
 * @param shape the shape
 * @param stride the stride
 * @param isFOrder 0 or 1 for whether the array is f
 * ordered or not
 * @return 0 if there is no element wise stride the
 * element wise stride of reshape(1,length) otherwise
 */
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer stride, int isFOrder, @Cast("const Nd4jLong*") LongPointer dimension, int dimensionLength);
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer stride, int isFOrder, @Cast("const Nd4jLong*") LongBuffer dimension, int dimensionLength);
    @Namespace("shape") public native int computeElementWiseStride(int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] stride, int isFOrder, @Cast("const Nd4jLong*") long[] dimension, int dimensionLength);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeInfoOnlyShapeAndStride(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] dimension, int dimensionLength,@Cast("bool") boolean reverseCopyStride, @Cast("Nd4jLong*") long[] buffer);
/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer doPermuteSwap(int length, @Cast("Nd4jLong*") LongPointer shape, IntPointer rearrange);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer doPermuteSwap(int length, @Cast("Nd4jLong*") LongBuffer shape, IntBuffer rearrange);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] doPermuteSwap(int length, @Cast("Nd4jLong*") long[] shape, int[] rearrange);



/**
 * In place permute swap
 * @param length
 * @param shape
 * @param rearrange
 */
    @Namespace("shape") public native void doPermuteSwap(int length, @Cast("Nd4jLong**") PointerPointer shape, IntPointer rearrange);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer permuteShapeBuffer(@Cast("const Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer permuteShapeBuffer(@Cast("const Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] permuteShapeBuffer(@Cast("const Nd4jLong*") long[] shapeBuffer, int[] rearrange);

    @Namespace("shape") public native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") LongPointer shapeBuffer, IntPointer rearrange, @Cast("Nd4jLong*") LongPointer out);
    @Namespace("shape") public native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") LongBuffer shapeBuffer, IntBuffer rearrange, @Cast("Nd4jLong*") LongBuffer out);
    @Namespace("shape") public native void permuteShapeBufferInPlace(@Cast("Nd4jLong*") long[] shapeBuffer, int[] rearrange, @Cast("Nd4jLong*") long[] out);

    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongPointer shapeBuffer, @Const IntPointer rearrange, @Cast("Nd4jLong") long len/*=-1*/);
    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongPointer shapeBuffer, @Const IntPointer rearrange);
    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeBuffer, @Const IntBuffer rearrange, @Cast("Nd4jLong") long len/*=-1*/);
    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") LongBuffer shapeBuffer, @Const IntBuffer rearrange);
    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") long[] shapeBuffer, @Const int[] rearrange, @Cast("Nd4jLong") long len/*=-1*/);
    @Namespace("shape") public native void doPermuteShapeInfo(@Cast("Nd4jLong*") long[] shapeBuffer, @Const int[] rearrange);

    /**
     * Rearrange the permute indexes
     * according to which  dimensions are specified.
     *
     * For example, dimension is implicitly:
     * 0,1,2
     *
     * If you want to do a reduce along dimensions 0 and 1,
     * you need to permute the indexes to be:
     * 2,0,1
     *
     * which will give us the ability to ierate along an element
     * wise stride.
     */

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer createPermuteIndexes(int originalRank, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer createPermuteIndexes(int originalRank, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] createPermuteIndexes(int originalRank, int[] dimension,int dimensionLength);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer computeResultShape(@Cast("const Nd4jLong*") LongPointer originalShapeBuffer, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer computeResultShape(@Cast("const Nd4jLong*") LongBuffer originalShapeBuffer, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] computeResultShape(@Cast("const Nd4jLong*") long[] originalShapeBuffer, int[] dimension,int dimensionLength);

    /**
     * This method does inplace transpose of given shapeBuffer
     *
     * @param shapeBuffer
     */
    @Namespace("shape") public native void transposeInplace(@Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public native void transposeInplace(@Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public native void transposeInplace(@Cast("Nd4jLong*") long[] shapeBuffer);


/**
 * Get the ordering for the device
 * @param length
 * @param shape
 * @param stride
 * @param elementStride
 * @return
 */
    @Namespace("shape") public native char getOrder(int length, @Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int elementStride);
    @Namespace("shape") public native char getOrder(int length, @Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int elementStride);
    @Namespace("shape") public native char getOrder(int length, @Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int elementStride);

/**
 * Ensure that every value in the re arrange
 * array is unique
 * @param arr
 * @param shape
 * @param arrLength
 * @param shapeLength
 * @return
 */

/**
 * Permute the shape information
 * @param info the shape information to permute
 * @param rearrange the order to re arrange
 * @param rank the rank of the rearrange array
 */
    @Namespace("shape") public native void permute(@Cast("shape::ShapeInformation**") PointerPointer info, IntPointer rearrange, int rank);
    @Namespace("shape") public native void permute(@ByPtrPtr ShapeInformation info, IntPointer rearrange, int rank);
    @Namespace("shape") public native void permute(@ByPtrPtr ShapeInformation info, IntBuffer rearrange, int rank);
    @Namespace("shape") public native void permute(@ByPtrPtr ShapeInformation info, int[] rearrange, int rank);

/**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of cthe shape
 */
    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") long[] shape, int rank);


    /**
     * When 1 dimension is the whole length of the
     * array
     */
    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native int oneDimEqualToLength(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native int isVector(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native @Cast("bool") boolean isLikeVector(@Cast("const Nd4jLong*") LongPointer shapeInfo, @ByRef IntPointer posOfNonUnityDim);
    @Namespace("shape") public native @Cast("bool") boolean isLikeVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @ByRef IntBuffer posOfNonUnityDim);
    @Namespace("shape") public native @Cast("bool") boolean isLikeVector(@Cast("const Nd4jLong*") long[] shapeInfo, @ByRef int[] posOfNonUnityDim);

    @Namespace("shape") public native @Cast("bool") boolean isCommonVector(@Cast("const Nd4jLong*") LongPointer shapeInfo, @ByRef IntPointer posOfNonUnityDim);
    @Namespace("shape") public native @Cast("bool") boolean isCommonVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @ByRef IntBuffer posOfNonUnityDim);
    @Namespace("shape") public native @Cast("bool") boolean isCommonVector(@Cast("const Nd4jLong*") long[] shapeInfo, @ByRef int[] posOfNonUnityDim);

    @Namespace("shape") public native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isRowVector(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native @Cast("bool") boolean isColumnVector(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isColumnVector(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isColumnVector(@Cast("const Nd4jLong*") long[] shapeInfo);

    /**
    * shape - input inShape is shape only, not shapeInfo
    * returns number of non-unity dimensions in inShape
    */
    @Namespace("shape") public native int numOfNonUnitDims(int rank, @Cast("const Nd4jLong*") LongPointer inShape);
    @Namespace("shape") public native int numOfNonUnitDims(int rank, @Cast("const Nd4jLong*") LongBuffer inShape);
    @Namespace("shape") public native int numOfNonUnitDims(int rank, @Cast("const Nd4jLong*") long[] inShape);

    /**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of the shape
 */

    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") LongPointer shape, int rank);
    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") LongBuffer shape, int rank);
    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") long[] shape, int rank);

    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native int isMatrix(@Cast("const Nd4jLong*") long[] shapeInfo);
/**
 * Returns the shape portion of an information
 * buffer
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeOf(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeOf(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeOf(@Cast("Nd4jLong*") long[] shapeInfo);

/**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */

    /**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */
    /**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/
    @Namespace("shape") public native void copyTo(int length, @Cast("const Nd4jLong*") LongPointer from, @Cast("Nd4jLong*") LongPointer to, @Cast("Nd4jLong*") LongPointer indexes);
    @Namespace("shape") public native void copyTo(int length, @Cast("const Nd4jLong*") LongBuffer from, @Cast("Nd4jLong*") LongBuffer to, @Cast("Nd4jLong*") LongBuffer indexes);
    @Namespace("shape") public native void copyTo(int length, @Cast("const Nd4jLong*") long[] from, @Cast("Nd4jLong*") long[] to, @Cast("Nd4jLong*") long[] indexes);

/**
 * Permute the given strides
 * in the given rearrange order
 * @param toPermute the buffer to permute
 * @param shapeRank the length of the buffer to permute
 * @param rearrange the rearrange order (must be 0 based indexes
 * and all must be filled in)
 * @return the rearranged array
 */
    //ND4J_EXPORT _CUDA_HD Nd4jLong *permutedStrides(Nd4jLong *toPermute, int shapeRank, Nd4jLong *rearrange);

/**
 * Return the slice (shape + 1 in pointer arithmetic)
 * @param shape the shape to take the slice of
 * @return the shape array - the first entry
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer slice(@Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer slice(@Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] slice(@Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public native int slices(@Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public native int slices(@Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public native int slices(@Cast("Nd4jLong*") long[] shapeBuffer);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") LongPointer shapeBuffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") LongBuffer shapeBuffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] sliceOfShapeBuffer(@Cast("Nd4jLong") long sliceIdx, @Cast("Nd4jLong*") long[] shapeBuffer);
/**
 * Returns the length of the
 * shape information buffer:
 * rank * 2 + 3
 * @param rank the rank to get the shape
 * info length for
 * @return rank * 2 + 4
 */
    @Namespace("shape") public native int shapeInfoLength(int rank);

    @Namespace("shape") public native int shapeInfoLength(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native int shapeInfoLength(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native int shapeInfoLength(@Cast("Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native @Cast("size_t") long shapeInfoByteLength(int rank);

    @Namespace("shape") public native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("size_t") long shapeInfoByteLength(@Cast("const Nd4jLong*") long[] shapeInfo);

/**
 * Returns the rank portion of
 * an information buffer
 */
    @Namespace("shape") public native int rank(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native int rank(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native int rank(@Cast("const Nd4jLong*") long[] shapeInfo);
    @Namespace("shape") public native int rank(@Const IntPointer shapeInfo);
    @Namespace("shape") public native int rank(@Const IntBuffer shapeInfo);
    @Namespace("shape") public native int rank(@Const int[] shapeInfo);

    /**
    *  returns pointer on elementWiseStride
    */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer ews(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer ews(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] ews(@Cast("Nd4jLong*") long[] shapeInfo);

/**
 * Converts a raw int buffer of the layout:
 * rank
 * shape
 * stride
 * offset
 * elementWiseStride
 *
 * where shape and stride are both straight int pointers
 */
    @Namespace("shape") public native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native ShapeInformation infoFromBuffer(@Cast("Nd4jLong*") long[] buffer);

/**
 * Returns the stride portion of an information
 * buffer
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer stride(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer stride(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] stride(@Cast("Nd4jLong*") long[] buffer);

/**
 * Compute the length of the given shape
 */
    @Namespace("shape") public native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("bool") boolean isEmpty(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long length(@Cast("const Nd4jLong*") long[] shapeInfo);

/***
 * Returns the offset portion of an information buffer
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong") long offset(@Cast("Nd4jLong*") long[] buffer);

    @Namespace("shape") public native @Cast("Nd4jLong*") @ByRef LongPointer extra(@Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") @ByRef LongBuffer extra(@Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") @ByRef long[] extra(@Cast("Nd4jLong*") long[] buffer);

/**
 * Returns the ordering
 * for this shape information buffer
 */
    @Namespace("shape") public native char order(@Cast("const Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native char order(@Cast("const Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native char order(@Cast("const Nd4jLong*") long[] buffer);

/**
 * Returns the type
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long type(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long type(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long type(@Cast("const Nd4jLong*") long[] shapeInfo);

/**
 * Returns the element wise stride for this information
 * buffer
 */
   @Namespace("shape") public native @Cast("Nd4jLong") long elementWiseStride(@Cast("const Nd4jLong*") LongPointer shapeInfo);
   @Namespace("shape") public native @Cast("Nd4jLong") long elementWiseStride(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
   @Namespace("shape") public native @Cast("Nd4jLong") long elementWiseStride(@Cast("const Nd4jLong*") long[] shapeInfo);


    /**
 * Returns the element wise stride for this information
 * buffer
     * relative to a dimension and ordering for a reduction index
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") LongPointer buffer, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") LongBuffer buffer, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long reductionIndexElementWiseStride(@Cast("Nd4jLong*") long[] buffer, int[] dimension, int dimensionLength);

/**
 * Returns whether
 * the given shape info buffer
 * represents a scalar shape
 */
    @Namespace("shape") public native int isScalar(@Cast("const Nd4jLong*") LongPointer info);
    @Namespace("shape") public native int isScalar(@Cast("const Nd4jLong*") LongBuffer info);
    @Namespace("shape") public native int isScalar(@Cast("const Nd4jLong*") long[] info);

/**
 * Returns whether
 * the given shape information
 * represents a scalar
 * shape or not
 */
    @Namespace("shape") public native int isScalar(ShapeInformation info);

/**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
     * Iterate over a given set of indexes
     * the begin and end indexes are 0 based.
     * 1 padding is automatically assumed for the ending.
     *
     * For example if you want to iterate over 0 to 4
     * it will go to 4 rather than 3.
     *
     * indexes should be the indexes to exclude
     * indexes length should be the length of indexes
     */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer everyIndexBut(@Cast("const Nd4jLong*") LongPointer indexes,int indexesLength,int begin,int end);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer everyIndexBut(@Cast("const Nd4jLong*") LongBuffer indexes,int indexesLength,int begin,int end);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] everyIndexBut(@Cast("const Nd4jLong*") long[] indexes,int indexesLength,int begin,int end);

/**
 * Computes the offset for accessing
 * a global element given the shape information
 * and the offset to be read.
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    ND4J_EXPORT int tadOffset(shape::ShapeInformation *xInfo, int offset);

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer ensureVectorShape(@Cast("Nd4jLong*") LongPointer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer ensureVectorShape(@Cast("Nd4jLong*") LongBuffer shape);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] ensureVectorShape(@Cast("Nd4jLong*") long[] shape);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer createScalarShapeInfo();

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer createScalarShapeInfo(@Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer createScalarShapeInfo(@Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] createScalarShapeInfo(@Cast("Nd4jLong*") long[] ret);

/**
 * Generate an int buffer
 * up to the given length
 * at the specified increment
 *
 */

/**
 * Range between from and two with an
 * increment of 1
 */

/**
 * Keep the given indexes
 * in the data
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer keep(@Cast("Nd4jLong*") LongPointer data, @Const IntPointer index, int indexLength, int dataLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer keep(@Cast("Nd4jLong*") LongBuffer data, @Const IntBuffer index, int indexLength, int dataLength);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] keep(@Cast("Nd4jLong*") long[] data, @Const int[] index, int indexLength, int dataLength);

/**
 * Generate reverse copy of the data
 * @param data
 * @param length
 * @return
 */
/**
 *
 * @param arr1
 * @param arr1Length
 * @param arr2
 * @param arr2Length
 * @return
 */

/**
 *
 * @param numArrays
 * @param numTotalElements
 * @param arr
 * @param lengths
 * @return
 */

/**
 * Get the length per slice of the
 * given shape and the dimension
 * @param rank the rank of the shape
 * @param shape the shape of to get
 * the length per slice for
 * @param dimension the dimension to
 * get the length per slice for
 * @param dimensionLength the length of the dimension array
 * @return the length per slice of the given shape
 * along the given dimension
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Const IntPointer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Const IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long lengthPerSlice(int rank, @Cast("const Nd4jLong*") long[] shape, @Const int[] dimension, int dimensionLength);

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("const Nd4jLong*") LongPointer shape,
                                           @Cast("const Nd4jLong*") LongPointer tensorShape,
                                           int tensorShapeLength,
                                           @Const IntPointer dimension,
                                           int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("const Nd4jLong*") LongBuffer shape,
                                           @Cast("const Nd4jLong*") LongBuffer tensorShape,
                                           int tensorShapeLength,
                                           @Const IntBuffer dimension,
                                           int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long sliceOffsetForTensor(int rank,
                                           int index,
                                           @Cast("const Nd4jLong*") long[] shape,
                                           @Cast("const Nd4jLong*") long[] tensorShape,
                                           int tensorShapeLength,
                                           @Const int[] dimension,
                                           int dimensionLength);

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long sliceOffsetForTensor(int index,int tensorLength,int lengthPerSlice2);
/**
 * Computes the tensor along dimension
 * offset
 * @param index the index to get the offset for the tad for
 * @param rank the rank of the shapes and strides
 * @param info the shape information to use for tad
 * @param dimension the dimensions to use for computing the tensor along dimensions
 */
//    ND4J_EXPORT _CUDA_HD int offset(int index,
//                         int rank,
//                         shape::ShapeInformation *info,
//                         Nd4jLong *dimension,
//                         int dimensionLength);


/**
 * Computes the number
 * of tensors along
 * a given dimension
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") LongPointer shape,
                                            IntPointer dimension,
                                            int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") LongBuffer shape,
                                            IntBuffer dimension,
                                            int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(int rank,
                                            int length,
                                            @Cast("Nd4jLong*") long[] shape,
                                            int[] dimension,
                                            int dimensionLength);

/**
 * Computes the number
 * of tensors along
 * a given dimension
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") LongPointer shapeInfo, IntPointer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension, int dimensionLength);
    @Namespace("shape") public native @Cast("Nd4jLong") long tensorsAlongDimension(@Cast("Nd4jLong*") long[] shapeInfo, int[] dimension, int dimensionLength);



/**
 * Returns the tensor along dimension
 * for the given block index
 * @param blockSize
 * @param blockIdx
 * @param i
 * @return
 */
    @Namespace("shape") public native int tadForBlockIndex(int blockSize, int blockIdx, int i);

/**
 * Computes the number of tads per block
 *
 */
    @Namespace("shape") public native int tadsPerBlock(int blockSize, int tads);

//    ND4J_EXPORT _CUDA_HD Nd4jLong *tadShapeInfo(int index, Nd4jLong *xShapeInfo, Nd4jLong *dimension,
//                                int dimensionLength);

/**
 * Returns a shape buffer
 * for the shape information metadata.
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer toShapeBuffer( ShapeInformation info);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") LongPointer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") LongBuffer ret);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] toShapeBuffer( ShapeInformation info, @Cast("Nd4jLong*") long[] ret);

/**
 * Returns the number of elements per thread
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int numElementsPerThread(int N);

/**
 * Returns the block starting index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int blockStartingIndex(int N);

/**
 * Returns the thread starting index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int threadStartingIndex(int N, int stride, int offset);

/**
 * Returns the thread ending index
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    int threadEndingIndex(int N, int stride, int offset);

/**
 * Returns indexing information
 * for the current kernel invocation
 */
//#ifdef __CUDACC__
//    __device__
//#endif
//    CurrentIndexing *currentIndex(int N, int offset, int stride);

/** Given an linear index, element wise stride
 * and the length of each tad
 * map a linear index to a tad
 * @param i the index to map
 * @param the element wise stride for the tads
 * @param numElementsPerTad the number of elements
 * per tad
 */
    @Namespace("shape") public native int tadIndex(int i, int elementWiseStride, int numElementsPerTad);

/**
 * Map a tad to a
 * reduction index.
 * @param tadIndexForOriginal the original tad index for the
 * split up problem (eg: split is dimension 3 mapping to a 2,3 problem)
 * @param tadsForReduced the number of tads for the shrunk down problem (eg: 2,3)
 * @param tadsForOriginal the number of tads for the smaller problem (eg: 3)
 */
    @Namespace("shape") public native int reductionIndexForTad(int tadIndexForOriginal, int tadsForReduced,
                                 int tadsForOriginal);

/**
 * Computes the number of tads
 * per reduce index for the
 * reduction tad.
 */
    @Namespace("shape") public native int tadsPerReduceIndex(int tadsForReduce, int tadsForOriginal);

/**
 * Maps a linear index to a reduction index
 * @param i the linear index to map
 * @param elementWiseStride the element wise stride
 * for the multiple problem
 * @param tadNum the number of tads for the shrunken problem
 * @param originalTadNum the tad number for the reduced version of the problem
 */
    @Namespace("shape") public native int reductionIndexForLinear(int i, int elementWiseStride, int numElementsPerTad,
                                    int tadNum, int originalTadNum);

/**
 * Returns the prod of the data
 * up to the given length
 */
    @Namespace("shape") public native @Cast("Nd4jLong") long prodLong(@Cast("const Nd4jLong*") LongPointer data, int length);
    @Namespace("shape") public native @Cast("Nd4jLong") long prodLong(@Cast("const Nd4jLong*") LongBuffer data, int length);
    @Namespace("shape") public native @Cast("Nd4jLong") long prodLong(@Cast("const Nd4jLong*") long[] data, int length);

    /**
     * Returns the rear most left over item not present in
     * the dimension array. This assumes that the dimension array is sorted.
     *
     * For example, given a dimension array of:
     * 0,2
     *
     * and
     *
     * 12,4,2,1 in data
     *
     * You end up with 1 (data[3])
     * since the first item won't match
     * the last item of the dimension array
     */

//    ND4J_EXPORT _CUDA_HD int rearMostLeftOverItem(Nd4jLong *data,int length,Nd4jLong *dimension,int dimensionLength);

    /**
* Get an offset for retrieval
* from a data buffer
* based on the given
* shape stride and given indices
* @param baseOffset the offset to start from
* @param shape the shape of the array
* @param stride the stride of the array
* @param indices the indices to iterate over
* @return the double at the specified index
*/

    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] coords, @Cast("Nd4jLong") long baseOffset/*=0*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer coords, @Const IntPointer dims);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer coords, @Const IntBuffer dims);
    @Namespace("shape") public native @Cast("Nd4jLong") long getOffset(@Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] coords, @Const int[] dims);     // length of dims is equal to rank of shapeInfo

    // all three arrays should have same rank
    // all three arrays should have same dimensions or some of them are 1 (that is satisfy broadcasting principle), strides may be different
    // shapeInfo1 - first array should have max length compared to rest of two arrays
    @Namespace("shape") public native void getOffsetBroadcast(@Cast("const Nd4jLong") long startInd, @Cast("const Nd4jLong") long ind,
                                                    @Cast("const Nd4jLong*") LongPointer shapeInfo1, @Cast("const Nd4jLong*") LongPointer shapeInfo2, @Cast("const Nd4jLong*") LongPointer shapeInfo3,
                                                    @Cast("const bool") boolean sameOffsets12, @Cast("const bool") boolean sameOffsets13,
                                                    IntPointer coords,
                                                    @Cast("Nd4jLong*") @ByRef LongPointer offset1, @Cast("Nd4jLong*") @ByRef LongPointer offset2, @Cast("Nd4jLong*") @ByRef LongPointer offset3);
    @Namespace("shape") public native void getOffsetBroadcast(@Cast("const Nd4jLong") long startInd, @Cast("const Nd4jLong") long ind,
                                                    @Cast("const Nd4jLong*") LongBuffer shapeInfo1, @Cast("const Nd4jLong*") LongBuffer shapeInfo2, @Cast("const Nd4jLong*") LongBuffer shapeInfo3,
                                                    @Cast("const bool") boolean sameOffsets12, @Cast("const bool") boolean sameOffsets13,
                                                    IntBuffer coords,
                                                    @Cast("Nd4jLong*") @ByRef LongBuffer offset1, @Cast("Nd4jLong*") @ByRef LongBuffer offset2, @Cast("Nd4jLong*") @ByRef LongBuffer offset3);
    @Namespace("shape") public native void getOffsetBroadcast(@Cast("const Nd4jLong") long startInd, @Cast("const Nd4jLong") long ind,
                                                    @Cast("const Nd4jLong*") long[] shapeInfo1, @Cast("const Nd4jLong*") long[] shapeInfo2, @Cast("const Nd4jLong*") long[] shapeInfo3,
                                                    @Cast("const bool") boolean sameOffsets12, @Cast("const bool") boolean sameOffsets13,
                                                    int[] coords,
                                                    @Cast("Nd4jLong*") @ByRef long[] offset1, @Cast("Nd4jLong*") @ByRef long[] offset2, @Cast("Nd4jLong*") @ByRef long[] offset3);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer createShapeInfo(@Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer createShapeInfo(@Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int rank);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] createShapeInfo(@Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int rank);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer createShapeInfo(@Cast("Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer stride, int rank, @Cast("Nd4jLong*") LongPointer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer createShapeInfo(@Cast("Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer stride, int rank, @Cast("Nd4jLong*") LongBuffer buffer);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] createShapeInfo(@Cast("Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] stride, int rank, @Cast("Nd4jLong*") long[] buffer);

    /**
    * Convert a linear index to the corresponding coordinates
    * for example if shape is {2, 4}, then index 5 corresponds to coordinates [1, 1]
    */
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo,  @Cast("Nd4jLong*") LongPointer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo,  @Cast("Nd4jLong*") LongBuffer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo,  @Cast("Nd4jLong*") long[] coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo,  IntPointer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo,  IntBuffer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo,  int[] coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("Nd4jLong*") LongPointer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("Nd4jLong*") LongBuffer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("Nd4jLong*") long[] coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") LongPointer shape, IntPointer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") LongBuffer shape, IntBuffer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, int rank, @Cast("const Nd4jLong*") long[] shape, int[] coords);

    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer coords);
    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer coords);
    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] coords);
    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo, IntPointer coords);
    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo, IntBuffer coords);
    @Namespace("shape") public native void index2coordsCPU(@Cast("const Nd4jLong") long startIndex, @Cast("const Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo, int[] coords);
    // ND4J_EXPORT _CUDA_HD void index2coordsCPU(const Nd4jLong& startIndex, const Nd4jLong& index, const Nd4jLong *shapeInfo, const int* dims, Nd4jLong *coords);

    /**
    * take into account only dimensions stored in tadDims, tadDims must be sorted in increasing order!
    */
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer dims, int dimsLen, IntPointer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer dims, int dimsLen, IntBuffer coords);
    @Namespace("shape") public native void index2coords(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] dims, int dimsLen, int[] coords);

    /**
    * Convert coordinates to the corresponding linear index (sequence number in other words)
    * for example if shape is {2, 4} and coordinates [1, 1] then index 5 is returned
    */
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Const IntPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Const IntBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(int rank, @Cast("const Nd4jLong*") long[] shape, @Const int[] coords);
    /**
    * take into account only dimensions stored in tadDims, tadDims must be sorted in increasing order!
    */
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Const IntPointer dims, int dimsSize, @Const IntPointer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Const IntBuffer dims, int dimsSize, @Const IntBuffer coords);
    @Namespace("shape") public native @Cast("Nd4jLong") long coords2index(@Cast("const Nd4jLong*") long[] shapeInfo, @Const int[] dims, int dimsSize, @Const int[] coords);

   /**
   * increment n-dimensional array by one iteration by changing coord appropriately
   * for example we have array with shape {2, 3}:
   * - if input coord = {0,1}, then output coord = {0,2}
   * - if input coord = {0,2}, then output coord = {1,0}
   * so the aim is to produce following subsequence of coord: {0,0}, {0,1}, {0,2}, {1,0}, {1,1}, {1,2}
   */

   /* calculates an array buffer offset for given "index" using following formula: offset = coord_0*stride_0 + coord_1*stride_1 + ... + coord_{rank-1}*stride_{rank-1}
   */
    @Namespace("shape") public native @Cast("uint") int getIndexOffset(@Cast("uint") int index, @Cast("const uint*") IntPointer shapeInfo);
    @Namespace("shape") public native @Cast("uint") int getIndexOffset(@Cast("uint") int index, @Cast("const uint*") IntBuffer shapeInfo);
    @Namespace("shape") public native @Cast("uint") int getIndexOffset(@Cast("uint") int index, @Cast("const uint*") int[] shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long getIndexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long getIndexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long getIndexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") long[] shapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long indexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongPointer lShapeInfo, @Cast("const uint*") IntPointer uShapeInfo, @Cast("const bool") boolean useUnsigned);
    @Namespace("shape") public native @Cast("Nd4jLong") long indexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") LongBuffer lShapeInfo, @Cast("const uint*") IntBuffer uShapeInfo, @Cast("const bool") boolean useUnsigned);
    @Namespace("shape") public native @Cast("Nd4jLong") long indexOffset(@Cast("Nd4jLong") long index, @Cast("const Nd4jLong*") long[] lShapeInfo, @Cast("const uint*") int[] uShapeInfo, @Cast("const bool") boolean useUnsigned);

    @Namespace("shape") public native void printShapeInfo(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native void printShapeInfo(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native void printShapeInfo(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native void printShapeInfoLinear(@Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("const Nd4jLong*") long[] shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("const Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, @Cast("const Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, @Cast("const Nd4jLong*") long[] shapeInfo);

    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") String msg, int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides);
    @Namespace("shape") public native void printShapeInfoLinear(@Cast("char*") BytePointer msg, int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides);

    @Namespace("shape") public native void printIntArray(@Cast("const Nd4jLong*") LongPointer arr, int length);
    @Namespace("shape") public native void printIntArray(@Cast("const Nd4jLong*") LongBuffer arr, int length);
    @Namespace("shape") public native void printIntArray(@Cast("const Nd4jLong*") long[] arr, int length);
    @Namespace("shape") public native void printIntArray(@Const IntPointer arr, int length);
    @Namespace("shape") public native void printIntArray(@Const IntBuffer arr, int length);
    @Namespace("shape") public native void printIntArray(@Const int[] arr, int length);

    @Namespace("shape") public native void printArray(FloatPointer arr,int length);
    @Namespace("shape") public native void printArray(FloatBuffer arr,int length);
    @Namespace("shape") public native void printArray(float[] arr,int length);

    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer shapeBufferOfNpy(int rank, @Cast("unsigned int*") IntPointer shape,@Cast("bool") boolean fortranOrder);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer shapeBufferOfNpy(int rank, @Cast("unsigned int*") IntBuffer shape,@Cast("bool") boolean fortranOrder);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] shapeBufferOfNpy(int rank, @Cast("unsigned int*") int[] shape,@Cast("bool") boolean fortranOrder);

//    ND4J_EXPORT _CUDA_HD Nd4jLong *shapeBufferOfNpyBuffer(char *buffer);


   // this function checks the consistence of dimensions with array rank (negative dimensions, too large dimensions, too big number of dimensions)
    // also sort input array of dimensions, this operation is also necessary for creating TAD object
    @Namespace("shape") public native void checkDimensions(int rank, @StdVector IntPointer dimensions);
    @Namespace("shape") public native void checkDimensions(int rank, @StdVector IntBuffer dimensions);
    @Namespace("shape") public native void checkDimensions(int rank, @StdVector int[] dimensions);

    // function calculates linear index of array min, min is sub-array of max, index to be returned is min-array's index and corresponds to maxIdx of max array
    // dimsToExclude - should be sorted in increasing order
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, @Const IntPointer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, @Const IntBuffer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, @Const int[] dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayIndex(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo);

    // function calculates absolute offset of min array, min is sub-array of max, offset to be returned corresponds to maxIdx of max array
    // dimsToExclude - should be sorted in increasing order
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, @Const IntPointer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, @Const IntBuffer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, @Const int[] dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native @Cast("Nd4jLong") long subArrayOffset(@Cast("const Nd4jLong") long maxIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo);

    // max array is outer for min array, min array is sub-array of max array
    // function calculates the coordinates of min array (and saves them into minIdxs) given coordinates of max array (already stored in maxIdxs)
    // dimsToExclude - should be sorted in increasing order
    // dimsLen - length of dimsToExclude, if not set (= -1), then it is calculated as maxRank - minRank
    @Namespace("shape") public native void maxIndToMinInd(IntPointer maxIdxs, IntPointer minIdxs, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, @Const IntPointer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native void maxIndToMinInd(IntPointer maxIdxs, IntPointer minIdxs, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo);
    @Namespace("shape") public native void maxIndToMinInd(IntBuffer maxIdxs, IntBuffer minIdxs, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, @Const IntBuffer dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native void maxIndToMinInd(IntBuffer maxIdxs, IntBuffer minIdxs, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo);
    @Namespace("shape") public native void maxIndToMinInd(int[] maxIdxs, int[] minIdxs, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, @Const int[] dimsToExclude/*=nullptr*/, int dimsLen/*=-1*/);
    @Namespace("shape") public native void maxIndToMinInd(int[] maxIdxs, int[] minIdxs, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo);

    // calculate indexes of max-array, these output indexes correspond to one minIdx index of min-array which is sub-array of max-array
    // dimsToExclude - should be sorted in increasing order
    @Namespace("shape") public native int outerArrayIndexes(IntPointer maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, @Const IntPointer dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayIndexes(IntPointer maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo);
    @Namespace("shape") public native int outerArrayIndexes(IntBuffer maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, @Const IntBuffer dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayIndexes(IntBuffer maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo);
    @Namespace("shape") public native int outerArrayIndexes(int[] maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, @Const int[] dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayIndexes(int[] maxIdxs, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo);

    // calculate offsets of max-array, these offsets correspond to one minIdx index of min-array which is sub-array of max-array
    // maxOffsets - will contain calculated offsets of max-array, buffer for maxOffsets should be allocated beforehand
    // dimsToExclude - should be sorted in increasing order
    // memBuff - auxiliary memory buffer (size = 2 * max_rank) for coordinates and increments storing, should be allocated beforehand
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") LongPointer maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, IntPointer memBuff, @Const IntPointer dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") LongPointer maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("const Nd4jLong*") LongPointer minShapeInfo, IntPointer memBuff);
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") LongBuffer maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, IntBuffer memBuff, @Const IntBuffer dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") LongBuffer maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("const Nd4jLong*") LongBuffer minShapeInfo, IntBuffer memBuff);
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") long[] maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, int[] memBuff, @Const int[] dimsToExclude/*=nullptr*/);
    @Namespace("shape") public native int outerArrayOffsets(@Cast("Nd4jLong*") long[] maxOffsets, @Cast("const Nd4jLong") long minIdx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("const Nd4jLong*") long[] minShapeInfo, int[] memBuff);

    // calculates offsets for entities (elements or sub-arrays), shape in context of sub-array means dimensions excluded from outer array
    // rank is equal to size of shape
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides, @Cast("Nd4jLong*") LongPointer offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides, @Cast("Nd4jLong*") LongPointer offsets);
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides, @Cast("Nd4jLong*") LongBuffer offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides, @Cast("Nd4jLong*") LongBuffer offsets);
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides, @Cast("Nd4jLong*") long[] offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(int rank, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides, @Cast("Nd4jLong*") long[] offsets);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("Nd4jLong*") LongPointer offsets);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("Nd4jLong*") LongBuffer offsets);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] offsets, byte order/*='c'*/);
    @Namespace("shape") public native void calcOffsets(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("Nd4jLong*") long[] offsets);
    // ND4J_EXPORT void calcOffsets(const Nd4jLong *xShapeInfo, Nd4jLong*& xOffsets, const Nd4jLong *yShapeInfo, Nd4jLong*& yOffsets, const char order = 'c');
    // ND4J_EXPORT void calcOffsets(const Nd4jLong *xShapeInfo, Nd4jLong*& xOffsets, const Nd4jLong *yShapeInfo, Nd4jLong*& yOffsets, const Nd4jLong* zShapeInfo, Nd4jLong*& zOffsets, const char order = 'c');
    @Namespace("shape") public native void shapeOldScalar(@Cast("sd::DataType") int dtype, @Cast("Nd4jLong*const") LongPointer buffer, byte order);
    @Namespace("shape") public native void shapeOldScalar(@Cast("sd::DataType") int dtype, @Cast("Nd4jLong*const") LongBuffer buffer, byte order);
    @Namespace("shape") public native void shapeOldScalar(@Cast("sd::DataType") int dtype, @Cast("Nd4jLong*const") long[] buffer, byte order);

    // deduce order and element-wise stride
    // if array is scalar or unit length vector then ews = 1 and order is preserved
    // if array is common vector then ews = stride of non-unity dimension and order is preserved
    // if strides are normal/contiguous then ews = 1 and corresponding order is set, otherwise ews = 0 and order is preserved
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") LongPointer shapeInfo, byte proposedOrder, int numOfNonUnitDims, @Cast("const Nd4jLong*") LongPointer shapeNoUnities, @Cast("const Nd4jLong*") LongPointer stridesNoUnities);
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") LongBuffer shapeInfo, byte proposedOrder, int numOfNonUnitDims, @Cast("const Nd4jLong*") LongBuffer shapeNoUnities, @Cast("const Nd4jLong*") LongBuffer stridesNoUnities);
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") long[] shapeInfo, byte proposedOrder, int numOfNonUnitDims, @Cast("const Nd4jLong*") long[] shapeNoUnities, @Cast("const Nd4jLong*") long[] stridesNoUnities);
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") LongPointer shapeInfo);
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") LongBuffer shapeInfo);
    @Namespace("shape") public native void checkStridesEwsAndOrder(@Cast("Nd4jLong*") long[] shapeInfo);

    /**
    * processes whole set of sub-arrays
    * evaluates shapeInfo of sub-arrays (all sub-arrays have the same shapeInfo) and their buffer offsets (each sub-array has its own unique offset from original this-buffer)
    * arguments:
    * wholeShapeInfo - original shapeInfo of whole array
    * numOfSubArrs - number of sub-arrays, size of subArrOffsets is equal to numOfSubArrs
    * dimsSize - size of dimsToExclude, if dimsSize = array rank or dimsSize = 0 it means sub-array is whole array, copy of wholeShapeInfo and one zero offset will be returned
    * dimsToExclude - MUST BE SORTED, dimensions to evaluate sub-array along, i.e. when shape is [2,3,4,5] and dimsToExclude={0,2}, then there will be 8 sub-arrays with shape [3,5]
    * subArrShapeInfo    - output argument, contains shapeInfo (same for all sub-arrays)
    * subArrOffsets      - output argument, contains successive sub-arrays offsets from original this-buffer
    * keepUnitiesInShape - if false then eliminate unities from sub-array shapeInfo, for example {1,a,1,b} -> {a,b}
    */
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") LongPointer wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const IntPointer dimsToExclude, @Cast("Nd4jLong*") LongPointer subArrShapeInfo, @Cast("Nd4jLong*") LongPointer subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") LongPointer wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const IntPointer dimsToExclude, @Cast("Nd4jLong*") LongPointer subArrShapeInfo, @Cast("Nd4jLong*") LongPointer subArrOffsets);
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") LongBuffer wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const IntBuffer dimsToExclude, @Cast("Nd4jLong*") LongBuffer subArrShapeInfo, @Cast("Nd4jLong*") LongBuffer subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") LongBuffer wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const IntBuffer dimsToExclude, @Cast("Nd4jLong*") LongBuffer subArrShapeInfo, @Cast("Nd4jLong*") LongBuffer subArrOffsets);
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") long[] wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const int[] dimsToExclude, @Cast("Nd4jLong*") long[] subArrShapeInfo, @Cast("Nd4jLong*") long[] subArrOffsets, @Cast("bool") boolean keepUnitiesInShape/*=false*/);
    @Namespace("shape") public native void calcSubArrsShapeInfoAndOffsets(@Cast("const Nd4jLong*") long[] wholeShapeInfo, @Cast("const Nd4jLong") long numOfSubArrs, int dimsSize, @Const int[] dimsToExclude, @Cast("Nd4jLong*") long[] subArrShapeInfo, @Cast("Nd4jLong*") long[] subArrOffsets);

    /**
    * processes only one sub-array, evaluates shapeInfo of sub-array and its buffer offset from original array
    * arguments:
    * idx - input argument, intervals of indexes which define the sub-array to point on,
    *        when isStrided = false then idx has form {dim0Start,dim0End,  dim1Start,dim1End, ....} and length (2 * maxRank)
    *        when isStrided = true  then idx has form {dim0Start,dim0End,dim0Stride,  dim1Start,dim1End,dim1Stride, ....} and length (3 * maxRank)
    *        when (dimStart == dimEnd) then whole range will be used for current dimension
    * maxShapeInfo - input argument, shapeInfo of original array
    * minShapeInfo - output argument, shapeInfo of sub-array to be deduced
    * minOffset - output argument, offset of sub-array buffer offsets from original buffer
    * keepUnitiesInShape - input argument, if false then eliminate unities from sub-array shapeInfo, for example {1,a,1,b} -> {a,b}
    * isStrided - input argument, if true then idx has length (3 * this->rankOf()) and contains additional stride numbers which correspond to stride between dimStart and dimEnd,
    * numOfUntiesInMinShape - input argument, number of occurrences in idx when (dimEnd - dimStart) = 1
    */
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") LongPointer idx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("Nd4jLong*") LongPointer minShapeInfo, @Cast("Nd4jLong*") @ByRef LongPointer minOffset, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/, int numOfUntiesInMinShape/*=0*/);
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") LongPointer idx, @Cast("const Nd4jLong*") LongPointer maxShapeInfo, @Cast("Nd4jLong*") LongPointer minShapeInfo, @Cast("Nd4jLong*") @ByRef LongPointer minOffset);
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") LongBuffer idx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("Nd4jLong*") LongBuffer minShapeInfo, @Cast("Nd4jLong*") @ByRef LongBuffer minOffset, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/, int numOfUntiesInMinShape/*=0*/);
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") LongBuffer idx, @Cast("const Nd4jLong*") LongBuffer maxShapeInfo, @Cast("Nd4jLong*") LongBuffer minShapeInfo, @Cast("Nd4jLong*") @ByRef LongBuffer minOffset);
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") long[] idx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("Nd4jLong*") long[] minShapeInfo, @Cast("Nd4jLong*") @ByRef long[] minOffset, @Cast("const bool") boolean keepUnitiesInShape/*=false*/, @Cast("const bool") boolean isStrided/*=false*/, int numOfUntiesInMinShape/*=0*/);
    @Namespace("shape") public native void calcSubArrShapeInfoAndOffset(@Cast("const Nd4jLong*") long[] idx, @Cast("const Nd4jLong*") long[] maxShapeInfo, @Cast("Nd4jLong*") long[] minShapeInfo, @Cast("Nd4jLong*") @ByRef long[] minOffset);

    /**
    * for example inShapeInfo is {3, 2,1,4, 4,4,1, 16384,1,99}
    * then output shapeNoUnities will contain {2,4, 4,1} - that is only shape and strides, no rank/type/ews/order
    * stridesNoUnities will point on strides in shapeNoUnities that is on {4,1}
    * returns number of non-unity dimensions in inShapeInfo
    * if there is no unities in inShapeInfo, then no copy procedure will be performed and shapeNoUnities/stridesNoUnities will point on corresponding places in inShapeInfo
    */
    @Namespace("shape") public native int excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") LongPointer inShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongPointer shapeNoUnities, @Cast("Nd4jLong*&") @ByPtrRef LongPointer stridesNoUnities);
    @Namespace("shape") public native int excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") LongBuffer inShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer shapeNoUnities, @Cast("Nd4jLong*&") @ByPtrRef LongBuffer stridesNoUnities);
    @Namespace("shape") public native int excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") long[] inShapeInfo, @Cast("Nd4jLong*&") @ByPtrRef long[] shapeNoUnities, @Cast("Nd4jLong*&") @ByPtrRef long[] stridesNoUnities);

    /**
    * for example inShapeInfo is {3, 2,1,3,1,4,  12,12,4,4,1, 16384,1,99}, dimsToExclude(points on unity dimensions) = {1,3}, dimsSize = 2
    * then outShapeInfo will contain {3, 2,3,4, 12,4,1, 16384,1,99}
    */
    @Namespace("shape") public native void excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") LongPointer inShapeInfo, @Const IntPointer dimsToExclude, int dimsSize, @Cast("Nd4jLong*") LongPointer outShapeInfo);
    @Namespace("shape") public native void excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") LongBuffer inShapeInfo, @Const IntBuffer dimsToExclude, int dimsSize, @Cast("Nd4jLong*") LongBuffer outShapeInfo);
    @Namespace("shape") public native void excludeUnitiesFromShapeInfo(@Cast("const Nd4jLong*") long[] inShapeInfo, @Const int[] dimsToExclude, int dimsSize, @Cast("Nd4jLong*") long[] outShapeInfo);

    /**
    * get stride over contiguous axis (contiguous axis must have stride = 1)
    * for example when inShapeInfo is {4, 2,5,4,3,  60,1,5,20, 16384,0,99} then output is 5 (that is smallest stride in inShapeInfo except those equal to 1)
    */
    // INLINEDEF _CUDA_HD Nd4jLong strideOverContigAxis(const int axis, const Nd4jLong* inShapeInfo);






//END HEADERS


    //BEGIN IMPLEMENTATIONS



// #ifdef __CUDACC__
// #endif

/**
* Length of a tad given
* the shape information
*/



/**
 * Tad element wise stride:
 * given the inner most dimension (the sorted dimension of the last)
 * the element wise stride of the tad (disregarding order) is the
 * last dimension's stride.
 *
 * For a given singular dimension this will just be the only entry.
 * For example, given the following c order shape/stride:
 * 2,2,3,2
 * 12,6,2,1
 *
 * The tad element wise stride for 3 will be 1.
 * For zero it wil be 12
 *
 * For 2,3 it's 1
 *
 * Note here that the multi dimensional 2,3 case
 * is equivalent to the singular 3 case.
 *
 *
 * Note that this is for the dimension that ultimately
 * ends up removed.
 *
 * Again: this may not preserve ordering of the tad
 * but maybe used for reductions.
 */
    @Namespace("shape") public native int tadElementWiseStride(@Cast("Nd4jLong*") LongPointer shapeInfo, IntPointer dimension,int dimensionLength);
    @Namespace("shape") public native int tadElementWiseStride(@Cast("Nd4jLong*") LongBuffer shapeInfo, IntBuffer dimension,int dimensionLength);
    @Namespace("shape") public native int tadElementWiseStride(@Cast("Nd4jLong*") long[] shapeInfo, int[] dimension,int dimensionLength);

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

/**
 * Computes the standard packed array strides for a given shape.
 *
 * @param shape    the shape of a matrix:
 * @param startNum the start number for the strides
 * @return the strides for a matrix of n dimensions
 */

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////


// check whether input dimensions are permuted, not permuted dimensions order have to be 0,....,rank-1


/**
 * @param toCopy the shape to copy
 * @return a copy of the original struct
 */

/**
 * Get the shape info buffer
 * for the given rank and shape.
 */

    /**
     * This is special method, it returns ONLY 2D shapebuffer.
     *
     * This method is used only for SoftMax
     */

/**
* Get the shape info buffer
* for the given rank and shape.
*/

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////


// //////////////////////////////////////////////////////////////////////
//     INLINEDEF _CUDA_HD Nd4jLong getIndexOffset(Nd4jLong index, const Nd4jLong *shapeInfo, Nd4jLong arrLen) {

//         const Nd4jLong ews = shapeInfo[shapeInfo[0] + shapeInfo[0] + 2];

//         if(ews > 0 && order(shapeInfo) == 'c')
//            if (ews == 1)
//                return index;
//            else
//                return ews * index;

//         Nd4jLong offset = 0;
//         Nd4jLong rank = shapeInfo[0];
//         for(int i = 1; i <= shapeInfo[0]; ++i) {
//             arrLen /= shapeInfo[i];
//             if(arrLen > 0 && shapeInfo[i] > 1) {
//                 offset += (index / arrLen) * shapeInfo[i + rank];
//                 index %= arrLen;
//             }
//         }
//         return offset;
//     }

//     INLINEDEF _CUDA_HD uint getIndexOffset(uint index, const uint *shapeInfo, uint arrLen) {

//         const uint rank = shapeInfo[0];
//         const uint ews = shapeInfo[rank + rank + 2];

//         if(ews > 0 && shapeInfo[rank + rank + 3] == 99)
//            if (ews == 1)
//                return index;
//            else
//                return ews * index;

//         uint offset = 0;

//         for(uint i = 1; i <= rank; ++i) {
//             arrLen /= shapeInfo[i];
//             if(arrLen > 0 && shapeInfo[i] > 1) {
//                 offset += (index / arrLen) * shapeInfo[i + rank];
//                 index %= arrLen;
//             }
//         }
//         return offset;
//     }

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////

/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */

/**
 *
 * @param length
 * @param shape
 * @param rearrange
 * @return
 */

/**
 * Get the ordering for the device
 * @param length
 * @param shape
 * @param stride
 * @param elementStride
 * @return
 */





/**
 * Ensure that every value in the re arrange
 * array is unique
 * @param arr
 * @param shape
 * @param arrLength
 * @param shapeLength
 * @return
 */

/**
 * Permute the shape information
 * @param info the shape information to permute
 * @param rearrange the order to re arrange
 * @param rank the rank of the rearrange array
 */

/**
 * Returns whether the
 * given shape is a vector or not
 * @param shape the shape of the array
 * @param rank the rank of the shape
 */

//////////////////////////////////////////////////////////////////////

/**
* Returns whether the
* given shape is a vector or not
* @param shape the shape of the array
* @param rank the rank of the shape
*/

/**
 * Returns the shape portion of an information
 * buffer
 */

/**
 * Return a copy of a buffer.
 * This buffer allocates memory
 * that must be freed elsewhere.
 */

/**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/

/**
* Return a copy of a buffer.
* This buffer allocates memory
* that must be freed elsewhere.
*/

/**
 * Permute the given strides
 * in the given rearrange order
 * @param toPermute the buffer to permute
 * @param shapeRank the length of the buffer to permute
 * @param rearrange the rearrange order (must be 0 based indexes
 * and all must be filled in)
 * @return the rearranged array
 */
 /*
    INLINEDEF _CUDA_HD Nd4jLong *permutedStrides(Nd4jLong *toPermute, int shapeRank, int *rearrange) {
        Nd4jLong *strideCopy = copyOf(shapeRank, toPermute);
        checkArrangeArray(rearrange, shapeRank, shapeRank);
        Nd4jLong *newStride = doPermuteSwap(shapeRank, strideCopy, rearrange);
        delete[] strideCopy;
        return newStride;
    }
    */

/**
 * Return the slice (shape + 1 in pointer arithmetic)
 * @param shape the shape to take the slice of
 * @return the shape array - the first entry
 */

/**
 * Returns the length of the
 * shape information buffer:
 * rank * 2 + 3
 * @param rank the rank to get the shape
 * info length for
 * @return rank * 2 + 4
 */

/**
 * Returns the rank portion of
 * an information buffer
 */

/**
 * Converts a raw int buffer of the layout:
 * rank
 * shape
 * stride
 * offset
 * elementWiseStride
 *
 * where shape and stride are both straight int pointers
 */

/**
 * Returns the stride portion of an information
 * buffer
 */


/**
 * Compute the length of the given shape
 */

/***
 * Returns the offset
 * portion of an information buffer
 */


/**
 * Returns the ordering
 * for this shape information buffer
 */

/**
 * Returns type
 */

/**
 * Returns the element wise stride for this information
 * buffer
 */

/**
* Returns the element wise stride for this information
* buffer relative to a dimension and reduction index
*/

/**
 * Returns whether
 * the given shape info buffer
 * represents a scalar shape
 */

/**
 * Returns whether
 * the given shape information
 * represents a scalar
 * shape or not
 */

/**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

    /**
 * Return a copy of this array with the
 * given index omitted
 *
 * @param data  the data to copy
 * @param indexes the index of the item to remove
 * @param dataLength the length of the data array
 * @param indexesLength the length of the data array
 * @return the new array with the omitted
 *
 * item
 */

/**
 * Computes the offset for accessing
 * a global element given the shape information
 * and the offset to be read.
 */
// #ifdef __CUDACC__
// #endif

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */
    @Namespace("shape") public native @Cast("Nd4jLong*") LongPointer ensureVectorShape(@Cast("Nd4jLong*") LongPointer shape, int dimension);
    @Namespace("shape") public native @Cast("Nd4jLong*") LongBuffer ensureVectorShape(@Cast("Nd4jLong*") LongBuffer shape, int dimension);
    @Namespace("shape") public native @Cast("Nd4jLong*") long[] ensureVectorShape(@Cast("Nd4jLong*") long[] shape, int dimension);

/**
 * Returns a shape
 * forces the given length to be 2.
 * @param shape the shape to modify
 * @param dimension the dimension (row or column)
 * for the shape to be returned as
 * @return the new shape
 */

    /**
     * This method does STRICT comparison for two shape buffers
     *
     * @param shape
     * @return
     */

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

    /**
     * This method does SOFT comparison for two shape buffers, we compare only rank & shapes
     *
     * @param shape
     * @return
     */

/**
 * Generate an int buffer
 * up to the given length
 * at the specified increment
 *
 */

/**
 * Generate a range
 * beginning at from and ending at to
 * incrementing by 1
 * @param from the start
 * @param to the end
 * @return the int array starting at from and ending at to
 */

/**
 * Keep the given indexes in the data
 * @param data
 * @param index
 * @param indexLength
 * @param dataLength
 * @return
 */

/**
 * Generate a reverse
 * copy of the data
 */

/**
 *
 * @param arr1
 * @param arr1Length
 * @param arr2
 * @param arr2Length
 * @return
 */

/**
 *
 * @param numArrays
 * @param numTotalElements
 * @param arr
 * @param lengths
 * @return
 */

/**
 * Get the length per slice of the
 * given shape and the dimension
 * @param rank the rank of the shape
 * @param shape the shape of to get
 * the length per slice for
 * @param dimension the dimension to
 * get the length per slice for
 * @param dimensionLength the length of the dimension array
 * @return the length per slice of the given shape
 * along the given dimension
 */

/**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */

    /**
 * calculates the offset for a tensor
 * @param index
 * @param arr
 * @param tensorShape
 * @return
 */


// #ifdef __CUDACC__
// #endif





/**
 * Computes the number
 * of tensors along
 * a given dimension
 */

/**
 * Computes the number
 * of tensors along
 * a given dimension
 */




/**
* Get an offset for retrieval
* from a data buffer
* based on the given
* shape stride and given indices
* @param baseOffset the offset to start from
* @param shape the shape of the array
* @param stride the stride of the array
* @param indices the indices to iterate over
* @return the double at the specified index
*/

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

/**
 * Returns the tensor along dimension
 * for the given block index
 * @param blockSize
 * @param blockIdx
 * @param i
 * @return
 */

/**
 * Computes the number of tads per block
 *
 */

/**
 * Returns a shape buffer
 * for the shape information metadata.
 */
/**
 * Given an linear index, element wise stride
 * and the length of each tad
 * map a linear index to a tad
 * @param i the index to map
 * @param the element wise stride for the tads
 * @param numElementsPerTad the number of elements
 * per tad
 */

/**
 * Map a tad to a
 * reduction index.
 * @param tadIndexForOriginal the original tad index for the
 * split up problem (eg: split is dimension 3 mapping to a 2,3 problem)
 * @param tadsForReduced the number of tads for the shrunk down problem (eg: 2,3)
 * @param tadsForOriginal the number of tads for the smaller problem (eg: 3)
 */

/**
 * Tad index for linear
 * @param linearIndex
 * @param tadLength
 * @return
 */

/**
 * Computes the number of tads
 * per reduce index for the
 * reduction tad.
 */

/**
 * Maps a linear index to a reduction index
 * @param i the linear index to map
 * @param elementWiseStride the element wise stride
 * for the multiple problem
 * @param tadNum the number of tads for the shrunken problem
 * @param originalTadNum the tad number for the reduced version of the problem
 */


/**
 * Returns the prod of the data
 * up to the given length
 */

    @Namespace("shape") public native int rearMostLeftOverItem(@Cast("Nd4jLong*") LongPointer data, @Cast("Nd4jLong*") LongPointer dimension,int dimensionLength);
    @Namespace("shape") public native int rearMostLeftOverItem(@Cast("Nd4jLong*") LongBuffer data, @Cast("Nd4jLong*") LongBuffer dimension,int dimensionLength);
    @Namespace("shape") public native int rearMostLeftOverItem(@Cast("Nd4jLong*") long[] data, @Cast("Nd4jLong*") long[] dimension,int dimensionLength);

// #ifdef __CUDACC__
// #endif






//    INLINEDEF _CUDA_HD Nd4jLong *shapeBufferOfNpyBuffer(char *buffer) {
//        unsigned Nd4jLong *shape;
//        unsigned int ndims, wordSize;
//        bool fortranOrder;
//        cnpy::parseNpyHeaderStr(std::string(buffer),wordSize,shape,ndims,fortranOrder);
//        Nd4jLong * ret =  shape::shapeBufferOfNpy(ndims,shape,fortranOrder);
//        delete[] shape;
//        return ret;
//    }

//////////////////////////////////////////////////////////////////////////
// copy-past from java hasDefaultStridesForShape function

// INLINEDEF _CUDA_H bool reshapeC(const int oldRank, Nd4jLong* oldShape, const int newRank, Nd4jLong* newShapeOf, bool isFOrder, Nd4jLong* target) {
//         int oldnd;
//         Nd4jLong* olddims = shape::copyOf(oldRank, shape::shapeOf(oldShape));
//         Nd4jLong* oldstrides = shape::copyOf(oldRank, shape::stride(oldShape));
//         int np, op, last_stride;
//         int oi, oj, ok, ni, nj, nk;
//         Nd4jLong* newStrides = new Nd4jLong[newRank];
//         oldnd = 0;

//         /*
//          * Remove axes with dimension 1 from the old array. They have no effect
//          * but would need special cases since their strides do not matter.
//          */
//         for (oi = 0; oi < oldRank; oi++) {
//             if (shape::shapeOf(oldShape)[oi] != 1) {
//                 olddims[oldnd] = shape::shapeOf(oldShape)[oi];
//                 oldstrides[oldnd] = shape::stride(oldShape)[oi];
//                 oldnd++;
//             }
//         }

//         np = 1;
//         for (ni = 0; ni < newRank; ni++) {
//             np *= newShapeOf[ni];
//         }
//         op = 1;
//         for (oi = 0; oi < oldnd; oi++) {
//             op *= olddims[oi];
//         }
//         if (np != op) {
//             /* different total sizes; no hope */
//             delete[] olddims;
//             delete[] oldstrides;
//             delete[] newStrides;

//             return false;
//         }

//         if (np == 0) {
//             /* the current code does not handle 0-sized arrays, so give up */
//             delete[] olddims;
//             delete[] oldstrides;
//             delete[] newStrides;

//             return false;
//         }

//         /* oi to oj and ni to nj give the axis ranges currently worked with */
//         oi = 0;
//         oj = 1;
//         ni = 0;
//         nj = 1;

//         while (ni < newRank && oi < oldnd) {
//             np = newShapeOf[ni];
//             op = olddims[oi];

//             while (np != op) {
//                 if (np < op) {
//                     /* Misses trailing 1s, these are handled later */
//                     np *= newShapeOf[nj++];
//                 } else {
//                     op *= olddims[oj++];
//                 }
//             }

//             /* Check whether the original axes can be combined */
//             for (ok = oi; ok < oj - 1; ok++) {
//                 if (isFOrder) {
//                     if (oldstrides[ok + 1] != olddims[ok] * oldstrides[ok]) {
//                         /* not contiguous enough */
//                         delete[] olddims;
//                         delete[] oldstrides;
//                         delete[] newStrides;

//                         return false;
//                     }
//                 } else {
//                     /* C order */
//                     if (oldstrides[ok] != olddims[ok + 1] * oldstrides[ok + 1]) {
//                         /* not contiguous enough */
//                         delete[] olddims;
//                         delete[] oldstrides;
//                         delete[] newStrides;

//                         return false;
//                     }
//                 }
//             }

//             /* Calculate new strides for all axes currently worked with */
//             if (isFOrder) {
//                 newStrides[ni] = oldstrides[oi];
//                 for (nk = ni + 1; nk < nj; nk++) {
//                     newStrides[nk] = newStrides[nk - 1] * newShapeOf[nk - 1];
//                 }
//             } else {
//                 /* C order */
//                 newStrides[nj - 1] = oldstrides[oj - 1];
//                 for (nk = nj - 1; nk > ni; nk--) {
//                     newStrides[nk - 1] = newStrides[nk] * newShapeOf[nk];
//                 }
//             }
//             ni = nj++;
//             oi = oj++;
//         }

//         if (ni >= 1) {
//             last_stride = newStrides[ni - 1];
//         } else {
//             last_stride = shape::elementWiseStride(oldShape);
//         }
//         if (isFOrder && ni >= 1) {
//             last_stride *= newShapeOf[ni - 1];
//         }
//         for (nk = ni; nk < newRank; nk++) {
//             newStrides[nk] = last_stride;
//         }

//         target[0] = newRank;
//         int cnt = 1;
//         for (int e = 0; e < newRank; e++)
//             target[cnt++] = newShapeOf[e];

//         for (int e = 0; e < newRank; e++)
//             target[cnt++] = newStrides[e];

//         target[shape::shapeInfoLength(newRank) - 3] = 0;
//         target[shape::shapeInfoLength(newRank) - 2] = 0;
//         target[shape::shapeInfoLength(newRank) - 1] = isFOrder ? 102 : 99;
//         sd::ArrayOptions::setDataType(target, sd::ArrayOptions::dataType(oldShape));

//         delete[] olddims;
//         delete[] oldstrides;
//         delete[] newStrides;

//         return true;
//     }

//////////////////////////////////////////////////////////////////////
// INLINEDEF _CUDA_H bool reshapeC(const int oldRank, const Nd4jLong* oldShapeInfo, const int newRank, const Nd4jLong* newShape, Nd4jLong* newShapeInfo) {

//         // PLEASE NOTE !: reshaping not-permuted (ews=1) array in f order (except insertion/elimination of unities) will definitely cause allocation of new buffer for array elements
//         // also this function takes into account identical shapes automatically, namely in that case oldShapeInfo is completely copied to newShapeInfo

//         newShapeInfo[0] = newRank;
//         memcpy(newShapeInfo + 1, newShape, newRank * sizeof(Nd4jLong));

//         Nd4jLong* newStrides       = shape::stride(newShapeInfo);
//         const Nd4jLong* oldShape   = shape::shapeOf(const_cast<Nd4jLong*>(oldShapeInfo));
//         const Nd4jLong* oldStrides = shape::stride(const_cast<Nd4jLong*>(oldShapeInfo));
//         Nd4jLong oldStart(0), oldStop(1), newStart(0), newStop(1), newDim, oldDim;

//         while (newStart < newRank && oldStart < oldRank) {

//             newDim = newShape[newStart];
//             oldDim = oldShape[oldStart];

//             while (newDim != oldDim && newDim > 0 && oldDim > 0)
//                 if (newDim < oldDim) newDim *= newShape[newStop++];
//                 else                 oldDim *= oldShape[oldStop++];

//             // ------ Check whether the original axes can be combined ------ //
//             for (int step = 1, i = oldStart; i < oldStop - 1; ++i) {
//                 if(oldShape[i] == 1)                // skip unity-dimension and its stride
//                     continue;
//                 while((i + step) < oldRank && oldShape[i + step] == 1)
//                     ++step;                         // skip following unity-dimensions and its strides if such are present
//                 if((i + step) < oldRank && oldStrides[i] != oldShape[i + step] * oldStrides[i + step])
//                     return false;                   // not contiguous enough
//             }

//             newStrides[newStop - 1] = oldStrides[oldStop - 1];
//             for (int i = newStop - 1; i > newStart; --i)
//                 newStrides[i - 1] = newStrides[i] * newShape[i];

//             newStart = newStop++;
//             oldStart = oldStop++;
//         }

//         // rest of strides should be unities (if there is remainder in strides space, that is newStart < newRank)
//         for (int i = newStart; i < newRank; ++i)
//             newStrides[i] = 1;

//         newShapeInfo[2 * newRank + 3] = shape::order(oldShapeInfo);                 // order
//         newShapeInfo[2 * newRank + 2] = shape::elementWiseStride(oldShapeInfo);     // ews
//         newShapeInfo[2 * newRank + 1] = shape::type(oldShapeInfo);                  // type

//         return true;
//     }

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

    // this function checks the consistence of dimensions with array rank (negative dimensions, too large dimensions, too big number of dimensions)
    // also it sorts input array of dimensions, this operation is also necessary for creating TAD object


// max array is outer for min array, min array is sub-array of max array
// function calculates the coordinates of min array (and saves them into minIdxs) given coordinates of max array (already stored in maxIdxs)

    //////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// INLINEDEF _CUDA_HD void index2coordsCPU(const Nd4jLong& startIndex, const Nd4jLong& index, const Nd4jLong *shapeInfo, const int* dims, const int dimsLen, int *coords) {

//     if(startIndex == index) {
//         shape::index2coords(index, shapeInfo, dims, dimsLen, coords);
//     }
//     else {
//         int i = dimsLen - 1;
//         while(coords[dims[i]] == shape::sizeAt(shapeInfo, dims[i]) - 1)
//             coords[dims[i--]] = 0;
//         ++coords[dims[i]];
//     }
// }

//////////////////////////////////////////////////////////////////////
// INLINEDEF _CUDA_HD void calcOffsets(const Nd4jLong *xShapeInfo, Nd4jLong*& xOffsets, const Nd4jLong *yShapeInfo, Nd4jLong*& yOffsets, const Nd4jLong* zShapeInfo, Nd4jLong*& zOffsets, const char order) {

//     // we assume all array have same length
//     const Nd4jLong len = shape::length(xShapeInfo);

//     const Nd4jLong xEws = shape::elementWiseStride(xShapeInfo);
//     const Nd4jLong yEws = shape::elementWiseStride(yShapeInfo);
//     const Nd4jLong zEws = shape::elementWiseStride(zShapeInfo);

//     const char xOrder = shape::order(xShapeInfo);
//     const char yOrder = shape::order(yShapeInfo);
//     const char zOrder = shape::order(zShapeInfo);

//     const bool shapesSame = shape::shapeEquals(xShapeInfo, yShapeInfo, zShapeInfo);

//     if (xEws == 1 && yEws == 1 && zEws == 1 && xOrder == yOrder && xOrder == zOrder && (xOrder == 'c' || shapesSame)) {
//         xOffsets = yOffsets = zOffsets = nullptr;
//     }
//     else if(xEws == 1 && yEws == 1 && xOrder == yOrder && (xOrder == 'c' || shape::shapeEquals(xShapeInfo, yShapeInfo))) {
//         xOffsets = yOffsets = nullptr;
//         zOffsets = new Nd4jLong[len];
//         shape::calcOffsets(zShapeInfo, zOffsets, xOrder);
//     }
//     else if(xEws == 1 && zEws == 1 && xOrder == zOrder && (xOrder == 'c' || shape::shapeEquals(xShapeInfo, zShapeInfo))) {
//         xOffsets = zOffsets = nullptr;
//         yOffsets = new Nd4jLong[len];
//         shape::calcOffsets(yShapeInfo, yOffsets, xOrder);
//     }
//     else if(yEws == 1 && zEws == 1 && yOrder == zOrder && (yOrder == 'c' || shape::shapeEquals(yShapeInfo, zShapeInfo))) {
//         yOffsets = zOffsets = nullptr;
//         xOffsets = new Nd4jLong[len];
//         shape::calcOffsets(xShapeInfo, xOffsets, yOrder);
//     }
//     else if(xEws == 1) {
//         xOffsets = nullptr;
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 yOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(yShapeInfo, yOffsets, xOrder);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 zOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(zShapeInfo, zOffsets, xOrder);
//             }
//         }
//     }
//     else if(yEws == 1) {
//         yOffsets = nullptr;
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets, yOrder);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 zOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(zShapeInfo, zOffsets, yOrder);
//             }
//         }
//     }
//     else if(zEws == 1) {
//         zOffsets = nullptr;
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets, zOrder);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 yOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(yShapeInfo, yOffsets, zOrder);
//             }
//         }
//     }
//     else if(shape::haveSameShapeAndStrides(xShapeInfo, yShapeInfo, zShapeInfo)) {
//         xOffsets = new Nd4jLong[len];
//         shape::calcOffsets(xShapeInfo, xOffsets);
//         yOffsets = zOffsets = xOffsets;
//     }
//     else if(shape::haveSameShapeAndStrides(xShapeInfo, yShapeInfo)) {
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 zOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(zShapeInfo, zOffsets);
//             }
//         }
//         yOffsets = xOffsets;
//     }
//     else if(shape::haveSameShapeAndStrides(xShapeInfo, zShapeInfo)) {
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 yOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(yShapeInfo, yOffsets);
//             }
//         }
//         zOffsets = xOffsets;
//     }
//     else {
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 yOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(yShapeInfo, yOffsets);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 zOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(zShapeInfo, zOffsets);
//             }
//         }
//     }
// }

//////////////////////////////////////////////////////////////////////
// INLINEDEF _CUDA_HD void calcOffsets(const Nd4jLong *xShapeInfo, Nd4jLong*& xOffsets, const Nd4jLong *yShapeInfo, Nd4jLong*& yOffsets, const char order) {

//     // we assume all array have same length
//     const Nd4jLong len = shape::length(xShapeInfo);

//     const Nd4jLong xEws = shape::elementWiseStride(xShapeInfo);
//     const Nd4jLong yEws = shape::elementWiseStride(yShapeInfo);

//     const char xOrder = shape::order(xShapeInfo);
//     const char yOrder = shape::order(yShapeInfo);

//     const bool shapesSame = shape::shapeEquals(xShapeInfo, yShapeInfo);

//     if (xEws == 1 && yEws == 1 && xOrder == yOrder && (xOrder == 'c' || shapesSame)) {
//         xOffsets = yOffsets = nullptr;
//     }
//     else if(xEws == 1) {
//         xOffsets = nullptr;
//         yOffsets = new Nd4jLong[len];
//         shape::calcOffsets(yShapeInfo, yOffsets, xOrder);
//     }
//     else if(yEws == 1) {
//         yOffsets = nullptr;
//         xOffsets = new Nd4jLong[len];
//         shape::calcOffsets(xShapeInfo, xOffsets, yOrder);
//     }
//     else if(shape::haveSameShapeAndStrides(xShapeInfo, yShapeInfo)) {
//         xOffsets = new Nd4jLong[len];
//         shape::calcOffsets(xShapeInfo, xOffsets);
//         yOffsets = xOffsets;
//     }
//     else {
//         PRAGMA_OMP_PARALLEL_SECTIONS
//         {
//             PRAGMA_OMP_SECTION
//             {
//                 xOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(xShapeInfo, xOffsets);
//             }
//             PRAGMA_OMP_SECTION
//             {
//                 yOffsets = new Nd4jLong[len];
//                 shape::calcOffsets(yShapeInfo, yOffsets);
//             }
//         }
//     }
// }


//////////////////////////////////////////////////////////////////////
// INLINEDEF _CUDA_HD Nd4jLong strideOverContigAxis(const int axis, const Nd4jLong* inShapeInfo) {

//     Nd4jLong result = 9223372036854775807LL;

//     for(uint i = 0; i < shape::rank(inShapeInfo); ++i) {

//         const auto currentStride = shape::stride(inShapeInfo)[i];

//         if(i == axis || shape::shapeOf(inShapeInfo)[i] == 1)
//             continue;

//         if(result > currentStride)
//             result = currentStride;
//     }

//     return result == 9223372036854775807LL ? 1 : result;
// }





// #endif /* SHAPE_H_ */


// Parsed from array/ShapeList.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_SHAPELIST_H
// #define LIBND4J_SHAPELIST_H

// #include <vector>
// #include <helpers/shape.h>
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class ShapeList extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ShapeList(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ShapeList(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ShapeList position(long position) {
            return (ShapeList)super.position(position);
        }
        @Override public ShapeList getPointer(long i) {
            return new ShapeList((Pointer)this).position(position + i);
        }
    
        public ShapeList(@Cast("const Nd4jLong*") LongPointer shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shape/*=nullptr*/);
        public ShapeList() { super((Pointer)null); allocate(); }
        private native void allocate();
        public ShapeList(@Cast("const Nd4jLong*") LongBuffer shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shape/*=nullptr*/);
        public ShapeList(@Cast("const Nd4jLong*") long[] shape/*=nullptr*/) { super((Pointer)null); allocate(shape); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shape/*=nullptr*/);
        public ShapeList(@Cast("const Nd4jLong**") @StdVector PointerPointer shapes, @Cast("bool") boolean isWorkspace) { super((Pointer)null); allocate(shapes, isWorkspace); }
        private native void allocate(@Cast("const Nd4jLong**") @StdVector PointerPointer shapes, @Cast("bool") boolean isWorkspace);
        public ShapeList(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr LongPointer shapes, @Cast("bool") boolean isWorkspace) { super((Pointer)null); allocate(shapes, isWorkspace); }
        private native void allocate(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr LongPointer shapes, @Cast("bool") boolean isWorkspace);
        public ShapeList(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr LongBuffer shapes, @Cast("bool") boolean isWorkspace) { super((Pointer)null); allocate(shapes, isWorkspace); }
        private native void allocate(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr LongBuffer shapes, @Cast("bool") boolean isWorkspace);
        public ShapeList(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr long[] shapes, @Cast("bool") boolean isWorkspace) { super((Pointer)null); allocate(shapes, isWorkspace); }
        private native void allocate(@Cast("const Nd4jLong**") @StdVector @ByPtrPtr long[] shapes, @Cast("bool") boolean isWorkspace);
        public ShapeList(@Cast("const Nd4jLong**") @StdVector PointerPointer shapes) { super((Pointer)null); allocate(shapes); }
        private native void allocate(@Cast("const Nd4jLong**") @StdVector PointerPointer shapes);
        //ShapeList(bool autoRemovable);

        public native @Cast("const Nd4jLong**") @StdVector PointerPointer asVector();
        public native void destroy();
        public native int size();
        public native @Cast("const Nd4jLong*") LongPointer at(int idx);
        public native void push_back(@Cast("const Nd4jLong*") LongPointer shape);
        public native void push_back(@Cast("const Nd4jLong*") LongBuffer shape);
        public native void push_back(@Cast("const Nd4jLong*") long[] shape);

        /**
         * PLEASE NOTE: This method should be called ONLY if shapes were generated at workspaces. Otherwise you'll get memory leak
         */
        public native void detach();
    }



// #endif //LIBND4J_SHAPELIST_H


// Parsed from ops/InputType.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef ND4J_INPUTTYPE_H
// #define ND4J_INPUTTYPE_H
        /** enum sd::ops::InputType */
        public static final int
            InputType_BOOLEAN = 0,
            InputType_NUMERIC = 1,
            InputType_STRINGULAR = 2,
            InputType_NUMERIC_SET = 3,
            InputType_STRINGULAR_SET = 4;
    


// #endif

// Parsed from ops/declarable/OpDescriptor.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_OPDESCRIPTOR_H
// #define LIBND4J_OPDESCRIPTOR_H

// #include <string>
// #include <vector>
// #include <initializer_list>
// #include <helpers/helper_hash.h>
// #include <ops/InputType.h>
// #include <graph/generated/node_generated.h>
// #include <array/DataType.h>

        /**
        *   This class is very basic info holder for ops. bean/pojo pretty much.
        *
        */
        @Namespace("sd::ops") @NoOffset public static class OpDescriptor extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public OpDescriptor(Pointer p) { super(p); }
        
            // default constructor
            public OpDescriptor(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace); }
            private native void allocate(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace);
            public OpDescriptor(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace); }
            private native void allocate(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace);

            // constructor for boolean ops
            public OpDescriptor(int numInputs, @StdString BytePointer opName, @Cast("bool") boolean isScalar) { super((Pointer)null); allocate(numInputs, opName, isScalar); }
            private native void allocate(int numInputs, @StdString BytePointer opName, @Cast("bool") boolean isScalar);
            public OpDescriptor(int numInputs, @StdString String opName, @Cast("bool") boolean isScalar) { super((Pointer)null); allocate(numInputs, opName, isScalar); }
            private native void allocate(int numInputs, @StdString String opName, @Cast("bool") boolean isScalar);

            // default constructor

            // constructor for configurable op
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs);
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, int tArgs, int iArgs);

            // constructor for non-configurable divergent op
            public OpDescriptor(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent); }
            private native void allocate(int numInputs, int numOutputs, @StdString BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent);
            public OpDescriptor(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent); }
            private native void allocate(int numInputs, int numOutputs, @StdString String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent);

            // constructor for non-configurable divergent op

            // constructor for configurable divergent op
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") String opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs);
            public OpDescriptor(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs) { super((Pointer)null); allocate(numInputs, numOutputs, opName, allowsInplace, divergent, tArgs, iArgs); }
            private native void allocate(int numInputs, int numOutputs, @Cast("char*") BytePointer opName, @Cast("bool") boolean allowsInplace, @Cast("bool") boolean divergent, int tArgs, int iArgs);

            // constructor for logical ops (while, scope, etc)
            public OpDescriptor(@Cast("char*") String opName, @Cast("bool") boolean isLogic) { super((Pointer)null); allocate(opName, isLogic); }
            private native void allocate(@Cast("char*") String opName, @Cast("bool") boolean isLogic);
            public OpDescriptor(@Cast("char*") BytePointer opName, @Cast("bool") boolean isLogic) { super((Pointer)null); allocate(opName, isLogic); }
            private native void allocate(@Cast("char*") BytePointer opName, @Cast("bool") boolean isLogic);

            public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef OpDescriptor other);

            // default destructor

            // this method returns minimal expected number of T arguments
            public native int getNumberOfTArgs();

            // this method returns minimal expected number of Integer arguments
            public native int getNumberOfIArgs();

            // this method returns minimal expected number of inputs
            public native int getNumberOfInputs();

            // this method returns hash code for this operation
            public native @Cast("Nd4jLong") long getHash();

            // this method returns minimal expected number of outputs
            public native int getNumberOfOutputs();

            // this method returns opName (can be empty)
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            // returns TRUE if this op is divergent. FALSE otherwise
            public native @Cast("bool") boolean isDivergent();

            // returns TRUE if this op allows in-place execution
            public native @Cast("bool") boolean allowsInplace();

            // this method allows you to enable/disable inplace call for a given op
            public native void allowInplace(@Cast("bool") boolean reallyAllow);

            // this method returns opNum (applicable for legacy XYZ ops only)
            public native int getOpNum();

            // this method allows to set specifc opNum
            public native void setOpNum(int opNum);

            public native void setHash(@Cast("Nd4jLong") long hash);

            public native @Cast("sd::ops::InputType") int inputType();



            public native OpDescriptor setInputType(@Cast("sd::ops::InputType") int type);
            public native OpDescriptor setAllowedInputTypes(int index, @Cast("sd::DataType*") @StdVector IntPointer dtype);
            public native OpDescriptor setAllowedInputTypes(int index, @Cast("sd::DataType*") @StdVector IntBuffer dtype);
            public native OpDescriptor setAllowedInputTypes(int index, @Cast("sd::DataType*") @StdVector int[] dtype);
            public native OpDescriptor setAllowedOutputTypes(int index, @Cast("sd::DataType*") @StdVector IntPointer dtype);
            public native OpDescriptor setAllowedOutputTypes(int index, @Cast("sd::DataType*") @StdVector IntBuffer dtype);
            public native OpDescriptor setAllowedOutputTypes(int index, @Cast("sd::DataType*") @StdVector int[] dtype);
            public native OpDescriptor setAllowedInputTypes(int index,  @Cast("sd::DataType") int dtype);
            public native OpDescriptor setAllowedOutputTypes(int index, @Cast("sd::DataType") int dtype);
            public native OpDescriptor setAllowedInputTypes(@Cast("sd::DataType") int dtype);
            public native OpDescriptor setAllowedOutputTypes(@Cast("sd::DataType") int dtype);
            public native OpDescriptor allowOverride(@Cast("bool") boolean reallyAllow);
            public native OpDescriptor setSameMode(@Cast("bool") boolean reallySame);
            public native OpDescriptor setInputType(int idx, @Cast("sd::DataType") int dtype);
            public native OpDescriptor setOutputType(int idx, @Cast("sd::DataType") int dtype);

            public native @Cast("sd::DataType*") @StdVector IntPointer getOutputTypesForOutput(int index);

            public native @Cast("bool") boolean checkInputMatch(int index, @Cast("sd::DataType") int dataType);
            public native @Cast("bool") boolean checkOutputMatch(int index, @Cast("sd::DataType") int dataType);
            public native @Cast("bool") boolean isSameMode();

            public native @Cast("bool") boolean isInherit(int index);
        }
    


// #endif //LIBND4J_OPDESCRIPTOR_H


// Parsed from ops/declarable/PlatformHelper.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef SD_PLATFORMHELPER_H
// #define SD_PLATFORMHELPER_H

// #include <helpers/ShapeUtils.h>
// #include <execution/Engine.h>
// #include <graph/Context.h>
// #include <string>
// #include <system/pointercast.h>
// #include <system/dll.h>
            /**
             * This abstract class defines methods used by platform-specific helpers implementations
             */
            @Namespace("sd::ops::platforms") @NoOffset public static class PlatformHelper extends Pointer {
                static { Loader.load(); }
                /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
                public PlatformHelper(Pointer p) { super(p); }
            

                public native @StdString BytePointer name();

                public native @Cast("samediff::Engine") int engine();

                public native @Cast("Nd4jLong") long hash();

                /**
                 * This method checks, if given helper can be used with given input/output/configuration options
                 *
                 * @param context
                 * @return
                 */
                public native @Cast("bool") boolean isUsable(@ByRef Context context);

                /**
                 * This method invokes helper. Typically this method replaces actual op execution
                 *
                 * @param context
                 * @return
                 */
                public native @Cast("Nd4jStatus") int invokeHelper(@ByRef Context context);

                /**
                 * Helper method, needed for compatibility with DeclarableOp macros
                 * @param ctx
                 * @param inputId
                 * @return
                 */
                public native NDArray getZ(@ByRef Context ctx, int inputId);

                /**
                 * Helper method, needed for compatibility with DeclarableOp macros
                 * @param ctx
                 * @param inputId
                 * @return
                 */
                public native NDArray getNullifiedZ(@ByRef Context ctx, int inputId);
            }
        
    



// #endif //SD_PLATFORMHELPER_H


// Parsed from ops/declarable/BroadcastableOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver on 6/6/2018.
//

// #ifndef LIBND4J_BROADCASTABLEOP_H
// #define LIBND4J_BROADCASTABLEOP_H

// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include "DeclarableOp.h"
// #include "DeclarableCustomOp.h"
        @Namespace("sd::ops") public static class BroadcastableOp extends DeclarableCustomOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public BroadcastableOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    



// #endif //LIBND4J_BROADCASTABLEOP_H


// Parsed from ops/declarable/BroadcastableBoolOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver on 6/6/2018.
//

// #ifndef SD_BROADCASTABLEBOOLOP_H
// #define SD_BROADCASTABLEBOOLOP_H

// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include "DeclarableOp.h"
// #include "DeclarableCustomOp.h"
        @Namespace("sd::ops") public static class BroadcastableBoolOp extends DeclarableCustomOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public BroadcastableBoolOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    



// #endif //SD_BROADCASTABLEBOOLOP_H


// Parsed from helpers/OpArgsHolder.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author Yurii Shyrma (iuriish@yahoo.com), created on 15.07.2018
//

// #ifndef LIBND4J_OPARGSHOLDER_H
// #define LIBND4J_OPARGSHOLDER_H


// #include <array/NDArray.h>
// #include <system/dll.h>

@Namespace("sd") @NoOffset public static class OpArgsHolder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpArgsHolder(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OpArgsHolder(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public OpArgsHolder position(long position) {
        return (OpArgsHolder)super.position(position);
    }
    @Override public OpArgsHolder getPointer(long i) {
        return new OpArgsHolder((Pointer)this).position(position + i);
    }


    // default constructor
	public OpArgsHolder() { super((Pointer)null); allocate(); }
	private native void allocate();

    // copy constructor
    public OpArgsHolder(@Const @ByRef OpArgsHolder other) { super((Pointer)null); allocate(other); }
    private native void allocate(@Const @ByRef OpArgsHolder other);

    // constructor
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs) { super((Pointer)null); allocate(inArrs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector DoublePointer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongPointer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector DoubleBuffer tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/);
    public OpArgsHolder(@Const @ByRef NDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/) { super((Pointer)null); allocate(inArrs, tArgs, iArgs, bArgs); }
    private native void allocate(@Const @ByRef NDArrayVector inArrs, @StdVector double[] tArgs/*=std::vector<double>()*/, @Cast("Nd4jLong*") @StdVector long[] iArgs/*=std::vector<Nd4jLong>()*/, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/);

    // move constructor

    // assignment operator
    public native @ByRef @Name("operator =") OpArgsHolder put(@Const @ByRef OpArgsHolder other);

    // move assignment operator

    public native @Const @ByRef NDArrayVector getInArrs();

    public native @StdVector DoublePointer getTArgs();

    public native @Cast("Nd4jLong*") @StdVector LongPointer getIArgs();

    public native @Cast("bool*") @StdVector BooleanPointer getBArgs();

    public native @Cast("bool*") @StdVector BooleanPointer getAllocInfo();

    public native int getNumInArrs();

    public native int getNumTArgs();

    public native int getNumIArgs();

    public native int getNumBArgs();

    public native @ByVal OpArgsHolder createArgsHolderForBP(@Const @ByRef NDArrayVector inGradArrs, @Cast("const bool") boolean isInPlace/*=false*/);
    public native @ByVal OpArgsHolder createArgsHolderForBP(@Const @ByRef NDArrayVector inGradArrs);

}







// #endif //LIBND4J_OPARGSHOLDER_H


// Parsed from ops/declarable/DeclarableOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_DECLARABLE_OPS_H
// #define LIBND4J_DECLARABLE_OPS_H

// #include <sstream>
// #include <types/float16.h>
// #include <system/pointercast.h>
// #include <array/NDArray.h>
// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include <helpers/helper_hash.h>
// #include <array/ShapeList.h>
// #include <array/ResultSet.h>
// #include <helpers/OpArgsHolder.h>
// #include <system/dll.h>
// #include <ops/declarable/EmptyHandling.h>
//#include <ops/declarable/declarable_ops.h>

// #include <chrono>
// #include <ctime>
// #include <mutex>

        @Namespace("sd::ops") public native @Cast("Nd4jStatus") int conditionHelper(@Cast("char*") String file, int line, int condition, int argNumber, @Cast("char*") String format);
        @Namespace("sd::ops") public native @Cast("Nd4jStatus") int conditionHelper(@Cast("char*") BytePointer file, int line, int condition, int argNumber, @Cast("char*") BytePointer format);

        /**
         * This class is the basic building block of Graph Operations. Any CustomOp out there is built on top of this "abstract" class.
         *
         */
        @Namespace("sd::ops") @NoOffset public static class DeclarableOp extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DeclarableOp(Pointer p) { super(p); }
        
            // for special cases, like BooleanOps

            // regular constructors

            // for LogicalOps

            // default testructor

            // this method returns OpDescriptor, describing this Op instance
            public native OpDescriptor getOpDescriptor();

            public native @Cast("Nd4jStatus") int validateDataTypes(@ByRef Context block);

            /**
            *   This method should be available in each implemented Op, and should return Op output shape(s), for a given input shape(s)
            */
            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);

            /**
             * Returns opName
             *
             * @return
             */
            public native @StdString @Cast({"char*", "std::string*"}) BytePointer getOpName();

            /**
             * Returns opHash
             */
            public native @Cast("Nd4jLong") long getOpHash();

            /**
             * This method sets arguments for op
             */
//            void setArguments();

            /**
             * This method returns pointer to results
             */
//            void getResults();

            /**
             * This method executes given Op
             *
             * @param block
             * @return 0 if OK, error code otherwise
             */
            public native @Cast("Nd4jStatus") int execute(Context block);

            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs);

            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @Cast("Nd4jStatus") int execute(@Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);

            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs);

            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet evaluate(@Const @ByRef NDArrayVector inputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector boolean[] bArgs/*=std::vector<bool>()*/, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/);

            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector boolean[] bArgs, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector boolean[] bArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector boolean[] bArgs, @Cast("sd::DataType*") @StdVector IntPointer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoublePointer tArgs, @Cast("Nd4jLong*") @StdVector LongPointer iArgs, @Cast("bool*") @StdVector boolean[] bArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs, @Cast("sd::DataType*") @StdVector IntBuffer dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector DoubleBuffer tArgs, @Cast("Nd4jLong*") @StdVector LongBuffer iArgs, @Cast("bool*") @StdVector BooleanPointer bArgs);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector boolean[] bArgs, @Cast("sd::DataType*") @StdVector int[] dArgs/*=std::vector<sd::DataType>()*/, @Cast("bool") boolean isInplace/*=false*/, @Cast("sd::DataType") int type/*=sd::DataType::FLOAT32*/);
            public native @Cast("Nd4jStatus") int execute(@ByRef RandomGenerator rng, @Const @ByRef NDArrayVector inputs, @Const @ByRef NDArrayVector outputs, @StdVector double[] tArgs, @Cast("Nd4jLong*") @StdVector long[] iArgs, @Cast("bool*") @StdVector boolean[] bArgs);

            public native @ByVal ResultSet execute(@Const @ByRef OpArgsHolder holder, @Cast("bool") boolean isInplace/*=false*/);
            public native @ByVal ResultSet execute(@Const @ByRef OpArgsHolder holder);


            // There methods provide various validation options
            public native @Cast("Nd4jStatus") int validateNonEmptyInput(@ByRef Context block);

            // this method checks if all input arrays have equal lengths
            public native @Cast("Nd4jStatus") int validateInputLengthMatch(@ByRef Context block);

            // this method checks if all input arrays have the same shapes (orders/strides are NOT checked)
            public native @Cast("Nd4jStatus") int validateInputDimensionsMatch(@ByRef Context block);

            // this method check if all input arrays have the same orders
            public native @Cast("Nd4jStatus") int validateOrdersMatch(@ByRef Context block);

            // this method checks if all input arrays are 2D
            public native @Cast("Nd4jStatus") int validateInput2D(@ByRef Context block);

            // this method checks if all input arrays are 3D
            public native @Cast("Nd4jStatus") int validateInput3D(@ByRef Context block);

            // this method checks if all input arrays are 4D
            public native @Cast("Nd4jStatus") int validateInput4D(@ByRef Context block);

            // this method checks if all input arrays are ND
            public native @Cast("Nd4jStatus") int validateInputDimensions(@ByRef Context block, int rank);

            // this method checks if number of available arguments matches op expectations
            public native @Cast("Nd4jStatus") int validateArguments(@ByRef Context block);
        }
    


// #endif //LIBND4J_DECLARABLE_OPS_H


// Parsed from ops/declarable/DeclarableListOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef LIBND4J_DECLARABLE_LIST_OP_H
// #define LIBND4J_DECLARABLE_LIST_OP_H

// #include <array/ResultSet.h>
// #include <graph/Context.h>
// #include <ops/declarable/OpRegistrator.h>
// #include <ops/declarable/DeclarableOp.h>
        @Namespace("sd::ops") public static class DeclarableListOp extends DeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DeclarableListOp(Pointer p) { super(p); }
        

            
            public native @Cast("Nd4jStatus") int execute(Context block);
            public native @ByVal ResultSet execute(NDArrayList list, @ByRef NDArrayVector inputs, @StdVector DoublePointer tArgs, @StdVector IntPointer iArgs);
            public native @ByVal ResultSet execute(NDArrayList list, @ByRef NDArrayVector inputs, @StdVector DoubleBuffer tArgs, @StdVector IntBuffer iArgs);
            public native @ByVal ResultSet execute(NDArrayList list, @ByRef NDArrayVector inputs, @StdVector double[] tArgs, @StdVector int[] iArgs);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    


// #endif

// Parsed from ops/declarable/DeclarableReductionOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_DECLARABLE_REDUCTION_OP_H
// #define LIBND4J_DECLARABLE_REDUCTION_OP_H

// #include <ops/declarable/DeclarableOp.h>
        @Namespace("sd::ops") public static class DeclarableReductionOp extends DeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DeclarableReductionOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    


// #endif //LIBND4J_DECLARABLE_REDUCTION_OP_H


// Parsed from ops/declarable/DeclarableCustomOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_DECLARABLECUSTOMOP_H
// #define LIBND4J_DECLARABLECUSTOMOP_H

// #include <ops/declarable/DeclarableOp.h>
        @Namespace("sd::ops") public static class DeclarableCustomOp extends DeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public DeclarableCustomOp(Pointer p) { super(p); }
        

            public native ShapeList calculateOutputShape(ShapeList inputShapes, @ByRef Context block);
        }
    


// #endif //LIBND4J_DECLARABLECUSTOMOP_H


// Parsed from ops/declarable/BooleanOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 13.10.2017.
//

// #ifndef LIBND4J_BOOLEANOP_H
// #define LIBND4J_BOOLEANOP_H

// #include <graph/Context.h>
// #include "OpDescriptor.h"
// #include "DeclarableOp.h"
        @Namespace("sd::ops") @NoOffset public static class BooleanOp extends DeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public BooleanOp(Pointer p) { super(p); }
        

            public native @Cast("bool") boolean verify(@Const @ByRef NDArrayVector args);
            public native @Cast("bool") boolean verify(@ByRef Context block);

            public native @Cast("Nd4jStatus") int execute(Context block);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    




// #endif //LIBND4J_BOOLEANOP_H

// Parsed from ops/declarable/LogicOp.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 15.10.2017.
//

// #ifndef LIBND4J_LOGICOP_H
// #define LIBND4J_LOGICOP_H

// #include "DeclarableOp.h"

        /**
         * Logic ops are unique snowflakes in any Graph. They dramatically change Graph Execution process, by introducing loops, conditions, etc.
         *
         * Their code is the part of GraphExecutioner logic. But we still want them to be expressed via Graph
         * \tparam T
         */
        @Namespace("sd::ops") public static class LogicOp extends DeclarableOp {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public LogicOp(Pointer p) { super(p); }
        
            public LogicOp(@Cast("char*") String name) { super((Pointer)null); allocate(name); }
            private native void allocate(@Cast("char*") String name);
            public LogicOp(@Cast("char*") BytePointer name) { super((Pointer)null); allocate(name); }
            private native void allocate(@Cast("char*") BytePointer name);

            public native ShapeList calculateOutputShape(ShapeList inputShape, @ByRef Context block);
        }
    



// #endif //LIBND4J_LOGICOP_H


// Parsed from ops/declarable/OpRegistrator.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_OPREGISTRATOR_H
// #define LIBND4J_OPREGISTRATOR_H

// #include <system/pointercast.h>
// #include <vector>
// #include <unordered_map>
// #include <mutex>
// #include <ops/declarable/DeclarableOp.h>
// #include <ops/declarable/PlatformHelper.h>
// #include <execution/Engine.h>

// handlers part
// #include <cstdlib>
// #include <csignal>

// #ifndef __JAVACPP_HACK__

// #endif
        /**
        *   This class provides runtime ops lookup, based on opName or opHash.
        *   To build lookup directory we use *_OP_IMPL macro, which puts static structs at compile time in .cpp files,
        *   so once binary is executed, static objects are initialized automatically, and we get list of all ops
        *   available at runtime via this singleton.
        *
        */
        @Namespace("sd::ops") @NoOffset public static class OpRegistrator extends Pointer {
            static { Loader.load(); }
            /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
            public OpRegistrator(Pointer p) { super(p); }
        

            public native @ByRef OpRegistrator getInstance();

            public native void exitHandler();
            public native void sigIntHandler(int sig);
            public native void sigSegVHandler(int sig);

            
            public native @Cast("char*") String getAllCustomOperations();

            /**
            * This method registers operation in our registry, so we can use them later
            *
            * @param op
            */
            public native @Cast("bool") boolean registerOperation(@Cast("char*") String name, DeclarableOp op);
            public native @Cast("bool") boolean registerOperation(@Cast("char*") BytePointer name, DeclarableOp op);
            public native @Cast("bool") boolean registerOperation(DeclarableOp op);

            public native void registerHelper(PlatformHelper op);

            public native @Cast("bool") boolean hasHelper(@Cast("Nd4jLong") long hash, @Cast("samediff::Engine") int engine);

            public native DeclarableOp getOperation(@Cast("char*") String name);
            public native DeclarableOp getOperation(@Cast("char*") BytePointer name);
            public native DeclarableOp getOperation(@Cast("Nd4jLong") long hash);

            public native PlatformHelper getPlatformHelper(@Cast("Nd4jLong") long hash, @Cast("samediff::Engine") int engine);

            public native @Cast("Nd4jLong*") @StdVector LongPointer getAllHashes();

            public native int numberOfOperations();
    }


        /*
         *  These structs are used to "register" our ops in OpRegistrator.
         */

    


// #endif //LIBND4J_OPREGISTRATOR_H


// Parsed from execution/ContextBuffers.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// @author raver119@gmail.com
//

// #ifndef LIBND4J_CONTEXTBUFFERS_H
// #define LIBND4J_CONTEXTBUFFERS_H

// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <execution/ErrorReference.h>
    @Namespace("sd") @NoOffset public static class ContextBuffers extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public ContextBuffers(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public ContextBuffers(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public ContextBuffers position(long position) {
            return (ContextBuffers)super.position(position);
        }
        @Override public ContextBuffers getPointer(long i) {
            return new ContextBuffers((Pointer)this).position(position + i);
        }
    
        public ContextBuffers() { super((Pointer)null); allocate(); }
        private native void allocate();
        public ContextBuffers(@Const @ByRef ContextBuffers other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef ContextBuffers other);
        public ContextBuffers(Pointer rPointer, Pointer sPointer, Pointer aPointer, @Cast("bool") boolean isOwner/*=false*/) { super((Pointer)null); allocate(rPointer, sPointer, aPointer, isOwner); }
        private native void allocate(Pointer rPointer, Pointer sPointer, Pointer aPointer, @Cast("bool") boolean isOwner/*=false*/);
        public ContextBuffers(Pointer rPointer, Pointer sPointer, Pointer aPointer) { super((Pointer)null); allocate(rPointer, sPointer, aPointer); }
        private native void allocate(Pointer rPointer, Pointer sPointer, Pointer aPointer);

        public native @ByRef @Name("operator =") ContextBuffers put(@Const @ByRef ContextBuffers other);

        public native void release();

        public native Pointer reductionBuffer();
        public native Pointer scalarBuffer();
        public native Pointer allocationBuffer();

        public native Pointer execStream();
        public native Pointer specialStream();

        public native void setReductionBuffer(Pointer pointer);
        public native void setScalarBuffer(Pointer pointer);
        public native void setAllocationBuffer(Pointer pointer);

        public native ErrorReference errorReference();

        public native void triggerOwnership(@Cast("bool") boolean isOwner);

        public native int deviceId();

        public native @Cast("bool") boolean isInitialized();
    }



// #endif //DEV_TESTS_CONTEXTBUFFERS_H


// Parsed from execution/LaunchContext.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 30.11.17.
//

// #ifndef LIBND4J_CUDACONTEXT_H
// #define LIBND4J_CUDACONTEXT_H


// #ifdef __CUDABLAS__
// #include <cuda.h>
// #include <cuda_runtime_api.h>
// #include <cuda_runtime.h>
// #include <cuda_device_runtime_api.h>
// #include "config.h"
// #endif

// used for MKLDNN etc
// #if !defined(__STANDALONE_BUILD__)
// #include "config.h"
// #endif

// #include <system/dll.h>
// #include <memory>
// #include <system/op_boilerplate.h>
// #include <memory/Workspace.h>
// #include <vector>
// #include <mutex>
// #include <execution/ContextBuffers.h>
// #include <execution/ErrorReference.h>

@Namespace("sd") @NoOffset public static class LaunchContext extends Pointer {
    static { Loader.load(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public LaunchContext(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public LaunchContext position(long position) {
        return (LaunchContext)super.position(position);
    }
    @Override public LaunchContext getPointer(long i) {
        return new LaunchContext((Pointer)this).position(position + i);
    }

// #ifdef __CUDABLAS__

// #ifndef __JAVACPP_HACK__

// #endif // JCPP

// #endif // CUDA
		public LaunchContext(@Cast("Nd4jPointer") Pointer cudaStream, @Cast("Nd4jPointer") Pointer reductionPointer/*=nullptr*/, @Cast("Nd4jPointer") Pointer scalarPointer/*=nullptr*/, @Cast("Nd4jPointer") Pointer allocationPointer/*=nullptr*/) { super((Pointer)null); allocate(cudaStream, reductionPointer, scalarPointer, allocationPointer); }
		private native void allocate(@Cast("Nd4jPointer") Pointer cudaStream, @Cast("Nd4jPointer") Pointer reductionPointer/*=nullptr*/, @Cast("Nd4jPointer") Pointer scalarPointer/*=nullptr*/, @Cast("Nd4jPointer") Pointer allocationPointer/*=nullptr*/);
		public LaunchContext(@Cast("Nd4jPointer") Pointer cudaStream) { super((Pointer)null); allocate(cudaStream); }
		private native void allocate(@Cast("Nd4jPointer") Pointer cudaStream);
    	public LaunchContext() { super((Pointer)null); allocate(); }
    	private native void allocate();
    	public native Workspace getWorkspace();
    	public native void setWorkspace(Workspace theWorkspace);

    	public native Pointer engine();

    	public native int getDeviceID();
    	public native void setDeviceID(int deviceID);
        public native ErrorReference errorReference();

// #ifndef __JAVACPP_HACK__

// #endif

    	public native @Cast("bool") boolean isInitialized();
    	public native void releaseBuffers();


	    public native LaunchContext defaultContext();


    	public native void swapContextBuffers(@ByRef ContextBuffers buffers);

}




// #endif //LIBND4J_CUDACONTEXT_H


// Parsed from array/ShapeDescriptor.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//  @author AbdelRauf 

// #ifndef DEV_TESTS_SHAPEDESCRIPTOR_H
// #define DEV_TESTS_SHAPEDESCRIPTOR_H

// #include <unordered_map>
// #include <vector>
// #include <system/dll.h>
// #include <system/pointercast.h>
// #include <array/ArrayOptions.h>
// #include <array/DataType.h>
// #include <initializer_list>


public static final int SHAPE_DESC_OK = 0;
public static final int SHAPE_DESC_INCORRECT_STRIDES = 1; //strides does not match shapes
public static final int SHAPE_DESC_INCORRECT_EWS = 2; //ews neither matches stride nor continuity
public static final int SHAPE_DESC_INCORRECT_RANK = 4; //rank > 32 or shape size and rank does not match

@Namespace("sd") @NoOffset public static class ShapeDescriptor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ShapeDescriptor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ShapeDescriptor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ShapeDescriptor position(long position) {
        return (ShapeDescriptor)super.position(position);
    }
    @Override public ShapeDescriptor getPointer(long i) {
        return new ShapeDescriptor((Pointer)this).position(position + i);
    }

        public ShapeDescriptor(@Const @ByRef ShapeDescriptor other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef ShapeDescriptor other);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/) { super((Pointer)null); allocate(shapeInfo, inheritDtype); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongPointer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/) { super((Pointer)null); allocate(shapeInfo, inheritDtype); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongBuffer shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo);
        public ShapeDescriptor(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/) { super((Pointer)null); allocate(shapeInfo, inheritDtype); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("bool") boolean inheritDtype/*=true*/);
        public ShapeDescriptor(@Cast("const Nd4jLong*") long[] shapeInfo) { super((Pointer)null); allocate(shapeInfo); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const sd::DataType") int dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const sd::DataType") int dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const sd::DataType") int dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const sd::DataType") int dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const sd::DataType") int dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const sd::DataType") int dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] dtypeOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] dtypeOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer dtypeOverride, @Cast("const Nd4jLong*") LongPointer orderOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride, orderOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer shapeInfo, @Cast("const Nd4jLong*") LongPointer dtypeOverride, @Cast("const Nd4jLong*") LongPointer orderOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer dtypeOverride, @Cast("const Nd4jLong*") LongBuffer orderOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride, orderOverride); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer shapeInfo, @Cast("const Nd4jLong*") LongBuffer dtypeOverride, @Cast("const Nd4jLong*") LongBuffer orderOverride);
        public ShapeDescriptor(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] dtypeOverride, @Cast("const Nd4jLong*") long[] orderOverride) { super((Pointer)null); allocate(shapeInfo, dtypeOverride, orderOverride); }
        private native void allocate(@Cast("const Nd4jLong*") long[] shapeInfo, @Cast("const Nd4jLong*") long[] dtypeOverride, @Cast("const Nd4jLong*") long[] orderOverride);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, @Cast("const Nd4jLong") long length) { super((Pointer)null); allocate(type, length); }
        private native void allocate(@Cast("const sd::DataType") int type, @Cast("const Nd4jLong") long length);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongPointer shape, int rank) { super((Pointer)null); allocate(type, order, shape, rank); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongPointer shape, int rank);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongBuffer shape, int rank) { super((Pointer)null); allocate(type, order, shape, rank); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongBuffer shape, int rank);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") long[] shape, int rank) { super((Pointer)null); allocate(type, order, shape, rank); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") long[] shape, int rank);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape) { super((Pointer)null); allocate(type, order, shape); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape) { super((Pointer)null); allocate(type, order, shape); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape) { super((Pointer)null); allocate(type, order, shape); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("Nd4jLong*") @StdVector LongPointer strides) { super((Pointer)null); allocate(type, order, shape, strides); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("Nd4jLong*") @StdVector LongPointer strides);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("Nd4jLong*") @StdVector LongBuffer strides) { super((Pointer)null); allocate(type, order, shape, strides); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("Nd4jLong*") @StdVector LongBuffer strides);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("Nd4jLong*") @StdVector long[] strides) { super((Pointer)null); allocate(type, order, shape, strides); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("Nd4jLong*") @StdVector long[] strides);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("Nd4jLong*") @StdVector LongPointer strides, @Cast("const Nd4jLong") long ews) { super((Pointer)null); allocate(type, order, shape, strides, ews); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("Nd4jLong*") @StdVector LongPointer strides, @Cast("const Nd4jLong") long ews);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("Nd4jLong*") @StdVector LongBuffer strides, @Cast("const Nd4jLong") long ews) { super((Pointer)null); allocate(type, order, shape, strides, ews); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("Nd4jLong*") @StdVector LongBuffer strides, @Cast("const Nd4jLong") long ews);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("Nd4jLong*") @StdVector long[] strides, @Cast("const Nd4jLong") long ews) { super((Pointer)null); allocate(type, order, shape, strides, ews); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("Nd4jLong*") @StdVector long[] strides, @Cast("const Nd4jLong") long ews);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras) { super((Pointer)null); allocate(type, order, shape, strides, rank, ews, extras); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongPointer shape, @Cast("const Nd4jLong*") LongPointer strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras) { super((Pointer)null); allocate(type, order, shape, strides, rank, ews, extras); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") LongBuffer shape, @Cast("const Nd4jLong*") LongBuffer strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);
        public ShapeDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras) { super((Pointer)null); allocate(type, order, shape, strides, rank, ews, extras); }
        private native void allocate(@Cast("const sd::DataType") int type, byte order, @Cast("const Nd4jLong*") long[] shape, @Cast("const Nd4jLong*") long[] strides, int rank, @Cast("Nd4jLong") long ews, @Cast("Nd4jLong") long extras);

        public ShapeDescriptor() { super((Pointer)null); allocate(); }
        private native void allocate();

        public native int rank();
        public native @Cast("Nd4jLong") long ews();
        public native @Cast("Nd4jLong") long arrLength();
        public native char order();
        public native @Cast("sd::DataType") int dataType();
        public native @Cast("bool") boolean isEmpty();
        public native @Cast("Nd4jLong*") @StdVector LongPointer shape();
        public native @Cast("Nd4jLong*") @StdVector LongPointer strides();

        //returns minimal allocation length
        public native @Cast("Nd4jLong") long allocLength();

        //returns Status for the correctness
        public native @Cast("Nd4jLong") long validate();

        // we use default copy assignment operator
        public native @ByRef @Name("operator =") ShapeDescriptor put(@Const @ByRef ShapeDescriptor other);

        // we use default move assignment operator

        // equal to operator
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef ShapeDescriptor other);

        // less than operator
        public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef ShapeDescriptor other);

        public native @Cast("Nd4jLong*") LongPointer toShapeInfo();



        public native @ByVal ShapeDescriptor emptyDescriptor(@Cast("const sd::DataType") int type);
        public native @ByVal ShapeDescriptor scalarDescriptor(@Cast("const sd::DataType") int type);
        public native @ByVal ShapeDescriptor vectorDescriptor(@Cast("const Nd4jLong") long length, @Cast("const sd::DataType") int type);

        //create Descriptor with padded buffer.
        public native @ByVal ShapeDescriptor paddedBufferDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongPointer shape, @Cast("Nd4jLong*") @StdVector LongPointer paddings);
        public native @ByVal ShapeDescriptor paddedBufferDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector LongBuffer shape, @Cast("Nd4jLong*") @StdVector LongBuffer paddings);
        public native @ByVal ShapeDescriptor paddedBufferDescriptor(@Cast("const sd::DataType") int type, byte order, @Cast("Nd4jLong*") @StdVector long[] shape, @Cast("Nd4jLong*") @StdVector long[] paddings);
    }


// #ifndef __JAVACPP_HACK__

// #endif


// #endif //DEV_TESTS_SHAPEDESCRIPTOR_H


// Parsed from array/TadDescriptor.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
//  @author raver119@gmail.com
//

// #ifndef DEV_TESTS_TADDESCRIPTOR_H
// #define DEV_TESTS_TADDESCRIPTOR_H

// #include "ShapeDescriptor.h"
// #include <system/dll.h>
    @Namespace("sd") @NoOffset public static class TadDescriptor extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public TadDescriptor(Pointer p) { super(p); }
    
        public TadDescriptor(@Cast("const Nd4jLong*") LongPointer originalShape, @Const IntPointer dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(originalShape, dimensions, length, keepUnitiesInShape); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer originalShape, @Const IntPointer dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Cast("const Nd4jLong*") LongPointer originalShape, @Const IntPointer dimensions, int length) { super((Pointer)null); allocate(originalShape, dimensions, length); }
        private native void allocate(@Cast("const Nd4jLong*") LongPointer originalShape, @Const IntPointer dimensions, int length);
        public TadDescriptor(@Cast("const Nd4jLong*") LongBuffer originalShape, @Const IntBuffer dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(originalShape, dimensions, length, keepUnitiesInShape); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer originalShape, @Const IntBuffer dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Cast("const Nd4jLong*") LongBuffer originalShape, @Const IntBuffer dimensions, int length) { super((Pointer)null); allocate(originalShape, dimensions, length); }
        private native void allocate(@Cast("const Nd4jLong*") LongBuffer originalShape, @Const IntBuffer dimensions, int length);
        public TadDescriptor(@Cast("const Nd4jLong*") long[] originalShape, @Const int[] dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(originalShape, dimensions, length, keepUnitiesInShape); }
        private native void allocate(@Cast("const Nd4jLong*") long[] originalShape, @Const int[] dimensions, int length, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Cast("const Nd4jLong*") long[] originalShape, @Const int[] dimensions, int length) { super((Pointer)null); allocate(originalShape, dimensions, length); }
        private native void allocate(@Cast("const Nd4jLong*") long[] originalShape, @Const int[] dimensions, int length);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntPointer dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(descriptor, dimensions, keepUnitiesInShape); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntPointer dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntPointer dimensions) { super((Pointer)null); allocate(descriptor, dimensions); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntPointer dimensions);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntBuffer dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(descriptor, dimensions, keepUnitiesInShape); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntBuffer dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntBuffer dimensions) { super((Pointer)null); allocate(descriptor, dimensions); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector IntBuffer dimensions);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector int[] dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/) { super((Pointer)null); allocate(descriptor, dimensions, keepUnitiesInShape); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector int[] dimensions, @Cast("const bool") boolean keepUnitiesInShape/*=false*/);
        public TadDescriptor(@Const @ByRef ShapeDescriptor descriptor, @StdVector int[] dimensions) { super((Pointer)null); allocate(descriptor, dimensions); }
        private native void allocate(@Const @ByRef ShapeDescriptor descriptor, @StdVector int[] dimensions);
        public TadDescriptor(@Const @ByRef TadDescriptor other) { super((Pointer)null); allocate(other); }
        private native void allocate(@Const @ByRef TadDescriptor other);

        // we use default copy assignment operator
        public native @ByRef @Name("operator =") TadDescriptor put(@Const @ByRef TadDescriptor other);

        // we use default move assignment operator

        // equal to operator
        public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef TadDescriptor other);

        // less than operator
        public native @Cast("bool") @Name("operator <") boolean lessThan(@Const @ByRef TadDescriptor other);

        public native @StdVector IntPointer axis();
        public native @ByRef ShapeDescriptor originalShape();
        public native @Const @ByRef ShapeDescriptor originalShapeConst();
        public native @Cast("bool") boolean areUnitiesinShape();
    }


// #ifndef __JAVACPP_HACK__

// #endif


// #endif //DEV_TESTS_TADDESCRIPTOR_H


// Parsed from helpers/DebugInfo.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by GS aka shugeo <sgazeos@gmail.com> on 3/12/19.
//

// #ifndef LIBND4J__DEBUG_INFO_HELPER__H
// #define LIBND4J__DEBUG_INFO_HELPER__H

// #include <system/pointercast.h>
// #include <system/op_boilerplate.h>
// #include <system/Environment.h>
// #include <helpers/StringUtils.h>
// #include <string>
// #include <system/dll.h>
// #include <math/templatemath.h>

// #ifdef __CUDACC__

// #endif
    @Namespace("sd") public static class DebugInfo extends Pointer {
        static { Loader.load(); }
        /** Default native constructor. */
        public DebugInfo() { super((Pointer)null); allocate(); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public DebugInfo(long size) { super((Pointer)null); allocateArray(size); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public DebugInfo(Pointer p) { super(p); }
        private native void allocate();
        private native void allocateArray(long size);
        @Override public DebugInfo position(long position) {
            return (DebugInfo)super.position(position);
        }
        @Override public DebugInfo getPointer(long i) {
            return new DebugInfo((Pointer)this).position(position + i);
        }
    
       public native double _minValue(); public native DebugInfo _minValue(double setter);
       public native double _maxValue(); public native DebugInfo _maxValue(double setter);
       public native double _meanValue(); public native DebugInfo _meanValue(double setter);
       public native double _stdDevValue(); public native DebugInfo _stdDevValue(double setter);
       public native @Cast("Nd4jLong") long _zeroCount(); public native DebugInfo _zeroCount(long setter);
       public native @Cast("Nd4jLong") long _positiveCount(); public native DebugInfo _positiveCount(long setter);
       public native @Cast("Nd4jLong") long _negativeCount(); public native DebugInfo _negativeCount(long setter);
       public native @Cast("Nd4jLong") long _infCount(); public native DebugInfo _infCount(long setter);
       public native @Cast("Nd4jLong") long _nanCount(); public native DebugInfo _nanCount(long setter);
    }

    @Namespace("sd") public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef DebugInfo first, @Const @ByRef DebugInfo second);




// #endif //LIBND4J_DEBUGHELPER_H


// Parsed from ops/declarable/CustomOperations.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

//
// Created by raver119 on 07.10.2017.
//

// #ifndef LIBND4J_CUSTOMOPERATIONS_H
// #define LIBND4J_CUSTOMOPERATIONS_H

// #include <ops/declarable/headers/activations.h>
// #include <ops/declarable/headers/boolean.h>
// #include <ops/declarable/headers/broadcastable.h>
// #include <ops/declarable/headers/convo.h>
// #include <ops/declarable/headers/compression.h>
// #include <ops/declarable/headers/list.h>
// #include <ops/declarable/headers/recurrent.h>
// #include <ops/declarable/headers/transforms.h>
// #include <ops/declarable/headers/parity_ops.h>
// #include <ops/declarable/headers/shape.h>
// #include <ops/declarable/headers/random.h>
// #include <ops/declarable/headers/nlp.h>
// #include <ops/declarable/headers/nn.h>
// #include <ops/declarable/headers/blas.h>
// #include <ops/declarable/headers/bitwise.h>
// #include <ops/declarable/headers/loss.h>
// #include <ops/declarable/headers/datatypes.h>
// #include <ops/declarable/headers/third_party.h>
// #include <ops/declarable/headers/tests.h>
// #include <ops/declarable/headers/kernels.h>
// #include <ops/declarable/headers/strings.h>
// #include <ops/declarable/headers/compat.h>
// #include <ops/declarable/headers/util.h>
// #include <ops/declarable/headers/BarnesHutTsne.h>
// #include <ops/declarable/headers/images.h>
// #include <ops/declarable/headers/updaters.h>
// #include <ops/declarable/headers/decoder.h>
// #include <system/dll.h>
// #include <helpers/shape.h>
// #include <helpers/TAD.h>
// #include <graph/Status.h>
// #include <helpers/ArrayUtils.h>
// #include <helpers/ShapeBuilders.h>
// #include <array/NDArrayFactory.h>
// #include <helpers/OpTracker.h>
// #include <helpers/ConstantShapeHelper.h>
// #include <helpers/ConstantTadHelper.h>
    @Namespace("sd") public static class _loader extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public _loader(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public _loader(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public _loader position(long position) {
            return (_loader)super.position(position);
        }
        @Override public _loader getPointer(long i) {
            return new _loader((Pointer)this).position(position + i);
        }
    
        public _loader() { super((Pointer)null); allocate(); }
        private native void allocate();
    }

        // logic ops 
        
        
        
        
        


        /**
         * This operations exposes given arguments as it's own outputs, but does it only once.
         * Subsequent calls will be served directly by this op.
         *
         * PLEASE NOTE: This operation is internal graph operation, and shouldn't be used directly usually.
         */
        
    


// #endif //LIBND4J_CUSTOMOPERATIONS_H


// Parsed from build_info.h

/* ******************************************************************************
 *
 *
 * This program and the accompanying materials are made available under the
 * terms of the Apache License, Version 2.0 which is available at
 * https://www.apache.org/licenses/LICENSE-2.0.
 *
 *  See the NOTICE file distributed with this work for additional
 *  information regarding copyright ownership.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 ******************************************************************************/

// #ifndef LIBND4J_BUILD_INFO_H
// #define LIBND4J_BUILD_INFO_H

// #ifdef  _WIN32
// #define ND4J_EXPORT   __declspec( dllexport )
// #else
// #define ND4J_EXPORT
// #endif

// #define STRINGIFY(x) #x
// #define TOSTRING(x) STRINGIFY(x)

// #ifdef __cplusplus
// #endif

public native @Cast("char*") String buildInfo();

// #ifdef __cplusplus
// #endif

// #endif


}
