/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.mbean;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.management.stats.ServiceStatistics;
import org.mule.model.seda.SedaService;
import org.mule.module.management.mbean.FlowConstructService;
import org.mule.module.management.mbean.ServiceServiceMBean;
import org.mule.module.management.mbean.ServiceStats;
import org.mule.module.management.mbean.ServiceStatsMBean;
import org.mule.service.AbstractService;

public class ServiceService
extends FlowConstructService
implements ServiceServiceMBean,
MBeanRegistration,
ServiceStatsMBean {
    private static Log LOGGER = LogFactory.getLog(ServiceService.class);
    private ServiceStatistics statistics = this.getComponent().getStatistics();

    public ServiceService(String name, MuleContext muleContext) {
        super("Service", name, muleContext);
        ((FlowConstructService)this).statistics = this.statistics;
    }

    @Override
    public int getQueueSize() {
        AbstractService c = this.getComponent();
        if (c instanceof SedaService) {
            return (int)c.getStatistics().getQueuedEvents();
        }
        return -1;
    }

    @Override
    public void pause() throws MuleException {
        this.getComponent().pause();
    }

    @Override
    public void resume() throws MuleException {
        this.getComponent().resume();
    }

    @Override
    public boolean isPaused() {
        return this.getComponent().isPaused();
    }

    @Override
    public boolean isStopped() {
        return this.getComponent().isStopped();
    }

    public void stop() throws MuleException {
        this.getComponent().stop();
    }

    @Override
    public void forceStop() throws MuleException {
        this.getComponent().forceStop();
    }

    @Override
    public boolean isStopping() {
        return this.getComponent().isStopping();
    }

    @Override
    public void dispose() throws MuleException {
        this.getComponent().dispose();
    }

    public void start() throws MuleException {
        this.getComponent().start();
    }

    @Override
    public ObjectName getStatistics() {
        return this.statsName;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return super.preRegister(server, name);
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        try {
            if (this.getComponent().getStatistics() != null) {
                String quotedName = ObjectName.quote(this.getName());
                this.statsName = new ObjectName(this.objectName.getDomain() + ":type=org.mule.Statistics,service=" + quotedName);
                if (this.server.isRegistered(this.statsName)) {
                    this.server.unregisterMBean(this.statsName);
                }
                this.server.registerMBean(new ServiceStats(this.getComponent().getStatistics()), this.statsName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error post-registering the MBean", (Throwable)e);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    @Override
    public void postDeregister() {
        super.postDeregister();
    }

    private AbstractService getComponent() {
        return (AbstractService)this.muleContext.getRegistry().lookupService(this.getName());
    }

    @Override
    public void clearStatistics() {
        this.statistics.clear();
    }

    @Override
    public long getAsyncEventsReceived() {
        return this.statistics.getAsyncEventsReceived();
    }

    @Override
    public long getSyncEventsReceived() {
        return this.statistics.getSyncEventsReceived();
    }

    @Override
    public long getTotalEventsReceived() {
        return this.statistics.getTotalEventsReceived();
    }

    @Override
    public long getAsyncEventsSent() {
        return this.statistics.getAsyncEventsSent();
    }

    @Override
    public long getAverageExecutionTime() {
        return this.statistics.getAverageExecutionTime();
    }

    @Override
    public long getAverageQueueSize() {
        return this.statistics.getAverageQueueSize();
    }

    @Override
    public long getExecutedEvents() {
        return this.statistics.getExecutedEvents();
    }

    @Override
    public long getMaxExecutionTime() {
        return this.statistics.getMaxExecutionTime();
    }

    @Override
    public long getMaxQueueSize() {
        return this.statistics.getMaxQueueSize();
    }

    @Override
    public long getMinExecutionTime() {
        return this.statistics.getMinExecutionTime();
    }

    @Override
    public long getQueuedEvents() {
        return this.statistics.getQueuedEvents();
    }

    @Override
    public long getReplyToEventsSent() {
        return this.statistics.getReplyToEventsSent();
    }

    @Override
    public long getSyncEventsSent() {
        return this.statistics.getSyncEventsSent();
    }

    @Override
    public long getTotalEventsSent() {
        return this.statistics.getTotalEventsSent();
    }

    @Override
    public long getTotalExecutionTime() {
        return this.statistics.getTotalExecutionTime();
    }
}

