/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.BranchesIntermediary;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlDocument;
import com.mongodb.client.model.mql.MqlExpression;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.SwitchCase;
import java.util.ArrayList;
import java.util.function.Function;

@Beta(value={Reason.CLIENT})
public final class Branches<T extends MqlValue> {
    Branches() {
    }

    private static <T extends MqlValue, R extends MqlValue> BranchesIntermediary<T, R> with(Function<T, SwitchCase<R>> switchCase) {
        ArrayList v = new ArrayList();
        v.add(switchCase);
        return new BranchesIntermediary(v);
    }

    private static <T extends MqlValue> MqlExpression<?> mqlEx(T value) {
        return (MqlExpression)value;
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> is(Function<? super T, MqlBoolean> predicate, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("predicate", predicate);
        Assertions.notNull("mapping", mapping);
        return Branches.with(value -> new SwitchCase<MqlValue>((MqlBoolean)predicate.apply(value), (MqlValue)mapping.apply(value)));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> eq(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.eq((MqlValue)v), mapping);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> lt(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.lt((MqlValue)v), mapping);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> lte(T v, Function<? super T, ? extends R> mapping) {
        Assertions.notNull("v", v);
        Assertions.notNull("mapping", mapping);
        return this.is(value -> value.lte((MqlValue)v), mapping);
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isBoolean(Function<? super MqlBoolean, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isBoolean(), v -> (MqlValue)mapping.apply((MqlBoolean)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isNumber(Function<? super MqlNumber, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isNumber(), v -> (MqlValue)mapping.apply((MqlNumber)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isInteger(Function<? super MqlInteger, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isInteger(), v -> (MqlValue)mapping.apply((MqlInteger)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isString(Function<? super MqlString, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isString(), v -> (MqlValue)mapping.apply((MqlString)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isDate(Function<? super MqlDate, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isDate(), v -> (MqlValue)mapping.apply((MqlDate)v));
    }

    public <R extends MqlValue, Q extends MqlValue> BranchesIntermediary<T, R> isArray(Function<? super MqlArray<Q>, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isArray(), v -> (MqlValue)mapping.apply((MqlArray)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isDocument(Function<? super MqlDocument, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isDocumentOrMap(), v -> (MqlValue)mapping.apply((MqlDocument)v));
    }

    public <R extends MqlValue, Q extends MqlValue> BranchesIntermediary<T, R> isMap(Function<? super MqlMap<Q>, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isDocumentOrMap(), v -> (MqlValue)mapping.apply((MqlMap)v));
    }

    public <R extends MqlValue> BranchesIntermediary<T, R> isNull(Function<? super MqlValue, ? extends R> mapping) {
        Assertions.notNull("mapping", mapping);
        return this.is(v -> Branches.mqlEx(v).isNull(), v -> (MqlValue)mapping.apply((MqlValue)v));
    }
}

