/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.nio.channels.AsynchronousChannelGroup;

public final class AsynchronousSocketChannelStreamFactoryFactory
implements StreamFactoryFactory {
    private final InetAddressResolver inetAddressResolver;
    @Nullable
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver) {
        this(inetAddressResolver, null);
    }

    AsynchronousSocketChannelStreamFactoryFactory(InetAddressResolver inetAddressResolver, @Nullable AsynchronousChannelGroup group) {
        this.inetAddressResolver = inetAddressResolver;
        this.group = group;
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new AsynchronousSocketChannelStreamFactory(this.inetAddressResolver, socketSettings, sslSettings, this.group);
    }

    @Override
    public void close() {
        if (this.group != null) {
            this.group.shutdown();
        }
    }
}

