/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.ByteBufBsonDocument;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CompositeByteBuf;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernHelper;
import com.mongodb.internal.connection.RequestMessage;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.FieldNameValidator;
import org.bson.io.BsonOutput;

public final class CommandMessage
extends RequestMessage {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final FieldNameValidator commandFieldNameValidator;
    private final ReadPreference readPreference;
    private final boolean exhaustAllowed;
    private final SplittablePayload payload;
    private final FieldNameValidator payloadFieldNameValidator;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, true, null, null, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean exhaustAllowed, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, true, exhaustAllowed, null, null, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(namespace, command, commandFieldNameValidator, readPreference, settings, responseExpected, false, payload, payloadFieldNameValidator, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace namespace, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, MessageSettings settings, boolean responseExpected, boolean exhaustAllowed, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(namespace.getFullName(), CommandMessage.getOpCode(settings, clusterConnectionMode, serverApi), settings);
        this.namespace = namespace;
        this.command = command;
        this.commandFieldNameValidator = commandFieldNameValidator;
        this.readPreference = readPreference;
        this.responseExpected = responseExpected;
        this.exhaustAllowed = exhaustAllowed;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        Assertions.assertTrue(this.useOpMsg() || responseExpected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonDocument getCommandDocument(ByteBufferBsonOutput bsonOutput) {
        List<ByteBuf> byteBuffers = bsonOutput.getByteBuffers();
        try {
            ByteBufBsonDocument byteBufBsonDocument;
            CompositeByteBuf byteBuf;
            block12: {
                byteBuf = new CompositeByteBuf(byteBuffers);
                try {
                    byteBuf.position(this.getEncodingMetadata().getFirstDocumentPosition());
                    byteBufBsonDocument = ByteBufBsonDocument.createOne(byteBuf);
                    if (!byteBuf.hasRemaining()) break block12;
                    BsonDocument commandBsonDocument = byteBufBsonDocument.toBaseBsonDocument();
                    while (byteBuf.hasRemaining()) {
                        byteBuf.position(byteBuf.position() + 1);
                        int sequenceStart = byteBuf.position();
                        int sequenceSizeInBytes = byteBuf.getInt();
                        int sectionEnd = sequenceStart + sequenceSizeInBytes;
                        String fieldName = this.getSequenceIdentifier(byteBuf);
                        Assertions.assertFalse(fieldName.contains("."));
                        ByteBuf documentsByteBufSlice = byteBuf.duplicate().limit(sectionEnd);
                        try {
                            commandBsonDocument.append(fieldName, (BsonValue)new BsonArray(ByteBufBsonDocument.createList(documentsByteBufSlice)));
                        }
                        finally {
                            documentsByteBufSlice.release();
                        }
                        byteBuf.position(sectionEnd);
                    }
                    BsonDocument bsonDocument = commandBsonDocument;
                    byteBuf.release();
                    return bsonDocument;
                }
                catch (Throwable throwable) {
                    byteBuf.release();
                    throw throwable;
                }
            }
            ByteBufBsonDocument byteBufBsonDocument2 = byteBufBsonDocument;
            byteBuf.release();
            return byteBufBsonDocument2;
        }
        finally {
            byteBuffers.forEach(ByteBuf::release);
        }
    }

    private String getSequenceIdentifier(ByteBuf byteBuf) {
        ByteArrayOutputStream sequenceIdentifierBytes = new ByteArrayOutputStream();
        byte curByte = byteBuf.get();
        while (curByte != 0) {
            sequenceIdentifierBytes.write(curByte);
            curByte = byteBuf.get();
        }
        try {
            return sequenceIdentifierBytes.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MongoInternalException("Unexpected exception", e);
        }
    }

    boolean isResponseExpected() {
        if (this.responseExpected) {
            return true;
        }
        return this.payload != null && this.payload.isOrdered() && this.payload.hasAnotherSplit();
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, OperationContext operationContext) {
        int commandStartPosition;
        int messageStartPosition = bsonOutput.getPosition() - 16;
        if (this.useOpMsg()) {
            int flagPosition = bsonOutput.getPosition();
            bsonOutput.writeInt32(0);
            bsonOutput.writeByte(0);
            commandStartPosition = bsonOutput.getPosition();
            this.addDocument(this.command, bsonOutput, this.commandFieldNameValidator, this.getExtraElements(operationContext));
            if (this.payload != null) {
                bsonOutput.writeByte(1);
                int payloadBsonOutputStartPosition = bsonOutput.getPosition();
                bsonOutput.writeInt32(0);
                bsonOutput.writeCString(this.payload.getPayloadName());
                BsonWriterHelper.writePayload((BsonWriter)new BsonBinaryWriter(bsonOutput, this.payloadFieldNameValidator), bsonOutput, this.getSettings(), messageStartPosition, this.payload, this.getSettings().getMaxDocumentSize());
                int payloadBsonOutputLength = bsonOutput.getPosition() - payloadBsonOutputStartPosition;
                bsonOutput.writeInt32(payloadBsonOutputStartPosition, payloadBsonOutputLength);
            }
            bsonOutput.writeInt32(flagPosition, this.getOpMsgFlagBits());
        } else {
            bsonOutput.writeInt32(0);
            bsonOutput.writeCString(this.namespace.getFullName());
            bsonOutput.writeInt32(0);
            bsonOutput.writeInt32(-1);
            commandStartPosition = bsonOutput.getPosition();
            ArrayList<BsonElement> elements = null;
            if (this.serverApi != null) {
                elements = new ArrayList<BsonElement>(3);
                this.addServerApiElements(elements);
            }
            this.addDocument(this.command, bsonOutput, this.commandFieldNameValidator, elements);
        }
        return new RequestMessage.EncodingMetadata(commandStartPosition);
    }

    private int getOpMsgFlagBits() {
        int flagBits = 0;
        if (!this.isResponseExpected()) {
            flagBits = 2;
        }
        if (this.exhaustAllowed) {
            flagBits |= 0x10000;
        }
        return flagBits;
    }

    private boolean isDirectConnectionToReplicaSetMember() {
        return this.clusterConnectionMode == ClusterConnectionMode.SINGLE && this.getSettings().getServerType() != ServerType.SHARD_ROUTER && this.getSettings().getServerType() != ServerType.STANDALONE;
    }

    private boolean useOpMsg() {
        return this.getOpCode().equals((Object)OpCode.OP_MSG);
    }

    private List<BsonElement> getExtraElements(OperationContext operationContext) {
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        ArrayList<BsonElement> extraElements = new ArrayList<BsonElement>();
        if (!this.getSettings().isCryptd()) {
            timeoutContext.runMaxTimeMS(maxTimeMS -> extraElements.add(new BsonElement("maxTimeMS", (BsonValue)new BsonInt64(maxTimeMS))));
        }
        extraElements.add(new BsonElement("$db", (BsonValue)new BsonString(new MongoNamespace(this.getCollectionName()).getDatabaseName())));
        if (sessionContext.getClusterTime() != null) {
            extraElements.add(new BsonElement("$clusterTime", (BsonValue)sessionContext.getClusterTime()));
        }
        if (sessionContext.hasSession()) {
            if (!sessionContext.isImplicitSession() && !this.getSettings().isSessionSupported()) {
                throw new MongoClientException("Attempting to use a ClientSession while connected to a server that doesn't support sessions");
            }
            if (this.getSettings().isSessionSupported() && this.responseExpected) {
                extraElements.add(new BsonElement("lsid", (BsonValue)sessionContext.getSessionId()));
            }
        }
        boolean firstMessageInTransaction = sessionContext.notifyMessageSent();
        Assertions.assertFalse(sessionContext.hasActiveTransaction() && sessionContext.isSnapshot());
        if (sessionContext.hasActiveTransaction()) {
            this.checkServerVersionForTransactionSupport();
            extraElements.add(new BsonElement("txnNumber", (BsonValue)new BsonInt64(sessionContext.getTransactionNumber())));
            if (firstMessageInTransaction) {
                extraElements.add(new BsonElement("startTransaction", (BsonValue)BsonBoolean.TRUE));
                this.addReadConcernDocument(extraElements, sessionContext);
            }
            extraElements.add(new BsonElement("autocommit", (BsonValue)BsonBoolean.FALSE));
        } else if (sessionContext.isSnapshot()) {
            this.addReadConcernDocument(extraElements, sessionContext);
        }
        if (this.serverApi != null) {
            this.addServerApiElements(extraElements);
        }
        if (this.readPreference != null) {
            if (!this.readPreference.equals(ReadPreference.primary())) {
                extraElements.add(new BsonElement("$readPreference", (BsonValue)this.readPreference.toDocument()));
            } else if (this.isDirectConnectionToReplicaSetMember()) {
                extraElements.add(new BsonElement("$readPreference", (BsonValue)ReadPreference.primaryPreferred().toDocument()));
            }
        }
        return extraElements;
    }

    private void addServerApiElements(List<BsonElement> extraElements) {
        extraElements.add(new BsonElement("apiVersion", (BsonValue)new BsonString(this.serverApi.getVersion().getValue())));
        if (this.serverApi.getStrict().isPresent()) {
            extraElements.add(new BsonElement("apiStrict", (BsonValue)BsonBoolean.valueOf((boolean)this.serverApi.getStrict().get())));
        }
        if (this.serverApi.getDeprecationErrors().isPresent()) {
            extraElements.add(new BsonElement("apiDeprecationErrors", (BsonValue)BsonBoolean.valueOf((boolean)this.serverApi.getDeprecationErrors().get())));
        }
    }

    private void checkServerVersionForTransactionSupport() {
        if (this.getSettings().getMaxWireVersion() < 8 && this.getSettings().getServerType() == ServerType.SHARD_ROUTER) {
            throw new MongoClientException("Transactions are not supported by the MongoDB cluster to which this client is connected.");
        }
    }

    private void addReadConcernDocument(List<BsonElement> extraElements, SessionContext sessionContext) {
        BsonDocument readConcernDocument = ReadConcernHelper.getReadConcernDocument(sessionContext, this.getSettings().getMaxWireVersion());
        if (!readConcernDocument.isEmpty()) {
            extraElements.add(new BsonElement("readConcern", (BsonValue)readConcernDocument));
        }
    }

    private static OpCode getOpCode(MessageSettings settings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return CommandMessage.isServerVersionKnown(settings) || clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED || serverApi != null ? OpCode.OP_MSG : OpCode.OP_QUERY;
    }

    private static boolean isServerVersionKnown(MessageSettings settings) {
        return settings.getMaxWireVersion() >= 7;
    }
}

