/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async;

import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncConsumer;
import com.mongodb.internal.async.AsyncFunction;
import com.mongodb.internal.async.AsyncSupplier;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface AsyncRunnable
extends AsyncSupplier<Void>,
AsyncConsumer<Void> {
    public static AsyncRunnable beginAsync() {
        return c -> c.complete(c);
    }

    default public void thenRunAndFinish(Runnable runnable, SingleResultCallback<Void> callback) {
        this.finish((r, e) -> {
            if (e != null) {
                callback.completeExceptionally(e);
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable t) {
                callback.completeExceptionally(t);
                return;
            }
            callback.complete((Void)((Object)callback));
        });
    }

    default public void thenAlwaysRunAndFinish(Runnable runnable, SingleResultCallback<Void> callback) {
        this.finish((r, e) -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                if (e != null) {
                    t.addSuppressed(e);
                }
                callback.completeExceptionally(t);
                return;
            }
            callback.onResult((Void)r, e);
        });
    }

    default public AsyncRunnable thenRun(AsyncRunnable runnable) {
        return c -> this.unsafeFinish((r, e) -> {
            if (e == null) {
                runnable.finish(c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public <T extends Throwable> AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable runnable, Class<T> exceptionClass, AsyncFunction<Throwable, Void> errorFunction) {
        return this.thenRunTryCatchAsyncBlocks(runnable, (Throwable e) -> exceptionClass.isInstance(e), errorFunction);
    }

    default public AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable runnable, Predicate<Throwable> errorCheck, AsyncFunction<Throwable, Void> errorFunction) {
        return this.thenRun(c -> AsyncRunnable.beginAsync().thenRun(runnable).onErrorIf(errorCheck, errorFunction).finish(c));
    }

    default public AsyncRunnable thenRunIf(Supplier<Boolean> condition, AsyncRunnable runnable) {
        return callback -> this.unsafeFinish((arg_0, arg_1) -> AsyncRunnable.lambda$thenRunIf$7(callback, (Supplier)condition, runnable, arg_0, arg_1));
    }

    default public <R> AsyncSupplier<R> thenSupply(AsyncSupplier<R> supplier) {
        return c -> this.unsafeFinish((r, e) -> {
            if (e == null) {
                supplier.finish(c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncRunnable thenRunRetryingWhile(TimeoutContext timeoutContext, AsyncRunnable runnable, Predicate<Throwable> shouldRetry) {
        return this.thenRun(callback -> new RetryingAsyncCallbackSupplier(new RetryState(timeoutContext), (rs, lastAttemptFailure) -> shouldRetry.test((Throwable)lastAttemptFailure), cb -> runnable.finish(cb)).get(callback));
    }

    private static /* synthetic */ void lambda$thenRunIf$7(SingleResultCallback callback, Supplier condition, AsyncRunnable runnable, Void r, Throwable e) {
        boolean matched;
        if (e != null) {
            callback.completeExceptionally(e);
            return;
        }
        try {
            matched = (Boolean)condition.get();
        }
        catch (Throwable t) {
            callback.completeExceptionally(t);
            return;
        }
        if (matched) {
            runnable.finish(callback);
        } else {
            callback.complete(callback);
        }
    }
}

