/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.HashMap;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseRollbackOneUpdateMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String deploymentId;
    @PropertyElement
    protected String force;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.commandName = "rollbackOneUpdate";
        super.execute();
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        CommandScope liquibaseCommand = new CommandScope(new String[]{"rollbackOneUpdate"});
        Map<String, Object> argsMap = this.getCommandArgsObjectMap(liquibase);
        ChangeLogParameters clp = new ChangeLogParameters(database);
        argsMap.put("changeLogParameters", clp);
        if (this.force == null || this.force != null && !Boolean.parseBoolean(this.force)) {
            throw new LiquibaseException("Invalid value for --force.  You must specify 'liquibase.force=true' to use rollbackOneUpdate.");
        }
        argsMap.put("force", Boolean.TRUE);
        argsMap.put("liquibase", liquibase);
        for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
            liquibaseCommand.addArgumentValue(entry.getKey(), entry.getValue());
        }
        liquibaseCommand.execute();
    }

    private Map<String, Object> getCommandArgsObjectMap(Liquibase liquibase) throws LiquibaseException {
        Database database = liquibase.getDatabase();
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("deploymentId", this.deploymentId);
        argsMap.put("force", this.force);
        argsMap.put("database", database);
        argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        argsMap.put("changeLogFile", this.changeLogFile);
        return argsMap;
    }
}

