/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.command.core.DiffCommandStep;
import liquibase.command.core.InternalSnapshotCommandStep;
import liquibase.command.core.helpers.AbstractChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.command.core.helpers.DiffOutputControlCommandStep;
import liquibase.command.core.helpers.ReferenceDbUrlConnectionCommandStep;
import liquibase.command.providers.ReferenceDatabase;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.CommandValidationException;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import org.apache.commons.lang3.StringUtils;

public class GenerateChangelogCommandStep
extends AbstractChangelogCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"generateChangelog"};
    private static final String INFO_MESSAGE = "BEST PRACTICE: When generating formatted SQL changelogs, always check if the 'splitStatements' attribute" + System.lineSeparator() + "works for your environment. See https://docs.liquibase.com/commands/inspection/generate-changelog.html for more information. ";
    public static final CommandArgumentDefinition<String> AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CONTEXT_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;
    public static final CommandArgumentDefinition<String> LABEL_FILTER_ARG;
    public static final CommandArgumentDefinition<String> DATA_OUTPUT_DIR_ARG;
    public static final CommandArgumentDefinition<Boolean> OVERWRITE_OUTPUT_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_URL_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_USERNAME_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_DRIVER_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_DRIVER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_SCHEMAS_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_LIQUIBASE_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> REFERENCE_LIQUIBASE_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<Boolean> USE_OR_REPLACE_OPTION;

    @Override
    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(DiffOutputControl.class, DiffResult.class);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String changeLogFile = StringUtils.trimToNull((String)commandScope.getArgumentValue(CHANGELOG_FILE_ARG));
        if (changeLogFile != null && changeLogFile.toLowerCase().endsWith(".sql")) {
            Scope.getCurrentScope().getUI().sendMessage("\n" + INFO_MESSAGE + "\n");
            Scope.getCurrentScope().getLog(this.getClass()).info("\n" + INFO_MESSAGE + "\n");
        }
        Database referenceDatabase = (Database)commandScope.getDependency(ReferenceDatabase.class);
        DbUrlConnectionCommandStep.logMdc(referenceDatabase.getConnection().getURL(), referenceDatabase);
        DiffOutputControl diffOutputControl = (DiffOutputControl)resultsBuilder.getResult(DiffOutputControlCommandStep.DIFF_OUTPUT_CONTROL.getName());
        diffOutputControl.setDataDir(commandScope.getArgumentValue(DATA_OUTPUT_DIR_ARG));
        referenceDatabase.setOutputDefaultSchema(diffOutputControl.getIncludeSchema());
        if (commandScope.getArgumentValue(USE_OR_REPLACE_OPTION).booleanValue()) {
            diffOutputControl.setReplaceIfExistsSet(true);
        }
        InternalSnapshotCommandStep.logUnsupportedDatabase(referenceDatabase, this.getClass());
        DiffResult diffResult = (DiffResult)resultsBuilder.getResult(DiffCommandStep.DIFF_RESULT.getName());
        DiffToChangeLog changeLogWriter = new DiffToChangeLog(diffResult, diffOutputControl, (Boolean)commandScope.getArgumentValue(SKIP_OBJECT_SORTING));
        changeLogWriter.setChangeSetAuthor(commandScope.getArgumentValue(AUTHOR_ARG));
        if (commandScope.getArgumentValue(CONTEXT_ARG) != null) {
            changeLogWriter.setChangeSetContext(commandScope.getArgumentValue(CONTEXT_ARG));
        } else {
            changeLogWriter.setChangeSetContext(commandScope.getArgumentValue(CONTEXTS_ARG));
        }
        if (commandScope.getArgumentValue(LABEL_FILTER_ARG) != null) {
            changeLogWriter.setChangeSetLabels(commandScope.getArgumentValue(LABEL_FILTER_ARG));
        }
        changeLogWriter.setChangeSetPath(changeLogFile);
        changeLogWriter.setChangeSetRunOnChangeTypes(((String)commandScope.getArgumentValue(RUN_ON_CHANGE_TYPES_ARG)).split("\\s*,\\s*"));
        changeLogWriter.setChangeReplaceIfExistsTypes(((String)commandScope.getArgumentValue(REPLACE_IF_EXISTS_TYPES_ARG)).split("\\s*,\\s*"));
        ObjectQuotingStrategy originalStrategy = referenceDatabase.getObjectQuotingStrategy();
        try {
            referenceDatabase.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            if (StringUtils.trimToNull((String)changeLogFile) != null) {
                Boolean overwriteOutputFile = commandScope.getArgumentValue(OVERWRITE_OUTPUT_FILE_ARG);
                changeLogWriter.print(changeLogFile, overwriteOutputFile);
            } else {
                try (PrintStream outputStream = new PrintStream(resultsBuilder.getOutputStream());){
                    changeLogWriter.print(outputStream);
                }
            }
            if (!this.areThereChangeObjectsToWrite(diffResult)) {
                Scope.getCurrentScope().getUI().sendMessage(String.format("Changelog not generated. There are no changesets to write to %s changelog", changeLogFile));
            } else {
                Scope.getCurrentScope().getUI().sendMessage("Generated changelog written to " + changeLogFile);
            }
        }
        finally {
            referenceDatabase.setObjectQuotingStrategy(originalStrategy);
        }
    }

    private boolean areThereChangeObjectsToWrite(DiffResult diffResult) {
        return diffResult.getMissingObjects().size() > 2 || !diffResult.getUnexpectedObjects().isEmpty() || !diffResult.getChangedObjects().isEmpty();
    }

    @Override
    public void validate(CommandScope commandScope) throws CommandValidationException {
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DATABASE_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_URL_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_USERNAME_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.USERNAME_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_PASSWORD_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.PASSWORD_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DRIVER_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DRIVER_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DEFAULT_SCHEMA_NAME_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_SCHEMA_NAME_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DEFAULT_CATALOG_NAME_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DEFAULT_CATALOG_NAME_ARG));
        commandScope.addArgumentValue(ReferenceDbUrlConnectionCommandStep.REFERENCE_DRIVER_PROPERTIES_FILE_ARG, commandScope.getArgumentValue(DbUrlConnectionArgumentsCommandStep.DRIVER_PROPERTIES_FILE_ARG));
        commandScope.addArgumentValue(DbUrlConnectionArgumentsCommandStep.SKIP_DATABASE_STEP_ARG, true);
        commandScope.addArgumentValue(DiffCommandStep.FORMAT_ARG, "none");
        GenerateChangelogCommandStep.validateConditionsToOverwriteChangelogFile(commandScope);
        GenerateChangelogCommandStep.validateReplaceIfExistsTypes(commandScope);
        GenerateChangelogCommandStep.validateRunOnChangeTypes(commandScope);
    }

    private static void validateConditionsToOverwriteChangelogFile(CommandScope commandScope) throws CommandValidationException {
        String changeLogFile = StringUtils.trimToNull((String)commandScope.getArgumentValue(CHANGELOG_FILE_ARG));
        if (changeLogFile != null) {
            Resource file;
            PathHandlerFactory pathHandlerFactory = Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            try {
                file = pathHandlerFactory.getResource(changeLogFile);
            }
            catch (IOException e) {
                throw new CommandValidationException(e);
            }
            Boolean overwriteOutputFile = commandScope.getArgumentValue(OVERWRITE_OUTPUT_FILE_ARG);
            if (file.exists() && !overwriteOutputFile.booleanValue()) {
                throw new CommandValidationException(String.format(coreBundle.getString("changelogfile.already.exists"), changeLogFile));
            }
        }
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Generate a changelog");
        commandDefinition.setLongDescription("Writes Change Log XML to copy the current state of the database to standard out or a file");
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = builder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Changelog file to write results").build();
        AUTHOR_ARG = builder.argument("author", String.class).description("Specifies the author for changesets in the generated changelog").build();
        CONTEXT_ARG = builder.argument("context", String.class).hidden().build();
        LABEL_FILTER_ARG = builder.argument("labelFilter", String.class).addAlias("labels").description("Changeset labels to generate").build();
        CONTEXTS_ARG = builder.argument("contextFilter", String.class).addAlias("contexts").description("Changeset contexts to generate").build();
        DATA_OUTPUT_DIR_ARG = builder.argument("dataOutputDirectory", String.class).description("Directory to write table data to").build();
        OVERWRITE_OUTPUT_FILE_ARG = builder.argument("overwriteOutputFile", Boolean.class).defaultValue(false).description("Flag to allow overwriting of output changelog file. Default: false").build();
        REFERENCE_URL_ARG = builder.argument("referenceUrl", String.class).hidden().build();
        REFERENCE_DEFAULT_SCHEMA_NAME_ARG = builder.argument("referenceDefaultSchemaName", String.class).hidden().build();
        REFERENCE_DEFAULT_CATALOG_NAME_ARG = builder.argument("referenceDefaultCatalogName", String.class).hidden().build();
        REFERENCE_DRIVER_ARG = builder.argument("referenceDriver", String.class).hidden().build();
        REFERENCE_DRIVER_PROPERTIES_FILE_ARG = builder.argument("referenceDriverPropertiesFile", String.class).hidden().build();
        REFERENCE_USERNAME_ARG = builder.argument("referenceUsername", String.class).hidden().build();
        REFERENCE_PASSWORD_ARG = builder.argument("referencePassword", String.class).hidden().setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        REFERENCE_SCHEMAS_ARG = builder.argument("referenceSchemas", String.class).hidden().build();
        REFERENCE_LIQUIBASE_SCHEMA_NAME_ARG = builder.argument("referenceLiquibaseSchemaName", String.class).hidden().build();
        REFERENCE_LIQUIBASE_CATALOG_NAME_ARG = builder.argument("referenceLiquibaseCatalogName", String.class).hidden().build();
        USE_OR_REPLACE_OPTION = builder.argument("useOrReplaceOption", Boolean.class).description("If true, will add 'OR REPLACE' option to the create view change object").defaultValue(false).build();
        builder.addArgument(AbstractChangelogCommandStep.RUN_ON_CHANGE_TYPES_ARG).build();
        builder.addArgument(AbstractChangelogCommandStep.REPLACE_IF_EXISTS_TYPES_ARG).build();
        builder.addArgument(AbstractChangelogCommandStep.SKIP_OBJECT_SORTING).build();
    }
}

