/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import liquibase.integration.commandline.LiquibaseCommandLine;

public class LiquibaseLauncher {
    private static boolean debug = false;

    public static void main(String[] args) throws Exception {
        ClassLoader parentLoader;
        String parentLoaderSetting;
        String debugSetting = System.getenv("LIQUIBASE_LAUNCHER_DEBUG");
        if (debugSetting != null && debugSetting.equals("true")) {
            debug = true;
            LiquibaseLauncher.debug("Debug mode enabled because LIQUIBASE_LAUNCHER_DEBUG is set to " + debugSetting);
        }
        if ((parentLoaderSetting = System.getenv("LIQUIBASE_LAUNCHER_PARENT_CLASSLOADER")) == null) {
            parentLoaderSetting = "system";
        }
        LiquibaseLauncher.debug("LIQUIBASE_LAUNCHER_PARENT_CLASSLOADER is set to " + parentLoaderSetting);
        String liquibaseHomeEnv = System.getenv("LIQUIBASE_HOME");
        LiquibaseLauncher.debug("LIQUIBASE_HOME: " + liquibaseHomeEnv);
        if (liquibaseHomeEnv == null || liquibaseHomeEnv.equals("")) {
            throw new IllegalArgumentException("Unable to find LIQUIBASE_HOME environment variable");
        }
        File liquibaseHome = new File(liquibaseHomeEnv);
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new File(liquibaseHome, "internal/lib/liquibase-core.jar").toURI().toURL());
        File[] libDirs = new File[]{new File("./liquibase_libs"), new File(liquibaseHome, "lib"), new File(liquibaseHome, "internal/lib")};
        for (File libDirFile : libDirs) {
            LiquibaseLauncher.debug("Looking for libraries in " + libDirFile.getAbsolutePath());
            if (!libDirFile.exists()) {
                LiquibaseLauncher.debug("Skipping directory " + libDirFile.getAbsolutePath() + " because it does not exist");
                continue;
            }
            File[] files = libDirFile.listFiles();
            if (files == null) {
                LiquibaseLauncher.debug("Skipping directory " + libDirFile.getAbsolutePath() + " because it does not list files");
                continue;
            }
            for (File lib : files) {
                if (!lib.getName().toLowerCase(Locale.US).endsWith(".jar") || lib.getName().toLowerCase(Locale.US).equals("liquibase-core.jar")) continue;
                try {
                    urls.add(lib.toURI().toURL());
                    LiquibaseLauncher.debug("Added " + lib.getAbsolutePath() + " to classpath");
                }
                catch (Exception e) {
                    LiquibaseLauncher.debug("Error adding " + lib.getAbsolutePath() + ":" + e.getMessage(), e);
                }
            }
            try {
                urls.add(libDirFile.toURI().toURL());
                LiquibaseLauncher.debug("Added " + libDirFile.getAbsolutePath() + " to classpath");
            }
            catch (Exception e) {
                LiquibaseLauncher.debug("Error adding " + libDirFile.getAbsolutePath() + ":" + e.getMessage(), e);
            }
        }
        if (debug) {
            LiquibaseLauncher.debug("Final Classpath:");
            for (URL url : urls) {
                LiquibaseLauncher.debug("  " + url.toString());
            }
        }
        if (parentLoaderSetting.equalsIgnoreCase("system")) {
            parentLoader = ClassLoader.getSystemClassLoader().getParent();
        } else if (parentLoaderSetting.equalsIgnoreCase("thread")) {
            parentLoader = Thread.currentThread().getContextClassLoader();
        } else {
            throw new RuntimeException("Unknown LIQUIBASE_LAUNCHER_PARENT_CLASSLOADER value: " + parentLoaderSetting);
        }
        URLClassLoader classloader = new URLClassLoader(urls.toArray(new URL[0]), parentLoader);
        Thread.currentThread().setContextClassLoader(classloader);
        Class<?> cli = classloader.loadClass(LiquibaseCommandLine.class.getName());
        cli.getMethod("main", String[].class).invoke(null, new Object[]{args});
    }

    private static void debug(String message) {
        if (debug) {
            LiquibaseLauncher.debug(message, null);
        }
    }

    private static void debug(String message, Throwable e) {
        if (debug) {
            System.err.println("[LIQUIBASE LAUNCHER DEBUG] " + message);
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }
    }
}

