/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.connections.httpclient.DefaultHttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;
import org.keycloak.utils.ScopeUtil;

public class DefaultHttpClientFactoryTest {
    private static final String DISABLE_TRUST_MANAGER_PROPERTY = "disable-trust-manager";
    private static final String TEST_DOMAIN = "keycloak.org";

    @Test
    public void createHttpClientProviderWithDisableTrustManager() throws IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(DISABLE_TRUST_MANAGER_PROPERTY, "true");
        DefaultHttpClientFactory factory = new DefaultHttpClientFactory();
        factory.init((Config.Scope)ScopeUtil.createScope(values));
        ResteasyKeycloakSession session = new ResteasyKeycloakSession(new ResteasyKeycloakSessionFactory());
        HttpClientProvider provider = factory.create((KeycloakSession)session);
        Optional<String> testURL = this.getTestURL();
        Assume.assumeTrue((String)"Could not get test url for domain", (boolean)testURL.isPresent());
        try (CloseableHttpClient httpClient = provider.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testURL.get()));){
            Assert.assertEquals((long)404L, (long)response.getStatusLine().getStatusCode());
        }
    }

    @Test(expected=SSLPeerUnverifiedException.class)
    public void createHttpClientProviderWithUnvailableURL() throws IOException {
        DefaultHttpClientFactory factory = new DefaultHttpClientFactory();
        factory.init((Config.Scope)ScopeUtil.createScope(new HashMap<String, String>()));
        ResteasyKeycloakSession session = new ResteasyKeycloakSession(new ResteasyKeycloakSessionFactory());
        HttpClientProvider provider = factory.create((KeycloakSession)session);
        try (CloseableHttpClient httpClient = provider.getHttpClient();){
            Optional<String> testURL = this.getTestURL();
            Assume.assumeTrue((String)"Could not get test url for domain", (boolean)testURL.isPresent());
            httpClient.execute((HttpUriRequest)new HttpGet(testURL.get()));
        }
    }

    private Optional<String> getTestURL() {
        try {
            return Optional.of("https://" + InetAddress.getByName(TEST_DOMAIN).getHostAddress());
        }
        catch (UnknownHostException e) {
            return Optional.empty();
        }
    }
}

