/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.util.List;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;

public class CoreConfigUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static IDPSSODescriptorType getIDPDescriptor(EntitiesDescriptorType entitiesDescriptor) {
        IDPSSODescriptorType idp = null;
        List entitiesList = entitiesDescriptor.getEntityDescriptor();
        for (Object theObject : entitiesList) {
            if (theObject instanceof EntitiesDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntitiesDescriptorType)theObject);
            } else if (theObject instanceof EntityDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)theObject);
            }
            if (idp == null) continue;
            break;
        }
        return idp;
    }

    public static IDPSSODescriptorType getIDPDescriptor(EntityDescriptorType entityDescriptor) {
        List edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                IDPSSODescriptorType idpSSO = edtDesc.getIdpDescriptor();
                if (idpSSO == null) continue;
                return idpSSO;
            }
        }
        return null;
    }

    public static SPSSODescriptorType getSPDescriptor(EntityDescriptorType entityDescriptor) {
        List edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                SPSSODescriptorType spSSO = edtDesc.getSpDescriptor();
                if (spSSO == null) continue;
                return spSSO;
            }
        }
        return null;
    }

    public static String getIdentityURL(IDPSSODescriptorType idp, String bindingURI) {
        String identityURL = null;
        List endpoints = idp.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            identityURL = endpoint.getLocation().toString();
            break;
        }
        return identityURL;
    }

    public static String getLogoutURL(IDPSSODescriptorType idp, String bindingURI) {
        String logoutURL = null;
        List endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            logoutURL = endpoint.getLocation().toString();
            break;
        }
        return logoutURL;
    }

    public static String getLogoutResponseLocation(IDPSSODescriptorType idp, String bindingURI) {
        String logoutResponseLocation = null;
        List endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            if (endpoint.getResponseLocation() != null) {
                logoutResponseLocation = endpoint.getResponseLocation().toString();
                break;
            }
            logoutResponseLocation = null;
            break;
        }
        return logoutResponseLocation;
    }

    public static String getServiceURL(SPSSODescriptorType sp, String bindingURI) {
        String serviceURL = null;
        List endpoints = sp.getAssertionConsumerService();
        for (IndexedEndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            serviceURL = endpoint.getLocation().toString();
            break;
        }
        return serviceURL;
    }

    private static void addAllEntityDescriptorsRecursively(List<EntityDescriptorType> resultList, EntitiesDescriptorType entitiesDescriptorType) {
        List entities = entitiesDescriptorType.getEntityDescriptor();
        for (Object o : entities) {
            if (o instanceof EntitiesDescriptorType) {
                CoreConfigUtil.addAllEntityDescriptorsRecursively(resultList, (EntitiesDescriptorType)o);
                continue;
            }
            if (o instanceof EntityDescriptorType) {
                resultList.add((EntityDescriptorType)o);
                continue;
            }
            throw new IllegalArgumentException("Wrong type: " + o.getClass());
        }
    }
}

