/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;

public class Config {
    private static ConfigProvider configProvider = new SystemPropertiesConfigProvider();

    public static void init(ConfigProvider configProvider) {
        Config.configProvider = configProvider;
        StringPropertyReplacer.setDefaultPropertyResolver((StringPropertyReplacer.PropertyResolver)new StringPropertyReplacer.PropertyResolver(){
            SystemEnvProperties systemVariables = new SystemEnvProperties(Config.access$000());

            public String resolve(String property) {
                return this.systemVariables.getProperty(property);
            }
        });
    }

    public static String getAdminRealm() {
        return configProvider.scope("admin").get("realm", "master");
    }

    public static String getProvider(String spi) {
        String provider = configProvider.getProvider(spi);
        if (provider == null || provider.trim().equals("")) {
            return null;
        }
        return provider;
    }

    public static String getDefaultProvider(String spi) {
        String provider = configProvider.getDefaultProvider(spi);
        if (provider == null || provider.trim().equals("")) {
            return null;
        }
        return provider;
    }

    public static Scope scope(String ... scope) {
        return configProvider.scope(scope);
    }

    private static Set<String> getAllowedSystemVariables() {
        Scope adminScope = configProvider.scope("admin");
        if (adminScope == null) {
            return Collections.emptySet();
        }
        String[] allowedSystemVariables = adminScope.getArray("allowed-system-variables");
        if (allowedSystemVariables == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(allowedSystemVariables));
    }

    static /* synthetic */ Set access$000() {
        return Config.getAllowedSystemVariables();
    }

    public static interface ConfigProvider {
        public String getProvider(String var1);

        public String getDefaultProvider(String var1);

        public Scope scope(String ... var1);
    }

    public static interface Scope {
        public String get(String var1);

        public String get(String var1, String var2);

        public String[] getArray(String var1);

        public Integer getInt(String var1);

        public Integer getInt(String var1, Integer var2);

        public Long getLong(String var1);

        public Long getLong(String var1, Long var2);

        public Boolean getBoolean(String var1);

        public Boolean getBoolean(String var1, Boolean var2);

        public Scope scope(String ... var1);

        public Set<String> getPropertyNames();
    }

    public static class SystemPropertiesConfigProvider
    implements ConfigProvider {
        @Override
        public String getProvider(String spi) {
            return System.getProperties().getProperty("keycloak." + spi + ".provider");
        }

        @Override
        public String getDefaultProvider(String spi) {
            return System.getProperties().getProperty("keycloak." + spi + ".provider.default");
        }

        @Override
        public Scope scope(String ... scope) {
            StringBuilder sb = new StringBuilder();
            sb.append("keycloak.");
            for (String s : scope) {
                sb.append(s);
                sb.append(".");
            }
            return new SystemPropertiesScope(sb.toString());
        }
    }

    public static class SystemPropertiesScope
    implements Scope {
        protected String prefix;

        public SystemPropertiesScope(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String get(String key) {
            return this.get(key, null);
        }

        @Override
        public String get(String key, String defaultValue) {
            String v = System.getProperty(this.prefix + key, defaultValue);
            return v != null && !v.isEmpty() ? v : null;
        }

        @Override
        public String[] getArray(String key) {
            String value = this.get(key);
            if (value != null) {
                String[] a = value.split(",");
                for (int i = 0; i < a.length; ++i) {
                    a[i] = a[i].trim();
                }
                return a;
            }
            return null;
        }

        @Override
        public Integer getInt(String key) {
            return this.getInt(key, null);
        }

        @Override
        public Integer getInt(String key, Integer defaultValue) {
            String v = this.get(key, null);
            return v != null ? Integer.valueOf(v) : defaultValue;
        }

        @Override
        public Long getLong(String key) {
            return this.getLong(key, null);
        }

        @Override
        public Long getLong(String key, Long defaultValue) {
            String v = this.get(key, null);
            return v != null ? Long.valueOf(v) : defaultValue;
        }

        @Override
        public Boolean getBoolean(String key) {
            return this.getBoolean(key, null);
        }

        @Override
        public Boolean getBoolean(String key, Boolean defaultValue) {
            String v = this.get(key, null);
            if (v != null) {
                return Boolean.valueOf(v);
            }
            return defaultValue;
        }

        @Override
        public Scope scope(String ... scope) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix + ".");
            for (String s : scope) {
                sb.append(s);
                sb.append(".");
            }
            return new SystemPropertiesScope(sb.toString());
        }

        @Override
        public Set<String> getPropertyNames() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

